/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.configures;

import com.fierhub.conditions.ConfigurationCheckCondition;
import com.fierhub.model.FierhubConfig;
import com.fierhub.service.RequestFilterService;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@Conditional(value={ConfigurationCheckCondition.class})
public class FierhubSecurityConfig {
    private FierhubConfig fierhubConfig;

    @Bean(value={"fierhubSecurityFilterChain"})
    public SecurityFilterChain fierhubSecurityFilterChain(HttpSecurity http) throws Exception {
        this.fierhubConfig = FierhubConfig.getInstance();
        http.csrf(AbstractHttpConfigurer::disable).cors(Customizer.withDefaults());
        if (this.fierhubConfig.getAuthorize() != null && this.fierhubConfig.getAuthorize().getRoutes() != null) {
            http.authorizeHttpRequests(auth -> {
                this.fierhubConfig.getAuthorize().getRoutes().forEach(path -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{path})).permitAll());
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated();
            }).sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        }
        http.addFilterBefore((Filter)this.requestFilterService(), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public RequestFilterService requestFilterService() {
        return new RequestFilterService();
    }
}

