/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.database.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fierhub.database.service.DbUtils;
import com.fierhub.database.utils.Template;
import in.bottomhalf.common.models.DatabaseProperties;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbManager {
    @Autowired
    ObjectMapper mapper;
    @Autowired
    DbUtils dbUtils;
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public DbManager(DatabaseProperties properties) throws Exception {
        Template template = new Template();
        this.jdbcTemplate = template.getTemplate(properties);
    }

    public <T> void save(T instance) throws Exception {
        String query = this.dbUtils.save(instance);
        this.jdbcTemplate.execute(query);
    }

    public <T> void saveAll(List<T> instance, Class<T> type) throws Exception {
        String query = this.dbUtils.saveAll(instance, type);
        this.jdbcTemplate.execute(query);
    }

    public <T> int nextIntPrimaryKey(Class<T> instance) throws Exception {
        int index = 0;
        String lastIndexQuery = this.dbUtils.lastPrimaryKey(instance);
        try {
            String lastIndex = (String)this.jdbcTemplate.queryForObject(lastIndexQuery, String.class);
            if (!lastIndex.isEmpty()) {
                index = Integer.parseInt(lastIndex);
            }
        }
        catch (EmptyResultDataAccessException e) {
            index = 0;
        }
        return index + 1;
    }

    public <T> long nextLongPrimaryKey(Class<T> instance) throws Exception {
        long index = 0L;
        String lastIndexQuery = this.dbUtils.lastPrimaryKey(instance);
        try {
            String lastIndex = (String)this.jdbcTemplate.queryForObject(lastIndexQuery, String.class);
            if (!lastIndex.isEmpty()) {
                index = Integer.parseInt(lastIndex);
            }
        }
        catch (EmptyResultDataAccessException e) {
            index = 0L;
        }
        return index + 1L;
    }

    public <T> List<T> get(Class<T> type) throws Exception {
        String query = this.dbUtils.get(type);
        List result = this.jdbcTemplate.queryForList(query);
        return (List)this.mapper.convertValue((Object)result, new TypeReference<List<T>>(){});
    }

    public <T> T getById(long id, Class<T> type) throws Exception {
        String query = this.dbUtils.getById(id, type);
        try {
            Map result = this.jdbcTemplate.queryForMap(query);
            return (T)this.mapper.convertValue((Object)result, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T getById(String id, Class<T> type) throws Exception {
        String query = this.dbUtils.getById(id, type);
        try {
            Map result = this.jdbcTemplate.queryForMap(query);
            return (T)this.mapper.convertValue((Object)result, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T getById(int id, Class<T> type) throws Exception {
        String query = this.dbUtils.getById(id, type);
        try {
            Map result = this.jdbcTemplate.queryForMap(query);
            return (T)this.mapper.convertValue((Object)result, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T queryRaw(String query, Class<T> type) {
        Map result = this.jdbcTemplate.queryForMap(query);
        return (T)this.mapper.convertValue((Object)result, type);
    }

    public <T> List<T> queryList(String query, Class<T> type) {
        List result = this.jdbcTemplate.queryForList(query);
        return (List)this.mapper.convertValue((Object)result, new TypeReference<List<T>>(){});
    }

    public void execute(String query) {
        this.jdbcTemplate.execute(query);
    }
}

