/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.database.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.springframework.stereotype.Service;

@Service
public class HttpRequestService {
    String tokenManagerUri;

    public String invoke(Object request) throws Exception {
        HttpURLConnection connection = this.getHttpURLConnection();
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = mapper.writeValueAsString(request);
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.writeBytes(requestBody);
            wr.flush();
        }
        int responseCode = connection.getResponseCode();
        System.out.println("Response Code: " + responseCode);
        String response = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            StringBuilder responseBuilder = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                responseBuilder.append(inputLine);
            }
            response = responseBuilder.toString();
        }
        connection.disconnect();
        return response;
    }

    public void setHttpUrl(String tokenManagerUri) {
        this.tokenManagerUri = tokenManagerUri;
    }

    private HttpURLConnection getHttpURLConnection() throws IOException {
        URL url = new URL(this.tokenManagerUri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        return connection;
    }
}

