/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.model;

import in.bottomhalf.common.models.DatabaseProperties;
import in.bottomhalf.common.models.JwtSecret;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class FierhubConfig {
    private JwtSecret jwtSecret;
    private List<DatasourceModel> datasource;
    private AuthorizeModel authorize;
    private ConfigurationModel configurationGateway;
    private ConfigurationModel configurationService;
    private ConfigurationModel configuration;
    private List<DatasourceModel> connections;
    private List<JwtSecret> secrets;
    private List<String> appSettingFiles;
    private Map<String, KeyValueRecord> records;
    private boolean useDbConfigFromFierhub;
    private boolean useTokenSecretFromFierhub;
    private boolean isFierhubDataLoadingCompleted;
    private boolean configuredFromFierhub;
    private boolean configurationCompleted;
    private static FierhubConfig INSTANCE;

    public boolean isConfigurationCompleted() {
        return this.configurationCompleted;
    }

    public void setConfigurationCompleted(boolean configurationCompleted) {
        this.configurationCompleted = configurationCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FierhubConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<FierhubConfig> clazz = FierhubConfig.class;
        synchronized (FierhubConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new FierhubConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void addSecret(JwtSecret secret) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<JwtSecret>();
        }
        if (this.secrets.size() == 1) {
            ((JwtSecret)this.secrets.stream().findFirst().get()).setPrimary(true);
        } else {
            secret.setPrimary(true);
        }
        this.secrets.add(secret);
    }

    public void updateDatabaseProperties(DatasourceModel datasource) {
        List<DatasourceModel> connections = this.getConnections();
        int count = 1;
        for (DatasourceModel con : connections) {
            con.setOrder(++count);
        }
        count = connections.size() + 1;
        Optional<DatasourceModel> record = connections.stream().filter(x -> x.getFile() != null && x.getFile().equals(datasource.getName())).findFirst();
        if (record.isPresent()) {
            if (record.get().getProperties() == null) {
                record.get().setProperties(datasource.getProperties());
            } else {
                DatabaseProperties property = record.get().getProperties();
                record.get().setOrder(1);
                property.setDatabase(datasource.getProperties().getDatabase());
                property.setUrl(datasource.getProperties().getUrl());
                property.setPassword(datasource.getProperties().getPassword());
                property.setUserId(datasource.getProperties().getUserId());
                property.setDriverClassName(datasource.getProperties().getDriverClassName());
            }
        } else {
            DatasourceModel propertyModel = new DatasourceModel();
            propertyModel.setProperties(datasource.getProperties());
            propertyModel.setName(datasource.getName());
            propertyModel.setOrder(1);
            connections.add(propertyModel);
        }
    }

    private void initConfiguration(FierhubConfig source) throws Exception {
        if (source.configurationGateway != null) {
            this.configuration = source.configurationGateway;
        } else if (source.configurationService != null) {
            this.configuration = source.configurationService;
        } else {
            throw new Exception("Gateway or Service configuration is mandatory.");
        }
    }

    private void initSecrets(FierhubConfig source) {
        if (source.jwtSecret != null) {
            if (this.secrets == null) {
                this.secrets = new ArrayList<JwtSecret>();
            }
            this.secrets.add(source.jwtSecret);
        }
    }

    public JwtSecret getDefaultSecret() throws Exception {
        JwtSecret secret = null;
        if (this.getSecrets() != null) {
            Optional<JwtSecret> secretValue = this.getSecrets().stream().filter(JwtSecret::isPrimary).findFirst();
            if (secretValue.isPresent()) {
                secret = secretValue.get();
            } else if (!this.getSecrets().isEmpty()) {
                secret = this.getSecrets().get(0);
            } else {
                throw new Exception("No default secret found");
            }
        }
        return secret;
    }

    public DatasourceModel getDefaultConnection() throws Exception {
        DatasourceModel datasourceModel = null;
        if (this.getSecrets() != null) {
            Optional<DatasourceModel> datasourceValue = this.getConnections().stream().filter(x -> x.getOrder() == 1).findFirst();
            if (datasourceValue.isPresent()) {
                datasourceModel = datasourceValue.get();
            } else if (!this.getConnections().isEmpty()) {
                datasourceModel = this.getConnections().get(0);
            } else {
                throw new Exception("No default connection found");
            }
        }
        return datasourceModel;
    }

    private void initConnections(FierhubConfig source) {
        if (source.connections != null) {
            this.connections = source.connections;
        }
        source.connections = new ArrayList<DatasourceModel>();
    }

    public void initialize(FierhubConfig source) throws Exception {
        this.datasource = source.datasource;
        this.authorize = source.authorize;
        this.initConfiguration(source);
        this.initConfiguration(source);
        this.connections = source.connections;
        this.initSecrets(source);
    }

    public JwtSecret getJwtSecret() {
        return this.jwtSecret;
    }

    public void setJwtSecret(JwtSecret jwtSecret) {
        this.jwtSecret = jwtSecret;
    }

    public List<DatasourceModel> getDatasource() {
        return this.datasource;
    }

    public void setDatasource(List<DatasourceModel> datasource) {
        this.datasource = datasource;
    }

    public AuthorizeModel getAuthorize() {
        return this.authorize;
    }

    public void setAuthorize(AuthorizeModel authorize) {
        this.authorize = authorize;
    }

    public ConfigurationModel getConfigurationGateway() {
        return this.configurationGateway;
    }

    public void setConfigurationGateway(ConfigurationModel configurationGateway) {
        this.configurationGateway = configurationGateway;
    }

    public ConfigurationModel getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationModel configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationModel getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationModel configuration) {
        this.configuration = configuration;
    }

    public List<DatasourceModel> getConnections() {
        return this.connections;
    }

    public void setConnections(List<DatasourceModel> connections) {
        this.connections = connections;
    }

    public List<JwtSecret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<JwtSecret> secrets) {
        this.secrets = secrets;
    }

    public List<String> getAppSettingFiles() {
        return this.appSettingFiles;
    }

    public void setAppSettingFiles(List<String> appSettingFiles) {
        this.appSettingFiles = appSettingFiles;
    }

    public Map<String, KeyValueRecord> getRecords() {
        return this.records;
    }

    public void setRecords(Map<String, KeyValueRecord> records) {
        this.records = records;
    }

    public boolean isUseDbConfigFromFierhub() {
        return this.useDbConfigFromFierhub;
    }

    public void setUseDbConfigFromFierhub(boolean useDbConfigFromFierhub) {
        this.useDbConfigFromFierhub = useDbConfigFromFierhub;
    }

    public boolean isUseTokenSecretFromFierhub() {
        return this.useTokenSecretFromFierhub;
    }

    public void setUseTokenSecretFromFierhub(boolean useTokenSecretFromFierhub) {
        this.useTokenSecretFromFierhub = useTokenSecretFromFierhub;
    }

    public boolean isFierhubDataLoadingCompleted() {
        return this.isFierhubDataLoadingCompleted;
    }

    public void setFierhubDataLoadingCompleted(boolean fierhubDataLoadingCompleted) {
        this.isFierhubDataLoadingCompleted = fierhubDataLoadingCompleted;
    }

    public boolean isConfiguredFromFierhub() {
        return this.configuredFromFierhub;
    }

    public void setConfiguredFromFierhub(boolean configuredFromFierhub) {
        this.configuredFromFierhub = configuredFromFierhub;
    }

    public static class DatasourceModel {
        private int order;
        private String name;
        private String file;
        private DatabaseProperties properties;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public DatabaseProperties getProperties() {
            return this.properties;
        }

        public void setProperties(DatabaseProperties properties) {
            this.properties = properties;
        }
    }

    public static class ConfigurationModel {
        private boolean isGatewayService;
        private String token;
        private String fileName;
        private boolean useFilter;

        public boolean isUseFilter() {
            return this.useFilter;
        }

        public void setUseFilter(boolean useFilter) {
            this.useFilter = useFilter;
        }

        public boolean isGatewayService() {
            return this.isGatewayService;
        }

        public void setGatewayService(boolean gatewayService) {
            this.isGatewayService = gatewayService;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getUrl() {
            return "https://www.fierhub.com/api/fileContent/readFile";
        }
    }

    public static class AuthorizeModel {
        private List<String> routes;

        public List<String> getRoutes() {
            return this.routes;
        }

        public void setRoutes(List<String> routes) {
            this.routes = routes;
        }
    }

    public static class KeyValueRecord {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

