/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.model;

import io.jsonwebtoken.Claims;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class UserSession {
    String userId;
    String email;
    String code;
    Map<String, String> claimsValue;
    List<GrantedAuthority> roles;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Map<String, String> getClaimsValue() {
        return this.claimsValue;
    }

    public void setClaimsValue(Map<String, String> claimsValue) {
        this.claimsValue = claimsValue;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<GrantedAuthority> getRoles() {
        return this.roles;
    }

    public void setRoles(List<GrantedAuthority> roles) {
        this.roles = roles;
    }

    public UserSession() {
    }

    public UserSession(String email, String userId, String code, boolean expired, Map<String, Object> claimsValue, List<GrantedAuthority> roles) {
        this.email = email;
        this.userId = userId;
        this.roles = roles;
    }

    public String toString() {
        return "CurrentSession{email='" + this.email + "', userId=" + this.userId + ", claimsValue=" + this.claimsValue + ", roles=" + this.roles + "}";
    }

    public <T> T getValue(String key, Class<T> type) throws Exception {
        String value = this.claimsValue.get(key);
        if (value == null) {
            throw new InvalidKeyException("Field '" + key + "' not found in current token session");
        }
        if (!type.isInstance(value)) {
            throw new ClassCastException("Expected type " + type.getSimpleName() + " but found " + value.getClass().getSimpleName());
        }
        return (T)value;
    }

    public Map<String, String> claimToMap(Claims claims) {
        return claims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
    }
}

