/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fierhub.conditions.ConfigurationCheckCondition;
import com.fierhub.model.FierhubConfig;
import in.bottomhalf.common.models.DatabaseProperties;
import in.bottomhalf.common.models.FierhubRequestModel;
import in.bottomhalf.common.models.FierhubResponse;
import in.bottomhalf.common.models.JwtSecret;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration(proxyBeanMethods=false)
public class FierhubRegistry {
    @Autowired
    private FierhubConfig fierhubConfig;
    @Autowired
    ObjectMapper mapper;

    @Bean
    @Conditional(value={ConfigurationCheckCondition.class})
    public Object fierhubInitializer() throws Exception {
        FierhubConfig fierhubConfigInstance = FierhubConfig.getInstance();
        if (fierhubConfigInstance.getDatasource() != null) {
            List<FierhubConfig.DatasourceModel> dataSources = fierhubConfigInstance.getDatasource().stream().filter(x -> x.getFile() != null && !x.getFile().isEmpty()).toList();
            for (FierhubConfig.DatasourceModel datasource : dataSources) {
                this.readDataSource(datasource);
            }
        }
        if (fierhubConfigInstance.getConfiguration().getFileName() != null && !fierhubConfigInstance.getConfiguration().getFileName().isEmpty()) {
            this.readJwtSecret(fierhubConfigInstance.getConfiguration().getFileName());
        }
        if (fierhubConfigInstance.getConnections() == null) {
            this.fierhubConfig.setConnections(new ArrayList<FierhubConfig.DatasourceModel>());
        } else {
            this.fierhubConfig.setConnections(fierhubConfigInstance.getConnections());
        }
        this.fierhubConfig.setDatasource(fierhubConfigInstance.getDatasource());
        this.fierhubConfig.setConfiguration(fierhubConfigInstance.getConfiguration());
        this.fierhubConfig.setAuthorize(fierhubConfigInstance.getAuthorize());
        this.fierhubConfig.setSecrets(fierhubConfigInstance.getSecrets());
        this.fierhubConfig.setRecords(fierhubConfigInstance.getRecords());
        this.fierhubConfig.setConfigurationCompleted(true);
        return new Object();
    }

    private FierhubResponse httpRequestToFierhub(String fileName) throws Exception {
        FierhubConfig fierhubConfigInstance = FierhubConfig.getInstance();
        FierhubRequestModel fierhubRequestModel = FierhubRequestModel.Create((String)fierhubConfigInstance.getConfiguration().getToken(), (String)fileName);
        String requestBody = this.mapper.writeValueAsString((Object)fierhubRequestModel);
        String resultContent = this.postRequest(requestBody, fierhubConfigInstance.getConfiguration().getUrl());
        FierhubResponse fierhubResponse = (FierhubResponse)this.mapper.readValue(resultContent, FierhubResponse.class);
        if (fierhubResponse.statusCode != HttpStatus.OK.value()) {
            throw new Exception("Fail to get the Fierhub token repository detail. Please check your configuration.");
        }
        return fierhubResponse;
    }

    private void readDataSource(FierhubConfig.DatasourceModel datasource) throws Exception {
        FierhubConfig fierhubConfigInstance = FierhubConfig.getInstance();
        FierhubResponse fierhubTokeResponse = this.httpRequestToFierhub(datasource.getFile());
        DatabaseProperties properties = (DatabaseProperties)this.mapper.readValue(fierhubTokeResponse.responseBody, DatabaseProperties.class);
        if (properties == null) {
            throw new Exception("No database configuration found in your fierhub account.");
        }
        properties.validate();
        datasource.setProperties(properties);
        fierhubConfigInstance.updateDatabaseProperties(datasource);
    }

    private void readJwtSecret(String fileName) throws Exception {
        FierhubConfig fierhubConfigInstance = FierhubConfig.getInstance();
        FierhubResponse fierhubTokeResponse = this.httpRequestToFierhub(fileName);
        JwtSecret secret = (JwtSecret)this.mapper.readValue(fierhubTokeResponse.responseBody, JwtSecret.class);
        if (secret == null) {
            throw new Exception("No database configuration found in your fierhub account.");
        }
        fierhubConfigInstance.addSecret(secret);
    }

    private String postRequest(String requestBody, String filePath) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(filePath)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        try {
            String var8;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(client.send(request, HttpResponse.BodyHandlers.ofInputStream()).body()));){
                StringBuilder content = new StringBuilder();
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        var8 = content.toString();
                        break;
                    }
                    content.append(line).append("\n");
                }
            }
            return var8;
        }
        catch (Exception var11) {
            throw new Exception(var11.getMessage());
        }
    }
}

