/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fierhub.database.service.HttpRequestService;
import com.fierhub.model.FierhubConfig;
import in.bottomhalf.common.models.ApiAuthResponse;
import in.bottomhalf.common.models.JwtSecret;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FierhubService {
    @Autowired
    private HttpRequestService httpRequestService;
    @Value(value="https://www.bottomhalf.in/bt/s3/ExternalTokenManager/generateToken")
    private String tokenHubUrl;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private FierhubConfig fierhubConfig;

    public ApiAuthResponse generateToken(Object claims) throws Exception {
        return this.generate(claims, null, null);
    }

    public ApiAuthResponse generateToken(Object claims, String userId) throws Exception {
        return this.generate(claims, userId, null);
    }

    public ApiAuthResponse generateToken(Object claims, List<String> roles) throws Exception {
        return this.generate(claims, null, roles);
    }

    public ApiAuthResponse generateToken(Object claims, String userId, List<String> roles) throws Exception {
        return this.generate(claims, userId, roles);
    }

    public ApiAuthResponse generate(Object userClaimsInput, String userId, List<String> roles) throws Exception {
        try {
            Map<String, String> claims = null;
            if (!(userClaimsInput instanceof HashMap)) {
                claims = FierhubService.convertObjectToMap(userClaimsInput);
            } else {
                HashMap convertedClaims = (HashMap)userClaimsInput;
                claims = convertedClaims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
            }
            if (userId != null && !userId.isEmpty()) {
                claims.put("x-fier-userId", userId);
            }
            if (roles != null && !roles.isEmpty()) {
                claims.put("x-fier-roles", this.mapper.writeValueAsString(roles));
            }
            JwtSecret jwtSecret = this.fierhubConfig.getDefaultSecret();
            this.httpRequestService.setHttpUrl(this.tokenHubUrl);
            jwtSecret.setClaims(claims);
            String result = this.httpRequestService.invoke(jwtSecret);
            if (result == null) {
                throw new Exception("Fail to generate token from server");
            }
            ApiAuthResponse response = (ApiAuthResponse)this.mapper.readValue(result, ApiAuthResponse.class);
            if (response.getHttpStatusCode() != 200) {
                throw new Exception("Fail to generate token from server");
            }
            return response;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static Map<String, String> convertObjectToMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (obj == null) {
            return map;
        }
        for (Class<?> type = obj.getClass(); type != null; type = type.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    map.put(field.getName(), value != null ? value.toString() : null);
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
            for (Method method : methods = type.getDeclaredMethods()) {
                try {
                    if (!FierhubService.isGetter(method)) continue;
                    Object value = method.invoke(obj, new Object[0]);
                    String propertyName = FierhubService.getPropertyName(method.getName());
                    map.put(propertyName, value != null ? value.toString() : null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    private static boolean isGetter(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2;
    }

    private static String getPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return methodName;
    }
}

