/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fierhub.model.FierhubConfig;
import com.fierhub.model.UserSession;
import in.bottomhalf.common.models.JwtSecret;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtService {
    @Autowired
    FierhubConfig fierhubConfig;
    @Autowired
    UserSession userSession;
    @Autowired
    ObjectMapper mapper;

    public Key getSignInKey(String key) {
        return Keys.hmacShaKeyFor((byte[])key.getBytes());
    }

    public String extractUsername(String token) throws Exception {
        return this.extractClaim(token, Claims::getSubject);
    }

    public Date extractExpiration(String token) throws Exception {
        return this.extractClaim(token, Claims::getExpiration);
    }

    public <T> T extractClaim(String token, Function<Claims, T> claimsResolver) throws Exception {
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    public List<GrantedAuthority> extractAuthorities(String token) throws Exception {
        String result = this.extractClaim(token, x -> (String)x.get("roles", String.class));
        return this.convertToAuthorities(result);
    }

    public List<GrantedAuthority> convertToAuthorities(String result) {
        List roles = (List)this.mapper.convertValue(List.of(result.split(",")), (TypeReference)new TypeReference<List<String>>(){});
        return roles.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public UserSession getCurrentSession(String token) throws Exception {
        Claims claims = this.extractAllClaims(token);
        this.userSession.setEmail((String)claims.get("email", String.class));
        this.userSession.setUserId((String)claims.get("userId", String.class));
        String authorities = (String)claims.get("roles", String.class);
        this.userSession.setRoles(this.convertToAuthorities(authorities));
        String expiration = (String)claims.get("expiration", String.class);
        return this.userSession;
    }

    public void buildSessionInstance(Claims claims) {
        Map<String, String> mappedClaim = this.userSession.claimToMap(claims);
        this.bindSession(mappedClaim);
    }

    public void bindSession(Map<String, String> claims) {
        String authorities;
        this.userSession.setClaimsValue(claims);
        String id = claims.get("x-fier-userId");
        if (id != null) {
            this.userSession.setUserId(id);
        }
        if ((authorities = claims.get("x-fier-roles")) != null) {
            this.userSession.setRoles(this.convertToAuthorities(authorities));
        }
    }

    public Claims extractAllClaims(String token) throws Exception {
        JwtSecret jwtSecret = this.fierhubConfig.getDefaultSecret();
        return (Claims)Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])jwtSecret.getKey().getBytes())).setAllowedClockSkewSeconds(5L).build().parseClaimsJws(token).getBody();
    }

    public boolean isTokenExpired(String token) throws Exception {
        return this.extractExpiration(token).before(new Date());
    }

    public String generateToken(String username, Map<String, Object> extraClaims) throws Exception {
        JwtSecret jwtSecret = this.fierhubConfig.getDefaultSecret();
        return Jwts.builder().setClaims(extraClaims).setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + (long)jwtSecret.getExpiryTimeInSeconds())).signWith(this.getSignInKey(jwtSecret.getKey()), SignatureAlgorithm.HS256).compact();
    }
}

