/*
 * Decompiled with CFR 0.152.
 */
package com.fierhub.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fierhub.configures.RouteValidator;
import com.fierhub.model.FierhubConfig;
import com.fierhub.model.UserSession;
import com.fierhub.service.JwtService;
import io.jsonwebtoken.Claims;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestFilterService
extends OncePerRequestFilter {
    @Autowired
    JwtService jwtService;
    @Autowired
    @Qualifier(value="filterRouteValidator")
    RouteValidator routeValidator;
    @Autowired
    FierhubConfig fierhubConfig;
    @Autowired
    UserSession session;
    @Autowired
    ObjectMapper mapper;
    private static final Logger logger = LoggerFactory.getLogger(RequestFilterService.class);

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (!this.fierhubConfig.getConfiguration().isUseFilter() || HttpMethod.OPTIONS.matches(String.valueOf(request.getMethod()))) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            try {
                if (this.routeValidator.isSecured.test(request)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (this.fierhubConfig.getConfiguration().isGatewayService()) {
                    this.readAccessToken(request, response, true);
                } else {
                    this.handleService(request, response);
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void handleService(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response) throws Exception {
        Map<String, String> mappedClaims = null;
        String claimsFromHeader = request.getHeader("x-fier-claims");
        if (claimsFromHeader == null) {
            Claims claims = this.readAccessToken(request, response, false);
            if (claims == null) {
                response.sendError(401, "Claims not found in token");
                return;
            }
            mappedClaims = claims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        } else {
            mappedClaims = (Map<String, String>)this.mapper.readValue(claimsFromHeader, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        if (mappedClaims == null) {
            response.sendError(401, "Not found any claims");
            return;
        }
        System.out.println("[addAuthorizationSecurity]: UserId: " + this.session.getUserId());
        this.jwtService.bindSession(mappedClaims);
        this.addAuthorizationSecurity(request);
    }

    private Claims readAccessToken(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, boolean gatewayHandler) throws Exception {
        Claims claims;
        block6: {
            claims = null;
            try {
                String token = request.getHeader("Authorization");
                if (token != null && token.startsWith("Bearer ")) {
                    if (token.contains("Bearer")) {
                        token = token.replace("Bearer ", "");
                    }
                    if ((claims = this.jwtService.extractAllClaims(token)) == null || claims.isEmpty()) {
                        throw new Exception("Invalid authorization token, no claims found.");
                    }
                    if (gatewayHandler) {
                        response.setHeader("x-fier-claims", this.mapper.writeValueAsString((Object)claims));
                        this.jwtService.buildSessionInstance(claims);
                    }
                    break block6;
                }
                throw new Exception("Invalid authorization token.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return claims;
    }

    private void addAuthorizationSecurity(@NonNull HttpServletRequest request) {
        System.out.println("[addAuthorizationSecurity]: UserId: " + this.session.getUserId());
        if (this.session.getUserId() != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)this.session.getUserId(), null, this.session.getRoles());
            authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
            System.out.println("Authorities: " + authToken.getAuthorities());
        }
    }

    private void isAnonymousRoute(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        List<String> anonymousRoutes = this.fierhubConfig.getAuthorize().getRoutes();
        boolean isAnonymous = anonymousRoutes.stream().anyMatch(x -> url.contains(x.replaceAll("/\\*\\*$", "")));
        if (!isAnonymous) {
            throw new RuntimeException("You have not authorize to access");
        }
    }

    private void showHeaders(HttpServletRequest httpRequest) {
        Enumeration headerNames = httpRequest.getHeaderNames();
        logger.info("Headers in request call.");
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = httpRequest.getHeader(headerName);
            logger.info(headerName + ":    ->  " + headerValue);
        }
    }
}

