/* The following code was generated by JFlex 1.4.1 on 3/31/10 5:27 PM */

/*
 * 03/21/2010
 *
 * Copyright (C) 2010 Robert Futrell
 * robert_futrell at users.sourceforge.net
 * http://fifesoft.com/rsyntaxtextarea
 *
 * This library is distributed under a modified BSD license.  See the included
 * RSTALanguageSupport.License.txt file for details.
 */
package org.fife.rsta.ac.java.rjc.lexer;


/**
 * Scanner for the Java programming language.<p>
 *
 * @author Robert Futrell
 * @version 0.1
 */

class SourceCodeScanner implements org.fife.rsta.ac.java.rjc.lexer.TokenTypes {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\10\1\4\1\3\1\0\1\4\1\3\16\10\4\0\1\4\1\67"+
    "\1\31\1\0\1\7\1\100\1\73\1\30\1\54\1\55\1\6\1\75"+
    "\1\63\1\76\1\17\1\5\1\12\3\34\4\16\2\13\1\72\1\62"+
    "\1\66\1\64\1\65\1\71\1\35\5\15\1\20\5\7\1\11\13\7"+
    "\1\14\2\7\1\60\1\1\1\61\1\77\1\7\1\0\1\25\1\33"+
    "\1\36\1\43\1\23\1\24\1\47\1\40\1\42\1\7\1\37\1\26"+
    "\1\44\1\32\1\41\1\50\1\7\1\22\1\27\1\21\1\2\1\51"+
    "\1\52\1\45\1\46\1\53\1\56\1\74\1\57\1\70\41\10\2\0"+
    "\4\7\4\0\1\7\2\0\1\10\7\0\1\7\4\0\1\7\5\0"+
    "\27\7\1\0\37\7\1\0\u013f\7\31\0\162\7\4\0\14\7\16\0"+
    "\5\7\11\0\1\7\21\0\130\10\5\0\23\10\12\0\1\7\13\0"+
    "\1\7\1\0\3\7\1\0\1\7\1\0\24\7\1\0\54\7\1\0"+
    "\46\7\1\0\5\7\4\0\202\7\1\0\4\10\3\0\105\7\1\0"+
    "\46\7\2\0\2\7\6\0\20\7\41\0\46\7\2\0\1\7\7\0"+
    "\47\7\11\0\21\10\1\0\27\10\1\0\3\10\1\0\1\10\1\0"+
    "\2\10\1\0\1\10\13\0\33\7\5\0\3\7\15\0\4\10\14\0"+
    "\6\10\13\0\32\7\5\0\13\7\16\10\7\0\12\10\4\0\2\7"+
    "\1\10\143\7\1\0\1\7\10\10\1\0\6\10\2\7\2\10\1\0"+
    "\4\10\2\7\12\10\3\7\2\0\1\7\17\0\1\10\1\7\1\10"+
    "\36\7\33\10\2\0\3\7\60\0\46\7\13\10\1\7\u014f\0\3\10"+
    "\66\7\2\0\1\10\1\7\20\10\2\0\1\7\4\10\3\0\12\7"+
    "\2\10\2\0\12\10\21\0\3\10\1\0\10\7\2\0\2\7\2\0"+
    "\26\7\1\0\7\7\1\0\1\7\3\0\4\7\2\0\1\10\1\7"+
    "\7\10\2\0\2\10\2\0\3\10\11\0\1\10\4\0\2\7\1\0"+
    "\3\7\2\10\2\0\12\10\4\7\15\0\3\10\1\0\6\7\4\0"+
    "\2\7\2\0\26\7\1\0\7\7\1\0\2\7\1\0\2\7\1\0"+
    "\2\7\2\0\1\10\1\0\5\10\4\0\2\10\2\0\3\10\13\0"+
    "\4\7\1\0\1\7\7\0\14\10\3\7\14\0\3\10\1\0\11\7"+
    "\1\0\3\7\1\0\26\7\1\0\7\7\1\0\2\7\1\0\5\7"+
    "\2\0\1\10\1\7\10\10\1\0\3\10\1\0\3\10\2\0\1\7"+
    "\17\0\2\7\2\10\2\0\12\10\1\0\1\7\17\0\3\10\1\0"+
    "\10\7\2\0\2\7\2\0\26\7\1\0\7\7\1\0\2\7\1\0"+
    "\5\7\2\0\1\10\1\7\6\10\3\0\2\10\2\0\3\10\10\0"+
    "\2\10\4\0\2\7\1\0\3\7\4\0\12\10\1\0\1\7\20\0"+
    "\1\10\1\7\1\0\6\7\3\0\3\7\1\0\4\7\3\0\2\7"+
    "\1\0\1\7\1\0\2\7\3\0\2\7\3\0\3\7\3\0\10\7"+
    "\1\0\3\7\4\0\5\10\3\0\3\10\1\0\4\10\11\0\1\10"+
    "\17\0\11\10\11\0\1\7\7\0\3\10\1\0\10\7\1\0\3\7"+
    "\1\0\27\7\1\0\12\7\1\0\5\7\4\0\7\10\1\0\3\10"+
    "\1\0\4\10\7\0\2\10\11\0\2\7\4\0\12\10\22\0\2\10"+
    "\1\0\10\7\1\0\3\7\1\0\27\7\1\0\12\7\1\0\5\7"+
    "\2\0\1\10\1\7\7\10\1\0\3\10\1\0\4\10\7\0\2\10"+
    "\7\0\1\7\1\0\2\7\4\0\12\10\22\0\2\10\1\0\10\7"+
    "\1\0\3\7\1\0\27\7\1\0\20\7\4\0\6\10\2\0\3\10"+
    "\1\0\4\10\11\0\1\10\10\0\2\7\4\0\12\10\22\0\2\10"+
    "\1\0\22\7\3\0\30\7\1\0\11\7\1\0\1\7\2\0\7\7"+
    "\3\0\1\10\4\0\6\10\1\0\1\10\1\0\10\10\22\0\2\10"+
    "\15\0\60\7\1\10\2\7\7\10\4\0\10\7\10\10\1\0\12\10"+
    "\47\0\2\7\1\0\1\7\2\0\2\7\1\0\1\7\2\0\1\7"+
    "\6\0\4\7\1\0\7\7\1\0\3\7\1\0\1\7\1\0\1\7"+
    "\2\0\2\7\1\0\4\7\1\10\2\7\6\10\1\0\2\10\1\7"+
    "\2\0\5\7\1\0\1\7\1\0\6\10\2\0\12\10\2\0\2\7"+
    "\42\0\1\7\27\0\2\10\6\0\12\10\13\0\1\10\1\0\1\10"+
    "\1\0\1\10\4\0\2\10\10\7\1\0\42\7\6\0\24\10\1\0"+
    "\2\10\4\7\4\0\10\10\1\0\44\10\11\0\1\10\71\0\42\7"+
    "\1\0\5\7\1\0\2\7\1\0\7\10\3\0\4\10\6\0\12\10"+
    "\6\0\6\7\4\10\106\0\46\7\12\0\51\7\7\0\132\7\5\0"+
    "\104\7\5\0\122\7\6\0\7\7\1\0\77\7\1\0\1\7\1\0"+
    "\4\7\2\0\7\7\1\0\1\7\1\0\4\7\2\0\47\7\1\0"+
    "\1\7\1\0\4\7\2\0\37\7\1\0\1\7\1\0\4\7\2\0"+
    "\7\7\1\0\1\7\1\0\4\7\2\0\7\7\1\0\7\7\1\0"+
    "\27\7\1\0\37\7\1\0\1\7\1\0\4\7\2\0\7\7\1\0"+
    "\47\7\1\0\23\7\16\0\11\10\56\0\125\7\14\0\u026c\7\2\0"+
    "\10\7\12\0\32\7\5\0\113\7\3\0\3\7\17\0\15\7\1\0"+
    "\4\7\3\10\13\0\22\7\3\10\13\0\22\7\2\10\14\0\15\7"+
    "\1\0\3\7\1\0\2\10\14\0\64\7\40\10\3\0\1\7\3\0"+
    "\2\7\1\10\2\0\12\10\41\0\3\10\2\0\12\10\6\0\130\7"+
    "\10\0\51\7\1\10\126\0\35\7\3\0\14\10\4\0\14\10\12\0"+
    "\12\10\36\7\2\0\5\7\u038b\0\154\7\224\0\234\7\4\0\132\7"+
    "\6\0\26\7\2\0\6\7\2\0\46\7\2\0\6\7\2\0\10\7"+
    "\1\0\1\7\1\0\1\7\1\0\1\7\1\0\37\7\2\0\65\7"+
    "\1\0\7\7\1\0\1\7\3\0\3\7\1\0\7\7\3\0\4\7"+
    "\2\0\6\7\4\0\15\7\5\0\3\7\1\0\7\7\17\0\4\10"+
    "\32\0\5\10\20\0\2\7\23\0\1\7\13\0\4\10\6\0\6\10"+
    "\1\0\1\7\15\0\1\7\40\0\22\7\36\0\15\10\4\0\1\10"+
    "\3\0\6\10\27\0\1\7\4\0\1\7\2\0\12\7\1\0\1\7"+
    "\3\0\5\7\6\0\1\7\1\0\1\7\1\0\1\7\1\0\4\7"+
    "\1\0\3\7\1\0\7\7\3\0\3\7\5\0\5\7\26\0\44\7"+
    "\u0e81\0\3\7\31\0\11\7\6\10\1\0\5\7\2\0\5\7\4\0"+
    "\126\7\2\0\2\10\2\0\3\7\1\0\137\7\5\0\50\7\4\0"+
    "\136\7\21\0\30\7\70\0\20\7\u0200\0\u19b6\7\112\0\u51a6\7\132\0"+
    "\u048d\7\u0773\0\u2ba4\7\u215c\0\u012e\7\2\0\73\7\225\0\7\7\14\0"+
    "\5\7\5\0\1\7\1\10\12\7\1\0\15\7\1\0\5\7\1\0"+
    "\1\7\1\0\2\7\1\0\2\7\1\0\154\7\41\0\u016b\7\22\0"+
    "\100\7\2\0\66\7\50\0\15\7\3\0\20\10\20\0\4\10\17\0"+
    "\2\7\30\0\3\7\31\0\1\7\6\0\5\7\1\0\207\7\2\0"+
    "\1\10\4\0\1\7\13\0\12\10\7\0\32\7\4\0\1\7\1\0"+
    "\32\7\12\0\132\7\3\0\6\7\2\0\6\7\2\0\6\7\2\0"+
    "\3\7\3\0\2\7\3\0\2\7\22\0\3\10\4\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\2\6\1\7"+
    "\7\2\1\10\1\11\2\2\1\12\7\2\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\0\1\41\1\42\2\6"+
    "\4\0\22\2\4\10\2\11\1\43\12\2\1\44\3\2"+
    "\1\45\6\2\1\46\1\47\1\50\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\2\0\1\6\1\0\1\66\2\2\1\67"+
    "\10\2\1\70\12\2\1\71\4\10\3\11\1\2\1\72"+
    "\11\2\1\73\14\2\1\74\1\75\1\76\2\0\1\40"+
    "\1\77\1\100\2\2\1\101\1\2\1\102\1\103\5\2"+
    "\1\104\6\2\1\10\1\11\2\0\1\105\3\2\1\106"+
    "\1\2\1\107\1\2\1\110\10\2\1\111\5\2\1\112"+
    "\1\2\1\113\1\0\1\2\1\114\2\2\1\115\1\116"+
    "\2\2\1\117\2\2\1\120\2\2\1\10\1\11\1\0"+
    "\1\2\1\121\1\2\1\122\1\123\1\2\1\124\13\2"+
    "\1\125\1\126\1\2\1\127\1\130\2\2\1\131\2\2"+
    "\1\132\1\2\1\133\1\10\1\11\1\0\1\134\5\2"+
    "\1\135\1\2\1\136\1\137\5\2\1\140\1\141\3\2"+
    "\1\0\1\142\4\2\1\143\1\2\1\144\1\145\2\2"+
    "\1\146\1\147\1\2\1\0\1\150\4\2\1\151\1\152"+
    "\1\2\1\153\2\2\1\154\1\2\1\155\1\156\1\2"+
    "\1\157";

  private static int [] zzUnpackAction() {
    int [] result = new int[341];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\101\0\u0514\0\u0555\0\u0596"+
    "\0\u05d7\0\u0618\0\u0659\0\u069a\0\101\0\101\0\101\0\101"+
    "\0\101\0\101\0\101\0\101\0\u06db\0\u071c\0\u075d\0\u079e"+
    "\0\101\0\101\0\101\0\u07df\0\u0820\0\u0861\0\u08a2\0\u08e3"+
    "\0\u0924\0\u0965\0\u09a6\0\101\0\101\0\101\0\u09e7\0\u0a28"+
    "\0\u0a69\0\u0aaa\0\u0aeb\0\u0b2c\0\u0b6d\0\u0bae\0\u0bef\0\u0c30"+
    "\0\u0c71\0\u0cb2\0\u0cf3\0\u0d34\0\u0d75\0\u0db6\0\u0df7\0\u0e38"+
    "\0\u0e79\0\u0eba\0\u0efb\0\u0f3c\0\u0f7d\0\u0fbe\0\u0fff\0\u1040"+
    "\0\101\0\u1081\0\u10c2\0\101\0\u1103\0\u1144\0\u1185\0\u11c6"+
    "\0\u1207\0\u1248\0\u1289\0\u12ca\0\u130b\0\u134c\0\202\0\u138d"+
    "\0\u13ce\0\u140f\0\u1450\0\u1491\0\u14d2\0\u1513\0\u1554\0\u1595"+
    "\0\u15d6\0\101\0\101\0\u1617\0\101\0\u1658\0\101\0\101"+
    "\0\101\0\101\0\101\0\101\0\101\0\101\0\101\0\101"+
    "\0\101\0\u1699\0\u16da\0\u171b\0\u175c\0\101\0\u179d\0\u17de"+
    "\0\202\0\u181f\0\u1860\0\u18a1\0\u18e2\0\u1923\0\u1964\0\u19a5"+
    "\0\u19e6\0\202\0\u1a27\0\u1a68\0\u1aa9\0\u1aea\0\u1b2b\0\u1b6c"+
    "\0\u1bad\0\u1bee\0\u1c2f\0\u1c70\0\101\0\u1cb1\0\u1cf2\0\u1d33"+
    "\0\u1d74\0\u1db5\0\u1df6\0\101\0\u1e37\0\202\0\u1e78\0\u1eb9"+
    "\0\u1efa\0\u1f3b\0\u1f7c\0\u1fbd\0\u1ffe\0\u203f\0\u2080\0\u20c1"+
    "\0\u2102\0\u2143\0\u2184\0\u21c5\0\u2206\0\u2247\0\u2288\0\u22c9"+
    "\0\u230a\0\u234b\0\u238c\0\u23cd\0\101\0\u240e\0\101\0\u244f"+
    "\0\u2490\0\101\0\101\0\202\0\u24d1\0\u2512\0\202\0\u2553"+
    "\0\202\0\202\0\u2594\0\u25d5\0\u2616\0\u2657\0\u2698\0\202"+
    "\0\u26d9\0\u271a\0\u275b\0\u279c\0\u27dd\0\u281e\0\u285f\0\u28a0"+
    "\0\u1df6\0\u28e1\0\202\0\u2922\0\u2963\0\u29a4\0\202\0\u29e5"+
    "\0\202\0\u2a26\0\202\0\u2a67\0\u2aa8\0\u2ae9\0\u2b2a\0\u2b6b"+
    "\0\u2bac\0\u2bed\0\u2c2e\0\202\0\u2c6f\0\u2cb0\0\u2cf1\0\u2d32"+
    "\0\u2d73\0\202\0\u2db4\0\101\0\u2df5\0\u2e36\0\u2e77\0\u2eb8"+
    "\0\u2ef9\0\202\0\u2f3a\0\u2f7b\0\u2fbc\0\202\0\u2ffd\0\u303e"+
    "\0\202\0\u307f\0\u30c0\0\u3101\0\u3142\0\u3183\0\u31c4\0\202"+
    "\0\u3205\0\202\0\202\0\u3246\0\202\0\u3287\0\u32c8\0\u3309"+
    "\0\u334a\0\u338b\0\u33cc\0\u340d\0\u344e\0\u348f\0\u34d0\0\u3511"+
    "\0\202\0\101\0\u3552\0\202\0\202\0\u3593\0\u35d4\0\202"+
    "\0\u3615\0\u3656\0\202\0\u3697\0\202\0\u36d8\0\u3719\0\u375a"+
    "\0\202\0\u379b\0\u37dc\0\u381d\0\u385e\0\u389f\0\202\0\u38e0"+
    "\0\202\0\202\0\u3921\0\u3962\0\u39a3\0\u39e4\0\u3a25\0\202"+
    "\0\202\0\u3a66\0\u3aa7\0\u3ae8\0\u3b29\0\202\0\u3b6a\0\u3bab"+
    "\0\u3bec\0\u3c2d\0\202\0\u3c6e\0\202\0\202\0\u3caf\0\u3cf0"+
    "\0\202\0\202\0\u3d31\0\u3d72\0\202\0\u3db3\0\u3df4\0\u3e35"+
    "\0\u3e76\0\202\0\202\0\u3eb7\0\202\0\u3ef8\0\u3f39\0\202"+
    "\0\u3f7a\0\202\0\202\0\u3fbb\0\202";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[341];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\2\1\3\2\4\1\5\1\6\1\3\1\2\1\3"+
    "\1\7\1\10\2\3\1\10\1\11\1\3\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\10\1\25\1\26\3\3\1\27\1\30\3\3"+
    "\1\31\1\32\1\33\1\34\1\3\1\35\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\103\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\16\3\30\0\2\4\101\0\1\62"+
    "\1\63\55\0\1\64\100\0\1\65\25\0\1\66\1\67"+
    "\1\70\1\71\1\0\1\67\1\72\6\0\1\66\5\0"+
    "\1\67\10\0\1\71\44\0\1\66\2\10\2\0\1\10"+
    "\1\72\6\0\1\66\5\0\1\10\63\0\1\73\63\0"+
    "\1\3\4\0\10\3\1\0\2\3\1\74\5\3\2\0"+
    "\3\3\1\0\2\3\1\75\13\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\76\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\6\3\1\77"+
    "\1\3\2\0\1\100\2\3\1\0\7\3\1\101\6\3"+
    "\27\0\1\3\4\0\10\3\1\0\5\3\1\102\1\103"+
    "\1\3\2\0\3\3\1\0\3\3\1\104\1\105\11\3"+
    "\27\0\1\3\4\0\10\3\1\0\7\3\1\106\2\0"+
    "\1\3\1\107\1\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\3\3\1\110"+
    "\12\3\27\0\1\111\4\0\10\3\1\0\1\3\1\112"+
    "\6\3\2\0\3\3\1\0\2\3\1\113\5\3\1\114"+
    "\3\3\1\115\1\3\25\0\1\116\1\117\1\116\1\120"+
    "\24\116\1\121\50\116\1\22\1\122\1\22\1\123\25\22"+
    "\1\124\47\22\2\0\1\125\4\0\10\3\1\0\3\3"+
    "\1\126\1\3\1\127\2\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\2\3\1\130\5\3"+
    "\2\0\3\3\1\0\3\3\1\131\4\3\1\132\5\3"+
    "\27\0\1\3\4\0\10\3\1\0\5\3\1\133\1\134"+
    "\1\3\2\0\3\3\1\0\2\3\1\135\1\136\12\3"+
    "\27\0\1\3\4\0\10\3\1\0\4\3\1\137\3\3"+
    "\2\0\1\140\2\3\1\0\6\3\1\141\7\3\27\0"+
    "\1\3\4\0\10\3\1\0\3\3\1\142\4\3\2\0"+
    "\3\3\1\0\3\3\1\143\12\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\3\3\1\144"+
    "\12\3\27\0\1\145\4\0\10\3\1\0\2\3\1\146"+
    "\2\3\1\147\2\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\3\3\1\150\12\3\27\0\1\3\4\0\10\3\1\0"+
    "\10\3\2\0\3\3\1\0\2\3\1\151\13\3\111\0"+
    "\1\152\100\0\1\153\1\154\77\0\1\155\1\0\1\156"+
    "\76\0\1\157\100\0\1\160\6\0\1\161\71\0\1\162"+
    "\7\0\1\163\70\0\1\164\10\0\1\165\67\0\1\166"+
    "\11\0\1\167\66\0\1\170\100\0\1\171\14\0\3\62"+
    "\1\0\75\62\6\172\1\173\72\172\11\0\1\66\1\67"+
    "\1\70\2\0\1\67\1\72\6\0\1\66\5\0\1\67"+
    "\56\0\2\70\2\0\1\70\1\72\14\0\1\70\56\0"+
    "\2\174\1\0\2\174\1\0\1\174\2\0\3\174\5\0"+
    "\2\174\1\0\1\174\4\0\1\174\47\0\2\175\2\0"+
    "\1\175\15\0\1\175\63\0\1\176\63\0\1\177\4\0"+
    "\10\3\1\0\5\3\1\200\2\3\2\0\3\3\1\0"+
    "\10\3\1\201\5\3\27\0\1\3\4\0\10\3\1\0"+
    "\2\3\1\202\5\3\2\0\3\3\1\0\4\3\1\203"+
    "\11\3\27\0\1\3\4\0\10\3\1\0\1\3\1\204"+
    "\6\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\7\3\1\205\2\0\3\3\1\0\16\3"+
    "\27\0\1\206\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\207\6\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\6\3\1\210\1\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\3\3\1\211\12\3\27\0\1\3"+
    "\4\0\10\3\1\0\2\3\1\212\5\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\1\213\2\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\7\3\1\214\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\7\3\1\215\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\10\3\2\0\1\216\2\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\12\3"+
    "\1\217\3\3\27\0\1\3\4\0\10\3\1\0\2\3"+
    "\1\220\2\3\1\221\2\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\3\3\1\222\12\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\1\223\2\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\4\3\1\224\11\3\25\0\30\120\1\225\51\120\1\116"+
    "\1\226\7\120\1\227\3\120\1\230\2\120\2\116\1\120"+
    "\1\116\3\120\1\231\3\116\1\227\74\120\1\121\50\120"+
    "\1\123\1\22\1\232\7\123\1\22\3\123\1\22\2\123"+
    "\2\22\1\123\1\22\3\123\1\22\1\233\3\22\75\123"+
    "\1\234\47\123\2\0\1\3\4\0\10\3\1\0\6\3"+
    "\1\235\1\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\14\3"+
    "\1\236\1\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\237\6\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\3\3\1\240\4\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\3\3\1\241\12\3\27\0\1\3"+
    "\4\0\10\3\1\0\1\3\1\242\6\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\243\5\3\1\244\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\5\3\1\245\2\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\5\3\1\246\2\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\1\247\2\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\250\5\3\1\251\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\12\3\1\252\3\3\27\0\1\3\4\0\10\3\1\0"+
    "\4\3\1\253\3\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\254\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\1\3\1\255"+
    "\6\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\1\3\1\256\1\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\3\3\1\257\1\260\11\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\1\261"+
    "\15\3\27\0\1\3\4\0\10\3\1\0\6\3\1\262"+
    "\1\3\2\0\3\3\1\0\4\3\1\263\11\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\4\3\1\264\11\3\111\0\1\265\1\266\77\0\1\267"+
    "\14\0\6\172\1\270\72\172\5\271\1\272\1\173\72\271"+
    "\11\0\1\66\2\174\1\0\2\174\1\0\1\174\2\0"+
    "\3\174\1\66\4\0\2\174\1\0\1\174\4\0\1\174"+
    "\47\0\2\175\2\0\1\175\1\0\1\273\3\0\1\273"+
    "\7\0\1\175\46\0\1\3\4\0\10\3\1\0\3\3"+
    "\1\274\4\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\1\275\2\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\3\3\1\276\12\3\27\0\1\3\4\0"+
    "\10\3\1\0\7\3\1\277\2\0\3\3\1\0\16\3"+
    "\27\0\1\300\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\3\3"+
    "\1\301\4\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\6\3"+
    "\1\302\7\3\27\0\1\3\4\0\10\3\1\0\3\3"+
    "\1\303\4\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\7\3\1\177\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\5\3\1\304"+
    "\2\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\5\3\1\305\2\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\3\3\1\306"+
    "\4\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\1\3\1\307\6\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\11\3\1\310\4\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\311\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\4\3\1\312\11\3\27\0\1\3\4\0"+
    "\10\3\1\0\1\3\1\313\6\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\2\3\1\314"+
    "\5\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\1\315\15\3"+
    "\27\0\1\3\4\0\10\3\1\0\1\3\1\316\6\3"+
    "\2\0\3\3\1\0\16\3\25\0\2\120\1\226\7\120"+
    "\2\317\1\120\2\317\1\120\1\317\2\120\3\317\2\120"+
    "\1\121\2\120\2\317\1\120\1\317\4\120\1\317\47\120"+
    "\1\230\3\120\1\230\11\120\1\225\3\120\1\230\56\120"+
    "\1\116\3\120\1\116\11\120\1\225\3\120\1\116\44\120"+
    "\30\0\1\225\50\0\2\123\1\232\7\123\2\320\1\123"+
    "\2\320\1\123\1\320\2\123\3\320\3\123\1\234\1\123"+
    "\2\320\1\123\1\320\4\123\1\320\35\123\1\321\1\322"+
    "\1\321\1\0\25\321\1\124\47\321\2\0\1\3\4\0"+
    "\10\3\1\0\6\3\1\323\1\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\4\3\1\324\11\3\27\0\1\3\4\0"+
    "\10\3\1\0\5\3\1\325\2\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\6\3\1\326"+
    "\1\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\327\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\1\330\15\3\27\0\1\3\4\0\10\3"+
    "\1\0\3\3\1\331\4\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\7\3\1\332\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\2\3\1\333\5\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\1\3\1\334\5\3\1\335"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\3\3\1\336\4\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\1\3\1\337\6\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\6\3\1\340\1\3\2\0\3\3\1\0\3\3"+
    "\1\341\12\3\27\0\1\3\4\0\10\3\1\0\5\3"+
    "\1\342\2\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\1\3\1\343\1\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\3\3\1\344\12\3\27\0\1\3"+
    "\4\0\10\3\1\0\6\3\1\345\1\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\346\6\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\13\3"+
    "\1\347\2\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\1\3\1\350\14\3\27\0\1\3"+
    "\4\0\10\3\1\0\5\3\1\351\2\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\5\3\1\352\10\3\27\0\1\3"+
    "\4\0\10\3\1\0\6\3\1\353\1\3\2\0\3\3"+
    "\1\0\16\3\111\0\1\354\14\0\5\172\1\272\1\270"+
    "\72\172\6\271\1\355\72\271\2\0\1\3\4\0\10\3"+
    "\1\0\7\3\1\356\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\14\3\1\357\1\3\27\0\1\3\4\0\10\3\1\0"+
    "\2\3\1\360\5\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\1\361\2\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\362\6\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\6\3\1\363\1\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\2\3"+
    "\1\364\5\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\2\3\1\365\5\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\2\3"+
    "\1\366\5\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\1\367"+
    "\15\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\4\3\1\370\11\3\27\0\1\3\4\0"+
    "\10\3\1\0\1\3\1\371\6\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\2\3\1\372\13\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\1\373\15\3"+
    "\25\0\12\120\2\374\1\120\2\374\1\120\1\374\2\120"+
    "\3\374\2\120\1\121\2\120\2\374\1\120\1\374\4\120"+
    "\1\374\35\120\12\123\2\375\1\123\2\375\1\123\1\375"+
    "\2\123\3\375\3\123\1\234\1\123\2\375\1\123\1\375"+
    "\4\123\1\375\35\123\1\0\1\321\1\376\7\0\1\321"+
    "\3\0\1\321\2\0\2\321\1\0\1\321\3\0\5\321"+
    "\46\0\1\3\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\13\3\1\377\2\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\3\3\1\0\1\3\1\u0100\14\3"+
    "\27\0\1\3\4\0\10\3\1\0\3\3\1\u0101\4\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\3\3\1\0\2\3\1\u0102\13\3"+
    "\27\0\1\3\4\0\10\3\1\0\7\3\1\u0103\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\10\3\2\0\3\3\1\0\4\3\1\u0104\11\3\27\0"+
    "\1\3\4\0\10\3\1\0\1\3\1\u0105\6\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\2\3\1\u0106\5\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\5\3\1\u0107\2\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\3\3\1\u0108\4\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\2\3\1\u0109\5\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\u010a\4\0\10\3\1\0"+
    "\10\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\6\3\1\u010b\1\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\4\3\1\u010c\11\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\u010d\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\5\3\1\u010e"+
    "\2\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\5\3\1\u010f\2\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\1\3\1\u0110"+
    "\6\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\u0111\4\3\2\0\3\3\1\0"+
    "\16\3\25\0\5\271\1\u0112\1\355\72\271\2\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\4\3"+
    "\1\u0113\11\3\27\0\1\3\4\0\10\3\1\0\7\3"+
    "\1\u0114\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\1\u0115\2\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\5\3\1\u0116\10\3\27\0\1\3\4\0\10\3"+
    "\1\0\6\3\1\u0117\1\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\1\3\1\u0118\6\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\5\3\1\u0119\2\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\1\3\1\u011a\6\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\3\3\1\0\1\u011b\15\3\27\0"+
    "\1\3\4\0\10\3\1\0\2\3\1\u011c\5\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\10\3\2\0\3\3\1\0\2\3\1\u011d\13\3\25\0"+
    "\12\120\2\u011e\1\120\2\u011e\1\120\1\u011e\2\120\3\u011e"+
    "\2\120\1\121\2\120\2\u011e\1\120\1\u011e\4\120\1\u011e"+
    "\35\120\12\123\2\u011f\1\123\2\u011f\1\123\1\u011f\2\123"+
    "\3\u011f\3\123\1\234\1\123\2\u011f\1\123\1\u011f\4\123"+
    "\1\u011f\35\123\2\0\1\376\7\0\2\u0120\1\0\2\u0120"+
    "\1\0\1\u0120\2\0\3\u0120\5\0\2\u0120\1\0\1\u0120"+
    "\4\0\1\u0120\37\0\1\3\4\0\10\3\1\0\3\3"+
    "\1\u0121\4\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\5\3\1\u0122\2\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\1\u0123\2\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\4\3\1\u0124\3\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\1\u0125\2\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\3\3\1\0\6\3\1\u0126\7\3"+
    "\27\0\1\3\4\0\10\3\1\0\1\3\1\u0127\6\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\6\3\1\u0128\1\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\3\3\1\u0129\4\3"+
    "\2\0\3\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\3\3\1\0\1\u012a\15\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\1\u012b\15\3\27\0\1\3\4\0\10\3\1\0\1\3"+
    "\1\u012c\6\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\11\3"+
    "\1\u012d\4\3\27\0\1\3\4\0\10\3\1\0\10\3"+
    "\2\0\3\3\1\0\4\3\1\u012e\11\3\27\0\1\3"+
    "\4\0\10\3\1\0\3\3\1\u012f\4\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\7\3"+
    "\1\u0130\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\10\3\1\u0131"+
    "\5\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\1\u0132\15\3\27\0\1\3\4\0\10\3"+
    "\1\0\4\3\1\u0133\3\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\3\3\1\u0134\12\3\25\0\12\120\2\116\1\120"+
    "\2\116\1\120\1\116\2\120\3\116\2\120\1\121\2\120"+
    "\2\116\1\120\1\116\4\120\1\116\35\120\12\123\2\22"+
    "\1\123\2\22\1\123\1\22\2\123\3\22\3\123\1\234"+
    "\1\123\2\22\1\123\1\22\4\123\1\22\35\123\12\0"+
    "\2\u0135\1\0\2\u0135\1\0\1\u0135\2\0\3\u0135\5\0"+
    "\2\u0135\1\0\1\u0135\4\0\1\u0135\37\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\1\u0136\2\3\1\0\16\3"+
    "\27\0\1\u0137\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\16\3\27\0\1\3\4\0\10\3\1\0\5\3"+
    "\1\u0138\2\3\2\0\3\3\1\0\16\3\27\0\1\3"+
    "\4\0\10\3\1\0\10\3\2\0\3\3\1\0\1\u0139"+
    "\15\3\27\0\1\3\4\0\10\3\1\0\3\3\1\u013a"+
    "\4\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\1\3\1\u013b\6\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\1\3\1\u013c"+
    "\6\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\u013d\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\3\3\1\u013e"+
    "\4\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\6\3\1\u013f\1\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\1\u0140\2\3\1\0\16\3\27\0\1\3\4\0\10\3"+
    "\1\0\1\3\1\u0141\6\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\10\3\2\0\3\3"+
    "\1\0\12\3\1\u0142\3\3\27\0\1\3\4\0\10\3"+
    "\1\0\10\3\2\0\1\u0143\2\3\1\0\16\3\37\0"+
    "\2\u0144\1\0\2\u0144\1\0\1\u0144\2\0\3\u0144\5\0"+
    "\2\u0144\1\0\1\u0144\4\0\1\u0144\37\0\1\3\4\0"+
    "\10\3\1\0\3\3\1\u0145\4\3\2\0\3\3\1\0"+
    "\16\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\1\u0146\15\3\27\0\1\3\4\0\10\3"+
    "\1\0\3\3\1\u0147\4\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\10\3\2\0\1\u0148"+
    "\2\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\3\3\1\u0149\4\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\3\3\1\u014a\4\3\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\1\3\1\u014b\6\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\4\3\1\u014c\11\3\37\0\2\321\1\0\2\321\1\0"+
    "\1\321\2\0\3\321\5\0\2\321\1\0\1\321\4\0"+
    "\1\321\37\0\1\3\4\0\10\3\1\0\3\3\1\u014d"+
    "\4\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\3\3\1\u014e"+
    "\12\3\27\0\1\3\4\0\10\3\1\0\1\3\1\u014f"+
    "\6\3\2\0\3\3\1\0\16\3\27\0\1\3\4\0"+
    "\10\3\1\0\10\3\2\0\3\3\1\0\5\3\1\u0150"+
    "\10\3\27\0\1\3\4\0\10\3\1\0\10\3\2\0"+
    "\3\3\1\0\15\3\1\u0151\27\0\1\3\4\0\10\3"+
    "\1\0\4\3\1\u0152\3\3\2\0\3\3\1\0\16\3"+
    "\27\0\1\3\4\0\10\3\1\0\7\3\1\u0153\2\0"+
    "\3\3\1\0\16\3\27\0\1\3\4\0\10\3\1\0"+
    "\3\3\1\u0154\4\3\2\0\3\3\1\0\16\3\27\0"+
    "\1\3\4\0\10\3\1\0\10\3\2\0\3\3\1\0"+
    "\5\3\1\u0155\10\3\25\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16380];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\22\1\1\11\7\1\10\11\4\1\3\11"+
    "\7\1\1\0\3\11\1\1\4\0\25\1\1\11\2\1"+
    "\1\11\25\1\2\11\1\1\1\11\1\1\13\11\2\0"+
    "\1\1\1\0\1\11\26\1\1\11\6\1\1\11\30\1"+
    "\1\11\1\1\1\11\2\0\2\11\25\1\2\0\31\1"+
    "\1\11\1\0\20\1\1\0\23\1\1\11\15\1\1\0"+
    "\24\1\1\0\16\1\1\0\21\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[341];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the
   * matched text
   */
  private int yycolumn;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Whether comments should be returned as tokens.
	 */
	private boolean returnComments;

	/**
	 * Whether whitespace should be returned as tokens.
	 */
	private boolean returnWhitespace;

	/**
	 * Whether the last documentation comment parsed should be kept.
	 */
	private boolean keepLastDocComment;

	/**
	 * The last documentation comment parsed, if that feature is enabled.
	 */
	private String lastDocComment;


	private Token createToken(int type) {
		return createToken(type, false);
	}


	private Token createToken(int type, boolean invalid) {
		return new TokenImpl(type, yytext(), yyline, yycolumn, yychar, invalid);
	}


	/**
	 * Returns the current column into the current line.
	 *
	 * @return The current column.
	 */
	public int getColumn() {
		return yycolumn;
	}


	/**
	 * Returns the last documentation comment parsed, if this feature is
	 * enabled.  The "last documentation comment" is cleared when this method
	 * returns.
	 *
	 * @return The last documentation comment parsed, or <code>null</code>
	 *         if the feature is disabled.
	 * @see #setKeepLastDocComment(boolean)
	 */
	public String getLastDocComment() {
		String comment = lastDocComment;
		lastDocComment = null;
		return comment;
	}


	/**
	 * Returns the current line into the document.
	 *
	 * @return The current line.
	 */
	public int getLine() {
		return yyline;
	}


	/**
	 * Returns the current offset into the document.
	 *
	 * @return The offset.
	 */
	public int getOffset() {
		return yychar;
	}


	/**
	 * Returns whether comments are returned as tokens.
	 *
	 * @return Whether comments are returned as tokens.
	 * @see #getReturnWhitespace()
	 */
	public boolean getReturnComments() {
		return returnComments;
	}


	/**
	 * Returns whether whitespace is returned as tokens.
	 *
	 * @return Whether whitespace is returned as tokens.
	 * @see #getReturnComments()
	 */
	public boolean getReturnWhitespace() {
		return returnWhitespace;
	}


	/**
	 * Sets whether the last documentation comment should be kept.
	 *
	 * @param keep Whether to keep the last documentation comment.
	 * @see #getLastDocComment()
	 */
	public void setKeepLastDocComment(boolean keep) {
		keepLastDocComment = keep;
	}


	/**
	 * Sets whether comments are returned as tokens.
	 *
	 * @param returnComments Whether comments should be returned as tokens.
	 * @see #getReturnComments()
	 * @see #setReturnWhitespace(boolean)
	 */
	public void setReturnComments(boolean returnComments) {
		this.returnComments = returnComments;
	}


	/**
	 * Sets whether whitespace is returned as tokens.
	 *
	 * @param returnWhitespace Whether whitespace should be returned as tokens.
	 * @see #getReturnWhitespace()
	 * @see #setReturnComments(boolean)
	 */
	public void setReturnWhitespace(boolean returnWhitespace) {
		this.returnWhitespace = returnWhitespace;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  SourceCodeScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  SourceCodeScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1776) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.rsta.ac.java.rjc.lexer.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 87:
          { return createToken(KEYWORD_THROWS);
          }
        case 112: break;
        case 11:
          { return createToken(SEPARATOR_LPAREN);
          }
        case 113: break;
        case 105:
          { return createToken(KEYWORD_VOLATILE);
          }
        case 114: break;
        case 95:
          { return createToken(KEYWORD_PUBLIC);
          }
        case 115: break;
        case 5:
          { return createToken(OPERATOR_TIMES);
          }
        case 116: break;
        case 71:
          { return createToken(KEYWORD_CASE);
          }
        case 117: break;
        case 34:
          { return createToken(OPERATOR_TIMES_EQUALS);
          }
        case 118: break;
        case 89:
          { return createToken(KEYWORD_ASSERT);
          }
        case 119: break;
        case 51:
          { return createToken(OPERATOR_DECREMENT);
          }
        case 120: break;
        case 15:
          { return createToken(SEPARATOR_LBRACKET);
          }
        case 121: break;
        case 104:
          { return createToken(KEYWORD_CONTINUE);
          }
        case 122: break;
        case 80:
          { return createToken(KEYWORD_SHORT);
          }
        case 123: break;
        case 26:
          { return createToken(OPERATOR_BITWISE_AND);
          }
        case 124: break;
        case 31:
          { return createToken(OPERATOR_MOD);
          }
        case 125: break;
        case 74:
          { return createToken(KEYWORD_VOID);
          }
        case 126: break;
        case 62:
          { return createToken(OPERATOR_LSHIFT_EQUALS);
          }
        case 127: break;
        case 38:
          { return createToken(OPERATOR_EQUALS_EQUALS);
          }
        case 128: break;
        case 69:
          { return createToken(LITERAL_NULL);
          }
        case 129: break;
        case 43:
          { return createToken(OPERATOR_NE);
          }
        case 130: break;
        case 28:
          { return createToken(OPERATOR_PLUS);
          }
        case 131: break;
        case 23:
          { return createToken(OPERATOR_BITWISE_NOT);
          }
        case 132: break;
        case 7:
          { return createToken(SEPARATOR_DOT);
          }
        case 133: break;
        case 102:
          { return createToken(KEYWORD_ABSTRACT);
          }
        case 134: break;
        case 92:
          { return createToken(KEYWORD_NATIVE);
          }
        case 135: break;
        case 35:
          { return createToken(LITERAL_STRING);
          }
        case 136: break;
        case 46:
          { return createToken(OPERATOR_BITWISE_OR_EQUALS);
          }
        case 137: break;
        case 60:
          { return createToken(OPERATOR_RSHIFT_EQUALS);
          }
        case 138: break;
        case 91:
          { return createToken(KEYWORD_SWITCH);
          }
        case 139: break;
        case 76:
          { return createToken(KEYWORD_THROW);
          }
        case 140: break;
        case 75:
          { return createToken(OPERATOR_RSHIFT2_EQUALS);
          }
        case 141: break;
        case 66:
          { return createToken(KEYWORD_ELSE);
          }
        case 142: break;
        case 3:
          { if (returnWhitespace) {
									return createToken(Token.WHITESPACE);
								}
          }
        case 143: break;
        case 54:
          { return createToken(ELIPSIS);
          }
        case 144: break;
        case 110:
          { return createToken(KEYWORD_IMPLEMENTS);
          }
        case 145: break;
        case 16:
          { return createToken(SEPARATOR_RBRACKET);
          }
        case 146: break;
        case 61:
          { return createToken(OPERATOR_RSHIFT2);
          }
        case 147: break;
        case 8:
          { return createToken(LITERAL_CHAR, true);
          }
        case 148: break;
        case 96:
          { return createToken(KEYWORD_EXTENDS);
          }
        case 149: break;
        case 84:
          { return createToken(KEYWORD_CONST);
          }
        case 150: break;
        case 94:
          { return createToken(KEYWORD_DOUBLE);
          }
        case 151: break;
        case 36:
          { return createToken(KEYWORD_IF);
          }
        case 152: break;
        case 83:
          { return createToken(KEYWORD_CLASS);
          }
        case 153: break;
        case 63:
          { return createToken(LITERAL_FP);
          }
        case 154: break;
        case 39:
          { return createToken(OPERATOR_GTE);
          }
        case 155: break;
        case 56:
          { return createToken(KEYWORD_FOR);
          }
        case 156: break;
        case 32:
          { if (returnComments) {
									return createToken(Token.COMMENT);
								}
          }
        case 157: break;
        case 70:
          { return createToken(KEYWORD_BYTE);
          }
        case 158: break;
        case 30:
          { return createToken(OPERATOR_BITWISE_XOR);
          }
        case 159: break;
        case 18:
          { return createToken(SEPARATOR_COMMA);
          }
        case 160: break;
        case 14:
          { return createToken(SEPARATOR_RBRACE);
          }
        case 161: break;
        case 41:
          { return createToken(OPERATOR_LTE);
          }
        case 162: break;
        case 57:
          { return createToken(LITERAL_CHAR);
          }
        case 163: break;
        case 58:
          { return createToken(KEYWORD_NEW);
          }
        case 164: break;
        case 48:
          { return createToken(OPERATOR_PLUS_EQUALS);
          }
        case 165: break;
        case 81:
          { return createToken(KEYWORD_BREAK);
          }
        case 166: break;
        case 1:
          { return createToken(IDENTIFIER, true);
          }
        case 167: break;
        case 9:
          { return createToken(LITERAL_STRING, true);
          }
        case 168: break;
        case 4:
          { return createToken(OPERATOR_DIVIDE);
          }
        case 169: break;
        case 29:
          { return createToken(OPERATOR_MINUS);
          }
        case 170: break;
        case 98:
          { return createToken(KEYWORD_BOOLEAN);
          }
        case 171: break;
        case 93:
          { return createToken(KEYWORD_IMPORT);
          }
        case 172: break;
        case 20:
          { return createToken(OPERATOR_GT);
          }
        case 173: break;
        case 47:
          { return createToken(OPERATOR_LOGICAL_OR);
          }
        case 174: break;
        case 2:
          { return createToken(IDENTIFIER);
          }
        case 175: break;
        case 53:
          { return createToken(OPERATOR_MOD_EQUALS);
          }
        case 176: break;
        case 100:
          { return createToken(KEYWORD_PRIVATE);
          }
        case 177: break;
        case 55:
          { return createToken(KEYWORD_TRY);
          }
        case 178: break;
        case 25:
          { return createToken(OPERATOR_COLON);
          }
        case 179: break;
        case 68:
          { return createToken(KEYWORD_LONG);
          }
        case 180: break;
        case 6:
          { return createToken(LITERAL_INT);
          }
        case 181: break;
        case 13:
          { return createToken(SEPARATOR_LBRACE);
          }
        case 182: break;
        case 45:
          { return createToken(OPERATOR_LOGICAL_AND);
          }
        case 183: break;
        case 21:
          { return createToken(OPERATOR_LT);
          }
        case 184: break;
        case 78:
          { return createToken(KEYWORD_FINAL);
          }
        case 185: break;
        case 24:
          { return createToken(OPERATOR_QUESTION);
          }
        case 186: break;
        case 19:
          { return createToken(OPERATOR_EQUALS);
          }
        case 187: break;
        case 108:
          { return createToken(KEYWORD_PROTECTED);
          }
        case 188: break;
        case 65:
          { return createToken(KEYWORD_THIS);
          }
        case 189: break;
        case 44:
          { return createToken(OPERATOR_BITWISE_AND_EQUALS);
          }
        case 190: break;
        case 109:
          { return createToken(KEYWORD_INSTANCEOF);
          }
        case 191: break;
        case 99:
          { return createToken(KEYWORD_DEFAULT);
          }
        case 192: break;
        case 40:
          { return createToken(OPERATOR_RSHIFT);
          }
        case 193: break;
        case 64:
          { return createToken(LITERAL_BOOLEAN);
          }
        case 194: break;
        case 67:
          { return createToken(KEYWORD_ENUM);
          }
        case 195: break;
        case 97:
          { return createToken(KEYWORD_FINALLY);
          }
        case 196: break;
        case 79:
          { return createToken(KEYWORD_SUPER);
          }
        case 197: break;
        case 77:
          { return createToken(KEYWORD_FLOAT);
          }
        case 198: break;
        case 101:
          { return createToken(KEYWORD_PACKAGE);
          }
        case 199: break;
        case 59:
          { return createToken(KEYWORD_INT);
          }
        case 200: break;
        case 22:
          { return createToken(OPERATOR_LOGICAL_NOT);
          }
        case 201: break;
        case 111:
          { return createToken(KEYWORD_SYNCHRONIZED);
          }
        case 202: break;
        case 73:
          { return createToken(KEYWORD_GOTO);
          }
        case 203: break;
        case 10:
          { return createToken(ANNOTATION_START);
          }
        case 204: break;
        case 12:
          { return createToken(SEPARATOR_RPAREN);
          }
        case 205: break;
        case 27:
          { return createToken(OPERATOR_BITWISE_OR);
          }
        case 206: break;
        case 49:
          { return createToken(OPERATOR_INCREMENT);
          }
        case 207: break;
        case 107:
          { return createToken(KEYWORD_INTERFACE);
          }
        case 208: break;
        case 88:
          { return createToken(KEYWORD_RETURN);
          }
        case 209: break;
        case 72:
          { return createToken(KEYWORD_CHAR);
          }
        case 210: break;
        case 17:
          { return createToken(SEPARATOR_SEMICOLON);
          }
        case 211: break;
        case 50:
          { return createToken(OPERATOR_MINUS_EQUALS);
          }
        case 212: break;
        case 33:
          { return createToken(OPERATOR_DIVIDE_EQUALS);
          }
        case 213: break;
        case 52:
          { return createToken(OPERATOR_BITWISE_XOR_EQUALS);
          }
        case 214: break;
        case 42:
          { return createToken(OPERATOR_LSHIFT);
          }
        case 215: break;
        case 103:
          { return createToken(KEYWORD_STRICTFP);
          }
        case 216: break;
        case 90:
          { return createToken(KEYWORD_STATIC);
          }
        case 217: break;
        case 85:
          { return createToken(KEYWORD_WHILE);
          }
        case 218: break;
        case 37:
          { return createToken(KEYWORD_DO);
          }
        case 219: break;
        case 106:
          { return createToken(KEYWORD_TRANSIENT);
          }
        case 220: break;
        case 86:
          { if (keepLastDocComment) {
									lastDocComment = yytext();
								}
								if (returnComments) {
									return createToken(Token.DOC_COMMENT);
								}
          }
        case 221: break;
        case 82:
          { return createToken(KEYWORD_CATCH);
          }
        case 222: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return null;
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
