/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.fife.ui.autocomplete.EmptyIcon;

public class DecorativeIconPanel
extends JPanel {
    public static final int WIDTH = 8;
    private JLabel iconLabel;
    private boolean showIcon;
    private String tip;
    protected static final EmptyIcon EMPTY_ICON = new EmptyIcon(8);

    public DecorativeIconPanel() {
        this.setLayout(new BorderLayout());
        this.iconLabel = new JLabel((Icon)EMPTY_ICON){

            @Override
            public String getToolTipText(MouseEvent e) {
                return DecorativeIconPanel.this.showIcon ? DecorativeIconPanel.this.tip : null;
            }
        };
        this.iconLabel.setVerticalAlignment(1);
        ToolTipManager.sharedInstance().registerComponent(this.iconLabel);
        this.add((Component)this.iconLabel, "North");
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public boolean getShowIcon() {
        return this.showIcon;
    }

    @Override
    public String getToolTipText() {
        return this.tip;
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.showIcon) {
            super.paintChildren(g);
        }
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = EMPTY_ICON;
        }
        this.iconLabel.setIcon(icon);
    }

    public void setShowIcon(boolean show) {
        if (show != this.showIcon) {
            this.showIcon = show;
            this.repaint();
        }
    }

    @Override
    public void setToolTipText(String tip) {
        this.tip = tip;
    }
}

