/* The following code was generated by JFlex 1.4.1 on 8/19/09 10:23 AM */

/*
 * 7/28/2009
 *
 * DelphiTokenMaker.java - Scanner for the Delphi programming language.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for the Delphi programming language.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>DelphiTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class DelphiTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int COMPILER_DIRECTIVE = 3;
  public static final int EOL_COMMENT = 5;
  public static final int YYINITIAL = 0;
  public static final int COMPILER_DIRECTIVE2 = 4;
  public static final int MLC = 1;
  public static final int MLC2 = 2;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\13\1\12\1\0\1\13\1\7\22\0\1\13\1\42\1\7"+
    "\1\10\1\11\1\42\1\42\1\14\1\17\1\21\1\20\1\27\1\42"+
    "\1\27\1\30\1\22\1\4\7\6\2\3\1\45\1\42\1\44\1\46"+
    "\1\44\1\42\1\43\3\5\1\25\1\26\1\25\5\1\1\24\13\1"+
    "\1\23\2\1\1\41\1\0\1\41\1\44\1\2\1\0\1\36\1\55"+
    "\1\60\1\62\1\34\1\35\1\56\1\47\1\51\1\66\1\67\1\37"+
    "\1\54\1\57\1\61\1\50\1\70\1\32\1\40\1\31\1\33\1\63"+
    "\1\52\1\64\1\53\1\65\1\15\1\7\1\16\1\42\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\2\3\1\2\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\11\1\12\11\2\1\12"+
    "\14\2\1\13\1\14\1\15\4\13\1\16\2\13\1\17"+
    "\1\20\1\13\1\21\2\13\1\22\3\13\1\23\1\3"+
    "\1\24\1\23\1\24\1\23\1\25\1\23\1\26\1\27"+
    "\1\30\1\31\3\2\1\32\15\2\1\32\20\2\1\32"+
    "\31\2\1\32\3\2\4\0\1\33\1\34\4\0\1\24"+
    "\1\0\2\25\1\35\22\2\1\36\2\2\1\32\73\2"+
    "\1\32\1\2\10\0\1\37\1\2\1\40\1\36\56\2"+
    "\1\40\2\2\1\36\16\2\2\0\1\41\2\0\1\42"+
    "\13\2\1\32\40\2\1\32\10\2\4\0\10\2\1\36"+
    "\65\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[437];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\71\0\162\0\253\0\344\0\u011d\0\u0156\0\u018f"+
    "\0\u01c8\0\u0201\0\u023a\0\u0273\0\u023a\0\u02ac\0\u02e5\0\u031e"+
    "\0\u0357\0\u023a\0\u023a\0\u0390\0\u03c9\0\u0402\0\u043b\0\u0474"+
    "\0\u04ad\0\u04e6\0\u051f\0\u0558\0\u0591\0\u0156\0\u05ca\0\u0603"+
    "\0\u063c\0\u0675\0\u06ae\0\u06e7\0\u0720\0\u0759\0\u0792\0\u07cb"+
    "\0\u0804\0\u083d\0\u0876\0\u023a\0\u023a\0\u08af\0\u08e8\0\u0921"+
    "\0\u095a\0\u023a\0\u0993\0\u09cc\0\u023a\0\u023a\0\u0a05\0\u023a"+
    "\0\u0a3e\0\u0a77\0\u023a\0\u0ab0\0\u0ae9\0\u0b22\0\u0b5b\0\u0b5b"+
    "\0\u0b5b\0\u0b94\0\u0bcd\0\u0c06\0\u0c3f\0\u0c78\0\u023a\0\u023a"+
    "\0\u0cb1\0\u023a\0\u0cea\0\u0d23\0\u0d5c\0\u018f\0\u0d95\0\u0dce"+
    "\0\u0e07\0\u0e40\0\u0e79\0\u0eb2\0\u0eeb\0\u0f24\0\u0f5d\0\u0f96"+
    "\0\u0fcf\0\u1008\0\u1041\0\u107a\0\u10b3\0\u10ec\0\u1125\0\u115e"+
    "\0\u1197\0\u11d0\0\u1209\0\u1242\0\u127b\0\u12b4\0\u12ed\0\u1326"+
    "\0\u135f\0\u1398\0\u13d1\0\u140a\0\u1443\0\u147c\0\u14b5\0\u14ee"+
    "\0\u1527\0\u1560\0\u1599\0\u15d2\0\u160b\0\u1644\0\u167d\0\u16b6"+
    "\0\u16ef\0\u1728\0\u1761\0\u179a\0\u17d3\0\u180c\0\u1845\0\u187e"+
    "\0\u18b7\0\u18f0\0\u1929\0\u1962\0\u199b\0\u19d4\0\u1a0d\0\u1a46"+
    "\0\u1a7f\0\u1ab8\0\u1af1\0\u1b2a\0\u1b63\0\u1b9c\0\u023a\0\u023a"+
    "\0\u1bd5\0\u1c0e\0\u1c47\0\u1c80\0\u1cb9\0\u1cf2\0\u0b5b\0\u1d2b"+
    "\0\u023a\0\u1d64\0\u1d9d\0\u1dd6\0\u1e0f\0\u1e48\0\u1e81\0\u1eba"+
    "\0\u1ef3\0\u1f2c\0\u1f65\0\u1f9e\0\u1fd7\0\u2010\0\u2049\0\u2082"+
    "\0\u20bb\0\u20f4\0\u212d\0\u018f\0\u2166\0\u219f\0\u21d8\0\u2211"+
    "\0\u224a\0\u2283\0\u22bc\0\u22f5\0\u232e\0\u2367\0\u23a0\0\u23d9"+
    "\0\u2412\0\u244b\0\u2484\0\u24bd\0\u24f6\0\u252f\0\u2568\0\u25a1"+
    "\0\u25da\0\u2613\0\u264c\0\u2685\0\u26be\0\u26f7\0\u2730\0\u2769"+
    "\0\u27a2\0\u27db\0\u2814\0\u284d\0\u2886\0\u28bf\0\u28f8\0\u2931"+
    "\0\u296a\0\u29a3\0\u29dc\0\u2a15\0\u2a4e\0\u2a87\0\u2ac0\0\u2af9"+
    "\0\u2b32\0\u2b6b\0\u2ba4\0\u2bdd\0\u2c16\0\u2c4f\0\u2c88\0\u2cc1"+
    "\0\u2cfa\0\u2d33\0\u2d6c\0\u2da5\0\u2dde\0\u2e17\0\u2e50\0\u2e89"+
    "\0\u2ec2\0\u2efb\0\u2f34\0\u2f6d\0\u2fa6\0\u2fdf\0\u3018\0\u3051"+
    "\0\u308a\0\u30c3\0\u30fc\0\u3135\0\u018f\0\u316e\0\u018f\0\u31a7"+
    "\0\u31e0\0\u3219\0\u3252\0\u328b\0\u32c4\0\u32fd\0\u3336\0\u336f"+
    "\0\u33a8\0\u33e1\0\u341a\0\u3453\0\u348c\0\u34c5\0\u34fe\0\u3537"+
    "\0\u3570\0\u35a9\0\u35e2\0\u361b\0\u3654\0\u368d\0\u36c6\0\u36ff"+
    "\0\u3738\0\u3771\0\u37aa\0\u37e3\0\u381c\0\u3855\0\u388e\0\u38c7"+
    "\0\u3900\0\u3939\0\u3972\0\u39ab\0\u39e4\0\u3a1d\0\u3a56\0\u3a8f"+
    "\0\u3ac8\0\u3b01\0\u3b3a\0\u3b73\0\u3bac\0\u3be5\0\u3c1e\0\u3c57"+
    "\0\u3c90\0\u3cc9\0\u3d02\0\u3d3b\0\u3d74\0\u3dad\0\u3de6\0\u3e1f"+
    "\0\u3e58\0\u3e91\0\u3eca\0\u3f03\0\u3f3c\0\u3f75\0\u3fae\0\u3fe7"+
    "\0\u4020\0\u4059\0\u4092\0\u40cb\0\u4104\0\u413d\0\u4176\0\u41af"+
    "\0\u41e8\0\u4221\0\u425a\0\u4293\0\u42cc\0\u4305\0\u433e\0\u4377"+
    "\0\u43b0\0\u43e9\0\u4422\0\u445b\0\u4494\0\u44cd\0\u4506\0\u453f"+
    "\0\u4578\0\u45b1\0\u45ea\0\u4623\0\u465c\0\u4695\0\u46ce\0\u4707"+
    "\0\u4740\0\u4779\0\u47b2\0\u47eb\0\u4824\0\u485d\0\u4896\0\u48cf"+
    "\0\u4908\0\u4941\0\u497a\0\u49b3\0\u49ec\0\u4a25\0\u4a5e\0\u4a97"+
    "\0\u4ad0\0\u4b09\0\u3eca\0\u4b42\0\u4b7b\0\u4bb4\0\u4bed\0\u4c26"+
    "\0\u4c5f\0\u4c98\0\u4cd1\0\u4d0a\0\u4092\0\u4d43\0\u413d\0\u4d7c"+
    "\0\u4db5\0\u4dee\0\u4e27\0\u4e60\0\u4e99\0\u4ed2\0\u4f0b\0\u1fd7"+
    "\0\u4f44\0\u4f7d\0\u4fb6\0\u4fef\0\u5028\0\u5061\0\u509a\0\u50d3"+
    "\0\u510c\0\u5145\0\u517e\0\u51b7\0\u51f0\0\u5229\0\u5262\0\u529b"+
    "\0\u52d4\0\u530d\0\u5346\0\u537f\0\u53b8\0\u53f1\0\u542a\0\u5463"+
    "\0\u549c\0\u54d5\0\u550e\0\u5547\0\u5580\0\u55b9\0\u55f2\0\u562b"+
    "\0\u5664\0\u569d\0\u56d6\0\u570f\0\u5748\0\u5781\0\u57ba\0\u57f3"+
    "\0\u582c\0\u5865\0\u589e\0\u58d7\0\u5910\0\u5949\0\u5982\0\u59bb"+
    "\0\u59f4\0\u5a2d\0\u5a66\0\u5a9f\0\u5ad8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[437];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\2\10\1\11\1\12\1\10\1\11\1\13\1\14"+
    "\1\10\1\15\1\16\1\17\1\20\1\13\1\21\1\22"+
    "\1\23\1\24\4\10\1\22\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\23\1\13\1\36"+
    "\3\22\1\10\1\37\1\40\1\41\1\10\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\1\51\1\52\4\10"+
    "\12\53\1\54\3\53\1\55\16\53\1\56\11\53\1\57"+
    "\2\53\1\60\16\53\12\61\1\62\5\61\1\63\14\61"+
    "\1\56\11\61\1\57\2\61\1\60\16\61\12\64\1\65"+
    "\3\64\1\66\52\64\12\67\1\70\5\67\1\71\50\67"+
    "\12\72\1\73\22\72\1\74\11\72\1\75\2\72\1\76"+
    "\16\72\7\7\1\0\2\7\11\0\4\7\2\0\10\7"+
    "\2\0\1\7\3\0\23\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\22\10"+
    "\3\77\2\11\1\77\1\11\1\0\2\77\11\0\1\77"+
    "\1\100\1\101\1\102\1\0\1\103\3\77\1\102\1\101"+
    "\1\77\1\100\1\77\2\0\1\77\3\0\13\77\1\101"+
    "\11\77\1\104\1\105\1\77\1\105\1\0\2\77\11\0"+
    "\1\106\1\100\1\101\1\102\1\0\1\103\3\77\1\102"+
    "\1\101\1\77\1\100\1\77\2\0\1\77\3\0\13\77"+
    "\1\101\1\77\1\106\4\77\71\0\3\7\2\14\1\7"+
    "\1\14\1\0\2\7\11\0\4\7\2\0\10\7\2\0"+
    "\1\7\3\0\22\7\13\0\1\16\55\0\14\17\1\107"+
    "\54\17\11\0\1\110\77\0\1\111\72\0\1\112\51\0"+
    "\2\103\1\0\1\103\62\0\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\113\6\10\2\0"+
    "\1\7\3\0\1\114\3\10\1\115\5\10\1\116\7\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\3\10\1\117\1\10\1\120\2\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\7\10\1\121\2\0\1\7\3\0\10\10\1\122"+
    "\11\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\123\1\10\2\0\1\7\3\0\10\10"+
    "\1\124\4\10\1\125\4\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\2\10\1\126\2\10\1\127"+
    "\2\10\2\0\1\7\3\0\2\10\1\130\7\10\1\131"+
    "\7\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\116\1\132\1\133\4\10\1\134\2\0\1\7"+
    "\3\0\6\10\1\135\13\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\5\10\1\136\2\10\2\0"+
    "\1\7\3\0\2\10\1\137\7\10\1\140\7\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\141"+
    "\2\10\1\142\1\10\1\143\2\10\2\0\1\7\3\0"+
    "\1\144\1\10\1\145\2\10\1\146\14\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\147"+
    "\1\150\2\10\1\151\1\152\1\10\2\0\1\7\3\0"+
    "\12\10\1\153\7\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\4\10\1\116\2\10\1\116\2\0"+
    "\1\7\3\0\5\10\1\154\2\10\1\155\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\156\6\10\2\0\1\7\3\0\1\157\1\10\1\160"+
    "\7\10\1\161\7\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\162\4\10\2\0\1\7"+
    "\3\0\12\10\1\124\7\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\163\4\10\2\0"+
    "\1\7\3\0\4\10\1\164\5\10\1\165\7\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\12\10\1\166\7\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\167"+
    "\1\10\1\170\2\10\2\0\1\7\3\0\2\10\1\171"+
    "\7\10\1\172\7\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\2\10\1\173\2\10\1\174\1\175"+
    "\1\10\2\0\1\7\3\0\1\176\11\10\1\177\1\200"+
    "\6\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\10\1\116\1\201\1\10\1\116\3\10\2\0"+
    "\1\7\3\0\6\10\1\202\1\10\1\116\3\10\1\203"+
    "\5\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\204\4\10\2\0\1\7\3\0\2\10"+
    "\1\205\1\10\1\206\5\10\1\207\7\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\210"+
    "\2\10\2\0\1\7\3\0\2\10\1\211\17\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\12\10\1\212\7\10\12\53\1\0"+
    "\3\53\1\0\16\53\1\0\11\53\1\0\2\53\1\0"+
    "\16\53\31\0\1\213\17\0\1\214\50\0\1\215\111\0"+
    "\1\216\16\0\12\61\1\0\5\61\1\0\14\61\1\0"+
    "\11\61\1\0\2\61\1\0\16\61\21\0\1\217\47\0"+
    "\12\64\1\0\3\64\1\0\52\64\12\67\1\0\5\67"+
    "\1\0\50\67\21\0\1\220\47\0\12\72\1\0\22\72"+
    "\1\0\11\72\1\0\2\72\1\0\16\72\31\0\1\221"+
    "\17\0\1\222\50\0\1\223\111\0\1\224\16\0\7\77"+
    "\1\0\2\77\11\0\4\77\2\0\10\77\2\0\1\77"+
    "\3\0\25\77\2\225\1\77\1\225\1\0\2\77\11\0"+
    "\4\77\1\226\1\0\10\77\2\0\1\77\3\0\25\77"+
    "\2\103\1\77\1\103\1\0\2\77\11\0\2\77\1\101"+
    "\1\102\2\0\3\77\1\102\1\101\3\77\2\0\1\77"+
    "\3\0\13\77\1\101\11\77\2\104\1\77\1\104\1\0"+
    "\2\77\11\0\2\77\1\101\1\102\1\0\1\103\3\77"+
    "\1\102\1\101\3\77\2\0\1\77\3\0\13\77\1\101"+
    "\11\77\1\104\1\105\1\77\1\105\1\0\2\77\11\0"+
    "\1\77\1\227\1\101\1\102\1\0\1\103\3\77\1\102"+
    "\1\101\1\77\1\227\1\77\2\0\1\77\3\0\13\77"+
    "\1\101\11\77\4\230\1\0\2\77\11\0\2\77\2\230"+
    "\2\0\3\77\3\230\2\77\2\0\1\77\3\0\6\77"+
    "\1\230\2\77\1\230\1\77\1\230\6\77\11\0\1\231"+
    "\57\0\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\2\10\1\232\5\10\2\0\1\7\3\0\4\10"+
    "\1\116\15\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\233\1\10\1\234\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\1\10"+
    "\1\235\20\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\5\10\1\236\1\10\1\237\2\0\1\7"+
    "\3\0\1\10\1\240\1\241\4\10\1\242\1\10\1\243"+
    "\7\10\1\244\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\2\10\1\123"+
    "\17\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\245\4\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\246\6\10\1\247\2\0\1\7\3\0\2\10\1\201"+
    "\17\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\7\10\1\235\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\13\10\1\116\6\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\250\7\10"+
    "\2\0\1\7\3\0\1\10\1\251\7\10\1\252\10\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\10\10\1\253\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\254\4\10\1\255\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\6\10\1\235\1\10\2\0\1\7\3\0\10\10\1\256"+
    "\11\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\10\1\257\6\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\10\1\260\6\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\261"+
    "\7\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\7\10\1\262\2\0"+
    "\1\7\3\0\5\10\1\116\14\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\7\10\1\263\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\6\10"+
    "\1\264\13\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\6\10\1\265"+
    "\13\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\10\10\1\266\1\267"+
    "\10\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\10\1\270\3\10\1\271\2\10\2\0\1\7"+
    "\3\0\12\10\1\272\1\273\6\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\116\4\10\1\274"+
    "\1\275\1\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\4\10\1\276"+
    "\3\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\10\1\116\4\10"+
    "\1\116\1\10\2\0\1\7\3\0\12\10\1\277\7\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\10\10\1\300\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\5\10"+
    "\1\301\2\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\2\10\1\302\7\10\1\303\7\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\6\10\1\304\13\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\7\10\1\305"+
    "\2\0\1\7\3\0\11\10\1\306\10\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\307"+
    "\2\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\2\10\1\310\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\1\10\1\311\20\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\312\5\10\1\313\1\10\2\0"+
    "\1\7\3\0\1\314\1\10\1\315\10\10\1\316\6\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\2\10\1\317\17\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\2\10\1\320\17\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\321\7\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\322\6\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\7\10\1\323\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\7\10\1\324\12\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\325\7\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\12\10\1\326\7\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\327\7\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\5\10\1\330\2\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\5\10\1\331"+
    "\14\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\254\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\116\7\10\2\0\1\7\3\0\13\10\1\332\6\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\10\1\333\6\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\334\5\10\1\235\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\5\10"+
    "\1\335\2\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\336"+
    "\2\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\5\10\1\337\2\10\1\340\11\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\341"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\116\7\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\17\10"+
    "\1\342\2\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\3\10\1\343\4\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\4\10\1\344\2\10\1\345\2\0\1\7\3\0"+
    "\1\10\1\346\20\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\7\10\1\347\2\0\1\7\3\0"+
    "\14\10\1\116\5\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\10\10"+
    "\1\350\11\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\2\10\1\351\5\10\2\0\1\7\3\0"+
    "\3\10\1\352\16\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\10\1\353\6\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\354\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\10\1\116\6\10\2\0\1\7\3\0\22\10"+
    "\50\0\1\355\57\0\1\356\62\0\1\357\111\0\1\360"+
    "\66\0\1\361\57\0\1\362\62\0\1\363\111\0\1\364"+
    "\16\0\3\77\2\225\1\77\1\225\1\0\2\77\11\0"+
    "\2\77\1\101\1\77\2\0\4\77\1\101\3\77\2\0"+
    "\1\77\3\0\13\77\1\101\6\77\3\0\2\225\1\0"+
    "\1\225\62\0\3\77\4\230\1\0\2\77\11\0\1\77"+
    "\1\227\2\230\2\0\3\77\3\230\1\227\1\77\2\0"+
    "\1\77\3\0\6\77\1\230\2\77\1\230\1\77\1\230"+
    "\6\77\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\365\4\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\3\10\1\366\4\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\10\10\1\116\11\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\116"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\6\10\1\367\1\10"+
    "\2\0\1\7\3\0\13\10\1\370\6\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\2\10\1\371\7\10\1\372\7\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\3\10"+
    "\1\373\4\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\10\10\1\374\11\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\2\10\1\375\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\12\10\1\376\7\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\2\10\1\377\5\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\7\10\1\116\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\2\10\1\u0100\17\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\5\10"+
    "\1\u0101\2\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u0102"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\12\10\1\u0103\7\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u0104\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\11\10"+
    "\1\u0105\10\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\7\10\1\232\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\5\10\1\u0106\2\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\3\10\1\u0107\16\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\u0108"+
    "\2\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\12\10\1\u0109\7\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u010a\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\u010b\7\10\2\0\1\7\3\0"+
    "\12\10\1\u010c\7\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\u0100\4\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u010d\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\7\10\1\u010e\12\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\5\10\1\171\2\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\2\10\1\u010f\17\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\u0110\7\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\u0111\6\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\11\10"+
    "\1\u0112\10\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\6\10\1\u0113\1\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\4\10\1\254\3\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\3\10\1\273\4\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\u0114\6\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\7\10\1\u0115\12\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\6\10\1\u0116\1\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\14\10\1\u0117\5\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\u0118\7\10\2\0\1\7\3\0"+
    "\1\10\1\u0119\5\10\1\u011a\1\10\1\u011b\10\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\6\10"+
    "\1\u011c\1\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\11\10\1\267\10\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\20\10\1\u011d\1\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\u011e\7\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\10\10\1\u011f"+
    "\11\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\u0120\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\3\10\1\u0121\4\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\2\10\1\u0122\17\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u0123"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\u0124\7\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\u0125\4\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\u0126\7\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\6\10\1\235\1\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\1\116\21\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\13\10\1\u0127\6\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\7\10\1\u0128\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\2\10\1\234"+
    "\17\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\u0127\4\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\6\10\1\u0129\1\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\12\10\1\116\7\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\254"+
    "\6\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\3\10\1\u012a\4\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u012b\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\10\1\u012c\6\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\13\10\1\u012d"+
    "\6\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\7\10\1\245\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\367\6\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\1\10\1\367\20\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\u012e\6\10\1\u012f"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\11\10\1\171\10\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\u0130\4\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u0131\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u0132\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\u0133\7\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\u0134"+
    "\6\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\1\10\1\u0135\20\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\5\10\1\u0136\2\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\6\10"+
    "\1\u0115\13\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\10\10\1\166"+
    "\11\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u0137\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\u0138\7\10\2\0\1\7\3\0\22\10\45\0\1\u0139"+
    "\57\0\1\355\104\0\1\u013a\50\0\1\u013b\105\0\1\u013c"+
    "\57\0\1\361\104\0\1\u013d\50\0\1\u013e\40\0\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\5\10"+
    "\1\u013f\2\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\12\10\1\u0140\7\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\13\10\1\u0141\6\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\2\10\1\u0142\5\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\5\10\1\201\2\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\u0143\7\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\7\10\1\u0144\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\124"+
    "\6\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\2\10\1\u0145\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\6\10\1\116\1\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\4\10\1\235\3\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u0146\6\10\2\0\1\7\3\0"+
    "\10\10\1\u0147\11\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\10\1\u0148\6\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\1\10\1\201"+
    "\20\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\u0149\7\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\6\10"+
    "\1\u014a\1\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\u014b"+
    "\2\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\4\10\1\116\15\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\5\10\1\u014c\14\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\5\10"+
    "\1\u014d\14\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u014e\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\u014f\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\5\10\1\u0150\2\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\2\10\1\u0151\3\10\1\u0152\13\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\10\10\1\u0153\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\2\10\1\u0154\17\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u0155"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\5\10\1\u0156\2\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\124\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\u0157\7\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\u0158\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\6\10\1\u0157\1\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\5\10"+
    "\1\u0159\2\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u015a"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\3\10\1\u015b\4\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\u015c\6\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\u015d\4\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\2\10\1\u015e"+
    "\17\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\124\1\10\1\u015f\2\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\4\10\1\u0160\3\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\u0161\7\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\3\10"+
    "\1\u0162\4\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\u0163"+
    "\6\10\2\0\1\7\3\0\7\10\1\u0161\12\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\10\10\1\235\11\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\u0164"+
    "\6\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\2\10\1\u0165\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\15\10\1\254\4\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\3\10\1\370\4\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\6\10\1\u0152"+
    "\13\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u015f\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\3\10\1\u0166\4\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\7\10"+
    "\1\u0167\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\4\10\1\344\3\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u0168\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\2\10"+
    "\1\u0169\17\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\5\10\1\u016a\2\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\u016b\7\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\11\10\1\201\10\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\u016c"+
    "\4\10\1\u016d\1\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\2\10"+
    "\1\u016e\5\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\10\1\u016f"+
    "\6\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\3\10\1\u0170\4\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\2\10\1\u0171\17\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\5\10"+
    "\1\u0172\14\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u0173\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\2\10\1\267\5\10\2\0\1\7\3\0\22\10"+
    "\22\0\1\u0174\106\0\1\355\4\0\1\u0139\24\0\1\u013b"+
    "\1\u0175\4\u013b\1\0\1\u0175\1\u013b\2\0\1\u0175\2\0"+
    "\3\u0175\5\u013b\2\u0175\10\u013b\3\u0175\1\0\2\u0175\22\u013b"+
    "\22\0\1\u0176\106\0\1\361\4\0\1\u013c\24\0\1\u013e"+
    "\1\u0177\4\u013e\1\0\1\u0177\1\u013e\2\0\1\u0177\2\0"+
    "\3\u0177\5\u013e\2\u0177\10\u013e\3\u0177\1\0\2\u0177\22\u013e"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\13\10\1\u0178\6\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\10\10\1\u0179\11\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u017a"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\10\1\u017b\6\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\u017c\6\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\u017d\7\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\10\1\u017e\6\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\10\10\1\267\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\13\10\1\u017f\6\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\u0180\7\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\2\10\1\u0181\17\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\6\10\1\u0108\1\10\2\0\1\7"+
    "\3\0\2\10\1\u0182\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\u0155\6\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\5\10\1\u0183\2\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\6\10\1\u0184"+
    "\13\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u0185\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\2\10\1\u0159\5\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\u0186\6\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\10\10\1\u0187\11\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\12\10\1\u0188\7\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\7\10\1\116\12\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\11\10"+
    "\1\116\10\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\13\10\1\254"+
    "\6\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\6\10\1\171\1\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\2\10\1\u0151\17\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\3\10"+
    "\1\367\4\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\1\u0189\7\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\11\10\1\u0183\10\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\1\10\1\u018a\6\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\5\10\1\u018b\2\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\13\10\1\u018c\6\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\7\10\1\u018d\2\0\1\7\3\0\11\10\1\254\10\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\7\10\1\u0189\12\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\12\10\1\u018e\7\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\336"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\5\10\1\u018f\14\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\4\10\1\u0190\3\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\2\10"+
    "\1\u0191\17\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\5\10\1\u0192\2\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u0193\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\1\10\1\u0194\20\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\10\10\1\u0195\11\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\10\10\1\u0196\11\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\2\10\1\u0197\17\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\2\10\1\u0198\17\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\12\10"+
    "\1\u0199\7\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\6\10\1\u019a\1\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\2\10\1\u019b\5\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\11\10\1\u014c\10\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\10\10\1\u019c\2\10\1\254\6\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\2\10\1\u019d\17\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\7\10\1\u019e\12\10\22\0\1\u013b"+
    "\70\0\1\u013e\46\0\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\14\10"+
    "\1\u019f\5\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\6\10\1\u0186\1\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\10\10\1\u019a\11\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\11\10\1\u01a0\10\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\12\10\1\u01a1\7\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\330"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\3\10\1\u019e\4\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u01a2\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\12\10"+
    "\1\234\7\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\16\10\1\u01a3"+
    "\3\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\1\u0111\7\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\6\10"+
    "\1\u017d\1\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\11\10\1\u019a\10\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\4\10\1\254\15\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\367\7\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\12\10\1\u01a4"+
    "\7\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\254\4\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\u0108\7\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\5\10\1\116\14\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\2\10\1\u01a5\5\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\1\u0111\21\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\10\1\u01a6\6\10\2\0\1\7\3\0"+
    "\22\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\3\10\1\u01a7\4\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\5\10\1\u01a8\2\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\u0113"+
    "\7\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\6\10\1\u01a9\1\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\10\10\1\367\11\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\5\10\1\u01aa\2\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\11\10\1\u01ab"+
    "\10\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u01a4\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\10\10\1\u019e\11\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\10\10"+
    "\2\0\1\7\3\0\13\10\1\u0189\6\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\5\10\1\u0155"+
    "\2\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\1\254\7\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\11\10"+
    "\1\u01ac\10\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\u01ad\7\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\10\10\2\0\1\7\3\0\11\10\1\254\10\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\7\10"+
    "\1\254\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\5\10\1\212\2\10"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\3\10\1\u01ae\4\10\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\13\10"+
    "\1\u01af\6\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\13\10\1\367"+
    "\6\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\5\10\1\u0105\2\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\6\10\1\367\1\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\10"+
    "\1\235\6\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\10\10\2\0"+
    "\1\7\3\0\5\10\1\254\14\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\10\10\1\u01b0\11\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\10\10\2\0\1\7\3\0"+
    "\11\10\1\235\10\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\10\10\2\0\1\7\3\0\2\10"+
    "\1\u0182\17\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\10\10\2\0\1\7\3\0\11\10\1\u017e"+
    "\10\10\1\7\6\10\1\0\1\7\1\10\11\0\4\10"+
    "\2\0\10\10\2\0\1\7\3\0\4\10\1\367\15\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\52\7\10\2\0\1\7\3\0\22\10\1\7\6\10"+
    "\1\0\1\7\1\10\11\0\4\10\2\0\3\10\1\u01b1"+
    "\4\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\7\10\1\u01b2\2\0"+
    "\1\7\3\0\22\10\1\7\6\10\1\0\1\7\1\10"+
    "\11\0\4\10\2\0\2\10\1\u01b3\5\10\2\0\1\7"+
    "\3\0\22\10\1\7\6\10\1\0\1\7\1\10\11\0"+
    "\4\10\2\0\1\u01b4\7\10\2\0\1\7\3\0\22\10"+
    "\1\7\6\10\1\0\1\7\1\10\11\0\4\10\2\0"+
    "\1\10\1\u0163\6\10\2\0\1\7\3\0\22\10\1\7"+
    "\6\10\1\0\1\7\1\10\11\0\4\10\2\0\1\u01b5"+
    "\7\10\2\0\1\7\3\0\22\10\1\7\6\10\1\0"+
    "\1\7\1\10\11\0\4\10\2\0\10\10\2\0\1\7"+
    "\3\0\11\10\1\u0189\10\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\5\10\1\u0105\1\10\1\254"+
    "\2\0\1\7\3\0\22\10\1\7\6\10\1\0\1\7"+
    "\1\10\11\0\4\10\2\0\1\10\1\270\6\10\2\0"+
    "\1\7\3\0\22\10";

  private static int [] zzUnpackTrans() {
    int [] result = new int[23313];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\4\1\1\11\1\1\1\11\4\1\2\11\30\1"+
    "\2\11\4\1\1\11\2\1\2\11\1\1\1\11\2\1"+
    "\1\11\13\1\2\11\1\1\1\11\100\1\4\0\2\11"+
    "\4\0\1\1\1\0\2\1\1\11\123\1\10\0\104\1"+
    "\2\0\1\1\2\0\66\1\4\0\76\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[437];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Token type specific to DelphiTokenMaker; denotes a line ending
	 * with an unterminated "(*" comment.
	 */
	public static final int INTERNAL_MLC2			= -1;

	/**
	 * Token type specific to DelphiTokenMaker; denotes a line ending
	 * with an unterminated "{$" compiler directive.
	 */
	public static final int INTERNAL_COMPILER_DIRECTIVE	= -2;

	/**
	 * Token type specific to DelphiTokenMaker; denotes a line ending
	 * with an unterminated "(*$" compiler directive.
	 */
	public static final int INTERNAL_COMPILER_DIRECTIVE2	= -3;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public DelphiTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, false);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 * @param hyperlink Whether this token is a hyperlink.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType,
						int startOffset, boolean hyperlink) {
		super.addToken(array, start,end, tokenType, startOffset, hyperlink);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			case INTERNAL_MLC2:
				state = MLC2;
				start = text.offset;
				break;
			case INTERNAL_COMPILER_DIRECTIVE:
				state = COMPILER_DIRECTIVE;
				start = text.offset;
				break;
			case INTERNAL_COMPILER_DIRECTIVE2:
				state = COMPILER_DIRECTIVE2;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DelphiTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DelphiTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 158) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 15:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_COMPILER_DIRECTIVE); return firstToken;
          }
        case 35: break;
        case 4:
          { addToken(Token.PREPROCESSOR);
          }
        case 36: break;
        case 5:
          { addNullToken(); return firstToken;
          }
        case 37: break;
        case 27:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 38: break;
        case 6:
          { addToken(Token.WHITESPACE);
          }
        case 39: break;
        case 21:
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 40: break;
        case 20:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 41: break;
        case 26:
          { addToken(Token.RESERVED_WORD);
          }
        case 42: break;
        case 16:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.PREPROCESSOR);
          }
        case 43: break;
        case 9:
          { addToken(Token.SEPARATOR);
          }
        case 44: break;
        case 17:
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_COMPILER_DIRECTIVE2); return firstToken;
          }
        case 45: break;
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 46: break;
        case 18:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 47: break;
        case 25:
          { start = zzMarkedPos-2; yybegin(EOL_COMMENT);
          }
        case 48: break;
        case 30:
          { addToken(Token.FUNCTION);
          }
        case 49: break;
        case 7:
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 50: break;
        case 14:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_MLC2); return firstToken;
          }
        case 51: break;
        case 32:
          { addToken(Token.DATA_TYPE);
          }
        case 52: break;
        case 1:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 53: break;
        case 31:
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 54: break;
        case 22:
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 55: break;
        case 34:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 56: break;
        case 29:
          { start = zzMarkedPos-3; yybegin(COMPILER_DIRECTIVE2);
          }
        case 57: break;
        case 24:
          { start = zzMarkedPos-2; yybegin(MLC2);
          }
        case 58: break;
        case 33:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 59: break;
        case 19:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 60: break;
        case 28:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.PREPROCESSOR);
          }
        case 61: break;
        case 13:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.COMMENT_MULTILINE);
          }
        case 62: break;
        case 3:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 63: break;
        case 10:
          { addToken(Token.OPERATOR);
          }
        case 64: break;
        case 8:
          { start = zzMarkedPos-1; yybegin(MLC);
          }
        case 65: break;
        case 23:
          { start = zzMarkedPos-2; yybegin(COMPILER_DIRECTIVE);
          }
        case 66: break;
        case 11:
          {
          }
        case 67: break;
        case 12:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 68: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case COMPILER_DIRECTIVE: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_COMPILER_DIRECTIVE); return firstToken;
            }
            case 438: break;
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 439: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 440: break;
            case COMPILER_DIRECTIVE2: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_COMPILER_DIRECTIVE2); return firstToken;
            }
            case 441: break;
            case MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 442: break;
            case MLC2: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_MLC2); return firstToken;
            }
            case 443: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
