/* The following code was generated by JFlex 1.4.1 on 10/11/20 11:23 PM */

/*
 * MarkdownTokenMaker.java - Generates tokens for Markdown syntax highlighting.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Markdown files.  This is based off of our {@code HTMLTokenMaker}
 * class, and as such, probably highlights more HTML than it should.  Still, it
 * should be good enough for most use cases.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>MarkdownTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class MarkdownTokenMaker extends AbstractMarkupTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int CODE = 12;
  public static final int INTAG_CHECK_TAG_NAME = 2;
  public static final int STRIKETHROUGH = 11;
  public static final int BOLDITALIC2 = 6;
  public static final int BOLDITALIC1 = 5;
  public static final int ITALIC2 = 10;
  public static final int ITALIC1 = 9;
  public static final int BOLD2 = 8;
  public static final int BOLD1 = 7;
  public static final int SYNTAX_HIGHLIGHTING = 13;
  public static final int INATTR_SINGLE = 4;
  public static final int INATTR_DOUBLE = 3;
  public static final int YYINITIAL = 0;
  public static final int INTAG = 1;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\4\1\2\1\0\1\1\23\0\1\41\1\43\1\7\1\10"+
    "\1\22\1\14\1\5\1\17\1\46\1\47\1\16\1\40\1\14\1\20"+
    "\1\35\1\15\1\12\6\76\3\12\1\33\1\6\1\3\1\101\1\42"+
    "\1\14\1\36\1\50\1\51\1\53\1\60\1\61\1\70\1\71\1\75"+
    "\1\66\1\100\1\72\1\64\1\57\1\55\1\54\1\63\1\73\1\52"+
    "\1\62\1\65\1\67\1\74\1\11\1\77\1\56\1\11\1\44\1\0"+
    "\1\45\1\0\1\13\1\37\1\50\1\51\1\53\1\60\1\32\1\27"+
    "\1\71\1\23\1\30\1\100\1\72\1\31\1\57\1\55\1\54\1\25"+
    "\1\73\1\52\1\26\1\24\1\67\1\74\1\34\1\77\1\56\1\11"+
    "\3\0\1\21\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\13\1\2\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\2\1\10\1\11\1\2\1\12\1\13\1\2\1\14"+
    "\2\2\2\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\2\23\2\25\1\23\1\25\2\23\2\25\6\23"+
    "\1\25\1\23\1\25\1\23\1\1\1\26\7\1\1\27"+
    "\3\1\1\30\1\1\1\0\1\31\1\4\3\31\1\6"+
    "\1\2\1\32\1\33\1\34\1\2\1\35\1\0\1\2"+
    "\1\0\2\23\1\25\27\23\1\25\2\23\1\25\44\23"+
    "\2\0\1\36\1\37\2\0\1\40\4\31\1\41\1\42"+
    "\1\43\1\44\1\45\1\2\1\0\57\23\1\25\17\23"+
    "\1\46\1\47\1\0\4\31\1\50\1\2\1\0\1\25"+
    "\23\23\1\25\16\23\1\0\1\31\2\0\2\51\3\23"+
    "\1\25\21\23\4\0\1\52\13\23\1\53\3\0\3\23"+
    "\1\0\1\52\1\0\1\23\2\0\1\52\1\23\1\52";

  private static int [] zzUnpackAction() {
    int [] result = new int[342];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u056a\0\u05ac\0\u05ee"+
    "\0\u0630\0\u0672\0\u06b4\0\u06f6\0\u0738\0\u077a\0\u07bc\0\u07fe"+
    "\0\u0840\0\u0420\0\u0882\0\u0420\0\u0420\0\u0420\0\u08c4\0\u0420"+
    "\0\u0906\0\u0948\0\u098a\0\u09cc\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4"+
    "\0\u0b16\0\u0b58\0\u0b9a\0\u0bdc\0\u0c1e\0\u0c60\0\u0ca2\0\u0ce4"+
    "\0\u0d26\0\u0d68\0\u08c4\0\u0daa\0\u0dec\0\u0420\0\u0e2e\0\u0e70"+
    "\0\u0eb2\0\u0ef4\0\u0f36\0\u0f78\0\u0fba\0\u0420\0\u0ffc\0\u103e"+
    "\0\u1080\0\u0420\0\u10c2\0\u1104\0\u1146\0\u1188\0\u11ca\0\u120c"+
    "\0\u124e\0\u0420\0\u1290\0\u12d2\0\u1314\0\u0420\0\u1356\0\u0420"+
    "\0\u1398\0\u13da\0\u141c\0\u145e\0\u14a0\0\u14e2\0\u1524\0\u1566"+
    "\0\u15a8\0\u15ea\0\u162c\0\u166e\0\u16b0\0\u16f2\0\u1734\0\u1776"+
    "\0\u17b8\0\u17fa\0\u183c\0\u187e\0\u18c0\0\u1902\0\u1944\0\u1986"+
    "\0\u19c8\0\u1a0a\0\u1a4c\0\u1a8e\0\u1ad0\0\u1b12\0\u1b54\0\u1b96"+
    "\0\u1bd8\0\u1c1a\0\u1c5c\0\u1c9e\0\u1ce0\0\u1d22\0\u1d64\0\u1da6"+
    "\0\u1de8\0\u1e2a\0\u1e6c\0\u1eae\0\u1ef0\0\u1f32\0\u1f74\0\u1fb6"+
    "\0\u1ff8\0\u203a\0\u207c\0\u20be\0\u2100\0\u2142\0\u2184\0\u21c6"+
    "\0\u2208\0\u224a\0\u228c\0\u22ce\0\u2310\0\u2352\0\u2394\0\u23d6"+
    "\0\u2418\0\u245a\0\u249c\0\u24de\0\u2520\0\u2562\0\u25a4\0\u0420"+
    "\0\u0420\0\u25e6\0\u2628\0\u1188\0\u266a\0\u26ac\0\u26ee\0\u2730"+
    "\0\u0420\0\u0420\0\u0420\0\u2772\0\u27b4\0\u27f6\0\u2838\0\u0d26"+
    "\0\u287a\0\u28bc\0\u28fe\0\u2940\0\u2982\0\u29c4\0\u2a06\0\u2a48"+
    "\0\u2a8a\0\u2acc\0\u2b0e\0\u2b50\0\u2b92\0\u2bd4\0\u2c16\0\u2c58"+
    "\0\u2c9a\0\u2cdc\0\u2d1e\0\u2d60\0\u2da2\0\u2de4\0\u2e26\0\u2e68"+
    "\0\u2eaa\0\u2eec\0\u2f2e\0\u2f70\0\u2fb2\0\u2ff4\0\u3036\0\u3078"+
    "\0\u30ba\0\u30fc\0\u313e\0\u3180\0\u31c2\0\u3204\0\u3246\0\u1b12"+
    "\0\u3288\0\u32ca\0\u330c\0\u334e\0\u3390\0\u33d2\0\u3414\0\u3456"+
    "\0\u3498\0\u34da\0\u351c\0\u355e\0\u35a0\0\u35e2\0\u3624\0\u3666"+
    "\0\u36a8\0\u36ea\0\u372c\0\u376e\0\u37b0\0\u37f2\0\u0420\0\u0420"+
    "\0\u3834\0\u3876\0\u38b8\0\u38fa\0\u393c\0\u27b4\0\u397e\0\u39c0"+
    "\0\u2ff4\0\u3a02\0\u3a44\0\u3a86\0\u3ac8\0\u3b0a\0\u3b4c\0\u3b8e"+
    "\0\u3bd0\0\u3c12\0\u3c54\0\u3c96\0\u3cd8\0\u3d1a\0\u3d5c\0\u3d9e"+
    "\0\u3de0\0\u3e22\0\u3e64\0\u3ea6\0\u3ee8\0\u3f2a\0\u3f6c\0\u3fae"+
    "\0\u3ff0\0\u4032\0\u4074\0\u40b6\0\u1bd8\0\u40f8\0\u413a\0\u417c"+
    "\0\u41be\0\u4200\0\u4242\0\u4284\0\u42c6\0\u4308\0\u434a\0\u039c"+
    "\0\u0420\0\u438c\0\u43ce\0\u4410\0\u4410\0\u4452\0\u4494\0\u44d6"+
    "\0\u4518\0\u455a\0\u459c\0\u45de\0\u4620\0\u4662\0\u46a4\0\u46e6"+
    "\0\u4728\0\u476a\0\u47ac\0\u47ee\0\u4830\0\u4872\0\u48b4\0\u48f6"+
    "\0\u4938\0\u497a\0\u1104\0\u49bc\0\u49fe\0\u4a40\0\u4a82\0\u4ac4"+
    "\0\u4b06\0\u4b48\0\u4b8a\0\u4bcc\0\u4c0e\0\u4c50\0\u48b4\0\u4c92"+
    "\0\u4cd4\0\u4d16\0\u4d58\0\u4d9a\0\u4ddc\0\u4e1e\0\u3834\0\u4e60"+
    "\0\u4ea2\0\u4ee4\0\u4f26\0\u0420\0\u4f68\0\u48b4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[342];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\17\1\20\1\21\1\22\1\23\1\24\2\17\1\25"+
    "\1\17\1\26\1\27\2\17\1\30\1\17\1\31\1\32"+
    "\15\17\1\33\1\34\1\23\1\35\1\36\1\37\31\17"+
    "\1\26\3\17\1\40\1\41\1\0\1\40\1\23\2\40"+
    "\1\42\5\40\1\43\1\40\1\44\21\40\1\23\1\45"+
    "\36\40\1\46\2\47\1\0\1\47\1\50\2\47\1\50"+
    "\5\47\1\50\1\47\1\50\3\47\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\6\47\2\50\5\47"+
    "\1\61\1\62\1\63\1\64\1\65\1\66\1\47\1\67"+
    "\1\70\1\60\1\54\1\53\1\57\1\52\1\56\1\71"+
    "\1\55\1\47\1\72\1\73\1\74\1\51\3\47\1\50"+
    "\7\75\1\76\72\75\17\77\1\76\62\77\16\100\1\101"+
    "\63\100\13\102\1\103\66\102\16\100\1\104\63\100\13\102"+
    "\1\105\66\102\16\100\1\106\63\100\13\102\1\106\66\102"+
    "\21\107\1\110\60\107\37\111\1\112\101\111\1\113\42\111"+
    "\2\17\4\0\5\17\1\0\2\17\1\0\2\17\1\0"+
    "\15\17\1\0\1\17\1\0\41\17\1\20\2\0\1\23"+
    "\1\0\5\17\1\0\2\17\1\0\2\17\1\0\15\17"+
    "\1\0\1\17\1\23\40\17\102\0\11\114\2\115\2\114"+
    "\1\116\5\114\1\117\3\115\1\120\3\115\1\114\1\121"+
    "\1\114\1\0\11\114\31\115\1\114\1\0\1\23\2\0"+
    "\1\23\34\0\1\23\40\0\4\24\1\0\1\24\1\122"+
    "\32\24\1\0\40\24\2\25\1\0\77\25\2\17\4\0"+
    "\4\17\1\26\1\0\2\17\1\0\2\17\1\0\13\17"+
    "\1\123\1\17\1\0\1\17\1\0\34\17\1\26\3\17"+
    "\13\0\1\124\104\0\1\125\22\0\1\126\40\0\2\17"+
    "\4\0\5\17\1\0\2\17\1\0\1\17\1\127\1\0"+
    "\15\17\1\0\1\17\1\126\40\17\21\0\1\130\117\0"+
    "\1\131\42\0\2\17\4\0\5\17\1\0\2\17\1\0"+
    "\2\17\1\0\15\17\1\0\1\17\1\126\40\17\2\35"+
    "\1\0\77\35\2\17\4\0\5\17\1\0\2\17\1\0"+
    "\2\17\1\0\15\17\1\0\1\17\1\0\2\17\1\37"+
    "\35\17\2\132\4\133\5\132\1\133\2\132\1\133\2\132"+
    "\1\133\15\132\1\133\1\132\1\133\3\132\1\17\34\132"+
    "\2\40\1\0\1\40\1\0\2\40\1\0\5\40\1\0"+
    "\1\40\1\0\21\40\2\0\36\40\1\0\1\40\1\41"+
    "\1\0\1\40\1\23\2\40\1\0\5\40\1\0\1\40"+
    "\1\0\21\40\1\23\1\0\36\40\43\0\1\45\37\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\36\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\4\47\1\134\5\47\1\135\6\47\2\0\7\47\1\73"+
    "\6\47\1\135\3\47\1\134\10\47\1\73\2\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\3\47\1\136\1\73\2\47\1\137\1\140"+
    "\1\47\1\141\6\47\2\0\5\47\1\142\1\143\1\73"+
    "\5\47\1\73\1\141\3\47\1\73\1\140\1\47\1\137"+
    "\4\47\1\136\3\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\11\47\1\144"+
    "\7\47\2\0\5\47\1\145\1\47\1\146\11\47\1\144"+
    "\14\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\4\47\1\147\1\150\4\47"+
    "\1\151\6\47\2\0\5\47\1\152\3\47\1\153\2\47"+
    "\1\154\1\47\1\151\1\47\1\150\1\47\1\147\1\47"+
    "\1\155\11\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\10\47\1\156\10\47"+
    "\2\0\7\47\1\157\1\47\1\160\11\47\1\156\12\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\6\47\1\161\1\162\1\47\1\163"+
    "\7\47\2\0\12\47\1\164\1\47\1\165\2\47\1\161"+
    "\1\47\1\163\3\47\1\162\10\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\10\47\1\166\1\47\1\167\6\47\2\0\5\47\1\170"+
    "\10\47\1\167\4\47\1\166\12\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\14\47\1\171\14\47\1\172\4\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\5\47\1\173\1\174\12\47\2\0\6\47"+
    "\1\175\1\176\1\177\4\47\1\200\1\47\1\174\1\173"+
    "\3\47\1\201\11\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\10\47\1\165"+
    "\1\202\7\47\2\0\5\47\1\203\1\47\1\73\1\47"+
    "\1\204\3\47\1\205\3\47\1\202\1\47\1\165\1\206"+
    "\1\47\1\207\7\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\24\47\1\210\11\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\10\47\1\211"+
    "\1\47\1\212\6\47\2\0\5\47\1\213\3\47\1\214"+
    "\4\47\1\212\4\47\1\211\12\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\5\47\1\215\3\47\1\73\7\47\2\0\6\47\1\216"+
    "\11\47\1\215\1\73\2\47\1\217\11\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\12\47\1\220\6\47\2\0\5\47\1\221\3\47"+
    "\1\222\4\47\1\220\17\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\12\47"+
    "\1\223\6\47\2\0\5\47\1\224\10\47\1\223\5\47"+
    "\1\225\11\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\4\47\1\73\2\47"+
    "\1\226\1\227\1\73\1\230\6\47\2\0\5\47\1\231"+
    "\7\47\1\73\1\230\2\47\2\73\1\227\1\47\1\226"+
    "\10\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\11\47\1\73\7\47\2\0"+
    "\21\47\1\73\14\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\232"+
    "\6\47\2\0\6\47\1\233\7\47\1\232\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\10\47\1\234\10\47\2\0\5\47\1\235"+
    "\15\47\1\234\12\47\1\0\7\75\1\0\72\75\17\77"+
    "\1\0\62\77\16\100\1\0\63\100\16\0\1\236\63\0"+
    "\13\102\1\0\66\102\13\0\1\237\104\0\1\240\76\0"+
    "\1\240\66\0\21\107\1\0\60\107\21\0\1\241\60\0"+
    "\37\111\1\0\42\111\37\0\1\242\42\0\36\114\1\243"+
    "\54\114\2\115\10\114\10\115\1\114\1\115\1\114\1\243"+
    "\11\114\31\115\12\114\2\244\10\114\10\244\1\114\1\244"+
    "\1\114\1\243\11\114\31\244\12\114\2\115\10\114\1\115"+
    "\1\245\6\115\1\114\1\115\1\114\1\243\11\114\31\115"+
    "\12\114\2\115\10\114\1\115\1\246\3\115\1\247\2\115"+
    "\1\114\1\115\1\114\1\243\11\114\31\115\12\114\2\115"+
    "\10\114\10\115\1\114\1\250\1\114\1\243\11\114\31\115"+
    "\1\114\2\17\4\0\5\17\1\0\2\17\1\0\2\17"+
    "\1\0\15\17\1\0\1\17\1\251\40\17\13\0\1\252"+
    "\104\0\1\253\63\0\2\17\4\0\5\17\1\0\2\17"+
    "\1\0\1\17\1\254\1\0\15\17\1\0\1\17\1\0"+
    "\40\17\37\0\1\255\42\0\2\132\4\133\5\132\1\133"+
    "\2\132\1\133\2\132\1\133\15\132\1\133\1\132\1\133"+
    "\3\132\1\256\34\132\45\133\1\257\34\133\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\14\47\1\260\21\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\5\47\1\261\30\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\12\47\1\262\6\47\2\0\16\47\1\262\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\11\47\1\263\24\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\4\47\1\210\14\47\2\0\14\47\1\264"+
    "\5\47\1\210\13\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\34\47\1\265\1\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\6\47\1\210\27\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\11\47\1\204\24\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\5\47\1\266\30\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\7\47\1\267\26\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\73"+
    "\6\47\2\0\11\47\1\270\4\47\1\73\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\7\47\1\271\26\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\5\47\1\272\30\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\11\47\1\273\7\47\2\0\7\47\1\274"+
    "\1\275\10\47\1\273\14\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\14\47\1\276\21\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\24\47\1\277\11\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\5\47\1\300\30\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\5\47"+
    "\1\73\13\47\2\0\6\47\1\73\11\47\1\73\15\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\12\47\1\301\6\47\2\0\16\47"+
    "\1\301\7\47\1\302\7\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\5\47\1\303\30\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\7\47\1\304\1\47\1\305\1\306\23\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\10\47\1\307\10\47\2\0\23\47\1\307"+
    "\12\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\7\47\1\310"+
    "\26\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\5\47\1\311"+
    "\30\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\5\47\1\312\1\73\12\47"+
    "\2\0\17\47\1\73\1\312\15\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\26\47\1\73\7\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\12\47\1\313\23\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\26\47\1\314\7\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\6\47\1\315\4\47\1\316\22\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\6\47\1\317\27\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\12\47\1\320\6\47\2\0\16\47\1\320"+
    "\17\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\5\47\1\321\13\47\2\0"+
    "\20\47\1\321\15\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\10\47\1\322"+
    "\10\47\2\0\23\47\1\322\12\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\6\47\1\235\27\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\4\47\1\323\5\47\1\324\6\47\2\0\16\47\1\324"+
    "\3\47\1\323\13\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\7\47\1\325\26\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\15\47\1\326\20\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\15\47\1\327\20\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\10\47\1\330"+
    "\10\47\2\0\11\47\1\331\11\47\1\330\12\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\6\47\1\332\12\47\2\0\17\47\1\332"+
    "\16\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\15\47\1\333"+
    "\20\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\11\47\1\73"+
    "\24\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\4\47\1\334\14\47\2\0"+
    "\22\47\1\334\13\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\6\47\1\335"+
    "\12\47\2\0\17\47\1\335\16\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\11\47\1\264\7\47\2\0\21\47\1\264\14\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\4\47\1\264\14\47\2\0\22\47\1\264"+
    "\13\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\12\47\1\305"+
    "\23\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\5\47\1\275\13\47\2\0"+
    "\12\47\1\336\5\47\1\275\15\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\11\47\1\337\7\47\2\0\14\47\1\340\1\264\3\47"+
    "\1\337\14\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\4\47\1\341\14\47"+
    "\2\0\22\47\1\341\13\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\35\47\1\273\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\4\47\1\342"+
    "\14\47\2\0\22\47\1\342\13\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\6\47\1\306\12\47\2\0\17\47\1\306\16\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\31\47\1\73\4\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\6\47\1\343\1\344\1\47\1\163\1\345"+
    "\6\47\2\0\6\47\1\235\7\47\1\345\1\343\1\47"+
    "\1\163\3\47\1\344\10\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\4\47"+
    "\1\346\14\47\2\0\12\47\1\347\7\47\1\346\13\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\5\47\1\73\13\47\2\0\7\47"+
    "\1\350\10\47\1\73\15\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\11\47"+
    "\1\351\7\47\2\0\21\47\1\351\14\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\21\47\2\0\12\47\1\73\23\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\21\47\2\0\5\47\1\352\1\47\1\73\21\47"+
    "\1\73\4\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\4\47\1\353\4\47"+
    "\1\73\7\47\2\0\21\47\1\73\1\353\13\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\4\47\1\354\14\47\2\0\22\47\1\354"+
    "\13\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\13\47\1\355"+
    "\22\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\15\47\1\73"+
    "\20\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\15\47\1\356"+
    "\20\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\7\47\1\73"+
    "\26\47\17\0\1\357\76\0\1\357\125\0\1\360\42\0"+
    "\36\361\1\0\43\361\11\114\2\115\10\114\1\115\1\362"+
    "\6\115\1\114\1\115\1\114\1\243\11\114\31\115\12\114"+
    "\2\115\10\114\2\115\1\363\5\115\1\114\1\115\1\114"+
    "\1\243\11\114\31\115\12\114\2\115\10\114\6\115\1\364"+
    "\1\115\1\114\1\115\1\114\1\243\11\114\31\115\12\114"+
    "\2\115\10\114\10\115\1\114\1\365\1\114\1\243\11\114"+
    "\31\115\1\114\2\254\1\0\77\254\11\0\2\366\5\0"+
    "\1\366\2\0\10\366\1\0\1\366\13\0\31\366\1\0"+
    "\2\17\4\0\5\17\1\0\2\17\1\0\2\17\1\0"+
    "\15\17\1\0\1\17\1\0\4\17\1\367\33\17\46\0"+
    "\1\370\33\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\15\47\1\371"+
    "\20\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\5\47\1\233"+
    "\30\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\11\47\1\306"+
    "\24\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\12\47\1\73\6\47\2\0"+
    "\16\47\1\73\17\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\4\47\1\372"+
    "\14\47\2\0\22\47\1\372\13\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\10\47\1\373\10\47\2\0\23\47\1\373\12\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\5\47\1\304\30\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\26\47\1\326\7\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\10\47\1\374\10\47\2\0\11\47\1\375"+
    "\11\47\1\374\12\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\10\47\1\316\1\47\1\73\23\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\12\47\1\376\6\47\2\0\16\47\1\376\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\31\47\1\316\4\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\4\47\1\377\14\47\2\0\22\47\1\377"+
    "\13\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\5\47\1\73\13\47\2\0"+
    "\20\47\1\73\15\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\7\47\1\u0100\26\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\11\47\1\260"+
    "\7\47\2\0\21\47\1\260\14\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\11\47\1\u0101\7\47\2\0\21\47\1\u0101\14\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\24\47\1\u0102\11\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\14\47\1\u0103\21\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\14\47\1\73\21\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\4\47\1\316\14\47\2\0\22\47\1\316"+
    "\13\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\4\47\1\73\14\47\2\0"+
    "\22\47\1\73\13\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\12\47\1\u0104\23\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\5\47\1\u0105\30\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\13\47\1\316\22\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\24\47\1\306\11\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\27\47\1\73\6\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\u0106"+
    "\6\47\2\0\16\47\1\u0106\17\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\12\47\1\260\6\47\2\0\16\47\1\260\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\12\47\1\235\6\47\2\0\16\47\1\235"+
    "\17\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\12\47\1\233\6\47\2\0"+
    "\16\47\1\233\17\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\12\47\1\u0107\23\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\11\47\1\u0108"+
    "\7\47\2\0\21\47\1\u0108\14\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\15\47\1\264\20\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\10\47\1\u0109\10\47\2\0\23\47\1\u0109\12\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\5\47\1\73\30\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\11\47\1\u010a\24\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\7\47\1\u010b\26\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\10\47\1\205\10\47\2\0\23\47\1\205"+
    "\12\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\10\47\1\u010c"+
    "\25\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\12\47\1\u010d\6\47\2\0"+
    "\16\47\1\u010d\17\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\13\47\1\73\22\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\4\47\1\u010e"+
    "\14\47\2\0\22\47\1\u010e\13\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\11\47\1\u010f\24\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\31\47\1\u0110\4\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\26\47\1\u0111\7\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\14\47\1\u0112\21\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\10\47\1\u010e\10\47\2\0\23\47\1\u010e\2\47\1\u0111"+
    "\7\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\5\47\1\312\13\47\2\0"+
    "\20\47\1\312\15\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\10\47\1\u0113\25\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\7\47\1\u0114\26\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\21\47\2\0"+
    "\14\47\1\u0115\21\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\235"+
    "\6\47\2\0\5\47\1\73\10\47\1\235\17\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\24\47\1\73\11\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\21\47\2\0\27\47\1\73\1\u0116\5\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\4\47\1\u0117\14\47\2\0\22\47"+
    "\1\u0117\13\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\11\47\1\u0118\7\47"+
    "\2\0\21\47\1\u0118\14\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\5\47\1\u0119\30\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\5\47\1\u011a\30\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\26\47\1\u011b\7\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\12\47"+
    "\1\205\6\47\2\0\16\47\1\205\17\47\1\0\35\361"+
    "\1\u011c\1\0\43\361\11\114\2\115\10\114\2\115\1\u011d"+
    "\5\115\1\114\1\115\1\114\1\243\11\114\31\115\12\114"+
    "\2\115\10\114\10\115\1\u011e\1\115\1\114\1\243\11\114"+
    "\31\115\12\114\2\115\10\114\7\115\1\363\1\114\1\115"+
    "\1\114\1\243\11\114\31\115\12\114\2\115\10\114\10\115"+
    "\1\114\1\115\1\u011f\1\243\11\114\31\115\1\114\2\367"+
    "\4\370\5\367\1\370\2\367\1\370\2\367\1\370\15\367"+
    "\1\370\1\367\1\370\5\367\1\u0120\32\367\47\370\1\u0121"+
    "\32\370\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\5\47\1\u0122\30\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\12\47\1\u0123\23\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\27\47\1\264\6\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\12\47\1\165\23\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\10\47\1\306\25\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\10\47\1\u010e\10\47\2\0\23\47"+
    "\1\u010e\12\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\10\47"+
    "\1\264\25\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\15\47"+
    "\1\u0124\20\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\7\47"+
    "\1\264\26\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\12\47\1\u0125\6\47"+
    "\2\0\16\47\1\u0125\17\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\15\47\1\u0126\20\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\14\47\1\264\21\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\12\47\1\233\23\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\4\47"+
    "\1\u0127\14\47\2\0\22\47\1\u0127\13\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\12\47\1\306\6\47\2\0\16\47\1\306\17\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\10\47\1\210\25\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\12\47\1\u0128\23\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\12\47\1\u0129\6\47\2\0\16\47"+
    "\1\u0129\17\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\27\47"+
    "\1\u012a\6\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\7\47\1\u012b\11\47"+
    "\2\0\25\47\1\u012b\10\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\11\47\1\226\24\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\24\47\1\u0106\11\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\5\47\1\u012c\30\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\7\47\1\u012d\26\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\12\47"+
    "\1\u012e\6\47\2\0\5\47\1\u0106\10\47\1\u012e\17\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\7\47\1\u012f\26\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\5\47\1\u0130\30\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\24\47\1\u0131\11\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\10\47\1\u0132\10\47\2\0\23\47"+
    "\1\u0132\12\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\11\47"+
    "\1\165\24\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\10\47\1\u0133\10\47"+
    "\2\0\23\47\1\u0133\12\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\4\47"+
    "\1\u0134\4\47\1\u0135\7\47\2\0\21\47\1\u0135\1\u0134"+
    "\3\47\1\u0136\7\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\226"+
    "\6\47\2\0\16\47\1\226\17\47\1\0\36\u0137\1\0"+
    "\43\u0137\11\114\2\115\10\114\3\115\1\363\4\115\1\u011e"+
    "\1\115\1\114\1\243\11\114\31\115\16\114\1\u0138\20\114"+
    "\1\243\50\114\2\u0139\1\114\1\u0139\2\u011f\2\u0139\1\u011f"+
    "\4\u0139\11\u011f\1\u0139\1\u011f\1\u0139\1\u013a\1\114\1\u0139"+
    "\1\114\1\u013b\5\u0139\31\u011f\1\u0139\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\7\47\1\u013c\26\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\4\47"+
    "\1\u013d\14\47\2\0\22\47\1\u013d\13\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\6\47\1\u0108\12\47\2\0\17\47\1\u0108\16\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\12\47\1\u013e\6\47\2\0\16\47"+
    "\1\u013e\17\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\6\47\1\u013f\12\47"+
    "\2\0\17\47\1\u013f\16\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\13\47\1\304\22\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\6\47"+
    "\1\u012c\12\47\2\0\17\47\1\u012c\16\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\21\47\2\0\30\47\1\u0140\5\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\21\47\2\0\11\47\1\u012e\24\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\6\47\1\73\12\47\2\0\17\47\1\73\16\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\11\47\1\u0141\24\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\21\47\2\0\12\47\1\306\23\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\10\47\1\u0142\10\47\2\0\23\47"+
    "\1\u0142\12\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\14\47"+
    "\1\u0143\21\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\12\47\1\264\6\47"+
    "\2\0\16\47\1\264\17\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\10\47\1\u0144\25\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\11\47"+
    "\1\u012c\7\47\2\0\21\47\1\u012c\14\47\1\0\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\12\47\1\u0145\6\47\2\0\16\47\1\u0145\17\47"+
    "\1\0\2\47\1\0\1\47\1\0\2\47\1\0\5\47"+
    "\1\0\1\47\1\0\10\47\1\220\10\47\2\0\23\47"+
    "\1\220\12\47\1\0\2\47\1\0\1\47\1\0\2\47"+
    "\1\0\5\47\1\0\1\47\1\0\21\47\2\0\7\47"+
    "\1\u0146\26\47\1\0\36\u0137\1\0\3\u0137\1\u0147\37\u0137"+
    "\15\114\1\u011f\20\114\1\243\50\114\2\u0139\1\114\1\u0139"+
    "\2\u011f\2\u0139\1\u011f\4\u0139\11\u011f\1\u0139\1\u011f\1\u0139"+
    "\1\u013a\1\114\1\u0139\2\114\5\u0139\31\u011f\1\u0139\5\361"+
    "\2\u0148\1\361\1\u0148\2\u0149\2\u0148\1\u0149\4\u0148\11\u0149"+
    "\1\u0148\1\u0149\1\u0148\1\u014a\1\361\1\u0148\2\361\5\u0148"+
    "\31\u0149\1\u0148\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\12\47\1\324\6\47\2\0"+
    "\16\47\1\324\17\47\1\0\2\47\1\0\1\47\1\0"+
    "\2\47\1\0\5\47\1\0\1\47\1\0\12\47\1\u014b"+
    "\6\47\2\0\16\47\1\u014b\17\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\34\47\1\73\1\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\11\47\1\153\24\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\24\47\1\u014c\11\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\21\47\2\0\24\47\1\276\11\47\1\0\2\47\1\0"+
    "\1\47\1\0\2\47\1\0\5\47\1\0\1\47\1\0"+
    "\5\47\1\306\13\47\2\0\20\47\1\306\15\47\1\0"+
    "\2\47\1\0\1\47\1\0\2\47\1\0\5\47\1\0"+
    "\1\47\1\0\12\47\1\u012c\6\47\2\0\16\47\1\u012c"+
    "\17\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\11\47\1\260"+
    "\24\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\21\47\2\0\14\47\1\u014d"+
    "\21\47\1\0\2\47\1\0\1\47\1\0\2\47\1\0"+
    "\5\47\1\0\1\47\1\0\10\47\1\233\10\47\2\0"+
    "\23\47\1\233\12\47\1\0\5\361\2\u0148\1\361\1\u0148"+
    "\2\u0149\2\u0148\1\u0149\4\u0148\11\u0149\1\u0148\1\u0149\1\u014e"+
    "\1\u014a\1\361\1\u0148\2\361\5\u0148\31\u0149\1\u0148\5\361"+
    "\2\u0148\1\361\1\u0148\2\u0149\2\u0148\1\u0149\4\u0148\11\u0149"+
    "\1\u0148\1\u0149\1\u014e\1\u014a\1\361\1\u0148\1\361\1\u014f"+
    "\5\u0148\31\u0149\1\u0148\5\0\2\u014a\1\0\1\u014a\2\u0150"+
    "\2\u014a\1\u0150\4\u014a\11\u0150\1\u014a\1\u0150\2\u014a\1\0"+
    "\1\u014a\2\0\5\u014a\31\u0150\1\u014a\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\34\47\1\306\1\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\21\47"+
    "\2\0\11\47\1\211\24\47\1\0\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\5\47"+
    "\1\u0151\13\47\2\0\20\47\1\u0151\15\47\1\0\5\u0137"+
    "\2\u0152\1\u0137\1\u0152\2\u0153\2\u0152\1\u0153\4\u0152\11\u0153"+
    "\1\u0152\1\u0153\1\u0152\1\u014a\1\u0137\1\u0152\2\u0137\5\u0152"+
    "\31\u0153\1\u0152\5\0\2\u014a\1\0\1\u014a\2\u0150\2\u014a"+
    "\1\u0150\4\u014a\11\u0150\1\u014a\1\u0150\2\u014a\1\0\1\u014a"+
    "\1\0\1\u0154\5\u014a\31\u0150\1\u014a\2\47\1\0\1\47"+
    "\1\0\2\47\1\0\5\47\1\0\1\47\1\0\11\47"+
    "\1\u0155\7\47\2\0\21\47\1\u0155\14\47\1\0\5\u0137"+
    "\2\u0152\1\u0137\1\u0152\2\u0153\2\u0152\1\u0153\4\u0152\11\u0153"+
    "\1\u0152\1\u0153\1\u0152\1\u014a\1\u0137\1\u0152\1\u0137\1\u0147"+
    "\5\u0152\31\u0153\1\u0152\5\u0137\2\u0152\1\u0137\1\u0152\2\u0153"+
    "\2\u0152\1\u0153\4\u0152\11\u0153\1\u0152\1\u0153\1\u0152\1\u014a"+
    "\1\u0137\1\u0152\1\u0137\1\u0156\5\u0152\31\u0153\1\u0152\2\47"+
    "\1\0\1\47\1\0\2\47\1\0\5\47\1\0\1\47"+
    "\1\0\21\47\2\0\5\47\1\211\30\47\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[20394];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\15\1\1\11\20\1\1\11\1\1\3\11\1\1"+
    "\1\11\25\1\1\11\7\1\1\11\3\1\1\11\1\1"+
    "\1\0\5\1\1\11\3\1\1\11\1\1\1\11\1\0"+
    "\1\1\1\0\102\1\2\0\2\11\2\0\5\1\3\11"+
    "\3\1\1\0\77\1\2\11\1\0\6\1\1\0\43\1"+
    "\1\0\1\1\2\0\1\1\1\11\25\1\4\0\15\1"+
    "\3\0\3\1\1\0\1\1\1\0\1\1\2\0\1\11"+
    "\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[342];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Type specific to XMLTokenMaker denoting a line ending with an unclosed
	 * double-quote attribute.
	 */
	public static final int INTERNAL_ATTR_DOUBLE			= -1;


	/**
	 * Type specific to XMLTokenMaker denoting a line ending with an unclosed
	 * single-quote attribute.
	 */
	public static final int INTERNAL_ATTR_SINGLE			= -2;


	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed HTML tag; thus a new line is beginning
	 * still inside of the tag.
	 */
	public static final int INTERNAL_INTAG					= -3;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "***" bold/italic tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_BOLDITALIC1         = -4;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "___" bold/italic tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_BOLDITALIC2         = -5;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "**" bold tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_BOLD1         = -6;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "__" bold tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_BOLD2         = -7;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "*" italic tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_ITALIC1         = -8;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "_" italic tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_ITALIC2         = -9;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "`" code tag; thus a new line is
	 * beginning still inside of the tag.
	 */
    public static final int INTERNAL_IN_CODE         = -10;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "```" code block; thus a new line is
	 * beginning still inside of the block.
	 */
    public static final int INTERNAL_IN_SYNTAX_HIGHLIGHTING     = -11;

	/**
	 * Token type specific to MarkdownTokenMaker; this signals that the user has
	 * ended a line with an unclosed "~~" strikethrough section; thus a new line
	 * is beginning still inside of the block.
	 */
    public static final int INTERNAL_IN_STRIKETHROUGH     = -12;

	/**
	 * Whether closing markup tags are automatically completed for Markdown.
	 */
	private static boolean completeCloseTags;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public MarkdownTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	@Override
	protected OccurrenceMarker createOccurrenceMarker() {
		return new HtmlOccurrenceMarker();
	}


	/**
	 * Sets whether markup close tags should be completed.  You might not want
	 * this to be the case, since some tags in standard HTML aren't usually
	 * closed.
	 *
	 * @return Whether closing markup tags are completed.
	 * @see #setCompleteCloseTags(boolean)
	 */
	@Override
	public boolean getCompleteCloseTags() {
		return completeCloseTags;
	}


	@Override
	public boolean getCurlyBracesDenoteCodeBlocks(int languageIndex) {
		return false;
	}


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return null;
	}


	/**
	 * Returns <code>TokenTypes.MARKUP_TAG_NAME</code>.
	 *
	 * @param type The token type.
	 * @return Whether tokens of this type should have "mark occurrences"
	 *         enabled.
	 */
	@Override
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==TokenTypes.MARKUP_TAG_NAME;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		int languageIndex = 0;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case INTERNAL_INTAG:
				state = INTAG;
				break;
			case INTERNAL_ATTR_DOUBLE:
				state = INATTR_DOUBLE;
				break;
			case INTERNAL_ATTR_SINGLE:
				state = INATTR_SINGLE;
				break;
            case INTERNAL_IN_BOLDITALIC1:
                state = BOLDITALIC1;
                break;
            case INTERNAL_IN_BOLDITALIC2:
                state = BOLDITALIC2;
                break;
            case INTERNAL_IN_BOLD1:
                state = BOLD1;
                break;
            case INTERNAL_IN_BOLD2:
                state = BOLD2;
                break;
            case INTERNAL_IN_ITALIC1:
                state = ITALIC1;
                break;
            case INTERNAL_IN_ITALIC2:
                state = ITALIC2;
                break;
            case INTERNAL_IN_CODE:
                state = CODE;
                break;
            case INTERNAL_IN_SYNTAX_HIGHLIGHTING:
                state = SYNTAX_HIGHLIGHTING;
                break;
            case INTERNAL_IN_STRIKETHROUGH:
                state = STRIKETHROUGH;
                break;
			default:
                state = YYINITIAL;
				break;
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Overridden to accept letters, digits, underscores, and hyphens.
	 */
	@Override
	public boolean isIdentifierChar(int languageIndex, char ch) {
        return Character.isLetterOrDigit(ch) || ch=='-' || ch=='.' || ch=='_';
	}


	/**
	 * Sets whether markup close tags should be completed.  You might not want
	 * this to be the case, since some tags in standard HTML aren't usually
	 * closed.
	 *
	 * @param complete Whether closing markup tags are completed.
	 * @see #getCompleteCloseTags()
	 */
	public static void setCompleteCloseTags(boolean complete) {
		completeCloseTags = complete;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public MarkdownTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public MarkdownTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 186) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 44: break;
        case 12:
          { // In many cases, '>' is the beginning of a block quote
                                    if (TokenUtils.isBlankOrAllWhiteSpace(firstToken)) {
                                        addToken(Token.COMMENT_EOL);
                                    }
                                    // But if not, highlight it as an identifier and continue on
                                    else {
                                        int count = yylength();
                                        addToken(zzStartRead, zzStartRead, Token.IDENTIFIER);
                                        zzMarkedPos -= (count - 1);
                                    }
          }
        case 45: break;
        case 27:
          { start = zzMarkedPos - 2; yybegin(BOLD1);
          }
        case 46: break;
        case 38:
          { addToken(start,zzStartRead + 2, Token.FUNCTION); yybegin(YYINITIAL);
          }
        case 47: break;
        case 17:
          { yybegin(YYINITIAL); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 48: break;
        case 11:
          { start = zzMarkedPos - 1; yybegin(CODE);
          }
        case 49: break;
        case 30:
          { addToken(start,zzStartRead + 1, Token.RESERVED_WORD_2); yybegin(YYINITIAL);
          }
        case 50: break;
        case 28:
          { // An unordered list item.  Trailing space is required
                                    if (TokenUtils.isBlankOrAllWhiteSpace(firstToken)) {
                                        start = zzStartRead;
                                        addToken(start, start, TokenTypes.LITERAL_NUMBER_DECIMAL_INT);
                                        addToken(start + 1, start + 1, TokenTypes.WHITESPACE);
                                    }
                                    // Something before it - not an unordered list item
                                    else {
                                        start = zzStartRead;
                                        addToken(start, start, TokenTypes.IDENTIFIER);
                                        addToken(start + 1, start + 1, TokenTypes.WHITESPACE);
                                    }
          }
        case 51: break;
        case 20:
          { /* Shouldn't happen */ yypushback(1); yybegin(INTAG);
          }
        case 52: break;
        case 43:
          { addToken(TokenTypes.OPERATOR); /* Quick email address syntax */
          }
        case 53: break;
        case 4:
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(INTAG);
          }
        case 54: break;
        case 8:
          { start = zzMarkedPos - 1; yybegin(ITALIC2);
          }
        case 55: break;
        case 42:
          { addToken(TokenTypes.OPERATOR); /* Quick URL syntax */
          }
        case 56: break;
        case 24:
          { addToken(start,zzStartRead, Token.PREPROCESSOR); yybegin(YYINITIAL);
          }
        case 57: break;
        case 25:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									zzMarkedPos -= (count-1); //yypushback(count-1);
									yybegin(INTAG_CHECK_TAG_NAME);
          }
        case 58: break;
        case 33:
          { // An ordered list item.  Trailing space is required
                                    if (TokenUtils.isBlankOrAllWhiteSpace(firstToken)) {
                                        start = zzStartRead;
                                        int length = yylength();
                                        addToken(start, start + length - 3, TokenTypes.LITERAL_NUMBER_DECIMAL_INT);
                                        addToken(start + length - 2, start + length - 2, TokenTypes.IDENTIFIER);
                                        addToken(start + length - 1, start + length - 1, TokenTypes.WHITESPACE);
                                    }
                                    // Not an ordered list item - highlight the digits as plain text
                                    else {
                                        start = zzStartRead;
                                        int length = yylength();
                                        addToken(start, start + length - 2, TokenTypes.IDENTIFIER);
                                        addToken(start + length - 1, start + length - 1, TokenTypes.WHITESPACE);
                                    }
          }
        case 59: break;
        case 9:
          { start = zzMarkedPos - 1; yybegin(ITALIC1);
          }
        case 60: break;
        case 22:
          { yybegin(INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 61: break;
        case 14:
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE);
          }
        case 62: break;
        case 7:
          { // In almost all cases, '#' is the beginning of a heading
                                    if (getNoTokensIdentifiedYet()) {
                                        addToken(Token.RESERVED_WORD);
                                    }
                                    // If for some reason it isn't, highlight it as an identifier and continue on
                                    else {
                                        int count = yylength();
                                        addToken(zzStartRead, zzStartRead + 1, Token.IDENTIFIER);
                                        zzMarkedPos -= (count - 1);
                                    }
          }
        case 63: break;
        case 37:
          { start = zzMarkedPos - 3; yybegin(SYNTAX_HIGHLIGHTING);
          }
        case 64: break;
        case 34:
          { start = zzMarkedPos - 3; yybegin(BOLDITALIC2);
          }
        case 65: break;
        case 36:
          { // An "hr" line must be "---" all by itself on a line
                                    boolean firstOnLine = getNoTokensIdentifiedYet();
                                    start = zzStartRead;
                                    if (firstOnLine) {
                                        if (yylength() == 3) {
                                            addToken(TokenTypes.COMMENT_DOCUMENTATION);
                                        }
                                        else {
                                            // "hr" markup with following content is invalid
                                            addToken(start, start + 2, Token.IDENTIFIER);
                                            zzMarkedPos = start + 3;
                                        }
                                    }
                                    else {
                                        // The "hr" markup is really just an identifier
                                        addToken(start, start + 2, Token.IDENTIFIER);
                                        zzMarkedPos = start + 3;
                                    }
          }
        case 66: break;
        case 19:
          { /* A non-recognized HTML tag name */ yypushback(yylength()); yybegin(INTAG);
          }
        case 67: break;
        case 5:
          { addToken(Token.WHITESPACE);
          }
        case 68: break;
        case 21:
          { addToken(Token.MARKUP_TAG_NAME);
          }
        case 69: break;
        case 35:
          { start = zzMarkedPos - 3; yybegin(BOLDITALIC1);
          }
        case 70: break;
        case 23:
          { addToken(start,zzStartRead, Token.DATA_TYPE); yybegin(YYINITIAL);
          }
        case 71: break;
        case 16:
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE);
          }
        case 72: break;
        case 13:
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 73: break;
        case 6:
          { addToken(Token.MARKUP_ENTITY_REFERENCE);
          }
        case 74: break;
        case 41:
          { // Image or URL - alt or link text + URL, optional title
                                    start = zzStartRead;
                                    int count = yylength();
                                    int rBracket = yytext().indexOf(']');
                                    addToken(start, start + rBracket, TokenTypes.REGEX);
                                    addToken(start + rBracket + 1, start + count - 1, TokenTypes.ANNOTATION);
          }
        case 75: break;
        case 39:
          { addToken(start,zzStartRead + 2, Token.PREPROCESSOR); yybegin(YYINITIAL);
          }
        case 76: break;
        case 31:
          { addToken(start,zzStartRead + 1, Token.OPERATOR); yybegin(YYINITIAL);
          }
        case 77: break;
        case 40:
          { // A code block with a language specified
                                    start = zzStartRead;
                                    int length = yylength();
                                    addToken(start, start + 2, TokenTypes.PREPROCESSOR);
                                    addToken(start + 3, start + length - 1, TokenTypes.VARIABLE);
                                    start = zzMarkedPos;
                                    yybegin(SYNTAX_HIGHLIGHTING);
          }
        case 78: break;
        case 32:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									zzMarkedPos -= (count-2); //yypushback(count-2);
									yybegin(INTAG_CHECK_TAG_NAME);
          }
        case 79: break;
        case 3:
          { addNullToken(); return firstToken;
          }
        case 80: break;
        case 10:
          { addToken(TokenTypes.OPERATOR);
          }
        case 81: break;
        case 29:
          { start = zzMarkedPos - 2; yybegin(STRIKETHROUGH);
          }
        case 82: break;
        case 18:
          { addToken(Token.OPERATOR);
          }
        case 83: break;
        case 26:
          { start = zzMarkedPos - 2; yybegin(BOLD2);
          }
        case 84: break;
        case 15:
          { addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 85: break;
        case 1:
          {
          }
        case 86: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case CODE: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_IN_CODE); return firstToken;
            }
            case 343: break;
            case INTAG_CHECK_TAG_NAME: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG); return firstToken;
            }
            case 344: break;
            case STRIKETHROUGH: {
              addToken(start,zzStartRead-1, Token.OPERATOR); addEndToken(INTERNAL_IN_STRIKETHROUGH); return firstToken;
            }
            case 345: break;
            case BOLDITALIC2: {
              addToken(start,zzStartRead-1, Token.FUNCTION); addEndToken(INTERNAL_IN_BOLDITALIC2); return firstToken;
            }
            case 346: break;
            case BOLDITALIC1: {
              addToken(start,zzStartRead-1, Token.FUNCTION); addEndToken(INTERNAL_IN_BOLDITALIC1); return firstToken;
            }
            case 347: break;
            case ITALIC2: {
              addToken(start,zzStartRead-1, Token.DATA_TYPE); addEndToken(INTERNAL_IN_ITALIC2); return firstToken;
            }
            case 348: break;
            case ITALIC1: {
              addToken(start,zzStartRead-1, Token.DATA_TYPE); addEndToken(INTERNAL_IN_ITALIC1); return firstToken;
            }
            case 349: break;
            case BOLD2: {
              addToken(start,zzStartRead-1, Token.RESERVED_WORD_2); addEndToken(INTERNAL_IN_BOLD2); return firstToken;
            }
            case 350: break;
            case BOLD1: {
              addToken(start,zzStartRead-1, Token.RESERVED_WORD_2); addEndToken(INTERNAL_IN_BOLD1); return firstToken;
            }
            case 351: break;
            case SYNTAX_HIGHLIGHTING: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_IN_SYNTAX_HIGHLIGHTING); return firstToken;
            }
            case 352: break;
            case INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_SINGLE); return firstToken;
            }
            case 353: break;
            case INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_DOUBLE); return firstToken;
            }
            case 354: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 355: break;
            case INTAG: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG); return firstToken;
            }
            case 356: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
