/* The following code was generated by JFlex 1.4.1 on 12/4/21 12:15 PM */

/*
 * 09/11/2008
 *
 * RubyTokenMaker.java - Scanner for Ruby
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Ruby.<p>
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>RubyTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class RubyTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int DOCCOMMENT = 12;
  public static final int STRING_Q_SLASH = 5;
  public static final int STRING_Q_BANG = 2;
  public static final int STRING_Q_LT = 7;
  public static final int STRING = 1;
  public static final int HEREDOC_EOF = 10;
  public static final int BACKTICKS = 9;
  public static final int YYINITIAL = 0;
  public static final int STRING_Q_CURLY_BRACE = 3;
  public static final int STRING_Q_PAREN = 4;
  public static final int CHAR_LITERAL = 8;
  public static final int HEREDOC_EOT = 11;
  public static final int STRING_Q_SQUARE_BRACKET = 6;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\24\1\23\1\0\1\24\1\7\22\0\1\24\1\44\1\110"+
    "\1\10\1\56\1\50\1\53\1\111\1\113\1\76\1\46\1\35\1\77"+
    "\1\43\1\40\1\47\1\3\1\4\6\6\2\2\1\37\1\77\1\51"+
    "\1\25\1\52\1\75\1\57\1\67\1\62\1\5\1\61\1\34\1\64"+
    "\1\63\1\1\1\65\2\1\1\1\1\1\1\66\1\70\1\1\1\112"+
    "\1\1\1\73\1\71\1\1\1\1\1\112\3\1\1\41\1\11\1\42"+
    "\1\55\1\12\1\60\1\20\1\26\1\104\1\32\1\16\1\17\1\27"+
    "\1\100\1\30\1\1\1\103\1\21\1\105\1\31\1\72\1\101\1\107"+
    "\1\14\1\22\1\13\1\15\1\74\1\102\1\33\1\106\1\1\1\114"+
    "\1\54\1\36\1\45\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\15\0\1\1\1\2\2\3\1\2\1\4\10\2\1\5"+
    "\1\6\1\7\6\2\1\7\1\10\1\2\10\7\2\1"+
    "\1\11\6\2\1\12\4\2\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\15\1\21\1\15\1\22\1\15\1\23"+
    "\1\15\1\24\1\15\1\25\1\15\1\26\1\15\1\27"+
    "\1\30\1\31\1\15\1\32\1\33\1\15\1\34\1\15"+
    "\1\35\3\15\1\36\3\15\1\1\1\37\1\3\4\1"+
    "\30\2\1\0\7\2\1\40\5\2\1\41\1\7\1\0"+
    "\1\42\1\43\1\44\1\45\1\46\1\47\2\7\3\50"+
    "\1\0\1\1\4\2\1\7\12\2\1\16\1\27\2\15"+
    "\5\0\2\37\2\3\1\51\24\2\1\40\7\2\1\12"+
    "\6\2\1\0\10\2\1\40\5\0\20\2\1\52\5\0"+
    "\1\1\1\37\3\1\1\53\1\12\17\2\1\12\5\2"+
    "\1\0\3\2\4\0\11\2\1\0\1\54\1\0\1\55"+
    "\1\0\12\2\1\0\2\2\1\56\1\57\3\0\1\2"+
    "\1\12\1\2\2\0\5\2\1\60\1\2\6\0\4\2"+
    "\1\12\7\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[357];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\115\0\232\0\347\0\u0134\0\u0181\0\u01ce\0\u021b"+
    "\0\u0268\0\u02b5\0\u0302\0\u034f\0\u039c\0\u03e9\0\u0436\0\u0483"+
    "\0\u04d0\0\u051d\0\u056a\0\u05b7\0\u0604\0\u0651\0\u069e\0\u06eb"+
    "\0\u0738\0\u0785\0\u07d2\0\u051d\0\u081f\0\u086c\0\u08b9\0\u0906"+
    "\0\u0953\0\u09a0\0\u09ed\0\u0a3a\0\u0a87\0\u051d\0\u0ad4\0\u0b21"+
    "\0\u051d\0\u0b6e\0\u0bbb\0\u0c08\0\u0c55\0\u0ca2\0\u0cef\0\u0d3c"+
    "\0\u0d89\0\u051d\0\u0dd6\0\u0e23\0\u0e70\0\u0ebd\0\u0f0a\0\u0f57"+
    "\0\u0fa4\0\u0ff1\0\u103e\0\u108b\0\u10d8\0\u051d\0\u051d\0\u1125"+
    "\0\u1172\0\u051d\0\u051d\0\u11bf\0\u051d\0\u120c\0\u051d\0\u1259"+
    "\0\u051d\0\u12a6\0\u051d\0\u12f3\0\u051d\0\u1340\0\u051d\0\u138d"+
    "\0\u13da\0\u051d\0\u051d\0\u1427\0\u051d\0\u051d\0\u1474\0\u051d"+
    "\0\u14c1\0\u051d\0\u150e\0\u155b\0\u15a8\0\u051d\0\u15f5\0\u1642"+
    "\0\u168f\0\u16dc\0\u1729\0\u1776\0\u1776\0\u17c3\0\u1810\0\u185d"+
    "\0\u18aa\0\u18f7\0\u1944\0\u1991\0\u19de\0\u1a2b\0\u1a78\0\u1ac5"+
    "\0\u1b12\0\u1b5f\0\u1bac\0\u1bf9\0\u1c46\0\u1c93\0\u1ce0\0\u1d2d"+
    "\0\u1d7a\0\u1dc7\0\u1e14\0\u1e61\0\u1eae\0\u1efb\0\u1f48\0\u1f95"+
    "\0\u1fe2\0\u202f\0\u207c\0\u20c9\0\u2116\0\u2163\0\u21b0\0\u21fd"+
    "\0\u0436\0\u224a\0\u2297\0\u22e4\0\u2331\0\u237e\0\u23cb\0\u2418"+
    "\0\u2465\0\u051d\0\u051d\0\u051d\0\u051d\0\u051d\0\u051d\0\u24b2"+
    "\0\u24ff\0\u254c\0\u03e9\0\u051d\0\u2599\0\u25e6\0\u2633\0\u2680"+
    "\0\u26cd\0\u271a\0\u0436\0\u2767\0\u27b4\0\u2801\0\u284e\0\u289b"+
    "\0\u28e8\0\u2935\0\u2982\0\u29cf\0\u2a1c\0\u051d\0\u051d\0\u2a69"+
    "\0\u2ab6\0\u2b03\0\u2b50\0\u2b9d\0\u2bea\0\u2c37\0\u2c84\0\u2cd1"+
    "\0\u2d1e\0\u2d6b\0\u2db8\0\u2e05\0\u2e52\0\u2e9f\0\u2eec\0\u2f39"+
    "\0\u2f86\0\u2fd3\0\u3020\0\u306d\0\u30ba\0\u3107\0\u3154\0\u31a1"+
    "\0\u31ee\0\u323b\0\u3288\0\u32d5\0\u3322\0\u336f\0\u33bc\0\u3409"+
    "\0\u3456\0\u34a3\0\u34f0\0\u353d\0\u358a\0\u35d7\0\u3624\0\u3671"+
    "\0\u36be\0\u370b\0\u3758\0\u37a5\0\u37f2\0\u383f\0\u388c\0\u38d9"+
    "\0\u3926\0\u3973\0\u39c0\0\u3a0d\0\u3a5a\0\u3aa7\0\u3af4\0\u3b41"+
    "\0\u3b8e\0\u3bdb\0\u3c28\0\u3c75\0\u3cc2\0\u3d0f\0\u3d5c\0\u3da9"+
    "\0\u3df6\0\u3e43\0\u3e90\0\u3edd\0\u3f2a\0\u3f77\0\u3fc4\0\u4011"+
    "\0\u405e\0\u40ab\0\u40f8\0\u4145\0\u4192\0\u1474\0\u41df\0\u422c"+
    "\0\u4279\0\u42c6\0\u4313\0\u2c84\0\u4360\0\u2d1e\0\u2d6b\0\u2db8"+
    "\0\u0436\0\u0436\0\u43ad\0\u43fa\0\u4447\0\u4494\0\u44e1\0\u452e"+
    "\0\u457b\0\u45c8\0\u4615\0\u4662\0\u46af\0\u46fc\0\u4749\0\u4796"+
    "\0\u47e3\0\u051d\0\u4830\0\u487d\0\u48ca\0\u4917\0\u4964\0\u49b1"+
    "\0\u49fe\0\u4a4b\0\u4a98\0\u4ae5\0\u4b32\0\u4b7f\0\u4bcc\0\u4c19"+
    "\0\u4c66\0\u4cb3\0\u4d00\0\u4d4d\0\u4d9a\0\u4de7\0\u4e34\0\u4e81"+
    "\0\u4ece\0\u051d\0\u4f1b\0\u4f68\0\u4360\0\u4fb5\0\u5002\0\u504f"+
    "\0\u509c\0\u50e9\0\u5136\0\u5183\0\u51d0\0\u521d\0\u526a\0\u52b7"+
    "\0\u5304\0\u5351\0\u051d\0\u051d\0\u539e\0\u53eb\0\u5438\0\u5485"+
    "\0\u54d2\0\u551f\0\u556c\0\u4f68\0\u55b9\0\u5606\0\u5653\0\u56a0"+
    "\0\u54d2\0\u051d\0\u56ed\0\u573a\0\u5787\0\u57d4\0\u5821\0\u586e"+
    "\0\u58bb\0\u5908\0\u5955\0\u59a2\0\u59ef\0\u39c0\0\u5a3c\0\u5a89"+
    "\0\u5ad6\0\u5b23\0\u5b70\0\u5bbd\0\u5c0a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[357];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\16\1\17\1\20\1\21\1\20\1\17\1\20\1\22"+
    "\1\23\1\16\1\17\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\17\1\44\1\45\1\46\1\47"+
    "\1\50\2\51\1\45\1\52\1\51\2\45\1\53\1\54"+
    "\1\55\1\56\1\57\1\51\1\60\1\61\1\62\1\17"+
    "\1\63\1\17\1\64\1\65\1\17\1\66\2\17\1\67"+
    "\1\70\1\17\1\22\1\46\1\22\1\17\1\71\1\72"+
    "\1\17\1\73\1\74\1\75\1\17\1\76\1\77\1\17"+
    "\2\46\11\100\1\101\11\100\1\102\64\100\1\103\4\100"+
    "\11\104\1\101\11\104\1\105\20\104\1\103\50\104\11\106"+
    "\1\101\11\106\1\107\12\106\1\103\56\106\11\110\1\101"+
    "\11\110\1\111\52\110\1\103\16\110\11\112\1\101\11\112"+
    "\1\113\23\112\1\103\45\112\11\114\1\101\11\114\1\115"+
    "\16\114\1\103\52\114\11\116\1\101\11\116\1\117\26\116"+
    "\1\103\42\116\11\120\1\121\11\120\1\122\65\120\1\123"+
    "\3\120\11\124\1\101\11\124\1\125\34\124\1\126\34\124"+
    "\11\127\1\101\11\127\1\130\10\127\1\131\71\127\1\101"+
    "\11\127\1\132\10\127\1\133\60\127\17\134\1\135\3\134"+
    "\1\136\1\134\1\137\52\134\1\140\1\134\1\141\12\134"+
    "\7\16\1\0\13\16\3\0\7\16\21\0\2\16\1\0"+
    "\14\16\3\0\10\16\2\0\1\16\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\2\16\3\20"+
    "\1\16\1\20\1\0\2\16\1\142\3\16\1\143\4\16"+
    "\3\0\6\16\1\143\21\0\2\16\1\0\14\16\3\0"+
    "\10\16\2\0\1\16\2\0\3\16\2\144\1\16\1\144"+
    "\1\0\2\16\1\145\10\16\3\0\1\146\3\16\1\147"+
    "\1\150\1\16\21\0\2\16\1\0\14\16\3\0\10\16"+
    "\2\0\1\16\117\0\23\23\1\0\71\23\1\16\6\17"+
    "\1\0\2\16\2\17\1\151\1\17\1\152\4\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\1\153\7\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\4\17"+
    "\1\154\1\17\1\155\2\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\3\17\1\156\3\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\7\17\1\157\1\17"+
    "\3\0\3\17\1\160\1\17\1\161\1\17\21\0\2\16"+
    "\1\0\13\17\1\162\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\6\17\1\163\2\17\3\0"+
    "\7\17\21\0\2\16\1\0\11\17\1\164\2\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\1\17\1\165\1\17\1\166\3\17\1\167\1\17\3\0"+
    "\3\17\1\170\3\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\6\17\1\171\2\17\3\0\7\17\21\0\2\16\1\0"+
    "\11\17\1\172\2\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\2\17\1\173\1\174\1\175"+
    "\2\17\1\176\1\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\1\17\1\177\4\17\1\200\1\17\2\0"+
    "\1\17\26\0\1\35\115\0\1\45\1\201\16\0\1\51"+
    "\47\0\1\16\6\17\1\0\2\16\2\17\1\202\1\17"+
    "\1\203\4\17\3\0\2\17\1\204\4\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\205\2\17\1\206\1\207"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\1\17"+
    "\1\210\3\17\1\211\3\17\3\0\3\17\1\211\3\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\4\17\1\212\4\17"+
    "\3\0\2\17\1\213\4\17\21\0\2\16\1\0\11\17"+
    "\1\214\2\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\215\4\17\3\0\7\17"+
    "\21\0\2\16\1\0\11\17\1\211\2\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\7\17\21\0\2\16\1\0\5\17\1\216\6\17"+
    "\3\0\10\17\2\0\1\17\27\0\1\51\70\0\1\217"+
    "\3\0\1\217\4\0\11\217\3\0\7\217\2\0\1\51"+
    "\21\0\14\217\3\0\10\217\2\0\1\217\42\0\1\220"+
    "\101\0\1\51\17\0\1\51\74\0\1\51\5\0\1\221"+
    "\5\0\1\222\2\0\1\223\2\0\1\224\1\0\1\225"+
    "\30\0\1\221\4\0\1\221\2\0\1\221\1\226\1\227"+
    "\25\0\1\230\23\0\1\231\70\0\1\51\24\0\1\51"+
    "\115\0\1\51\115\0\1\51\40\0\1\16\1\232\3\233"+
    "\1\232\1\233\1\0\2\16\11\232\2\0\1\234\7\232"+
    "\1\234\1\0\2\234\2\0\1\235\4\234\1\0\3\234"+
    "\2\0\2\233\1\234\14\232\1\234\1\0\1\234\10\232"+
    "\2\234\1\232\2\0\1\16\1\232\3\16\1\232\1\16"+
    "\1\0\2\16\11\232\3\0\7\232\21\0\1\16\1\236"+
    "\1\0\14\232\3\0\10\232\2\0\1\232\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\6\17\1\237\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\7\17\1\240\1\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\3\17\1\241\3\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\2\17\1\242\6\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\2\17\1\243\6\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\1\17\1\244\6\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\1\17\1\245"+
    "\7\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\2\17\1\246\1\247\5\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\1\250\7\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\6\17\1\251\1\252\1\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\1\253"+
    "\7\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\11\17\1\254"+
    "\2\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\2\17\1\255\4\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\11\100\1\0\11\100\1\0\64\100\1\0\4\100\23\256"+
    "\1\0\71\256\11\104\1\0\11\104\1\0\20\104\1\0"+
    "\50\104\11\106\1\0\11\106\1\0\12\106\1\0\56\106"+
    "\11\110\1\0\11\110\1\0\52\110\1\0\16\110\11\112"+
    "\1\0\11\112\1\0\23\112\1\0\45\112\11\114\1\0"+
    "\11\114\1\0\16\114\1\0\52\114\11\116\1\0\11\116"+
    "\1\0\26\116\1\0\42\116\11\120\1\0\11\120\1\0"+
    "\65\120\1\0\3\120\23\257\1\0\71\257\11\124\1\0"+
    "\11\124\1\0\34\124\1\0\34\124\11\127\1\0\11\127"+
    "\1\0\102\127\1\0\11\127\1\0\44\127\1\260\35\127"+
    "\1\0\11\127\1\0\44\127\1\261\24\127\17\134\1\0"+
    "\3\134\1\0\1\134\1\0\52\134\1\0\1\134\1\0"+
    "\12\134\13\0\1\262\14\0\1\263\102\0\1\264\111\0"+
    "\1\265\203\0\1\266\12\0\2\16\3\20\1\16\1\20"+
    "\1\0\2\16\1\142\10\16\3\0\7\16\21\0\2\16"+
    "\1\0\14\16\3\0\10\16\2\0\1\16\2\0\2\16"+
    "\3\267\1\16\1\267\1\0\13\16\3\0\7\16\1\270"+
    "\5\0\1\270\12\0\2\16\1\0\14\16\3\0\10\16"+
    "\2\0\1\16\2\0\3\16\2\144\1\16\1\144\1\0"+
    "\2\16\1\145\10\16\3\0\7\16\21\0\2\16\1\0"+
    "\14\16\3\0\10\16\2\0\1\16\2\0\3\16\2\271"+
    "\2\16\1\0\13\16\3\0\7\16\21\0\2\16\1\0"+
    "\14\16\3\0\10\16\2\0\1\16\2\0\2\16\3\272"+
    "\1\16\1\272\1\0\13\16\3\0\7\16\21\0\2\16"+
    "\1\0\14\16\3\0\10\16\2\0\1\16\2\0\2\16"+
    "\5\273\1\0\6\16\3\273\2\16\3\0\1\273\3\16"+
    "\1\273\1\16\1\273\21\0\2\16\1\0\2\273\1\16"+
    "\1\273\2\16\1\273\5\16\3\0\4\16\1\273\3\16"+
    "\2\0\1\16\2\0\1\16\6\17\1\0\2\16\3\17"+
    "\1\274\2\17\1\275\2\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\10\17\1\276\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\4\17\1\277\4\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\1\17\1\300"+
    "\4\17\1\301\1\17\1\302\3\0\4\17\1\303\2\17"+
    "\21\0\2\16\1\0\14\17\3\0\7\17\1\304\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\2\17\1\305\1\306\3\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\1\17\1\307\5\17\1\310\1\17\3\0\4\17"+
    "\1\311\2\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\10\17"+
    "\1\312\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\10\17\1\313\3\0\4\17\1\211\2\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\314\4\17\3\0\2\17"+
    "\1\315\4\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\6\17"+
    "\1\316\2\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\7\17\1\317\1\17\3\0\2\17\1\316\4\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\2\17\1\320\6\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\1\321"+
    "\10\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\1\17\1\322\7\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\2\17\1\323\4\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\4\17\1\243"+
    "\2\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\5\17\1\324"+
    "\2\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\6\17\1\306\2\17\3\0\7\17\21\0\2\16\1\0"+
    "\11\17\1\325\2\17\3\0\4\17\1\326\3\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\6\17\1\327"+
    "\2\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\1\330\6\17\21\0\2\16\1\0\14\17"+
    "\3\0\1\17\1\331\6\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\7\17\1\332\1\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\4\17\1\333\4\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\2\17"+
    "\1\334\4\17\1\335\1\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\10\17\1\336\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\20\0"+
    "\1\337\76\0\1\16\6\17\1\0\2\16\4\17\1\340"+
    "\4\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\1\17\1\341\5\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\3\17\1\342\3\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\1\17\1\343\7\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\7\17\21\0\2\16\1\0\11\17\1\344\2\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\3\17\1\345\5\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\4\17\1\346\4\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\5\17\1\347"+
    "\1\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\7\17\1\211"+
    "\1\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\1\17\1\243\7\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\5\17\1\350\3\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\21\0"+
    "\2\16\1\0\1\211\13\17\3\0\10\17\2\0\1\17"+
    "\3\0\6\217\3\0\11\217\3\0\7\217\24\0\14\217"+
    "\3\0\10\217\2\0\1\217\42\0\1\51\115\0\1\222"+
    "\2\0\1\223\2\0\1\224\1\0\1\225\41\0\1\226"+
    "\1\227\52\0\1\51\66\0\1\351\7\0\1\352\23\0"+
    "\1\353\27\0\1\354\1\355\3\0\1\16\6\232\1\0"+
    "\2\16\11\232\3\0\7\232\21\0\2\16\1\0\14\232"+
    "\3\0\10\232\2\0\1\232\5\0\1\234\14\0\2\234"+
    "\6\0\1\234\1\0\1\234\31\0\2\234\6\0\1\234"+
    "\4\0\2\234\12\0\1\16\1\232\3\16\1\232\1\16"+
    "\1\0\2\16\11\232\3\0\7\232\21\0\2\16\1\0"+
    "\14\232\3\0\10\232\2\0\1\232\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\7\17\21\0\2\16\1\0"+
    "\2\17\1\356\11\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\21\0"+
    "\2\16\1\0\11\17\1\357\2\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\1\17\1\360"+
    "\7\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\2\17\1\361\6\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\4\17\1\362\4\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\2\17\1\363\6\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\2\17\1\364\4\17\21\0\2\16\1\0\11\17\1\314"+
    "\2\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\1\17\1\365\7\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\4\17\1\277\4\17\3\0"+
    "\2\17\1\366\4\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\1\17\1\367\5\17\1\370\1\371\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\6\17\1\372\2\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\7\17\21\0\2\16\1\0\11\17\1\373\2\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\4\17\1\374\2\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\4\17\1\375\4\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\11\127\1\0\11\127\1\0\40\127\1\376\41\127\1\0"+
    "\11\127\1\0\45\127\1\376\23\127\101\0\1\377\34\0"+
    "\1\u0100\124\0\1\u0101\76\0\1\u0102\203\0\1\u0103\12\0"+
    "\2\16\3\267\1\16\1\267\1\0\2\16\1\u0104\10\16"+
    "\3\0\7\16\21\0\2\16\1\0\14\16\3\0\10\16"+
    "\2\0\1\16\4\0\3\u0105\1\0\1\u0105\106\0\3\16"+
    "\2\271\2\16\1\0\2\16\1\u0106\10\16\3\0\7\16"+
    "\21\0\2\16\1\0\14\16\3\0\10\16\2\0\1\16"+
    "\2\0\2\16\3\272\1\16\1\272\1\0\2\16\1\u0107"+
    "\10\16\3\0\7\16\21\0\2\16\1\0\14\16\3\0"+
    "\10\16\2\0\1\16\2\0\1\16\1\u0108\5\273\1\0"+
    "\2\16\4\u0108\3\273\2\u0108\3\0\1\273\3\u0108\1\273"+
    "\1\u0108\1\273\21\0\2\16\1\0\2\273\1\u0108\1\273"+
    "\2\u0108\1\273\5\u0108\3\0\4\u0108\1\273\3\u0108\2\0"+
    "\1\u0108\2\0\1\16\6\17\1\0\2\16\4\17\1\u0109"+
    "\4\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\1\17\1\u010a\2\17\1\u010b\3\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\1\17\1\u010a\7\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\3\17\1\211\3\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\2\17\1\u010c\1\u010d\5\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\4\17\1\u010e\2\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\4\17\1\u010f\3\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\7\17\21\0\2\16\1\0\11\17\1\211\2\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\3\17\1\u0110\5\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\10\17\1\u0111\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\4\17\1\u010a"+
    "\2\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\2\17\1\u0112"+
    "\6\17\3\0\2\17\1\213\4\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\4\17\1\372\4\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\4\17\1\u0113\4\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\4\17\1\211"+
    "\4\17\3\0\2\17\1\u0113\4\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\3\17\1\u0114\5\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\4\17\1\u010a\3\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\1\17\1\330"+
    "\7\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\7\17\1\u010a\1\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\10\17\1\274\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\3\17\1\u010a\1\17\1\357\2\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\4\17"+
    "\1\u0115\4\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\7\17\21\0\2\16\1\0\11\17"+
    "\1\u0116\2\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\6\17\1\u0117\2\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\1\u0118"+
    "\6\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\1\17\1\u010a"+
    "\6\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\6\17\1\u0119\2\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\3\17\1\306\3\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\7\0"+
    "\1\u011a\11\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\4\17\1\u011b"+
    "\4\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\4\17\1\u011c\1\211\3\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\325\4\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\2\17"+
    "\1\u011d\4\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\2\17\1\276\4\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\1\17\1\u011e\7\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\4\17\1\u011f\3\17\2\0\1\17"+
    "\31\0\1\u0120\65\0\1\16\6\17\1\0\2\16\6\17"+
    "\1\u0121\2\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\2\17\1\277\4\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\4\17\1\363\2\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\10\17\1\u010a\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\1\326\6\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\1\330\6\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\2\17\1\u0122\6\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\1\17\1\211\7\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\2\17\1\u0123"+
    "\4\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\26\0\1\351\33\0\1\353\27\0\1\354\1\355"+
    "\73\0\1\u0124\60\0\1\u0125\114\0\1\u0126\114\0\1\u0127"+
    "\60\0\1\16\6\17\1\0\2\16\11\17\3\0\7\17"+
    "\21\0\2\16\1\0\4\17\1\u0128\7\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\6\17"+
    "\1\276\2\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\4\17\1\u0129\4\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\6\17\1\u012a\2\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\3\17"+
    "\1\u010a\3\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\2\17\1\u012b\4\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\3\17\1\u012c\3\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\10\17\1\u010a\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\4\17\1\u010a\3\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\7\17\1\371"+
    "\1\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\4\17\1\u012d\3\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\7\17\1\u012e\1\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\4\17\1\211\4\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\10\17\1\u0117"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\1\17"+
    "\1\330\3\17\1\u012f\2\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\3\17\1\366\5\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\7\17\1\u0130\1\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\41\0\1\u0131\73\0\1\377\130\0\1\u0132"+
    "\163\0\1\u0133\53\0\1\u0134\56\0\3\u0105\1\0\1\u0105"+
    "\3\0\1\u0135\102\0\1\16\6\17\1\0\2\16\4\17"+
    "\1\u0136\4\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\6\17\1\211\1\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\2\17\1\277\6\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\7\17\1\u0137\1\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\3\17"+
    "\1\371\5\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\2\17\1\u0138\4\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\u010a\4\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\6\17\1\u0139\2\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\5\17"+
    "\1\211\3\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\2\17\1\371\6\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\11\17\3\0\5\17\1\335\1\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\7\17\1\u013a\1\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\10\17"+
    "\1\211\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\4\17\1\u013b\2\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\7\17\1\u013c\1\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\2\17\1\211\6\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\4\17\1\276"+
    "\3\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\3\17\1\u013d\3\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\4\17\1\u013e\4\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\6\17\1\u013f\2\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\32\0\1\u0140\64\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\3\17\1\211\4\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\6\17\1\u0141\2\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\3\17\1\u0142"+
    "\3\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\66\0\1\u0143\4\0\1\u0144\113\0\1\u0145\114\0"+
    "\1\u0146\114\0\1\u0147\24\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\5\17\1\211"+
    "\6\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\1\17\1\u012e\5\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\6\17\1\u010a\1\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\3\17\1\u0148\3\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\1\17\1\u0149\7\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\1\u010a\7\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\4\17\1\u014a\4\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\1\17\1\330\6\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\4\17\1\211\2\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\51\0\1\u014b\67\0\1\377"+
    "\14\0\1\u0131\56\0\6\u0134\1\0\1\u014c\1\0\1\u014c"+
    "\10\u0134\2\0\1\u014c\7\u0134\1\u014c\1\0\10\u014c\1\u0134"+
    "\1\u014c\2\0\1\u014c\2\0\1\u0134\1\u014c\1\0\14\u0134"+
    "\3\u014c\10\u0134\1\0\1\u014c\1\u0134\1\u014c\1\0\1\16"+
    "\6\17\1\0\2\16\1\u014d\10\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\2\17\1\u014e"+
    "\4\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\2\17\1\u0111"+
    "\6\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\7\17\21\0\2\16\1\0\14\17\3\0"+
    "\4\17\1\u010b\3\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\7\17\21\0\2\16\1\0"+
    "\11\17\1\u014f\2\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\6\17\1\u010a\2\17\3\0"+
    "\7\17\21\0\2\16\1\0\14\17\3\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\1\u0150\10\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\1\17"+
    "\1\u0151\7\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\11\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\5\17\1\u010a\2\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\7\17\1\316\1\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\33\0\1\u0152\63\0\1\16\6\17\1\0\2\16\1\17"+
    "\1\u0153\7\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\4\17\1\u0130\4\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\66\0\1\u0154"+
    "\4\0\1\u0155\107\0\1\u0156\4\0\1\u0157\107\0\1\u0158"+
    "\4\0\1\u0159\23\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\1\17\1\u010a\5\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\5\17\1\u010a\3\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\2\17\1\u010a\6\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\51\0\1\u0134\45\0\1\16\6\17\1\0\2\16\11\17"+
    "\3\0\7\17\21\0\2\16\1\0\13\17\1\u015a\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\11\17\3\0\3\17\1\u015b\3\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\6\17\1\306\2\17\3\0\7\17\21\0"+
    "\2\16\1\0\14\17\3\0\10\17\2\0\1\17\2\0"+
    "\1\16\6\17\1\0\2\16\11\17\3\0\7\17\21\0"+
    "\2\16\1\0\13\17\1\u015c\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\7\17"+
    "\21\0\2\16\1\0\11\17\1\u015d\2\17\3\0\10\17"+
    "\2\0\1\17\62\0\1\u0143\114\0\1\u0144\144\0\1\u0143"+
    "\114\0\1\u0144\115\0\1\u0143\114\0\1\u0144\3\0\1\16"+
    "\6\17\1\0\2\16\6\17\1\u014a\2\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\4\17\1\u015e\4\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0\1\16\6\17\1\0\2\16\6\17"+
    "\1\u015f\2\17\3\0\7\17\21\0\2\16\1\0\14\17"+
    "\3\0\10\17\2\0\1\17\2\0\1\16\6\17\1\0"+
    "\2\16\2\17\1\u0160\6\17\3\0\7\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\2\17\1\u0161\6\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\11\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\1\u011a\2\0\10\17\2\0"+
    "\1\17\2\0\1\16\6\17\1\0\2\16\11\17\3\0"+
    "\2\17\1\u0162\4\17\21\0\2\16\1\0\14\17\3\0"+
    "\10\17\2\0\1\17\2\0\1\16\6\17\1\0\2\16"+
    "\6\17\1\u0163\2\17\3\0\7\17\21\0\2\16\1\0"+
    "\14\17\3\0\10\17\2\0\1\17\2\0\1\16\6\17"+
    "\1\0\2\16\11\17\3\0\1\u0164\6\17\21\0\2\16"+
    "\1\0\14\17\3\0\10\17\2\0\1\17\2\0\1\16"+
    "\6\17\1\0\2\16\7\17\1\u0165\1\17\3\0\7\17"+
    "\21\0\2\16\1\0\14\17\3\0\10\17\2\0\1\17"+
    "\2\0\1\16\6\17\1\0\2\16\4\17\1\343\4\17"+
    "\3\0\7\17\21\0\2\16\1\0\14\17\3\0\10\17"+
    "\2\0\1\17\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[23639];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\15\0\4\1\1\11\11\1\1\11\11\1\1\11\2\1"+
    "\1\11\10\1\1\11\13\1\2\11\2\1\2\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\1\1\1\11\2\1\2\11\1\1\2\11\1\1"+
    "\1\11\1\1\1\11\3\1\1\11\42\1\1\0\17\1"+
    "\1\0\6\11\4\1\1\11\1\0\20\1\2\11\2\1"+
    "\5\0\50\1\1\0\11\1\5\0\21\1\5\0\26\1"+
    "\1\11\5\1\1\0\3\1\4\0\11\1\1\0\1\11"+
    "\1\0\1\1\1\0\12\1\1\0\2\1\2\11\3\0"+
    "\3\1\2\0\5\1\1\11\1\1\6\0\14\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[357];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF			= -1;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * an EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT			= -2;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q!...! style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_BANG				= -3;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q{...} style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_CURLY_BRACE		= -4;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q&lt;...&gt; style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_LT					= -5;


	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q(...) style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_PAREN					= -6;


	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q/.../ style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_SLASH				= -7;

	/**
	 * Token type specific to RubyTokenMaker; this signals that we are inside
	 * a %Q[...] style double quoted string.
	 */
	public static final int INTERNAL_STRING_Q_SQUARE_BRACKET		= -8;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public RubyTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "#", null };
	}


	/**
	 * Returns whether tokens of the specified type should have "mark
	 * occurrences" enabled for the current programming language.
	 *
	 * @param type The token type.
	 * @return Whether tokens of this type should have "mark occurrences"
	 *         enabled.
	 */
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==TokenTypes.IDENTIFIER || type==TokenTypes.VARIABLE;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state;
		switch (initialTokenType) {
			case TokenTypes.COMMENT_DOCUMENTATION:
				state = DOCCOMMENT;
				start = text.offset;
				break;
			case TokenTypes.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case TokenTypes.LITERAL_CHAR:
				state = CHAR_LITERAL;
				start = text.offset;
				break;
			case TokenTypes.LITERAL_BACKQUOTE:
				state = BACKTICKS;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF:
				state = HEREDOC_EOF;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT:
				state = HEREDOC_EOT;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_BANG:
				state = STRING_Q_BANG;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_CURLY_BRACE:
				state = STRING_Q_CURLY_BRACE;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_LT:
				state = STRING_Q_LT;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_PAREN:
				state = STRING_Q_PAREN;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_SLASH:
				state = STRING_Q_SLASH;
				start = text.offset;
				break;
			case INTERNAL_STRING_Q_SQUARE_BRACKET:
				state = STRING_Q_SQUARE_BRACKET;
				start = text.offset;
				break;
			default:
				state = YYINITIAL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public RubyTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public RubyTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 188) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 37:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_LT);
          }
        case 49: break;
        case 31:
          { addToken(TokenTypes.LITERAL_NUMBER_FLOAT);
          }
        case 50: break;
        case 29:
          { addToken(start,zzStartRead-1, TokenTypes.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT); return firstToken;
          }
        case 51: break;
        case 1:
          { addToken(TokenTypes.ERROR_IDENTIFIER);
          }
        case 52: break;
        case 27:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, TokenTypes.LITERAL_BACKQUOTE);
          }
        case 53: break;
        case 24:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_CHAR); return firstToken;
          }
        case 54: break;
        case 11:
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 55: break;
        case 10:
          { addToken(TokenTypes.FUNCTION);
          }
        case 56: break;
        case 4:
          { addToken(TokenTypes.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 57: break;
        case 28:
          { addToken(start,zzStartRead-1, TokenTypes.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF); return firstToken;
          }
        case 58: break;
        case 45:
          { int temp = zzStartRead;
                                if (start <= zzStartRead - 1) {
                                    addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION);
                                }
                                addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION);
                                start = zzMarkedPos;
          }
        case 59: break;
        case 40:
          { addToken(TokenTypes.VARIABLE);
          }
        case 60: break;
        case 26:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_BACKQUOTE); return firstToken;
          }
        case 61: break;
        case 41:
          { addToken(TokenTypes.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 62: break;
        case 33:
          { addToken(TokenTypes.PREPROCESSOR);
          }
        case 63: break;
        case 8:
          { addToken(TokenTypes.SEPARATOR);
          }
        case 64: break;
        case 2:
          { addToken(TokenTypes.IDENTIFIER);
          }
        case 65: break;
        case 46:
          { start = zzStartRead; yybegin(HEREDOC_EOF);
          }
        case 66: break;
        case 3:
          { addToken(TokenTypes.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 67: break;
        case 39:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_CURLY_BRACE);
          }
        case 68: break;
        case 20:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SLASH); return firstToken;
          }
        case 69: break;
        case 21:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SQUARE_BRACKET); return firstToken;
          }
        case 70: break;
        case 19:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_PAREN); return firstToken;
          }
        case 71: break;
        case 44:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+3, TokenTypes.COMMENT_DOCUMENTATION);
          }
        case 72: break;
        case 18:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_CURLY_BRACE); return firstToken;
          }
        case 73: break;
        case 16:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 74: break;
        case 14:
          { /* Skip escaped chars. */
          }
        case 75: break;
        case 25:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, TokenTypes.LITERAL_CHAR);
          }
        case 76: break;
        case 15:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 77: break;
        case 17:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_BANG); return firstToken;
          }
        case 78: break;
        case 43:
          { addToken(TokenTypes.LITERAL_BOOLEAN);
          }
        case 79: break;
        case 12:
          { start = zzMarkedPos-1; yybegin(CHAR_LITERAL);
          }
        case 80: break;
        case 47:
          { start = zzStartRead; yybegin(HEREDOC_EOT);
          }
        case 81: break;
        case 36:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_SLASH);
          }
        case 82: break;
        case 42:
          { if (start==zzStartRead) { addToken(TokenTypes.PREPROCESSOR); addNullToken(); return firstToken; }
          }
        case 83: break;
        case 35:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_BANG);
          }
        case 84: break;
        case 23:
          { /* Skip escaped single quotes only, but this should still work. */
          }
        case 85: break;
        case 48:
          { start = zzMarkedPos-6; yybegin(DOCCOMMENT);
          }
        case 86: break;
        case 22:
          { addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_LT); return firstToken;
          }
        case 87: break;
        case 6:
          { addToken(TokenTypes.WHITESPACE);
          }
        case 88: break;
        case 32:
          { addToken(TokenTypes.RESERVED_WORD);
          }
        case 89: break;
        case 30:
          { yybegin(YYINITIAL); addToken(start,zzEndRead, TokenTypes.COMMENT_DOCUMENTATION); return firstToken;
          }
        case 90: break;
        case 34:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_SQUARE_BRACKET);
          }
        case 91: break;
        case 5:
          { addNullToken(); return firstToken;
          }
        case 92: break;
        case 38:
          { start = zzMarkedPos-yylength(); yybegin(STRING_Q_PAREN);
          }
        case 93: break;
        case 7:
          { addToken(TokenTypes.OPERATOR);
          }
        case 94: break;
        case 9:
          { start = zzMarkedPos-1; yybegin(BACKTICKS);
          }
        case 95: break;
        case 13:
          {
          }
        case 96: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, TokenTypes.COMMENT_DOCUMENTATION); return firstToken;
            }
            case 358: break;
            case STRING_Q_SLASH: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SLASH); return firstToken;
            }
            case 359: break;
            case STRING_Q_BANG: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_BANG); return firstToken;
            }
            case 360: break;
            case STRING_Q_LT: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_LT); return firstToken;
            }
            case 361: break;
            case STRING: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 362: break;
            case HEREDOC_EOF: {
              addToken(start,zzStartRead-1, TokenTypes.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF); return firstToken;
            }
            case 363: break;
            case BACKTICKS: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_BACKQUOTE); return firstToken;
            }
            case 364: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 365: break;
            case STRING_Q_CURLY_BRACE: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_CURLY_BRACE); return firstToken;
            }
            case 366: break;
            case STRING_Q_PAREN: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_PAREN); return firstToken;
            }
            case 367: break;
            case CHAR_LITERAL: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_CHAR); return firstToken;
            }
            case 368: break;
            case HEREDOC_EOT: {
              addToken(start,zzStartRead-1, TokenTypes.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT); return firstToken;
            }
            case 369: break;
            case STRING_Q_SQUARE_BRACKET: {
              addToken(start,zzStartRead-1, TokenTypes.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_STRING_Q_SQUARE_BRACKET); return firstToken;
            }
            case 370: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
