/* The following code was generated by JFlex 1.4.1 on 12/24/19 12:25 AM */

/*
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class takes plain text and returns tokens representing 6502
 * assembler.<p>
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>Assembler6502TokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.2
 *
 */

public class Assembler6502TokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int EOL_COMMENT = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  1,  2, 2
  };

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\63\1\15\1\0\1\16\23\0\1\63\1\21\1\12\1\62"+
    "\1\4\1\7\1\41\1\13\2\51\1\20\1\20\1\11\1\20\1\22"+
    "\1\36\2\10\10\3\1\17\1\14\1\44\1\50\1\46\1\51\1\61"+
    "\1\34\1\23\1\5\1\40\1\32\1\53\1\1\1\6\1\24\1\57"+
    "\1\35\1\30\1\37\1\26\1\27\1\52\1\55\1\43\1\45\1\25"+
    "\1\60\1\56\1\54\1\42\1\31\1\1\1\11\1\0\1\11\1\33"+
    "\1\2\1\0\1\34\1\23\1\5\1\40\1\32\1\65\1\1\1\64"+
    "\1\24\1\57\1\35\1\30\1\37\1\26\1\27\1\52\1\55\1\43"+
    "\1\45\1\25\1\60\1\56\1\66\1\42\1\31\1\1\1\0\1\47"+
    "\1\0\1\21\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\2\1\1\2\3\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\12\1\1\10\1\1\1\10\1\1\2\10"+
    "\6\1\2\11\1\12\5\11\1\1\1\13\2\2\3\1"+
    "\1\2\1\14\1\15\12\0\21\1\1\16\6\1\1\16"+
    "\7\1\3\13\1\16\4\11\4\0\5\17\1\10\3\17"+
    "\3\1\1\13\4\11\4\0\3\17\1\1\1\13\3\11"+
    "\1\20\2\0\4\17\1\1\1\11\2\0\1\17";

  private static int [] zzUnpackAction() {
    int [] result = new int[150];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\67\0\156\0\245\0\334\0\u0113\0\u014a\0\u0181"+
    "\0\u01b8\0\u01ef\0\u0226\0\245\0\245\0\u025d\0\245\0\u0294"+
    "\0\u02cb\0\u0302\0\u0339\0\u0370\0\u03a7\0\u03de\0\u0415\0\u044c"+
    "\0\u0483\0\u04ba\0\u04f1\0\u0528\0\u055f\0\u0596\0\u05cd\0\u0604"+
    "\0\u063b\0\u0672\0\u06a9\0\u06e0\0\u0717\0\u074e\0\u0785\0\245"+
    "\0\u07bc\0\u07f3\0\u082a\0\u0861\0\u0898\0\u08cf\0\u08cf\0\334"+
    "\0\u014a\0\u0906\0\u093d\0\u0974\0\u01b8\0\245\0\245\0\u09ab"+
    "\0\u09e2\0\u0a19\0\u0a50\0\u0a87\0\u0abe\0\u0af5\0\u0b2c\0\u0b63"+
    "\0\u0b9a\0\u0bd1\0\u0c08\0\u0c3f\0\u0c76\0\u0cad\0\u0ce4\0\u0d1b"+
    "\0\u0d52\0\u0d89\0\u0dc0\0\u0df7\0\u0e2e\0\u0e65\0\u0e9c\0\u0ed3"+
    "\0\u0f0a\0\u0f41\0\334\0\u0f78\0\u0faf\0\u0fe6\0\u101d\0\u1054"+
    "\0\u108b\0\u063b\0\u10c2\0\u10f9\0\u1130\0\u1167\0\u119e\0\u11d5"+
    "\0\u120c\0\u06a9\0\u1243\0\u127a\0\u12b1\0\u12e8\0\u131f\0\u1356"+
    "\0\u138d\0\u13c4\0\u13fb\0\u1432\0\u1469\0\u09ab\0\u14a0\0\u14d7"+
    "\0\u150e\0\u1545\0\u09ab\0\u157c\0\u0a87\0\u15b3\0\u15ea\0\u1621"+
    "\0\u1658\0\u168f\0\u16c6\0\u16fd\0\u1734\0\u176b\0\u17a2\0\u17d9"+
    "\0\u1810\0\u1847\0\u187e\0\u18b5\0\u18ec\0\u1923\0\245\0\u195a"+
    "\0\u1991\0\u19c8\0\u19ff\0\u1a36\0\u1a6d\0\u1aa4\0\u0a50\0\u0af5"+
    "\0\u0b63\0\u1adb\0\u1b12\0\u19ff\0\u1b49\0\u1b80";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[150];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\2\5\1\6\1\7\1\10\1\5\1\11\1\6"+
    "\1\4\1\12\1\13\1\14\1\15\1\16\1\4\2\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\5"+
    "\1\27\1\17\1\30\1\5\1\17\1\5\1\31\1\32"+
    "\1\5\1\33\1\34\1\35\1\36\1\37\1\17\1\4"+
    "\1\40\1\41\3\5\1\42\1\5\1\43\1\44\1\16"+
    "\1\5\1\41\1\5\1\4\2\5\1\6\1\7\1\10"+
    "\1\5\1\45\1\6\1\4\1\12\1\13\1\14\1\15"+
    "\1\16\1\4\2\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\5\1\27\1\17\1\30\1\5\1\17"+
    "\1\5\1\31\1\32\1\5\1\33\1\34\1\35\1\36"+
    "\1\37\1\17\1\4\1\40\1\41\3\5\1\42\1\5"+
    "\1\43\1\44\1\16\1\5\1\41\1\5\6\46\1\47"+
    "\6\46\1\50\35\46\1\51\1\52\7\46\1\53\1\54"+
    "\1\55\67\0\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\10\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\7\5\2\56\1\0\3\5\1\56\2\5\1\6"+
    "\1\56\1\41\1\60\1\0\1\6\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\1\41\6\5\1\41\1\56"+
    "\1\41\1\5\1\0\1\5\1\41\1\56\2\5\1\56"+
    "\1\5\4\56\1\5\1\41\5\5\2\56\1\0\1\60"+
    "\1\41\1\5\3\0\1\61\1\0\1\61\2\0\1\61"+
    "\12\0\1\61\6\0\1\61\1\0\1\61\3\0\1\61"+
    "\12\0\1\61\11\0\1\61\1\0\1\56\2\5\1\41"+
    "\1\56\1\41\1\60\1\0\1\41\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\1\41\4\5\1\62\1\5"+
    "\1\41\1\56\1\41\1\5\1\0\1\63\1\41\1\56"+
    "\2\5\1\56\1\5\4\56\1\64\1\41\5\5\2\56"+
    "\1\0\1\60\1\41\1\5\10\0\1\65\56\0\12\12"+
    "\1\66\54\12\13\13\1\67\53\13\16\0\1\16\44\0"+
    "\1\16\4\0\3\70\1\0\1\70\1\71\1\0\1\70"+
    "\12\0\1\72\2\70\1\73\1\74\1\75\2\70\1\0"+
    "\1\76\1\70\1\0\1\77\1\70\1\0\1\100\1\70"+
    "\1\0\1\101\4\0\7\70\3\0\1\71\2\70\1\56"+
    "\2\5\1\41\1\56\1\102\1\60\1\0\1\41\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\1\41\1\103"+
    "\1\5\1\104\3\5\1\105\1\56\1\41\1\5\1\0"+
    "\1\106\1\41\1\56\1\5\1\107\1\56\1\5\4\56"+
    "\1\110\1\41\2\5\1\111\2\5\2\56\1\0\1\60"+
    "\1\41\1\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\3\5"+
    "\1\112\4\5\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\113\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\1\5\1\114\4\5\1\115"+
    "\1\116\1\56\1\64\1\5\1\0\2\5\1\56\1\117"+
    "\1\5\1\56\1\120\4\56\7\5\2\56\1\0\3\5"+
    "\1\56\3\5\1\56\2\5\1\0\1\5\1\0\3\56"+
    "\2\0\1\57\1\0\1\56\1\0\4\5\1\63\3\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\7\5\2\56\1\0\3\5\1\56\3\5\1\56"+
    "\2\5\1\0\1\5\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\10\5\1\56\2\5\1\0\2\5\1\56"+
    "\1\5\1\115\1\56\1\5\4\56\7\5\2\56\1\0"+
    "\3\5\1\56\3\5\1\56\2\5\1\0\1\5\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\10\5\1\56"+
    "\1\121\1\5\1\0\1\5\1\122\1\56\1\5\1\123"+
    "\1\56\1\124\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\2\5\1\41\1\56\1\41\1\60\1\0\1\41\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\1\41\3\5"+
    "\1\124\2\5\1\41\1\56\1\41\1\5\1\0\1\5"+
    "\1\41\1\56\2\5\1\56\1\5\4\56\1\5\1\41"+
    "\1\5\1\125\3\5\2\56\1\0\1\60\1\41\1\5"+
    "\1\56\2\5\1\41\1\56\1\41\1\60\1\0\1\41"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\1\41"+
    "\2\5\1\126\3\5\1\41\1\56\1\41\1\5\1\0"+
    "\1\5\1\127\1\56\1\130\1\124\1\56\1\110\4\56"+
    "\1\5\1\41\5\5\2\56\1\0\1\60\1\41\1\5"+
    "\1\56\2\5\1\41\1\56\1\131\1\60\1\0\1\41"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\1\132"+
    "\1\5\1\123\4\5\1\133\1\56\1\41\1\5\1\0"+
    "\1\5\1\132\1\56\2\5\1\56\1\5\4\56\1\5"+
    "\1\132\2\123\2\5\1\63\2\56\1\0\1\60\1\132"+
    "\1\123\41\0\1\17\25\0\1\56\3\5\1\56\2\5"+
    "\1\0\1\5\1\0\3\56\2\0\1\57\1\0\1\56"+
    "\1\0\2\5\1\134\1\5\1\135\1\115\1\5\1\136"+
    "\1\56\2\5\1\0\2\5\1\56\1\5\1\115\1\56"+
    "\1\5\4\56\7\5\2\56\1\0\3\5\44\0\1\17"+
    "\1\0\1\17\1\0\1\17\16\0\1\56\3\5\1\56"+
    "\2\5\1\0\1\5\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\1\113\1\5\1\122\2\5\1\137\1\5"+
    "\1\140\1\56\1\120\1\5\1\0\2\5\1\56\1\5"+
    "\1\104\1\56\1\5\4\56\7\5\2\56\1\0\3\5"+
    "\46\0\1\17\1\0\1\17\65\0\1\17\17\0\1\56"+
    "\3\5\1\56\1\5\1\141\1\0\1\5\1\0\3\56"+
    "\2\0\1\57\1\0\1\56\1\0\5\5\1\141\2\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\7\5\2\56\1\0\1\141\2\5\1\56\2\5"+
    "\1\41\1\56\1\41\1\60\1\0\1\41\1\0\3\56"+
    "\2\0\1\57\1\0\1\56\1\0\1\41\6\5\1\41"+
    "\1\56\1\41\1\5\1\0\1\5\1\41\1\56\2\5"+
    "\1\56\1\5\4\56\1\5\1\41\5\5\2\56\1\0"+
    "\1\60\1\41\1\5\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\10\5\1\56\2\5\1\0\1\63\1\5\1\56\2\5"+
    "\1\56\1\124\4\56\7\5\2\56\1\0\3\5\1\0"+
    "\2\142\2\0\2\142\14\0\10\142\1\0\2\142\1\0"+
    "\2\142\1\0\2\142\1\0\1\142\4\0\7\142\3\0"+
    "\3\142\12\143\1\144\50\143\1\0\3\143\1\0\2\145"+
    "\2\0\2\145\1\0\1\65\12\0\10\145\1\0\2\145"+
    "\1\0\2\145\1\0\2\145\1\0\1\145\4\0\7\145"+
    "\3\0\3\145\15\46\1\0\46\46\3\0\15\46\1\0"+
    "\7\46\1\146\36\46\3\0\15\46\1\0\6\46\1\147"+
    "\1\150\36\46\3\0\15\46\1\0\36\46\1\151\7\46"+
    "\2\0\1\152\25\0\1\153\65\0\1\154\1\155\115\0"+
    "\1\152\11\0\1\152\7\56\1\0\1\56\1\0\3\56"+
    "\2\0\1\56\1\0\1\56\1\0\13\56\1\0\24\56"+
    "\1\0\4\56\3\5\1\56\1\123\1\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\1\5"+
    "\1\123\6\5\1\56\2\5\1\0\1\5\1\123\1\56"+
    "\2\5\1\56\1\5\4\56\4\5\1\123\2\5\2\56"+
    "\1\0\3\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\10\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\1\123\6\5\2\56\1\0\3\5\1\56\3\5"+
    "\1\56\2\5\1\0\1\5\1\0\3\56\2\0\1\57"+
    "\1\0\1\56\1\0\6\5\1\123\1\5\1\56\2\5"+
    "\1\0\2\5\1\56\1\123\1\5\1\56\1\5\4\56"+
    "\7\5\2\56\1\0\3\5\7\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\13\156\1\0"+
    "\24\156\1\0\12\156\1\0\1\156\1\0\3\156\2\0"+
    "\1\156\1\0\1\156\1\0\1\156\1\157\11\156\1\0"+
    "\24\156\1\0\12\156\1\0\1\156\1\0\3\156\2\0"+
    "\1\156\1\0\1\156\1\0\1\156\1\160\7\156\1\161"+
    "\1\156\1\0\24\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\4\156\1\162"+
    "\6\156\1\0\24\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\13\156\1\0"+
    "\4\156\1\163\17\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\4\156\1\157"+
    "\6\156\1\0\24\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\3\156\1\164"+
    "\7\156\1\0\24\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\4\156\1\164"+
    "\6\156\1\0\24\156\1\0\12\156\1\0\1\156\1\0"+
    "\3\156\2\0\1\156\1\0\1\156\1\0\4\156\1\165"+
    "\6\156\1\0\24\156\1\0\11\156\1\166\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\13\156"+
    "\1\0\24\156\1\0\1\166\2\156\1\56\2\5\1\41"+
    "\1\56\1\132\1\60\1\0\1\41\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\1\41\6\5\1\41\1\56"+
    "\1\41\1\5\1\0\1\5\1\41\1\56\2\5\1\56"+
    "\1\123\4\56\1\5\1\41\5\5\2\56\1\0\1\60"+
    "\1\41\1\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\2\5"+
    "\1\123\5\5\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\7\5\1\123\1\56\2\5"+
    "\1\0\2\5\1\56\2\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\2\5\1\41\1\56\1\41"+
    "\1\60\1\0\1\41\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\1\41\6\5\1\41\1\56\1\41\1\5"+
    "\1\0\1\5\1\41\1\56\2\5\1\56\1\5\4\56"+
    "\1\5\1\41\1\5\1\123\3\5\2\56\1\0\1\60"+
    "\1\41\1\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\1\5"+
    "\1\123\6\5\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\10\5\1\56\1\5\1\123"+
    "\1\0\2\5\1\56\2\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\5\5\1\123\2\5\1\56\2\5\1\0\2\5\1\56"+
    "\2\5\1\56\1\5\4\56\7\5\2\56\1\0\3\5"+
    "\1\56\3\5\1\56\1\123\1\5\1\0\1\5\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\10\5\1\56"+
    "\2\5\1\0\2\5\1\56\2\5\1\56\1\123\4\56"+
    "\7\5\2\56\1\0\3\5\1\56\3\5\1\56\1\123"+
    "\1\5\1\0\1\5\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\6\5\1\123\1\5\1\56\2\5\1\0"+
    "\2\5\1\56\1\123\1\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\3\5\1\56\1\123\1\5"+
    "\1\0\1\5\1\0\3\56\2\0\1\57\1\0\1\56"+
    "\1\0\10\5\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\10\5\1\56\2\5\1\0"+
    "\1\167\1\5\1\56\2\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\10\5\1\56\1\123\1\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\10\5\1\56\2\5\1\0"+
    "\2\5\1\56\1\170\1\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\10\5\1\56\1\123\1\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\123\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\10\5\1\56\2\5\1\0"+
    "\2\5\1\56\1\123\1\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\10\5\1\56\2\5\1\0\2\5\1\56\1\123\1\5"+
    "\1\56\1\123\4\56\7\5\2\56\1\0\3\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\6\5\1\123\1\5\1\56"+
    "\1\123\1\5\1\0\2\5\1\56\1\123\1\5\1\56"+
    "\1\5\4\56\7\5\2\56\1\0\3\5\1\56\3\5"+
    "\1\56\2\5\1\0\1\5\1\0\3\56\2\0\1\57"+
    "\1\0\1\56\1\0\10\5\1\56\2\5\1\0\2\5"+
    "\1\56\1\5\1\123\1\56\1\5\4\56\7\5\2\56"+
    "\1\0\3\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\10\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\6\5\1\123\2\56\1\0\3\5\1\56\3\5"+
    "\1\56\1\123\1\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\10\5\1\56\2\5\1\0"+
    "\1\5\1\123\1\56\2\5\1\56\1\5\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\2\5\1\41\1\56\1\132"+
    "\1\60\1\0\1\41\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\1\41\6\5\1\41\1\56\1\41\1\5"+
    "\1\0\1\5\1\41\1\56\2\5\1\56\1\5\4\56"+
    "\1\5\1\41\5\5\2\56\1\0\1\60\1\41\1\5"+
    "\1\56\3\5\1\56\2\5\1\0\1\5\1\0\3\56"+
    "\2\0\1\57\1\0\1\56\1\0\10\5\1\56\2\5"+
    "\1\0\2\5\1\56\2\5\1\56\1\123\4\56\7\5"+
    "\2\56\1\0\3\5\1\56\2\5\1\41\1\56\1\41"+
    "\1\60\1\0\1\41\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\1\41\6\5\1\41\1\56\1\41\1\5"+
    "\1\0\1\5\1\41\1\56\2\5\1\56\1\5\4\56"+
    "\1\123\1\41\5\5\2\56\1\0\1\60\1\41\1\5"+
    "\1\56\2\5\1\41\1\56\1\132\1\60\1\0\1\41"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\1\41"+
    "\5\5\1\123\1\41\1\56\1\41\1\5\1\0\1\5"+
    "\1\41\1\56\1\123\1\5\1\56\1\5\4\56\1\5"+
    "\1\41\5\5\2\56\1\0\1\60\1\41\1\5\1\56"+
    "\3\5\1\56\2\5\1\0\1\5\1\0\3\56\2\0"+
    "\1\57\1\0\1\56\1\0\1\5\1\123\6\5\1\56"+
    "\2\5\1\0\2\5\1\56\2\5\1\56\1\123\4\56"+
    "\7\5\2\56\1\0\3\5\1\56\3\5\1\56\2\5"+
    "\1\0\1\5\1\0\3\56\2\0\1\57\1\0\1\56"+
    "\1\0\5\5\1\123\2\5\1\56\2\5\1\0\2\5"+
    "\1\56\1\5\1\123\1\56\1\5\4\56\7\5\2\56"+
    "\1\0\3\5\1\56\3\5\1\56\2\5\1\0\1\5"+
    "\1\0\3\56\2\0\1\57\1\0\1\56\1\0\10\5"+
    "\1\56\2\5\1\0\2\5\1\56\2\5\1\56\1\171"+
    "\4\56\7\5\2\56\1\0\3\5\1\56\3\5\1\56"+
    "\2\5\1\0\1\5\1\0\3\56\2\0\1\57\1\0"+
    "\1\56\1\0\4\5\1\123\3\5\1\56\2\5\1\0"+
    "\2\5\1\56\2\5\1\56\1\5\4\56\7\5\2\56"+
    "\1\0\3\5\1\56\3\5\1\56\1\123\1\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\1\5\1\123\6\5\1\56\2\5\1\0\1\5\1\123"+
    "\1\56\2\5\1\56\1\5\4\56\7\5\2\56\1\0"+
    "\3\5\1\56\3\5\1\56\2\5\1\0\1\5\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\10\5\1\56"+
    "\1\123\1\5\1\0\2\5\1\56\2\5\1\56\1\5"+
    "\4\56\1\123\6\5\2\56\1\0\3\5\63\143\1\0"+
    "\3\143\12\144\1\143\50\144\1\172\3\144\1\0\3\145"+
    "\1\0\2\145\1\0\1\145\12\0\10\145\1\0\2\145"+
    "\1\0\2\145\1\0\2\145\1\0\1\145\4\0\7\145"+
    "\3\0\3\145\15\46\1\0\7\46\1\173\36\46\3\0"+
    "\15\46\1\0\12\46\1\174\33\46\3\0\15\46\1\0"+
    "\34\46\1\175\11\46\3\0\15\46\1\0\36\46\1\176"+
    "\7\46\2\0\1\177\54\0\1\177\11\0\1\177\25\0"+
    "\1\200\71\0\1\201\110\0\1\202\14\0\7\156\1\0"+
    "\1\156\1\0\3\156\2\0\1\156\1\0\1\156\1\0"+
    "\1\203\12\156\1\0\24\156\1\0\12\156\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\2\156"+
    "\1\204\10\156\1\0\24\156\1\0\12\156\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\3\156"+
    "\1\205\7\156\1\0\24\156\1\0\12\156\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\2\156"+
    "\1\163\10\156\1\0\24\156\1\0\12\156\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\13\156"+
    "\1\0\1\156\1\163\22\156\1\0\12\156\1\0\1\156"+
    "\1\0\3\156\2\0\1\156\1\0\1\156\1\0\5\156"+
    "\1\163\5\156\1\0\4\156\1\163\17\156\1\0\3\156"+
    "\1\56\3\5\1\56\2\5\1\0\1\5\1\0\3\56"+
    "\2\0\1\57\1\0\1\56\1\0\7\5\1\130\1\56"+
    "\2\5\1\0\2\5\1\56\2\5\1\56\1\5\4\56"+
    "\7\5\2\56\1\0\3\5\1\56\3\5\1\56\2\5"+
    "\1\0\1\5\1\0\3\56\2\0\1\57\1\0\1\56"+
    "\1\0\2\5\1\206\5\5\1\56\2\5\1\0\2\5"+
    "\1\56\2\5\1\56\1\5\4\56\7\5\2\56\1\0"+
    "\3\5\1\56\3\5\1\56\2\5\1\0\1\5\1\0"+
    "\3\56\2\0\1\57\1\0\1\56\1\0\1\123\1\5"+
    "\1\123\5\5\1\56\2\5\1\0\1\5\1\123\1\56"+
    "\2\5\1\56\1\5\4\56\2\5\2\123\3\5\2\56"+
    "\1\0\2\5\1\123\12\172\1\207\54\172\15\46\1\0"+
    "\34\46\1\210\11\46\3\0\15\46\1\0\14\46\1\175"+
    "\31\46\3\0\15\46\1\0\1\46\1\211\44\46\3\0"+
    "\15\46\1\0\4\46\1\212\41\46\25\0\1\213\116\0"+
    "\1\214\46\0\1\202\53\0\1\215\47\0\7\156\1\0"+
    "\1\156\1\0\3\156\2\0\1\156\1\0\1\156\1\0"+
    "\6\156\1\216\4\156\1\0\24\156\1\0\12\156\1\0"+
    "\1\156\1\0\3\156\2\0\1\156\1\0\1\156\1\0"+
    "\3\156\1\217\1\165\4\156\1\220\1\156\1\0\3\156"+
    "\1\221\20\156\1\0\12\156\1\0\1\156\1\0\3\156"+
    "\2\0\1\156\1\0\1\156\1\0\12\156\1\157\1\0"+
    "\24\156\1\0\3\156\1\56\3\5\1\56\2\5\1\0"+
    "\1\5\1\0\3\56\2\0\1\57\1\0\1\56\1\0"+
    "\7\5\1\222\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\7\5\2\56\1\0\3\5\15\46"+
    "\1\0\1\46\1\211\25\46\1\175\16\46\3\0\15\46"+
    "\1\0\20\46\1\223\25\46\3\0\1\46\11\212\1\46"+
    "\2\212\1\0\1\46\14\212\1\46\10\212\1\46\1\212"+
    "\2\46\13\212\1\46\3\213\1\0\1\213\1\224\4\213"+
    "\1\224\1\213\1\224\1\0\2\224\2\0\4\224\10\213"+
    "\1\0\5\213\1\224\2\213\1\0\1\213\2\0\2\224"+
    "\7\213\2\224\1\0\3\213\17\0\1\215\25\0\1\202"+
    "\57\0\1\225\30\0\7\156\1\0\1\156\1\0\3\156"+
    "\2\0\1\156\1\0\1\156\1\0\2\156\1\226\10\156"+
    "\1\0\24\156\1\0\3\156\1\56\3\5\1\56\2\5"+
    "\1\0\1\5\1\0\3\56\2\0\1\57\1\0\1\56"+
    "\1\0\10\5\1\56\2\5\1\0\2\5\1\56\2\5"+
    "\1\56\1\5\4\56\3\5\1\125\3\5\2\56\1\0"+
    "\3\5\15\46\1\0\20\46\1\212\25\46\41\0\1\213"+
    "\30\0\7\156\1\0\1\156\1\0\3\156\2\0\1\156"+
    "\1\0\1\156\1\0\7\156\1\163\3\156\1\0\24\156"+
    "\1\0\3\156";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7095];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\11\7\1\2\11\1\1\1\11\30\1\1\11"+
    "\15\1\2\11\12\0\50\1\4\0\21\1\4\0\4\1"+
    "\1\11\4\1\2\0\6\1\2\0\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[150];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  We must have this here as JFLex does not generate a
	 * no parameter constructor.
	 */
	public Assembler6502TokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { ";", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *                    <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			default:
				state = YYINITIAL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Assembler6502TokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Assembler6502TokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 186) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r':
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof)
              zzAtBOL = false;
            else
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1:
          { addToken(Token.IDENTIFIER);
          }
        case 17: break;
        case 14:
          { addToken(Token.FUNCTION);
          }
        case 18: break;
        case 12:
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 19: break;
        case 15:
          { addToken(Token.VARIABLE);
          }
        case 20: break;
        case 7:
          { addToken(Token.WHITESPACE);
          }
        case 21: break;
        case 11:
          { addToken(Token.PREPROCESSOR);
          }
        case 22: break;
        case 16:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 23: break;
        case 4:
          { addToken(Token.ERROR_CHAR); /*addNullToken(); return firstToken;*/
          }
        case 24: break;
        case 5:
          { start = zzMarkedPos-1; yybegin(EOL_COMMENT);
          }
        case 25: break;
        case 8:
          { addToken(Token.OPERATOR);
          }
        case 26: break;
        case 2:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 27: break;
        case 13:
          { addToken(Token.LITERAL_CHAR);
          }
        case 28: break;
        case 3:
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 29: break;
        case 6:
          { addNullToken(); return firstToken;
          }
        case 30: break;
        case 10:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 31: break;
        case 9:
          {
          }
        case 32: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 151: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 152: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
