/* The following code was generated by JFlex 1.4.1 on 7/14/13 10:47 PM */

/*
 * 06/30/2013
 *
 * HtaccessTokenMaker.java - Token generator for .htaccess files.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for .htaccess files.
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>HtaccessTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.7
 *
 */

public class HtaccessTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int EOL_COMMENT = 1;
  public static final int INTAG = 2;
  public static final int INATTR_DOUBLE = 3;
  public static final int YYINITIAL = 0;
  public static final int INATTR_SINGLE = 4;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\5\1\7\1\0\1\3\23\0\1\5\1\14\1\12\1\10"+
    "\1\21\1\14\1\14\1\16\5\14\1\2\1\33\1\13\12\20\1\15"+
    "\1\14\1\4\1\53\1\6\2\14\1\34\1\41\1\35\1\40\1\31"+
    "\1\26\1\43\1\22\1\27\1\17\1\51\1\30\1\46\1\36\1\37"+
    "\1\24\1\50\1\44\1\25\1\23\1\45\1\47\1\32\1\52\1\42"+
    "\1\17\1\14\1\11\1\14\1\0\1\1\1\0\1\34\1\41\1\35"+
    "\1\40\1\31\1\55\1\43\1\54\1\27\1\17\1\51\1\30\1\46"+
    "\1\36\1\37\1\24\1\50\1\44\1\25\1\23\1\45\1\47\1\56"+
    "\1\52\1\42\1\17\3\0\1\14\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\2\1\1\2\1\3\1\2\1\3\1\4\1\5"+
    "\21\2\1\1\1\6\6\1\2\7\1\10\1\11\1\12"+
    "\1\13\1\1\1\14\1\1\1\15\1\0\2\16\44\2"+
    "\4\1\4\0\1\17\1\16\1\20\1\16\1\21\56\2"+
    "\4\1\4\0\62\2\1\22\13\2\3\1\1\23\2\0"+
    "\104\2\1\1\2\0\1\22\12\2\1\22\31\2\1\22"+
    "\146\2\1\22\60\2\1\22\33\2\1\22\47\2\1\22"+
    "\225\2\1\22\33\2\1\22\102\2\1\22\1\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[795];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\57\0\136\0\215\0\274\0\353\0\u011a\0\u0149"+
    "\0\u0178\0\u01a7\0\u01a7\0\u01d6\0\u0205\0\u0234\0\u0263\0\u0292"+
    "\0\u02c1\0\u02f0\0\u031f\0\u034e\0\u037d\0\u03ac\0\u03db\0\u040a"+
    "\0\u0439\0\u0468\0\u0497\0\u04c6\0\u04f5\0\u01a7\0\u0524\0\u0553"+
    "\0\u0582\0\u05b1\0\u05e0\0\u060f\0\u063e\0\u066d\0\u01a7\0\u01a7"+
    "\0\u01a7\0\u01a7\0\u069c\0\u01a7\0\u06cb\0\u06fa\0\u0729\0\u0758"+
    "\0\u0787\0\u07b6\0\u07e5\0\u0814\0\u0843\0\u0872\0\u08a1\0\u08d0"+
    "\0\u08ff\0\u092e\0\u095d\0\u098c\0\u09bb\0\u09ea\0\u0a19\0\u0a48"+
    "\0\u0a77\0\u0aa6\0\u0ad5\0\u0b04\0\u0b33\0\u0b62\0\u0b91\0\u0bc0"+
    "\0\u0bef\0\u0c1e\0\u0c4d\0\u0c7c\0\u0cab\0\u0cda\0\u0d09\0\u0d38"+
    "\0\u0d67\0\u0d96\0\u0dc5\0\u0df4\0\u0e23\0\u0e52\0\u0e81\0\u0eb0"+
    "\0\u0edf\0\u0f0e\0\u0f3d\0\u0f6c\0\u0f9b\0\u0fca\0\u0ff9\0\u01a7"+
    "\0\u1028\0\u01a7\0\u1057\0\u1086\0\u10b5\0\u10e4\0\u1113\0\u1142"+
    "\0\u1171\0\u11a0\0\u11cf\0\u11fe\0\u122d\0\u125c\0\u128b\0\u12ba"+
    "\0\u12e9\0\u1318\0\u1347\0\u1376\0\u13a5\0\u13d4\0\u1403\0\u1432"+
    "\0\u1461\0\u1490\0\u14bf\0\u14ee\0\u151d\0\u154c\0\u157b\0\u15aa"+
    "\0\u15d9\0\u1608\0\u1637\0\u1666\0\u1695\0\u16c4\0\u16f3\0\u1722"+
    "\0\u1751\0\u1780\0\u17af\0\u17de\0\u180d\0\u183c\0\u186b\0\u189a"+
    "\0\u18c9\0\u18f8\0\u1927\0\u1956\0\u1985\0\u19b4\0\u19e3\0\u1a12"+
    "\0\u1a41\0\u1a70\0\u1a9f\0\u1ace\0\u1afd\0\u1b2c\0\u1b5b\0\u1b8a"+
    "\0\u1bb9\0\u1be8\0\u1c17\0\u1c46\0\u1c75\0\u1ca4\0\u1cd3\0\u1d02"+
    "\0\u1d31\0\u1d60\0\u1d8f\0\u1dbe\0\u1ded\0\u1e1c\0\u1e4b\0\u1e7a"+
    "\0\u1ea9\0\u1ed8\0\u1f07\0\u1f36\0\u1f65\0\u1f94\0\u1fc3\0\u1ff2"+
    "\0\u2021\0\u2050\0\u207f\0\u20ae\0\u20dd\0\u210c\0\u213b\0\u216a"+
    "\0\u2199\0\u21c8\0\u21f7\0\u2226\0\u2255\0\u2284\0\u22b3\0\u22e2"+
    "\0\u2311\0\u2340\0\353\0\u236f\0\u239e\0\u23cd\0\u23fc\0\u242b"+
    "\0\u245a\0\u2489\0\u24b8\0\u24e7\0\u2516\0\u2545\0\u2574\0\u25a3"+
    "\0\u25d2\0\u2601\0\u2630\0\u265f\0\u268e\0\u26bd\0\u26ec\0\u271b"+
    "\0\u274a\0\u2779\0\u27a8\0\u27d7\0\u2806\0\u2835\0\u2864\0\u2893"+
    "\0\u28c2\0\u28f1\0\u2920\0\u294f\0\u297e\0\u29ad\0\u29dc\0\u2a0b"+
    "\0\u2a3a\0\u2a69\0\u2a98\0\u2ac7\0\u2af6\0\u2b25\0\u2b54\0\u2b83"+
    "\0\u2bb2\0\u2be1\0\u2c10\0\u2c3f\0\u2c6e\0\u2c9d\0\u2ccc\0\u2cfb"+
    "\0\u2d2a\0\u2d59\0\u2d88\0\u2db7\0\u2de6\0\u2e15\0\u2e44\0\u2e73"+
    "\0\u2ea2\0\u2ed1\0\u2f00\0\u2f2f\0\u2f5e\0\u2f8d\0\u2fbc\0\u2feb"+
    "\0\u301a\0\u3049\0\u3078\0\u30a7\0\u30d6\0\u3105\0\u3134\0\u3163"+
    "\0\u3192\0\u31c1\0\u31f0\0\u321f\0\u324e\0\u327d\0\u32ac\0\u32db"+
    "\0\u330a\0\u2601\0\u3339\0\u3368\0\u3397\0\u33c6\0\u33f5\0\u3424"+
    "\0\u3453\0\u3482\0\u34b1\0\u34e0\0\u350f\0\u353e\0\u356d\0\u359c"+
    "\0\u35cb\0\u35fa\0\u3629\0\u3658\0\u3687\0\u36b6\0\u36e5\0\u3714"+
    "\0\u3743\0\u3772\0\u37a1\0\u37d0\0\u37ff\0\u382e\0\u385d\0\u388c"+
    "\0\u38bb\0\u38ea\0\u3919\0\u3948\0\u3977\0\u39a6\0\u39d5\0\u3a04"+
    "\0\u3a33\0\u3a62\0\u3a91\0\u3ac0\0\u3aef\0\u3b1e\0\u3b4d\0\u3b7c"+
    "\0\u3bab\0\u3bda\0\u3c09\0\u3c38\0\u3c67\0\u3c96\0\u3cc5\0\u3cf4"+
    "\0\u3d23\0\u3d52\0\u3d81\0\u3db0\0\u3ddf\0\u3e0e\0\u3e3d\0\u3e6c"+
    "\0\u3368\0\u3e9b\0\u3eca\0\u3ef9\0\u3f28\0\u3f57\0\u3f86\0\u3fb5"+
    "\0\u3fe4\0\u4013\0\u4042\0\u4071\0\u40a0\0\u40cf\0\u40fe\0\u412d"+
    "\0\u415c\0\u418b\0\u41ba\0\u41e9\0\u4218\0\u4247\0\u4276\0\u42a5"+
    "\0\u42d4\0\u4303\0\u4332\0\u4361\0\u4390\0\u43bf\0\u43ee\0\u441d"+
    "\0\u444c\0\u447b\0\u44aa\0\u44d9\0\u4508\0\u4537\0\u4566\0\u4595"+
    "\0\u45c4\0\u45f3\0\u4622\0\u4651\0\u4680\0\u46af\0\u46de\0\u470d"+
    "\0\u473c\0\u476b\0\u479a\0\u47c9\0\u47f8\0\u4827\0\u4856\0\u4885"+
    "\0\u48b4\0\u48e3\0\u4912\0\u4941\0\u4970\0\u499f\0\u49ce\0\u49fd"+
    "\0\u4a2c\0\u4a5b\0\u4a8a\0\u4ab9\0\u4ae8\0\u4b17\0\u4b46\0\u4b75"+
    "\0\u4ba4\0\u4bd3\0\u4c02\0\u4c31\0\u4c60\0\u4c8f\0\u4cbe\0\u4ced"+
    "\0\u4d1c\0\u4d4b\0\u4d7a\0\u4da9\0\u4dd8\0\u4e07\0\u4e36\0\u4e65"+
    "\0\u4e94\0\u4ec3\0\u4ef2\0\u4f21\0\u4f50\0\u4f7f\0\u4fae\0\u4fdd"+
    "\0\u500c\0\u503b\0\u506a\0\u5099\0\u50c8\0\u50f7\0\u5126\0\u5155"+
    "\0\u5184\0\u51b3\0\u51e2\0\u5211\0\u5240\0\u526f\0\u529e\0\u52cd"+
    "\0\u52fc\0\u532b\0\u535a\0\u5389\0\u53b8\0\u53e7\0\u5416\0\u5445"+
    "\0\u5474\0\u54a3\0\u54d2\0\u5501\0\u5530\0\u555f\0\u558e\0\u55bd"+
    "\0\u55ec\0\u561b\0\u564a\0\u5679\0\u56a8\0\u56d7\0\u5706\0\u5735"+
    "\0\u5764\0\u5793\0\u57c2\0\u57f1\0\u5820\0\u584f\0\u587e\0\u58ad"+
    "\0\u58dc\0\u590b\0\u593a\0\u5969\0\u5998\0\u59c7\0\u59f6\0\u5a25"+
    "\0\u5a54\0\u5a83\0\u5ab2\0\u5ae1\0\u5b10\0\u5b3f\0\u5b6e\0\u5b9d"+
    "\0\u5bcc\0\u5bfb\0\u5c2a\0\u5c59\0\u5c88\0\u5cb7\0\u5ce6\0\u5d15"+
    "\0\u5d44\0\u5d73\0\u5da2\0\u5dd1\0\u5e00\0\u5e2f\0\u5e5e\0\u5e8d"+
    "\0\u5ebc\0\u5eeb\0\u5f1a\0\u5f49\0\u5f78\0\u5fa7\0\u5fd6\0\u6005"+
    "\0\u6034\0\u6063\0\u6092\0\u60c1\0\u60f0\0\u611f\0\u614e\0\u617d"+
    "\0\u61ac\0\u61db\0\u620a\0\u6239\0\u6268\0\u6297\0\u62c6\0\u62f5"+
    "\0\u6324\0\u6353\0\u6382\0\u63b1\0\u63e0\0\u640f\0\u643e\0\u646d"+
    "\0\u649c\0\u64cb\0\u64fa\0\u6529\0\u6558\0\u6587\0\u65b6\0\u65e5"+
    "\0\u6614\0\u6643\0\u6672\0\u66a1\0\u66d0\0\u66ff\0\u672e\0\u675d"+
    "\0\u678c\0\u67bb\0\u67ea\0\u6819\0\u6848\0\u6877\0\u68a6\0\u68d5"+
    "\0\u6904\0\u6933\0\u6962\0\u6991\0\u69c0\0\u69ef\0\u6a1e\0\u6a4d"+
    "\0\u6a7c\0\u6aab\0\u6ada\0\u6b09\0\u6b38\0\u6b67\0\u6b96\0\u6bc5"+
    "\0\u6bf4\0\u6c23\0\u6c52\0\u6c81\0\u6cb0\0\u6cdf\0\u6d0e\0\u6d3d"+
    "\0\u6d6c\0\u6d9b\0\u6dca\0\u6df9\0\u6e28\0\u6e57\0\u6e86\0\u6eb5"+
    "\0\u6ee4\0\u6f13\0\u6f42\0\u6f71\0\u6fa0\0\u6fcf\0\u6ffe\0\u702d"+
    "\0\u705c\0\u708b\0\u70ba\0\u70e9\0\u7118\0\u7147\0\u7176\0\u71a5"+
    "\0\u71d4\0\u7203\0\u7232\0\u7261\0\u7290\0\u72bf\0\u72ee\0\u731d"+
    "\0\u734c\0\u737b\0\u73aa\0\u73d9\0\u7408\0\u7437\0\u7466\0\u7495"+
    "\0\u74c4\0\u74f3\0\u7522\0\u7551\0\u7580\0\u75af\0\u75de\0\u760d"+
    "\0\u763c\0\u766b\0\u769a\0\u76c9\0\u76f8\0\u7727\0\u7756\0\u7785"+
    "\0\u77b4\0\u77e3\0\u7812\0\u7841\0\u7870\0\u789f\0\u78ce\0\u78fd"+
    "\0\u792c\0\u795b\0\u798a\0\u79b9\0\u79e8\0\u7a17\0\u7a46\0\u7a75"+
    "\0\u7aa4\0\u7ad3\0\u7b02\0\u7b31\0\u7b60\0\u7b8f\0\u7bbe\0\u7bed"+
    "\0\u7c1c\0\u7c4b\0\u7c7a\0\u7ca9\0\u7cd8\0\u7d07\0\u7d36\0\u7d65"+
    "\0\u7d94\0\u7dc3\0\u7df2\0\u7e21\0\u7e50\0\u7e7f\0\u7eae\0\u7edd"+
    "\0\u7f0c\0\u7f3b\0\u7f6a\0\u7f99\0\u7fc8\0\u7ff7\0\u8026\0\u8055"+
    "\0\u8084\0\u80b3\0\u80e2\0\u8111\0\u8140\0\u816f\0\u819e\0\u81cd"+
    "\0\u81fc\0\u822b\0\u825a\0\u8289\0\u82b8\0\u82e7\0\u8316\0\u8345"+
    "\0\u8374\0\u83a3\0\u83d2\0\u8401\0\u8430\0\u845f\0\u848e\0\u84bd"+
    "\0\u84ec\0\u851b\0\u854a\0\u8579\0\u85a8\0\u85d7\0\u8606\0\u8635"+
    "\0\u8664\0\u8693\0\u86c2\0\u86f1\0\u8720\0\u874f\0\u877e\0\u87ad"+
    "\0\u87dc\0\u880b\0\u883a\0\u8869\0\u8898\0\u88c7\0\u88f6\0\u8925"+
    "\0\u8954\0\u8983\0\u89b2\0\u89e1\0\u8a10\0\u8a3f\0\u8a6e\0\u8a9d"+
    "\0\u8acc\0\u8afb\0\u8b2a\0\u8b59\0\u8b88\0\u8bb7\0\u8be6\0\u8c15"+
    "\0\u8c44\0\u8c73\0\u8ca2\0\u8cd1\0\u8d00\0\u8d2f\0\u8d5e\0\u8d8d"+
    "\0\u8dbc\0\u8deb\0\u8e1a\0\u8e49\0\u8e78\0\u8ea7\0\u8ed6\0\u8f05"+
    "\0\u8f34\0\u8b2a\0\u8f63";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[795];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\6\1\7\1\10\1\11\1\6\1\12\1\13\1\6"+
    "\1\14\7\6\1\15\1\6\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\2\6\1\24\1\25\1\6\1\26\1\27"+
    "\1\30\2\6\1\31\1\32\1\33\3\6\1\34\1\6"+
    "\1\15\1\20\1\6\7\35\1\36\12\35\1\37\3\35"+
    "\1\40\3\35\1\41\21\35\1\42\1\43\1\44\3\45"+
    "\1\46\1\45\1\11\1\47\1\0\2\45\1\50\3\45"+
    "\1\51\34\45\1\52\3\45\12\53\1\54\44\53\16\55"+
    "\1\54\40\55\4\6\2\0\1\6\2\0\51\6\1\7"+
    "\1\0\1\11\1\6\2\0\46\6\1\0\1\56\11\0"+
    "\1\57\1\0\1\56\1\0\1\56\2\0\11\56\1\0"+
    "\17\56\1\0\3\56\3\0\1\11\1\0\1\11\130\0"+
    "\4\14\2\60\1\14\1\61\1\60\1\62\1\6\44\14"+
    "\4\6\2\0\1\6\2\0\20\6\1\63\31\6\2\0"+
    "\1\6\2\0\23\6\1\64\26\6\2\0\1\6\2\0"+
    "\14\6\1\65\3\6\1\66\2\6\1\67\1\70\25\6"+
    "\2\0\1\6\2\0\16\6\1\71\7\6\1\72\23\6"+
    "\2\0\1\6\2\0\14\6\1\73\10\6\1\74\7\6"+
    "\1\75\14\6\2\0\1\6\2\0\16\6\1\76\4\6"+
    "\1\77\26\6\2\0\1\6\2\0\25\6\1\100\5\6"+
    "\1\101\5\6\1\102\10\6\2\0\1\6\2\0\17\6"+
    "\1\103\4\6\1\104\1\105\1\6\1\106\4\6\1\107"+
    "\15\6\2\0\1\6\2\0\11\6\1\110\14\6\1\111"+
    "\3\6\1\112\10\6\1\110\6\6\2\0\1\6\2\0"+
    "\13\6\1\113\17\6\1\114\16\6\2\0\1\6\2\0"+
    "\16\6\1\115\1\6\1\116\31\6\2\0\1\6\2\0"+
    "\33\6\1\117\16\6\2\0\1\6\2\0\17\6\1\120"+
    "\1\121\31\6\2\0\1\6\2\0\25\6\1\122\24\6"+
    "\2\0\1\6\2\0\20\6\1\123\13\6\1\124\15\6"+
    "\2\0\1\6\2\0\30\6\1\125\15\6\7\35\1\0"+
    "\44\35\3\0\7\35\1\0\13\35\1\126\30\35\3\0"+
    "\7\35\1\0\13\35\1\127\3\35\1\130\24\35\3\0"+
    "\7\35\1\0\22\35\1\131\21\35\2\0\1\132\23\0"+
    "\1\133\56\0\1\134\3\0\1\135\61\0\1\132\23\0"+
    "\1\132\5\45\3\0\2\45\1\0\3\45\1\0\34\45"+
    "\1\0\6\45\1\46\1\45\1\11\2\0\2\45\1\0"+
    "\3\45\1\0\34\45\1\0\3\45\12\53\1\0\44\53"+
    "\16\55\1\0\40\55\1\0\2\56\12\0\1\56\1\0"+
    "\2\56\1\0\31\56\1\0\3\56\1\0\1\136\13\0"+
    "\1\136\1\0\1\136\2\0\11\136\1\0\17\136\1\0"+
    "\3\136\7\60\1\61\1\60\1\137\1\140\44\60\11\61"+
    "\1\141\1\142\44\61\4\14\2\60\1\14\1\0\1\60"+
    "\46\14\4\6\2\0\1\6\2\0\23\6\1\143\26\6"+
    "\2\0\1\6\2\0\14\6\1\144\35\6\2\0\1\6"+
    "\2\0\16\6\1\145\1\146\32\6\2\0\1\6\2\0"+
    "\12\6\1\147\20\6\1\150\16\6\2\0\1\6\2\0"+
    "\12\6\1\151\37\6\2\0\1\6\2\0\33\6\1\152"+
    "\16\6\2\0\1\6\2\0\17\6\1\153\32\6\2\0"+
    "\1\6\2\0\33\6\1\154\16\6\2\0\1\6\2\0"+
    "\23\6\1\155\26\6\2\0\1\6\2\0\27\6\1\156"+
    "\22\6\2\0\1\6\2\0\23\6\1\157\26\6\2\0"+
    "\1\6\2\0\35\6\1\160\14\6\2\0\1\6\2\0"+
    "\25\6\1\161\24\6\2\0\1\6\2\0\23\6\1\162"+
    "\26\6\2\0\1\6\2\0\33\6\1\163\16\6\2\0"+
    "\1\6\2\0\13\6\1\164\7\6\1\165\26\6\2\0"+
    "\1\6\2\0\17\6\1\166\32\6\2\0\1\6\2\0"+
    "\12\6\1\167\11\6\1\170\25\6\2\0\1\6\2\0"+
    "\26\6\1\171\23\6\2\0\1\6\2\0\27\6\1\172"+
    "\22\6\2\0\1\6\2\0\12\6\1\173\37\6\2\0"+
    "\1\6\2\0\20\6\1\174\2\6\1\175\26\6\2\0"+
    "\1\6\2\0\25\6\1\176\1\177\23\6\2\0\1\6"+
    "\2\0\16\6\1\200\33\6\2\0\1\6\2\0\12\6"+
    "\1\201\37\6\2\0\1\6\2\0\27\6\1\202\22\6"+
    "\2\0\1\6\2\0\33\6\1\203\16\6\2\0\1\6"+
    "\2\0\15\6\1\204\7\6\1\205\16\6\1\204\5\6"+
    "\2\0\1\6\2\0\26\6\1\206\23\6\2\0\1\6"+
    "\2\0\16\6\1\207\33\6\2\0\1\6\2\0\21\6"+
    "\1\210\1\6\1\211\3\6\1\212\5\6\1\213\1\6"+
    "\1\214\5\6\1\210\4\6\2\0\1\6\2\0\14\6"+
    "\1\215\35\6\2\0\1\6\2\0\12\6\1\216\37\6"+
    "\2\0\1\6\2\0\17\6\1\217\32\6\2\0\1\6"+
    "\2\0\16\6\1\220\27\6\7\35\1\0\13\35\1\221"+
    "\30\35\3\0\7\35\1\0\14\35\1\222\27\35\3\0"+
    "\7\35\1\0\20\35\1\223\23\35\3\0\7\35\1\0"+
    "\22\35\1\224\21\35\2\0\1\225\32\0\1\225\23\0"+
    "\1\225\23\0\1\226\57\0\1\227\62\0\1\230\27\0"+
    "\2\136\12\0\1\136\1\0\2\136\1\0\31\136\1\0"+
    "\3\136\7\60\1\0\47\60\7\61\1\0\47\61\4\6"+
    "\2\0\1\6\2\0\27\6\1\231\22\6\2\0\1\6"+
    "\2\0\14\6\1\232\35\6\2\0\1\6\2\0\12\6"+
    "\1\233\5\6\1\234\31\6\2\0\1\6\2\0\13\6"+
    "\1\235\10\6\1\236\1\6\1\237\4\6\1\240\1\241"+
    "\1\6\1\242\13\6\2\0\1\6\2\0\11\6\1\243"+
    "\4\6\1\244\1\6\1\245\5\6\1\246\14\6\1\243"+
    "\6\6\2\0\1\6\2\0\36\6\1\247\13\6\2\0"+
    "\1\6\2\0\16\6\1\250\33\6\2\0\1\6\2\0"+
    "\16\6\1\251\33\6\2\0\1\6\2\0\20\6\1\252"+
    "\31\6\2\0\1\6\2\0\24\6\1\253\25\6\2\0"+
    "\1\6\2\0\13\6\1\254\36\6\2\0\1\6\2\0"+
    "\20\6\1\255\31\6\2\0\1\6\2\0\13\6\1\256"+
    "\36\6\2\0\1\6\2\0\16\6\1\257\33\6\2\0"+
    "\1\6\2\0\32\6\1\260\17\6\2\0\1\6\2\0"+
    "\30\6\1\261\21\6\2\0\1\6\2\0\26\6\1\262"+
    "\23\6\2\0\1\6\2\0\16\6\1\263\33\6\2\0"+
    "\1\6\2\0\35\6\1\264\14\6\2\0\1\6\2\0"+
    "\26\6\1\265\23\6\2\0\1\6\2\0\16\6\1\266"+
    "\33\6\2\0\1\6\2\0\20\6\1\267\31\6\2\0"+
    "\1\6\2\0\25\6\1\270\24\6\2\0\1\6\2\0"+
    "\11\6\1\243\1\271\3\6\1\272\1\273\1\274\2\6"+
    "\1\275\1\276\1\6\1\277\1\300\13\6\1\243\6\6"+
    "\2\0\1\6\2\0\11\6\1\301\31\6\1\301\6\6"+
    "\2\0\1\6\2\0\24\6\1\302\25\6\2\0\1\6"+
    "\2\0\33\6\1\303\16\6\2\0\1\6\2\0\12\6"+
    "\1\304\37\6\2\0\1\6\2\0\40\6\1\305\11\6"+
    "\2\0\1\6\2\0\35\6\1\306\14\6\2\0\1\6"+
    "\2\0\16\6\1\307\33\6\2\0\1\6\2\0\20\6"+
    "\1\310\31\6\2\0\1\6\2\0\20\6\1\311\31\6"+
    "\2\0\1\6\2\0\23\6\1\312\26\6\2\0\1\6"+
    "\2\0\31\6\1\313\20\6\2\0\1\6\2\0\21\6"+
    "\1\314\23\6\1\314\4\6\2\0\1\6\2\0\35\6"+
    "\1\315\14\6\2\0\1\6\2\0\33\6\1\316\16\6"+
    "\2\0\1\6\2\0\27\6\1\317\22\6\2\0\1\6"+
    "\2\0\16\6\1\320\33\6\2\0\1\6\2\0\26\6"+
    "\1\321\23\6\2\0\1\6\2\0\34\6\1\322\15\6"+
    "\2\0\1\6\2\0\20\6\1\323\31\6\2\0\1\6"+
    "\2\0\23\6\1\324\26\6\2\0\1\6\2\0\12\6"+
    "\1\325\37\6\2\0\1\6\2\0\12\6\1\326\33\6"+
    "\7\35\1\0\14\35\1\327\27\35\3\0\7\35\1\0"+
    "\5\35\1\330\36\35\3\0\7\35\1\0\21\35\1\222"+
    "\22\35\3\0\7\35\1\0\23\35\1\331\20\35\36\0"+
    "\1\332\47\0\1\333\47\0\1\334\72\0\1\227\25\0"+
    "\4\6\2\0\1\6\2\0\20\6\1\335\31\6\2\0"+
    "\1\6\2\0\20\6\1\336\31\6\2\0\1\6\2\0"+
    "\16\6\1\337\33\6\2\0\1\6\2\0\33\6\1\340"+
    "\16\6\2\0\1\6\2\0\33\6\1\341\16\6\2\0"+
    "\1\6\2\0\16\6\1\342\33\6\2\0\1\6\2\0"+
    "\13\6\1\113\36\6\2\0\1\6\2\0\20\6\1\343"+
    "\31\6\2\0\1\6\2\0\14\6\1\344\35\6\2\0"+
    "\1\6\2\0\20\6\1\345\31\6\2\0\1\6\2\0"+
    "\23\6\1\346\26\6\2\0\1\6\2\0\25\6\1\347"+
    "\24\6\2\0\1\6\2\0\25\6\1\350\24\6\2\0"+
    "\1\6\2\0\34\6\1\351\15\6\2\0\1\6\2\0"+
    "\20\6\1\352\31\6\2\0\1\6\2\0\14\6\1\353"+
    "\35\6\2\0\1\6\2\0\13\6\1\354\36\6\2\0"+
    "\1\6\2\0\20\6\1\355\31\6\2\0\1\6\2\0"+
    "\20\6\1\356\31\6\2\0\1\6\2\0\16\6\1\357"+
    "\33\6\2\0\1\6\2\0\41\6\1\360\10\6\2\0"+
    "\1\6\2\0\27\6\1\361\1\362\4\6\1\363\14\6"+
    "\2\0\1\6\2\0\12\6\1\364\37\6\2\0\1\6"+
    "\2\0\34\6\1\365\15\6\2\0\1\6\2\0\17\6"+
    "\1\366\32\6\2\0\1\6\2\0\33\6\1\367\16\6"+
    "\2\0\1\6\2\0\33\6\1\370\16\6\2\0\1\6"+
    "\2\0\13\6\1\371\36\6\2\0\1\6\2\0\21\6"+
    "\1\313\23\6\1\313\4\6\2\0\1\6\2\0\26\6"+
    "\1\372\23\6\2\0\1\6\2\0\13\6\1\373\36\6"+
    "\2\0\1\6\2\0\31\6\1\374\20\6\2\0\1\6"+
    "\2\0\31\6\1\375\20\6\2\0\1\6\2\0\24\6"+
    "\1\376\1\347\24\6\2\0\1\6\2\0\23\6\1\377"+
    "\26\6\2\0\1\6\2\0\25\6\1\u0100\24\6\2\0"+
    "\1\6\2\0\17\6\1\u0101\32\6\2\0\1\6\2\0"+
    "\11\6\1\u0102\31\6\1\u0102\6\6\2\0\1\6\2\0"+
    "\34\6\1\u0103\15\6\2\0\1\6\2\0\20\6\1\u0104"+
    "\31\6\2\0\1\6\2\0\12\6\1\271\4\6\1\u0105"+
    "\3\6\1\u0106\1\6\1\u0107\1\6\1\u0108\1\u0109\1\6"+
    "\1\u010a\1\6\1\u010b\15\6\2\0\1\6\2\0\40\6"+
    "\1\u010c\11\6\2\0\1\6\2\0\14\6\1\u010d\35\6"+
    "\2\0\1\6\2\0\20\6\1\u010e\31\6\2\0\1\6"+
    "\2\0\16\6\1\u010f\33\6\2\0\1\6\2\0\23\6"+
    "\1\u0110\26\6\2\0\1\6\2\0\26\6\1\u0111\23\6"+
    "\2\0\1\6\2\0\33\6\1\313\16\6\2\0\1\6"+
    "\2\0\24\6\1\u0112\25\6\2\0\1\6\2\0\34\6"+
    "\1\u0113\15\6\2\0\1\6\2\0\14\6\1\u0114\35\6"+
    "\2\0\1\6\2\0\16\6\1\u0115\33\6\2\0\1\6"+
    "\2\0\16\6\1\u0116\33\6\2\0\1\6\2\0\35\6"+
    "\1\u0117\14\6\2\0\1\6\2\0\33\6\1\u0118\16\6"+
    "\2\0\1\6\2\0\36\6\1\u0119\13\6\2\0\1\6"+
    "\2\0\16\6\1\u011a\1\6\1\u011b\31\6\2\0\1\6"+
    "\2\0\12\6\1\232\37\6\2\0\1\6\2\0\14\6"+
    "\1\u011c\1\u011d\11\6\1\u011e\14\6\1\u011d\5\6\2\0"+
    "\1\6\2\0\16\6\1\u011f\33\6\2\0\1\6\2\0"+
    "\11\6\1\u0120\31\6\1\u0120\2\6\7\35\1\0\5\35"+
    "\1\330\7\35\1\222\26\35\3\0\7\35\1\0\3\35"+
    "\1\u0121\40\35\3\0\1\35\2\331\4\35\1\0\1\331"+
    "\2\35\41\331\3\332\1\0\2\u0122\5\0\1\u0122\2\0"+
    "\1\332\3\u0122\14\332\1\u0122\17\332\1\u0122\3\332\15\0"+
    "\1\334\7\0\1\227\44\0\1\u0123\43\0\4\6\2\0"+
    "\1\6\2\0\33\6\1\u0124\16\6\2\0\1\6\2\0"+
    "\25\6\1\u0125\24\6\2\0\1\6\2\0\35\6\1\u0126"+
    "\14\6\2\0\1\6\2\0\33\6\1\u0127\16\6\2\0"+
    "\1\6\2\0\26\6\1\u0128\23\6\2\0\1\6\2\0"+
    "\13\6\1\u0129\36\6\2\0\1\6\2\0\37\6\1\u012a"+
    "\12\6\2\0\1\6\2\0\20\6\1\u012b\31\6\2\0"+
    "\1\6\2\0\33\6\1\u012c\16\6\2\0\1\6\2\0"+
    "\25\6\1\u012d\24\6\2\0\1\6\2\0\13\6\1\u012e"+
    "\36\6\2\0\1\6\2\0\36\6\1\u012f\13\6\2\0"+
    "\1\6\2\0\12\6\1\347\37\6\2\0\1\6\2\0"+
    "\33\6\1\u0130\16\6\2\0\1\6\2\0\15\6\1\205"+
    "\26\6\1\205\5\6\2\0\1\6\2\0\12\6\1\u0131"+
    "\37\6\2\0\1\6\2\0\12\6\1\u0132\37\6\2\0"+
    "\1\6\2\0\12\6\1\271\4\6\1\u0133\32\6\2\0"+
    "\1\6\2\0\15\6\1\u0134\1\6\1\u0135\3\6\1\u0136"+
    "\7\6\1\u0137\10\6\1\u0134\5\6\2\0\1\6\2\0"+
    "\16\6\1\u0138\7\6\1\u0139\23\6\2\0\1\6\2\0"+
    "\20\6\1\u013a\31\6\2\0\1\6\2\0\23\6\1\u013b"+
    "\26\6\2\0\1\6\2\0\20\6\1\u013c\31\6\2\0"+
    "\1\6\2\0\33\6\1\u013d\5\6\1\u013e\10\6\2\0"+
    "\1\6\2\0\23\6\1\u013f\26\6\2\0\1\6\2\0"+
    "\20\6\1\u0140\31\6\2\0\1\6\2\0\27\6\1\u0141"+
    "\22\6\2\0\1\6\2\0\20\6\1\u0142\31\6\2\0"+
    "\1\6\2\0\17\6\1\u0143\32\6\2\0\1\6\2\0"+
    "\25\6\1\313\24\6\2\0\1\6\2\0\12\6\1\u0144"+
    "\37\6\2\0\1\6\2\0\35\6\1\u0145\14\6\2\0"+
    "\1\6\2\0\13\6\1\u0143\36\6\2\0\1\6\2\0"+
    "\26\6\1\u0146\23\6\2\0\1\6\2\0\25\6\1\u0147"+
    "\24\6\2\0\1\6\2\0\24\6\1\u0148\25\6\2\0"+
    "\1\6\2\0\12\6\1\u0149\37\6\2\0\1\6\2\0"+
    "\23\6\1\u014a\26\6\2\0\1\6\2\0\12\6\1\u014b"+
    "\37\6\2\0\1\6\2\0\14\6\1\u014c\1\u014d\26\6"+
    "\1\u014d\5\6\2\0\1\6\2\0\27\6\1\u014e\22\6"+
    "\2\0\1\6\2\0\34\6\1\u014f\15\6\2\0\1\6"+
    "\2\0\23\6\1\u0150\26\6\2\0\1\6\2\0\16\6"+
    "\1\u0151\11\6\1\u0152\21\6\2\0\1\6\2\0\23\6"+
    "\1\u0153\26\6\2\0\1\6\2\0\33\6\1\u0154\16\6"+
    "\2\0\1\6\2\0\14\6\1\u0155\35\6\2\0\1\6"+
    "\2\0\14\6\1\u0156\35\6\2\0\1\6\2\0\20\6"+
    "\1\u0157\31\6\2\0\1\6\2\0\25\6\1\u0158\24\6"+
    "\2\0\1\6\2\0\20\6\1\u0159\31\6\2\0\1\6"+
    "\2\0\13\6\1\u015a\36\6\2\0\1\6\2\0\25\6"+
    "\1\u015b\24\6\2\0\1\6\2\0\12\6\1\u015c\37\6"+
    "\2\0\1\6\2\0\17\6\1\u015d\32\6\2\0\1\6"+
    "\2\0\20\6\1\u015e\31\6\2\0\1\6\2\0\12\6"+
    "\1\u015f\37\6\2\0\1\6\2\0\12\6\1\u0160\37\6"+
    "\2\0\1\6\2\0\20\6\1\u0161\31\6\2\0\1\6"+
    "\2\0\20\6\1\u0162\31\6\2\0\1\6\2\0\20\6"+
    "\1\u0163\31\6\2\0\1\6\2\0\33\6\1\u0143\16\6"+
    "\2\0\1\6\2\0\14\6\1\u0164\35\6\2\0\1\6"+
    "\2\0\34\6\1\u0165\15\6\2\0\1\6\2\0\16\6"+
    "\1\u0166\33\6\2\0\1\6\2\0\16\6\1\310\33\6"+
    "\2\0\1\6\2\0\36\6\1\u0167\13\6\2\0\1\6"+
    "\2\0\23\6\1\u0168\22\6\7\35\1\0\3\35\1\331"+
    "\40\35\16\0\1\332\43\0\4\6\2\0\1\6\2\0"+
    "\25\6\1\u0107\24\6\2\0\1\6\2\0\36\6\1\313"+
    "\13\6\2\0\1\6\2\0\20\6\1\u0169\31\6\2\0"+
    "\1\6\2\0\26\6\1\u016a\23\6\2\0\1\6\2\0"+
    "\41\6\1\u016b\10\6\2\0\1\6\2\0\11\6\1\u016c"+
    "\31\6\1\u016c\6\6\2\0\1\6\2\0\34\6\1\u016d"+
    "\15\6\2\0\1\6\2\0\33\6\1\u0161\16\6\2\0"+
    "\1\6\2\0\16\6\1\u016e\33\6\2\0\1\6\2\0"+
    "\27\6\1\u016f\22\6\2\0\1\6\2\0\34\6\1\u0170"+
    "\15\6\2\0\1\6\2\0\16\6\1\u0171\33\6\2\0"+
    "\1\6\2\0\14\6\1\u0172\35\6\2\0\1\6\2\0"+
    "\16\6\1\u0173\33\6\2\0\1\6\2\0\23\6\1\u0174"+
    "\26\6\2\0\1\6\2\0\23\6\1\77\26\6\2\0"+
    "\1\6\2\0\23\6\1\u0175\26\6\2\0\1\6\2\0"+
    "\26\6\1\u0176\23\6\2\0\1\6\2\0\13\6\1\u0177"+
    "\36\6\2\0\1\6\2\0\20\6\1\u0178\31\6\2\0"+
    "\1\6\2\0\32\6\1\u0179\17\6\2\0\1\6\2\0"+
    "\13\6\1\113\17\6\1\u017a\16\6\2\0\1\6\2\0"+
    "\15\6\1\u017b\26\6\1\u017b\5\6\2\0\1\6\2\0"+
    "\14\6\1\u0143\35\6\2\0\1\6\2\0\25\6\1\u017c"+
    "\24\6\2\0\1\6\2\0\20\6\1\u017d\31\6\2\0"+
    "\1\6\2\0\35\6\1\u017e\14\6\2\0\1\6\2\0"+
    "\32\6\1\u017f\17\6\2\0\1\6\2\0\14\6\1\u0180"+
    "\20\6\1\u0181\14\6\2\0\1\6\2\0\26\6\1\u0182"+
    "\23\6\2\0\1\6\2\0\14\6\1\u0183\35\6\2\0"+
    "\1\6\2\0\20\6\1\313\31\6\2\0\1\6\2\0"+
    "\13\6\1\u0184\36\6\2\0\1\6\2\0\26\6\1\u0185"+
    "\23\6\2\0\1\6\2\0\25\6\1\u0149\24\6\2\0"+
    "\1\6\2\0\32\6\1\u0186\17\6\2\0\1\6\2\0"+
    "\26\6\1\u0187\23\6\2\0\1\6\2\0\30\6\1\u0188"+
    "\21\6\2\0\1\6\2\0\33\6\1\u0189\16\6\2\0"+
    "\1\6\2\0\13\6\1\u018a\36\6\2\0\1\6\2\0"+
    "\24\6\1\u018b\25\6\2\0\1\6\2\0\23\6\1\u018c"+
    "\26\6\2\0\1\6\2\0\23\6\1\u018d\26\6\2\0"+
    "\1\6\2\0\12\6\1\u018e\37\6\2\0\1\6\2\0"+
    "\35\6\1\u0143\14\6\2\0\1\6\2\0\32\6\1\u018f"+
    "\17\6\2\0\1\6\2\0\35\6\1\u0190\14\6\2\0"+
    "\1\6\2\0\14\6\1\u0191\35\6\2\0\1\6\2\0"+
    "\26\6\1\u0192\23\6\2\0\1\6\2\0\20\6\1\u0193"+
    "\31\6\2\0\1\6\2\0\13\6\1\u0194\36\6\2\0"+
    "\1\6\2\0\12\6\1\u0195\37\6\2\0\1\6\2\0"+
    "\12\6\1\u0196\37\6\2\0\1\6\2\0\12\6\1\u0197"+
    "\1\6\1\u0198\3\6\1\u0199\4\6\1\u0107\1\6\1\u019a"+
    "\22\6\2\0\1\6\2\0\20\6\1\u019b\31\6\2\0"+
    "\1\6\2\0\14\6\1\313\35\6\2\0\1\6\2\0"+
    "\26\6\1\u019c\23\6\2\0\1\6\2\0\12\6\1\u019d"+
    "\37\6\2\0\1\6\2\0\33\6\1\u019e\16\6\2\0"+
    "\1\6\2\0\24\6\1\u019f\1\u01a0\7\6\1\u01a1\14\6"+
    "\2\0\1\6\2\0\20\6\1\u01a2\31\6\2\0\1\6"+
    "\2\0\24\6\1\u01a3\25\6\2\0\1\6\2\0\11\6"+
    "\1\243\1\271\3\6\1\244\1\273\1\274\3\6\1\276"+
    "\1\6\1\246\14\6\1\243\6\6\2\0\1\6\2\0"+
    "\12\6\1\u01a4\37\6\2\0\1\6\2\0\15\6\1\u01a5"+
    "\26\6\1\u01a5\5\6\2\0\1\6\2\0\17\6\1\u01a6"+
    "\32\6\2\0\1\6\2\0\16\6\1\u01a7\33\6\2\0"+
    "\1\6\2\0\24\6\1\u01a8\25\6\2\0\1\6\2\0"+
    "\15\6\1\u01a9\26\6\1\u01a9\5\6\2\0\1\6\2\0"+
    "\33\6\1\u01aa\16\6\2\0\1\6\2\0\31\6\1\u01ab"+
    "\20\6\2\0\1\6\2\0\20\6\1\u01ac\31\6\2\0"+
    "\1\6\2\0\16\6\1\u01ad\33\6\2\0\1\6\2\0"+
    "\15\6\1\u01ae\26\6\1\u01ae\5\6\2\0\1\6\2\0"+
    "\17\6\1\202\32\6\2\0\1\6\2\0\12\6\1\u01af"+
    "\37\6\2\0\1\6\2\0\15\6\1\u01b0\26\6\1\u01b0"+
    "\5\6\2\0\1\6\2\0\16\6\1\u01b1\33\6\2\0"+
    "\1\6\2\0\25\6\1\u01b2\24\6\2\0\1\6\2\0"+
    "\32\6\1\313\17\6\2\0\1\6\2\0\40\6\1\u01b3"+
    "\11\6\2\0\1\6\2\0\32\6\1\u01b4\17\6\2\0"+
    "\1\6\2\0\13\6\1\u01b5\36\6\2\0\1\6\2\0"+
    "\23\6\1\u01b6\26\6\2\0\1\6\2\0\25\6\1\u01b7"+
    "\24\6\2\0\1\6\2\0\27\6\1\u01b8\22\6\2\0"+
    "\1\6\2\0\23\6\1\u01b9\26\6\2\0\1\6\2\0"+
    "\34\6\1\313\15\6\2\0\1\6\2\0\37\6\1\u01ba"+
    "\12\6\2\0\1\6\2\0\17\6\1\u01bb\32\6\2\0"+
    "\1\6\2\0\20\6\1\u01bc\31\6\2\0\1\6\2\0"+
    "\20\6\1\u01bd\31\6\2\0\1\6\2\0\35\6\1\u01be"+
    "\14\6\2\0\1\6\2\0\24\6\1\u01bf\25\6\2\0"+
    "\1\6\2\0\23\6\1\u01c0\3\6\1\361\1\u01c1\21\6"+
    "\2\0\1\6\2\0\23\6\1\u01c2\26\6\2\0\1\6"+
    "\2\0\34\6\1\u01c3\15\6\2\0\1\6\2\0\34\6"+
    "\1\u01c4\15\6\2\0\1\6\2\0\27\6\1\u01c5\22\6"+
    "\2\0\1\6\2\0\31\6\1\u01c6\20\6\2\0\1\6"+
    "\2\0\14\6\1\u01c7\35\6\2\0\1\6\2\0\34\6"+
    "\1\u01c8\15\6\2\0\1\6\2\0\33\6\1\u01c9\16\6"+
    "\2\0\1\6\2\0\34\6\1\u01ca\15\6\2\0\1\6"+
    "\2\0\13\6\1\u01cb\36\6\2\0\1\6\2\0\11\6"+
    "\1\u01cc\31\6\1\u01cc\6\6\2\0\1\6\2\0\20\6"+
    "\1\u01cd\31\6\2\0\1\6\2\0\12\6\1\271\10\6"+
    "\1\u0106\6\6\1\u010a\1\6\1\u010b\15\6\2\0\1\6"+
    "\2\0\16\6\1\u01ce\33\6\2\0\1\6\2\0\34\6"+
    "\1\u01cf\15\6\2\0\1\6\2\0\33\6\1\u01d0\16\6"+
    "\2\0\1\6\2\0\20\6\1\u01d1\31\6\2\0\1\6"+
    "\2\0\14\6\1\u01d2\11\6\1\237\1\361\22\6\2\0"+
    "\1\6\2\0\27\6\1\u01d3\22\6\2\0\1\6\2\0"+
    "\33\6\1\u01d4\16\6\2\0\1\6\2\0\12\6\1\u01d5"+
    "\37\6\2\0\1\6\2\0\41\6\1\u01d6\10\6\2\0"+
    "\1\6\2\0\26\6\1\u01d7\23\6\2\0\1\6\2\0"+
    "\41\6\1\u01d8\10\6\2\0\1\6\2\0\33\6\1\u01d9"+
    "\16\6\2\0\1\6\2\0\12\6\1\271\3\6\1\u01da"+
    "\1\273\32\6\2\0\1\6\2\0\35\6\1\u01db\14\6"+
    "\2\0\1\6\2\0\13\6\1\u017c\36\6\2\0\1\6"+
    "\2\0\13\6\1\u01dc\36\6\2\0\1\6\2\0\20\6"+
    "\1\u01dd\31\6\2\0\1\6\2\0\20\6\1\u01de\3\6"+
    "\1\u01df\1\6\1\237\1\6\1\362\2\6\1\u01e0\16\6"+
    "\2\0\1\6\2\0\12\6\1\u01e1\37\6\2\0\1\6"+
    "\2\0\11\6\1\u01e2\31\6\1\u01e2\6\6\2\0\1\6"+
    "\2\0\15\6\1\u01e3\26\6\1\u01e3\5\6\2\0\1\6"+
    "\2\0\20\6\1\u015b\31\6\2\0\1\6\2\0\20\6"+
    "\1\u01e4\31\6\2\0\1\6\2\0\40\6\1\313\11\6"+
    "\2\0\1\6\2\0\26\6\1\u01e5\23\6\2\0\1\6"+
    "\2\0\35\6\1\u01e6\14\6\2\0\1\6\2\0\24\6"+
    "\1\236\11\6\1\u01e7\13\6\2\0\1\6\2\0\33\6"+
    "\1\u01e8\16\6\2\0\1\6\2\0\33\6\1\u01e9\16\6"+
    "\2\0\1\6\2\0\31\6\1\u01ea\20\6\2\0\1\6"+
    "\2\0\15\6\1\u01eb\26\6\1\u01eb\5\6\2\0\1\6"+
    "\2\0\25\6\1\u01ec\24\6\2\0\1\6\2\0\32\6"+
    "\1\u01ed\17\6\2\0\1\6\2\0\12\6\1\u01ee\37\6"+
    "\2\0\1\6\2\0\20\6\1\u01ef\31\6\2\0\1\6"+
    "\2\0\25\6\1\u01f0\24\6\2\0\1\6\2\0\20\6"+
    "\1\u01f1\31\6\2\0\1\6\2\0\27\6\1\u01f2\22\6"+
    "\2\0\1\6\2\0\26\6\1\u011a\23\6\2\0\1\6"+
    "\2\0\20\6\1\u01f3\31\6\2\0\1\6\2\0\34\6"+
    "\1\u01f4\15\6\2\0\1\6\2\0\34\6\1\u01f5\15\6"+
    "\2\0\1\6\2\0\33\6\1\u013d\16\6\2\0\1\6"+
    "\2\0\13\6\1\u01f6\36\6\2\0\1\6\2\0\25\6"+
    "\1\u01f7\24\6\2\0\1\6\2\0\23\6\1\u01f8\26\6"+
    "\2\0\1\6\2\0\34\6\1\u01f9\15\6\2\0\1\6"+
    "\2\0\24\6\1\u01fa\25\6\2\0\1\6\2\0\31\6"+
    "\1\u01fb\20\6\2\0\1\6\2\0\12\6\1\u01fc\37\6"+
    "\2\0\1\6\2\0\14\6\1\u01fd\35\6\2\0\1\6"+
    "\2\0\23\6\1\u01fe\26\6\2\0\1\6\2\0\16\6"+
    "\1\u01ff\33\6\2\0\1\6\2\0\12\6\1\271\5\6"+
    "\1\274\31\6\2\0\1\6\2\0\20\6\1\u0200\31\6"+
    "\2\0\1\6\2\0\12\6\1\u0201\37\6\2\0\1\6"+
    "\2\0\16\6\1\u0202\33\6\2\0\1\6\2\0\17\6"+
    "\1\u0203\32\6\2\0\1\6\2\0\15\6\1\u0204\2\6"+
    "\1\u0205\2\6\1\u0106\1\u0206\2\6\1\u0207\1\u0208\1\6"+
    "\1\u0209\1\u020a\1\u020b\7\6\1\u0204\5\6\2\0\1\6"+
    "\2\0\26\6\1\u020c\23\6\2\0\1\6\2\0\14\6"+
    "\1\u020d\35\6\2\0\1\6\2\0\24\6\1\u020e\25\6"+
    "\2\0\1\6\2\0\13\6\1\u01d0\36\6\2\0\1\6"+
    "\2\0\15\6\1\u020f\26\6\1\u020f\5\6\2\0\1\6"+
    "\2\0\17\6\1\u0210\32\6\2\0\1\6\2\0\26\6"+
    "\1\u0211\23\6\2\0\1\6\2\0\16\6\1\u0212\33\6"+
    "\2\0\1\6\2\0\23\6\1\u0213\26\6\2\0\1\6"+
    "\2\0\31\6\1\371\20\6\2\0\1\6\2\0\13\6"+
    "\1\u0214\36\6\2\0\1\6\2\0\35\6\1\u0215\14\6"+
    "\2\0\1\6\2\0\12\6\1\u0216\37\6\2\0\1\6"+
    "\2\0\31\6\1\u0217\20\6\2\0\1\6\2\0\24\6"+
    "\1\266\25\6\2\0\1\6\2\0\23\6\1\u0218\26\6"+
    "\2\0\1\6\2\0\33\6\1\u0219\16\6\2\0\1\6"+
    "\2\0\35\6\1\313\14\6\2\0\1\6\2\0\25\6"+
    "\1\u021a\24\6\2\0\1\6\2\0\26\6\1\u021b\23\6"+
    "\2\0\1\6\2\0\34\6\1\371\15\6\2\0\1\6"+
    "\2\0\12\6\1\u021c\1\u021d\21\6\1\u021e\14\6\2\0"+
    "\1\6\2\0\20\6\1\u021f\31\6\2\0\1\6\2\0"+
    "\16\6\1\u0220\33\6\2\0\1\6\2\0\21\6\1\u0221"+
    "\23\6\1\u0221\4\6\2\0\1\6\2\0\33\6\1\u0222"+
    "\16\6\2\0\1\6\2\0\14\6\1\u0174\35\6\2\0"+
    "\1\6\2\0\20\6\1\u0223\31\6\2\0\1\6\2\0"+
    "\14\6\1\u0224\35\6\2\0\1\6\2\0\20\6\1\u0225"+
    "\31\6\2\0\1\6\2\0\24\6\1\u0226\2\6\1\u0227"+
    "\22\6\2\0\1\6\2\0\16\6\1\u0228\33\6\2\0"+
    "\1\6\2\0\26\6\1\u0229\23\6\2\0\1\6\2\0"+
    "\25\6\1\u022a\24\6\2\0\1\6\2\0\20\6\1\u022b"+
    "\31\6\2\0\1\6\2\0\23\6\1\u022c\26\6\2\0"+
    "\1\6\2\0\26\6\1\u022d\23\6\2\0\1\6\2\0"+
    "\25\6\1\u022e\24\6\2\0\1\6\2\0\23\6\1\u022f"+
    "\26\6\2\0\1\6\2\0\33\6\1\u0230\16\6\2\0"+
    "\1\6\2\0\17\6\1\u0200\32\6\2\0\1\6\2\0"+
    "\20\6\1\u0231\31\6\2\0\1\6\2\0\33\6\1\u0232"+
    "\16\6\2\0\1\6\2\0\27\6\1\u01d0\22\6\2\0"+
    "\1\6\2\0\13\6\1\313\36\6\2\0\1\6\2\0"+
    "\35\6\1\u0233\14\6\2\0\1\6\2\0\12\6\1\u0234"+
    "\37\6\2\0\1\6\2\0\12\6\1\271\37\6\2\0"+
    "\1\6\2\0\11\6\1\u0235\31\6\1\u0235\3\6\1\u0236"+
    "\2\6\2\0\1\6\2\0\52\6\2\0\1\6\2\0"+
    "\32\6\1\u0143\17\6\2\0\1\6\2\0\25\6\1\u0174"+
    "\24\6\2\0\1\6\2\0\12\6\1\313\37\6\2\0"+
    "\1\6\2\0\15\6\1\u0237\26\6\1\u0237\5\6\2\0"+
    "\1\6\2\0\13\6\1\u0238\36\6\2\0\1\6\2\0"+
    "\12\6\1\u0239\37\6\2\0\1\6\2\0\33\6\1\u023a"+
    "\16\6\2\0\1\6\2\0\25\6\1\u023b\24\6\2\0"+
    "\1\6\2\0\26\6\1\u023c\23\6\2\0\1\6\2\0"+
    "\20\6\1\u023d\31\6\2\0\1\6\2\0\16\6\1\u023e"+
    "\33\6\2\0\1\6\2\0\33\6\1\u023f\16\6\2\0"+
    "\1\6\2\0\20\6\1\u0240\31\6\2\0\1\6\2\0"+
    "\33\6\1\u0241\16\6\2\0\1\6\2\0\33\6\1\u0242"+
    "\16\6\2\0\1\6\2\0\12\6\1\u0243\37\6\2\0"+
    "\1\6\2\0\13\6\1\u0244\7\6\1\u0106\26\6\2\0"+
    "\1\6\2\0\16\6\1\371\33\6\2\0\1\6\2\0"+
    "\17\6\1\u01c5\32\6\2\0\1\6\2\0\34\6\1\u0245"+
    "\15\6\2\0\1\6\2\0\32\6\1\u0246\17\6\2\0"+
    "\1\6\2\0\24\6\1\u0247\25\6\2\0\1\6\2\0"+
    "\16\6\1\u0248\33\6\2\0\1\6\2\0\23\6\1\u0249"+
    "\26\6\2\0\1\6\2\0\20\6\1\u024a\31\6\2\0"+
    "\1\6\2\0\14\6\1\u024b\1\6\1\u024c\33\6\2\0"+
    "\1\6\2\0\12\6\1\u024d\37\6\2\0\1\6\2\0"+
    "\26\6\1\u024e\23\6\2\0\1\6\2\0\32\6\1\u024f"+
    "\17\6\2\0\1\6\2\0\25\6\1\u0250\24\6\2\0"+
    "\1\6\2\0\20\6\1\u0251\31\6\2\0\1\6\2\0"+
    "\20\6\1\u0252\31\6\2\0\1\6\2\0\23\6\1\u0253"+
    "\26\6\2\0\1\6\2\0\23\6\1\114\26\6\2\0"+
    "\1\6\2\0\41\6\1\313\10\6\2\0\1\6\2\0"+
    "\14\6\1\u0254\35\6\2\0\1\6\2\0\35\6\1\u0255"+
    "\14\6\2\0\1\6\2\0\33\6\1\u0256\16\6\2\0"+
    "\1\6\2\0\34\6\1\u0257\15\6\2\0\1\6\2\0"+
    "\14\6\1\u0258\35\6\2\0\1\6\2\0\17\6\1\u0259"+
    "\32\6\2\0\1\6\2\0\20\6\1\u025a\31\6\2\0"+
    "\1\6\2\0\17\6\1\u025b\32\6\2\0\1\6\2\0"+
    "\24\6\1\362\25\6\2\0\1\6\2\0\23\6\1\u025c"+
    "\26\6\2\0\1\6\2\0\33\6\1\u025d\16\6\2\0"+
    "\1\6\2\0\14\6\1\u025e\35\6\2\0\1\6\2\0"+
    "\12\6\1\u025f\37\6\2\0\1\6\2\0\27\6\1\u0260"+
    "\22\6\2\0\1\6\2\0\11\6\1\u0261\31\6\1\u0261"+
    "\6\6\2\0\1\6\2\0\27\6\1\361\22\6\2\0"+
    "\1\6\2\0\14\6\1\u0262\35\6\2\0\1\6\2\0"+
    "\16\6\1\u0263\33\6\2\0\1\6\2\0\20\6\1\u0264"+
    "\31\6\2\0\1\6\2\0\16\6\1\u0265\33\6\2\0"+
    "\1\6\2\0\16\6\1\u0266\33\6\2\0\1\6\2\0"+
    "\17\6\1\u0267\3\6\1\u0106\1\6\1\u0268\7\6\1\u0269"+
    "\1\u026a\13\6\2\0\1\6\2\0\16\6\1\u026b\33\6"+
    "\2\0\1\6\2\0\12\6\1\167\37\6\2\0\1\6"+
    "\2\0\24\6\1\276\25\6\2\0\1\6\2\0\26\6"+
    "\1\u026c\23\6\2\0\1\6\2\0\23\6\1\u026d\26\6"+
    "\2\0\1\6\2\0\35\6\1\u026e\14\6\2\0\1\6"+
    "\2\0\33\6\1\u026f\16\6\2\0\1\6\2\0\25\6"+
    "\1\u0270\24\6\2\0\1\6\2\0\26\6\1\u0271\23\6"+
    "\2\0\1\6\2\0\35\6\1\u0272\14\6\2\0\1\6"+
    "\2\0\17\6\1\313\32\6\2\0\1\6\2\0\16\6"+
    "\1\u0273\33\6\2\0\1\6\2\0\15\6\1\u020f\5\6"+
    "\1\u0274\1\6\1\u0275\1\6\1\u019a\2\6\1\u010a\4\6"+
    "\1\u0276\4\6\1\u020f\5\6\2\0\1\6\2\0\33\6"+
    "\1\u0277\16\6\2\0\1\6\2\0\33\6\1\u0278\16\6"+
    "\2\0\1\6\2\0\20\6\1\u0279\31\6\2\0\1\6"+
    "\2\0\40\6\1\u01c5\11\6\2\0\1\6\2\0\33\6"+
    "\1\u01a6\16\6\2\0\1\6\2\0\16\6\1\372\33\6"+
    "\2\0\1\6\2\0\25\6\1\u027a\24\6\2\0\1\6"+
    "\2\0\17\6\1\u027b\32\6\2\0\1\6\2\0\25\6"+
    "\1\u027c\24\6\2\0\1\6\2\0\24\6\1\u027d\25\6"+
    "\2\0\1\6\2\0\24\6\1\313\25\6\2\0\1\6"+
    "\2\0\16\6\1\u027e\33\6\2\0\1\6\2\0\27\6"+
    "\1\313\22\6\2\0\1\6\2\0\35\6\1\u01f8\14\6"+
    "\2\0\1\6\2\0\33\6\1\u027f\16\6\2\0\1\6"+
    "\2\0\12\6\1\u0280\37\6\2\0\1\6\2\0\35\6"+
    "\1\u021e\14\6\2\0\1\6\2\0\23\6\1\u0200\26\6"+
    "\2\0\1\6\2\0\16\6\1\u0281\33\6\2\0\1\6"+
    "\2\0\16\6\1\u0282\33\6\2\0\1\6\2\0\14\6"+
    "\1\u0241\35\6\2\0\1\6\2\0\16\6\1\u0233\33\6"+
    "\2\0\1\6\2\0\13\6\1\u0283\36\6\2\0\1\6"+
    "\2\0\12\6\1\202\37\6\2\0\1\6\2\0\12\6"+
    "\1\u0284\37\6\2\0\1\6\2\0\13\6\1\u0285\36\6"+
    "\2\0\1\6\2\0\31\6\1\u0286\20\6\2\0\1\6"+
    "\2\0\14\6\1\u0287\35\6\2\0\1\6\2\0\17\6"+
    "\1\u0288\32\6\2\0\1\6\2\0\20\6\1\u0289\31\6"+
    "\2\0\1\6\2\0\12\6\1\u028a\37\6\2\0\1\6"+
    "\2\0\26\6\1\u028b\23\6\2\0\1\6\2\0\25\6"+
    "\1\u0200\24\6\2\0\1\6\2\0\36\6\1\u0143\13\6"+
    "\2\0\1\6\2\0\25\6\1\u028c\24\6\2\0\1\6"+
    "\2\0\26\6\1\u028d\23\6\2\0\1\6\2\0\26\6"+
    "\1\u028e\23\6\2\0\1\6\2\0\34\6\1\u028f\15\6"+
    "\2\0\1\6\2\0\20\6\1\u0290\31\6\2\0\1\6"+
    "\2\0\17\6\1\u0291\32\6\2\0\1\6\2\0\25\6"+
    "\1\u0292\24\6\2\0\1\6\2\0\30\6\1\u0293\21\6"+
    "\2\0\1\6\2\0\13\6\1\u0294\36\6\2\0\1\6"+
    "\2\0\20\6\1\u0295\31\6\2\0\1\6\2\0\27\6"+
    "\1\u0296\22\6\2\0\1\6\2\0\34\6\1\u0297\15\6"+
    "\2\0\1\6\2\0\26\6\1\u0298\23\6\2\0\1\6"+
    "\2\0\12\6\1\u0299\37\6\2\0\1\6\2\0\17\6"+
    "\1\u029a\32\6\2\0\1\6\2\0\26\6\1\u029b\23\6"+
    "\2\0\1\6\2\0\26\6\1\u01f8\23\6\2\0\1\6"+
    "\2\0\26\6\1\u029c\23\6\2\0\1\6\2\0\24\6"+
    "\1\u029d\25\6\2\0\1\6\2\0\14\6\1\u0200\35\6"+
    "\2\0\1\6\2\0\14\6\1\167\35\6\2\0\1\6"+
    "\2\0\23\6\1\u029e\26\6\2\0\1\6\2\0\27\6"+
    "\1\u029f\22\6\2\0\1\6\2\0\11\6\1\u01b0\31\6"+
    "\1\u01b0\6\6\2\0\1\6\2\0\25\6\1\u0143\24\6"+
    "\2\0\1\6\2\0\35\6\1\u02a0\14\6\2\0\1\6"+
    "\2\0\24\6\1\u02a1\25\6\2\0\1\6\2\0\15\6"+
    "\1\u02a2\26\6\1\u02a2\5\6\2\0\1\6\2\0\12\6"+
    "\1\u0143\37\6\2\0\1\6\2\0\12\6\1\u02a1\37\6"+
    "\2\0\1\6\2\0\34\6\1\u011a\15\6\2\0\1\6"+
    "\2\0\33\6\1\u02a3\16\6\2\0\1\6\2\0\25\6"+
    "\1\u024e\24\6\2\0\1\6\2\0\34\6\1\u02a4\15\6"+
    "\2\0\1\6\2\0\26\6\1\u02a5\23\6\2\0\1\6"+
    "\2\0\23\6\1\u02a6\26\6\2\0\1\6\2\0\30\6"+
    "\1\u02a7\21\6\2\0\1\6\2\0\33\6\1\u02a8\16\6"+
    "\2\0\1\6\2\0\15\6\1\u02a9\26\6\1\u02a9\5\6"+
    "\2\0\1\6\2\0\32\6\1\u02aa\17\6\2\0\1\6"+
    "\2\0\34\6\1\u02ab\15\6\2\0\1\6\2\0\14\6"+
    "\1\u02ac\35\6\2\0\1\6\2\0\33\6\1\u02ad\16\6"+
    "\2\0\1\6\2\0\12\6\1\u02ae\37\6\2\0\1\6"+
    "\2\0\12\6\1\u02af\37\6\2\0\1\6\2\0\17\6"+
    "\1\u02b0\32\6\2\0\1\6\2\0\23\6\1\u02b1\26\6"+
    "\2\0\1\6\2\0\15\6\1\u02b2\26\6\1\u02b2\5\6"+
    "\2\0\1\6\2\0\13\6\1\u02b3\13\6\1\372\22\6"+
    "\2\0\1\6\2\0\13\6\1\u02b4\36\6\2\0\1\6"+
    "\2\0\12\6\1\u02b5\37\6\2\0\1\6\2\0\23\6"+
    "\1\u01fa\26\6\2\0\1\6\2\0\32\6\1\u02b6\17\6"+
    "\2\0\1\6\2\0\25\6\1\u02b7\24\6\2\0\1\6"+
    "\2\0\36\6\1\u02b8\13\6\2\0\1\6\2\0\20\6"+
    "\1\u02b9\31\6\2\0\1\6\2\0\14\6\1\u02a1\35\6"+
    "\2\0\1\6\2\0\20\6\1\u0220\31\6\2\0\1\6"+
    "\2\0\23\6\1\u02ba\26\6\2\0\1\6\2\0\11\6"+
    "\1\313\31\6\1\313\6\6\2\0\1\6\2\0\31\6"+
    "\1\u02bb\20\6\2\0\1\6\2\0\20\6\1\u02bc\31\6"+
    "\2\0\1\6\2\0\13\6\1\u02bd\36\6\2\0\1\6"+
    "\2\0\32\6\1\u02be\17\6\2\0\1\6\2\0\27\6"+
    "\1\u02bf\22\6\2\0\1\6\2\0\26\6\1\u02c0\23\6"+
    "\2\0\1\6\2\0\16\6\1\u02c1\33\6\2\0\1\6"+
    "\2\0\26\6\1\313\23\6\2\0\1\6\2\0\20\6"+
    "\1\u02c2\31\6\2\0\1\6\2\0\14\6\1\u02c3\35\6"+
    "\2\0\1\6\2\0\12\6\1\u02c4\37\6\2\0\1\6"+
    "\2\0\16\6\1\u02c5\33\6\2\0\1\6\2\0\20\6"+
    "\1\u02c6\31\6\2\0\1\6\2\0\13\6\1\u02c7\36\6"+
    "\2\0\1\6\2\0\20\6\1\u0250\31\6\2\0\1\6"+
    "\2\0\33\6\1\u02c8\16\6\2\0\1\6\2\0\20\6"+
    "\1\u02c9\31\6\2\0\1\6\2\0\23\6\1\u02ca\26\6"+
    "\2\0\1\6\2\0\23\6\1\u02cb\26\6\2\0\1\6"+
    "\2\0\20\6\1\u02cc\31\6\2\0\1\6\2\0\26\6"+
    "\1\u02cd\23\6\2\0\1\6\2\0\24\6\1\u02ce\25\6"+
    "\2\0\1\6\2\0\16\6\1\114\33\6\2\0\1\6"+
    "\2\0\20\6\1\u0286\31\6\2\0\1\6\2\0\25\6"+
    "\1\u0233\24\6\2\0\1\6\2\0\27\6\1\u0227\22\6"+
    "\2\0\1\6\2\0\12\6\1\u02cf\37\6\2\0\1\6"+
    "\2\0\13\6\1\u02d0\36\6\2\0\1\6\2\0\12\6"+
    "\1\u02d1\37\6\2\0\1\6\2\0\30\6\1\u02d2\21\6"+
    "\2\0\1\6\2\0\27\6\1\205\22\6\2\0\1\6"+
    "\2\0\12\6\1\205\37\6\2\0\1\6\2\0\35\6"+
    "\1\u02d3\14\6\2\0\1\6\2\0\20\6\1\u02d4\31\6"+
    "\2\0\1\6\2\0\32\6\1\u02d5\17\6\2\0\1\6"+
    "\2\0\15\6\1\u02d6\26\6\1\u02d6\5\6\2\0\1\6"+
    "\2\0\33\6\1\u02d7\16\6\2\0\1\6\2\0\23\6"+
    "\1\u02d8\26\6\2\0\1\6\2\0\20\6\1\u02d9\31\6"+
    "\2\0\1\6\2\0\33\6\1\u02da\16\6\2\0\1\6"+
    "\2\0\14\6\1\u02db\35\6\2\0\1\6\2\0\12\6"+
    "\1\u02dc\37\6\2\0\1\6\2\0\34\6\1\u02dd\15\6"+
    "\2\0\1\6\2\0\33\6\1\u02de\16\6\2\0\1\6"+
    "\2\0\20\6\1\u02df\31\6\2\0\1\6\2\0\20\6"+
    "\1\u02e0\31\6\2\0\1\6\2\0\26\6\1\u02e1\23\6"+
    "\2\0\1\6\2\0\26\6\1\u02e2\23\6\2\0\1\6"+
    "\2\0\34\6\1\u02e3\15\6\2\0\1\6\2\0\23\6"+
    "\1\u02e4\26\6\2\0\1\6\2\0\33\6\1\u02e5\16\6"+
    "\2\0\1\6\2\0\16\6\1\u02e6\33\6\2\0\1\6"+
    "\2\0\31\6\1\u02aa\20\6\2\0\1\6\2\0\30\6"+
    "\1\u01c1\21\6\2\0\1\6\2\0\32\6\1\u02e7\17\6"+
    "\2\0\1\6\2\0\27\6\1\u02e8\22\6\2\0\1\6"+
    "\2\0\20\6\1\u02e9\31\6\2\0\1\6\2\0\14\6"+
    "\1\u02ea\35\6\2\0\1\6\2\0\12\6\1\u02eb\37\6"+
    "\2\0\1\6\2\0\14\6\1\u02ec\35\6\2\0\1\6"+
    "\2\0\16\6\1\u02ed\33\6\2\0\1\6\2\0\15\6"+
    "\1\u01a9\1\6\1\u02ee\24\6\1\u01a9\5\6\2\0\1\6"+
    "\2\0\33\6\1\u02ef\16\6\2\0\1\6\2\0\33\6"+
    "\1\u02f0\16\6\2\0\1\6\2\0\20\6\1\u02f1\16\6"+
    "\1\u02f2\12\6\2\0\1\6\2\0\15\6\1\u02f3\26\6"+
    "\1\u02f3\5\6\2\0\1\6\2\0\16\6\1\u0241\33\6"+
    "\2\0\1\6\2\0\16\6\1\u0250\33\6\2\0\1\6"+
    "\2\0\36\6\1\u02f4\13\6\2\0\1\6\2\0\20\6"+
    "\1\326\31\6\2\0\1\6\2\0\25\6\1\u02f5\24\6"+
    "\2\0\1\6\2\0\25\6\1\u02f6\24\6\2\0\1\6"+
    "\2\0\21\6\1\u02f7\23\6\1\u02f7\4\6\2\0\1\6"+
    "\2\0\33\6\1\u02f8\16\6\2\0\1\6\2\0\20\6"+
    "\1\u02f9\31\6\2\0\1\6\2\0\12\6\1\u02fa\37\6"+
    "\2\0\1\6\2\0\16\6\1\u02fb\33\6\2\0\1\6"+
    "\2\0\14\6\1\u02fc\35\6\2\0\1\6\2\0\12\6"+
    "\1\u02b0\37\6\2\0\1\6\2\0\33\6\1\u02fd\16\6"+
    "\2\0\1\6\2\0\34\6\1\u02fe\15\6\2\0\1\6"+
    "\2\0\15\6\1\202\26\6\1\202\5\6\2\0\1\6"+
    "\2\0\20\6\1\u02aa\31\6\2\0\1\6\2\0\26\6"+
    "\1\u02ff\23\6\2\0\1\6\2\0\24\6\1\u0300\25\6"+
    "\2\0\1\6\2\0\26\6\1\u0301\23\6\2\0\1\6"+
    "\2\0\16\6\1\u0302\33\6\2\0\1\6\2\0\33\6"+
    "\1\u0303\16\6\2\0\1\6\2\0\11\6\1\u01dd\31\6"+
    "\1\u01dd\6\6\2\0\1\6\2\0\15\6\1\u0304\26\6"+
    "\1\u0304\5\6\2\0\1\6\2\0\26\6\1\u0305\23\6"+
    "\2\0\1\6\2\0\33\6\1\u0306\16\6\2\0\1\6"+
    "\2\0\20\6\1\u0307\31\6\2\0\1\6\2\0\25\6"+
    "\1\u0308\24\6\2\0\1\6\2\0\20\6\1\u0309\31\6"+
    "\2\0\1\6\2\0\33\6\1\u0250\16\6\2\0\1\6"+
    "\2\0\30\6\1\u030a\21\6\2\0\1\6\2\0\16\6"+
    "\1\u030b\33\6\2\0\1\6\2\0\20\6\1\u030c\31\6"+
    "\2\0\1\6\2\0\34\6\1\u030d\15\6\2\0\1\6"+
    "\2\0\26\6\1\u030e\23\6\2\0\1\6\2\0\33\6"+
    "\1\205\16\6\2\0\1\6\2\0\14\6\1\u030f\35\6"+
    "\2\0\1\6\2\0\23\6\1\u0310\26\6\2\0\1\6"+
    "\2\0\34\6\1\u0311\15\6\2\0\1\6\2\0\14\6"+
    "\1\u0312\35\6\2\0\1\6\2\0\12\6\1\u0313\37\6"+
    "\2\0\1\6\2\0\33\6\1\u0314\16\6\2\0\1\6"+
    "\2\0\33\6\1\u015b\16\6\2\0\1\6\2\0\20\6"+
    "\1\u0315\31\6\2\0\1\6\2\0\17\6\1\u0316\32\6"+
    "\2\0\1\6\2\0\12\6\1\u0317\37\6\2\0\1\6"+
    "\2\0\27\6\1\372\22\6\2\0\1\6\2\0\16\6"+
    "\1\u0150\33\6\2\0\1\6\2\0\24\6\1\u0143\25\6"+
    "\2\0\1\6\2\0\33\6\1\u0318\16\6\2\0\1\6"+
    "\2\0\16\6\1\u0319\33\6\2\0\1\6\2\0\20\6"+
    "\1\u031a\31\6\2\0\1\6\2\0\36\6\1\202\13\6"+
    "\2\0\1\6\2\0\23\6\1\u031b\26\6\2\0\1\6"+
    "\2\0\14\6\1\u01a6\31\6";

  private static int [] zzUnpackTrans() {
    int [] result = new int[36754];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\6\1\2\11\22\1\1\11\10\1\4\11\1\1"+
    "\1\11\2\1\1\0\52\1\4\0\2\1\1\11\1\1"+
    "\1\11\62\1\4\0\102\1\2\0\105\1\2\0\u01f8\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[795];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Type specific to HtaccessTokenMaker denoting a line ending with an
	 * unclosed double-quote attribute.
	 */
	public static final int INTERNAL_ATTR_DOUBLE			= -1;


	/**
	 * Type specific to HtaccessTokenMaker denoting a line ending with an
	 * unclosed single-quote attribute.
	 */
	public static final int INTERNAL_ATTR_SINGLE			= -2;


	/**
	 * Token type specific to HtaccessTokenMaker denoting a line ending with an
	 * unclosed XML tag; thus a new line is beginning still inside the tag.
	 */
	public static final int INTERNAL_INTAG					= -3;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public HtaccessTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *        occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns how to transform a line into a line comment.
	 *
	 * @return The line comment start and end text for .htaccess files.
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "#", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state;
		switch (initialTokenType) {
			case INTERNAL_ATTR_DOUBLE:
				state = INATTR_DOUBLE;
				break;
			case INTERNAL_ATTR_SINGLE:
				state = INATTR_SINGLE;
				break;
			case INTERNAL_INTAG:
				state = INTAG;
				break;
			default:
				state = YYINITIAL;
		}

		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HtaccessTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HtaccessTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 12:
          { yybegin(INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 20: break;
        case 4:
          { addNullToken(); return firstToken;
          }
        case 21: break;
        case 15:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(INTAG);
          }
        case 22: break;
        case 3:
          { addToken(Token.WHITESPACE);
          }
        case 23: break;
        case 17:
          { addToken(Token.ERROR_STRING_DOUBLE);
          }
        case 24: break;
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 25: break;
        case 6:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 26: break;
        case 18:
          { addToken(Token.FUNCTION);
          }
        case 27: break;
        case 14:
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 28: break;
        case 13:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(INTAG);
          }
        case 29: break;
        case 9:
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE);
          }
        case 30: break;
        case 8:
          { yybegin(YYINITIAL); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 31: break;
        case 16:
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 32: break;
        case 10:
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE);
          }
        case 33: break;
        case 19:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 34: break;
        case 5:
          { start = zzMarkedPos-1; yybegin(EOL_COMMENT);
          }
        case 35: break;
        case 11:
          { addToken(Token.OPERATOR);
          }
        case 36: break;
        case 7:
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 37: break;
        case 1:
          {
          }
        case 38: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 796: break;
            case INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_INTAG); return firstToken;
            }
            case 797: break;
            case INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_DOUBLE); return firstToken;
            }
            case 798: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 799: break;
            case INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_SINGLE); return firstToken;
            }
            case 800: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
