/* The following code was generated by JFlex 1.4.1 on 10/17/23, 10:39 PM */

/*
 * RustTokenMaker.rust - Scanner for the Rust programming language.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for the Rust programming language.<p>
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>RustTokenMaker.rust</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 1.0
 *
 */

public class RustTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int DOCCOMMENT = 5;
  public static final int EOL_COMMENT = 6;
  public static final int BYTE_STRING_LITERAL = 2;
  public static final int MLC = 4;
  public static final int STRING = 1;
  public static final int LINE_DOCCOMMENT = 7;
  public static final int RAW_STRING_LITERAL = 3;
  public static final int YYINITIAL = 0;
  public static final int RAW_BYTE_STRING_LITERAL = 3;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\22\1\24\1\23\1\0\1\24\1\17\16\22\4\0\1\24\1\54"+
    "\1\13\1\20\1\1\1\54\1\56\1\10\2\61\1\26\1\47\1\46"+
    "\1\35\1\36\1\25\1\4\1\5\1\16\1\102\1\103\1\7\1\101"+
    "\1\7\1\100\1\3\1\57\1\46\1\50\1\51\1\53\1\55\1\60"+
    "\1\6\1\30\1\6\1\33\1\34\1\33\5\1\1\27\13\1\1\32"+
    "\2\1\1\61\1\12\1\61\1\52\1\2\1\0\1\42\1\31\1\66"+
    "\1\74\1\41\1\15\1\67\1\62\1\64\1\1\1\73\1\43\1\71"+
    "\1\14\1\70\1\63\1\1\1\40\1\44\1\37\1\11\1\76\1\65"+
    "\1\72\1\75\1\77\1\45\1\52\1\45\1\55\41\22\2\0\4\21"+
    "\4\0\1\21\2\0\1\22\7\0\1\21\4\0\1\21\5\0\27\21"+
    "\1\0\37\21\1\0\u01ca\21\4\0\14\21\16\0\5\21\7\0\1\21"+
    "\1\0\1\21\21\0\160\22\5\21\1\0\2\21\2\0\4\21\1\0"+
    "\1\21\6\0\1\21\1\0\3\21\1\0\1\21\1\0\24\21\1\0"+
    "\123\21\1\0\213\21\1\0\5\22\2\0\246\21\1\0\46\21\2\0"+
    "\1\21\6\0\51\21\6\0\1\21\1\0\55\22\1\0\1\22\1\0"+
    "\2\22\1\0\2\22\1\0\1\22\10\0\33\21\4\0\4\21\15\0"+
    "\6\22\5\0\1\21\4\0\13\22\1\0\1\22\3\0\53\21\37\22"+
    "\4\0\2\21\1\22\143\21\1\0\1\21\10\22\1\0\6\22\2\21"+
    "\2\22\1\0\4\22\2\21\12\22\3\21\2\0\1\21\17\0\1\22"+
    "\1\21\1\22\36\21\33\22\2\0\131\21\13\22\1\21\16\0\12\22"+
    "\41\21\11\22\2\21\4\0\1\21\2\0\1\22\30\21\4\22\1\21"+
    "\11\22\1\21\3\22\1\21\5\22\22\0\31\21\3\22\4\0\13\21"+
    "\65\0\25\21\1\0\22\21\13\0\61\22\66\21\3\22\1\21\22\22"+
    "\1\21\7\22\12\21\2\22\2\0\12\22\1\0\20\21\3\22\1\0"+
    "\10\21\2\0\2\21\2\0\26\21\1\0\7\21\1\0\1\21\3\0"+
    "\4\21\2\0\1\22\1\21\7\22\2\0\2\22\2\0\3\22\1\21"+
    "\10\0\1\22\4\0\2\21\1\0\3\21\2\22\2\0\12\22\4\21"+
    "\7\0\2\21\1\0\1\22\2\0\3\22\1\0\6\21\4\0\2\21"+
    "\2\0\26\21\1\0\7\21\1\0\2\21\1\0\2\21\1\0\2\21"+
    "\2\0\1\22\1\0\5\22\4\0\2\22\2\0\3\22\3\0\1\22"+
    "\7\0\4\21\1\0\1\21\7\0\14\22\3\21\1\22\13\0\3\22"+
    "\1\0\11\21\1\0\3\21\1\0\26\21\1\0\7\21\1\0\2\21"+
    "\1\0\5\21\2\0\1\22\1\21\10\22\1\0\3\22\1\0\3\22"+
    "\2\0\1\21\17\0\2\21\2\22\2\0\12\22\1\0\1\21\7\0"+
    "\1\21\6\22\1\0\3\22\1\0\10\21\2\0\2\21\2\0\26\21"+
    "\1\0\7\21\1\0\2\21\1\0\5\21\2\0\1\22\1\21\7\22"+
    "\2\0\2\22\2\0\3\22\7\0\3\22\4\0\2\21\1\0\3\21"+
    "\2\22\2\0\12\22\1\0\1\21\20\0\1\22\1\21\1\0\6\21"+
    "\3\0\3\21\1\0\4\21\3\0\2\21\1\0\1\21\1\0\2\21"+
    "\3\0\2\21\3\0\3\21\3\0\14\21\4\0\5\22\3\0\3\22"+
    "\1\0\4\22\2\0\1\21\6\0\1\22\16\0\12\22\11\0\1\21"+
    "\6\0\5\22\10\21\1\0\3\21\1\0\27\21\1\0\20\21\3\0"+
    "\1\21\7\22\1\0\3\22\1\0\4\22\7\0\2\22\1\0\3\21"+
    "\5\0\2\21\2\22\2\0\12\22\20\0\1\21\3\22\1\0\10\21"+
    "\1\0\3\21\1\0\27\21\1\0\12\21\1\0\5\21\2\0\1\22"+
    "\1\21\7\22\1\0\3\22\1\0\4\22\7\0\2\22\7\0\1\21"+
    "\1\0\2\21\2\22\2\0\12\22\1\0\2\21\15\0\4\22\11\21"+
    "\1\0\3\21\1\0\51\21\2\22\1\21\7\22\1\0\3\22\1\0"+
    "\4\22\1\21\5\0\3\21\1\22\7\0\3\21\2\22\2\0\12\22"+
    "\12\0\6\21\1\0\3\22\1\0\22\21\3\0\30\21\1\0\11\21"+
    "\1\0\1\21\2\0\7\21\3\0\1\22\4\0\6\22\1\0\1\22"+
    "\1\0\10\22\6\0\12\22\2\0\2\22\15\0\60\21\1\22\2\21"+
    "\7\22\4\0\10\21\10\22\1\0\12\22\47\0\2\21\1\0\1\21"+
    "\1\0\5\21\1\0\30\21\1\0\1\21\1\0\12\21\1\22\2\21"+
    "\11\22\1\21\2\0\5\21\1\0\1\21\1\0\6\22\2\0\12\22"+
    "\2\0\4\21\40\0\1\21\27\0\2\22\6\0\12\22\13\0\1\22"+
    "\1\0\1\22\1\0\1\22\4\0\2\22\10\21\1\0\44\21\4\0"+
    "\24\22\1\0\2\22\5\21\13\22\1\0\44\22\11\0\1\22\71\0"+
    "\53\21\24\22\1\21\12\22\6\0\6\21\4\22\4\21\3\22\1\21"+
    "\3\22\2\21\7\22\3\21\4\22\15\21\14\22\1\21\17\22\2\0"+
    "\46\21\1\0\1\21\5\0\1\21\2\0\53\21\1\0\u014d\21\1\0"+
    "\4\21\2\0\7\21\1\0\1\21\1\0\4\21\2\0\51\21\1\0"+
    "\4\21\2\0\41\21\1\0\4\21\2\0\7\21\1\0\1\21\1\0"+
    "\4\21\2\0\17\21\1\0\71\21\1\0\4\21\2\0\103\21\2\0"+
    "\3\22\40\0\20\21\20\0\126\21\2\0\6\21\3\0\u026c\21\2\0"+
    "\21\21\1\0\32\21\5\0\113\21\3\0\13\21\7\0\15\21\1\0"+
    "\4\21\3\22\13\0\22\21\3\22\13\0\22\21\2\22\14\0\15\21"+
    "\1\0\3\21\1\0\2\22\14\0\64\21\40\22\3\0\1\21\3\0"+
    "\2\21\1\22\2\0\12\22\41\0\4\22\1\0\12\22\6\0\131\21"+
    "\7\0\5\21\2\22\42\21\1\22\1\21\5\0\106\21\12\0\37\21"+
    "\1\0\14\22\4\0\14\22\12\0\12\22\36\21\2\0\5\21\13\0"+
    "\54\21\4\0\32\21\6\0\12\22\46\0\27\21\5\22\4\0\65\21"+
    "\12\22\1\0\35\22\2\0\13\22\6\0\12\22\15\0\1\21\10\0"+
    "\16\22\1\0\2\22\77\0\5\22\57\21\21\22\7\21\4\0\12\22"+
    "\21\0\11\22\14\0\3\22\36\21\15\22\2\21\12\22\54\21\16\22"+
    "\14\0\44\21\24\22\10\0\12\22\3\0\3\21\12\22\44\21\2\0"+
    "\11\21\7\0\53\21\2\0\3\21\20\0\3\22\1\0\25\22\4\21"+
    "\1\22\6\21\1\22\2\21\3\22\1\21\5\0\300\21\72\22\1\0"+
    "\5\22\u0116\21\2\0\6\21\2\0\46\21\2\0\6\21\2\0\10\21"+
    "\1\0\1\21\1\0\1\21\1\0\1\21\1\0\37\21\2\0\65\21"+
    "\1\0\7\21\1\0\1\21\3\0\3\21\1\0\7\21\3\0\4\21"+
    "\2\0\6\21\4\0\15\21\5\0\3\21\1\0\7\21\16\0\5\22"+
    "\32\0\5\22\20\0\2\21\23\0\1\21\13\0\5\22\1\0\12\22"+
    "\1\0\1\21\15\0\1\21\20\0\15\21\3\0\40\21\20\0\15\22"+
    "\4\0\1\22\3\0\14\22\21\0\1\21\4\0\1\21\2\0\12\21"+
    "\1\0\1\21\3\0\5\21\6\0\1\21\1\0\1\21\1\0\1\21"+
    "\1\0\4\21\1\0\13\21\2\0\4\21\5\0\5\21\4\0\1\21"+
    "\21\0\51\21\u0a77\0\57\21\1\0\57\21\1\0\205\21\6\0\4\21"+
    "\3\22\2\21\14\0\46\21\1\0\1\21\5\0\1\21\2\0\70\21"+
    "\7\0\1\21\17\0\1\22\27\21\11\0\7\21\1\0\7\21\1\0"+
    "\7\21\1\0\7\21\1\0\7\21\1\0\7\21\1\0\7\21\1\0"+
    "\7\21\1\0\40\22\57\0\1\21\u01d5\0\3\21\31\0\11\21\6\22"+
    "\1\0\5\21\2\0\5\21\4\0\126\21\2\0\2\22\2\0\3\21"+
    "\1\0\132\21\1\0\4\21\5\0\53\21\1\0\136\21\21\0\40\21"+
    "\60\0\20\21\u0200\0\u19c0\21\100\0\u51fd\21\3\0\u048d\21\103\0\56\21"+
    "\2\0\u010d\21\3\0\20\21\12\22\2\21\24\0\57\21\1\22\4\0"+
    "\12\22\1\0\37\21\2\22\120\21\2\22\45\0\11\21\2\0\147\21"+
    "\2\0\65\21\2\0\11\21\52\0\15\21\1\22\3\21\1\22\4\21"+
    "\1\22\27\21\5\22\4\0\1\22\13\0\1\21\7\0\64\21\14\0"+
    "\2\22\62\21\22\22\12\0\12\22\6\0\22\22\6\21\3\0\1\21"+
    "\1\0\2\21\13\22\34\21\10\22\2\0\27\21\15\22\14\0\35\21"+
    "\3\0\4\22\57\21\16\22\16\0\1\21\12\22\6\0\5\21\1\22"+
    "\12\21\12\22\5\21\1\0\51\21\16\22\11\0\3\21\1\22\10\21"+
    "\2\22\2\0\12\22\6\0\27\21\3\0\1\21\3\22\62\21\1\22"+
    "\1\21\3\22\2\21\2\22\5\21\2\22\1\21\1\22\1\21\30\0"+
    "\3\21\2\0\13\21\5\22\2\0\3\21\2\22\12\0\6\21\2\0"+
    "\6\21\2\0\6\21\11\0\7\21\1\0\7\21\1\0\53\21\1\0"+
    "\16\21\6\0\163\21\10\22\1\0\2\22\2\0\12\22\6\0\u2ba4\21"+
    "\14\0\27\21\4\0\61\21\u2104\0\u016e\21\2\0\152\21\46\0\7\21"+
    "\14\0\5\21\5\0\1\21\1\22\12\21\1\0\15\21\1\0\5\21"+
    "\1\0\1\21\1\0\2\21\1\0\2\21\1\0\154\21\41\0\u016b\21"+
    "\22\0\100\21\2\0\66\21\50\0\15\21\3\0\20\22\20\0\20\22"+
    "\3\0\2\21\30\0\3\21\31\0\1\21\6\0\5\21\1\0\207\21"+
    "\2\0\1\22\4\0\1\21\13\0\12\22\7\0\32\21\4\0\1\21"+
    "\1\0\32\21\13\0\131\21\3\0\6\21\2\0\6\21\2\0\6\21"+
    "\2\0\3\21\3\0\2\21\3\0\2\21\22\0\3\22\4\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\10\0\1\1\1\2\1\3\2\4\1\5\1\2\1\6"+
    "\1\2\1\1\1\7\1\10\2\11\1\2\1\11\7\2"+
    "\1\12\1\2\5\11\11\2\1\13\1\14\1\15\1\14"+
    "\1\13\1\16\2\13\1\17\4\13\1\20\12\13\1\1"+
    "\2\21\1\22\1\4\1\21\1\22\2\21\1\23\2\21"+
    "\1\5\1\24\1\5\1\0\3\2\1\25\5\2\1\26"+
    "\1\27\1\30\6\2\1\31\1\1\14\2\1\0\1\11"+
    "\17\2\1\32\1\33\1\34\1\35\2\0\1\36\4\0"+
    "\1\37\12\0\1\1\1\4\1\22\1\0\2\23\1\4"+
    "\1\23\1\5\1\40\2\5\1\24\1\5\6\2\1\41"+
    "\1\42\1\43\1\1\16\2\1\25\21\2\22\0\1\1"+
    "\2\21\1\5\3\2\1\44\2\2\1\45\1\3\16\2"+
    "\1\0\1\13\2\0\1\46\2\0\1\47\2\0\1\50"+
    "\2\0\1\51\1\1\1\5\6\2\10\0\1\1\1\5"+
    "\1\52\2\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\u0110\0\u0154\0\u0198\0\u01dc"+
    "\0\u0220\0\u0264\0\u0264\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8"+
    "\0\u03fc\0\u03b8\0\u03b8\0\u0440\0\u0484\0\u04c8\0\u050c\0\u0550"+
    "\0\u0594\0\u05d8\0\u061c\0\u0660\0\u06a4\0\u06e8\0\u072c\0\u03b8"+
    "\0\u03b8\0\u0770\0\u07b4\0\u07f8\0\u03b8\0\u083c\0\u0880\0\u08c4"+
    "\0\u0908\0\u094c\0\u0990\0\u09d4\0\u0a18\0\u0a5c\0\u0aa0\0\u0ae4"+
    "\0\u0b28\0\u03b8\0\u0b6c\0\u0bb0\0\u0bf4\0\u0c38\0\u0c7c\0\u03b8"+
    "\0\u0cc0\0\u0d04\0\u0d48\0\u0d8c\0\u03b8\0\u0dd0\0\u0e14\0\u0e58"+
    "\0\u0e9c\0\u0ee0\0\u0f24\0\u0f68\0\u0fac\0\u0ff0\0\u1034\0\u1078"+
    "\0\u10bc\0\u1100\0\u10bc\0\u10bc\0\u1144\0\u1188\0\u11cc\0\u1210"+
    "\0\u1254\0\u1298\0\u12dc\0\u1320\0\u03b8\0\u1364\0\u13a8\0\u13ec"+
    "\0\u1430\0\u1474\0\u0264\0\u14b8\0\u14fc\0\u1540\0\u1584\0\u15c8"+
    "\0\u160c\0\u1650\0\u03b8\0\u1694\0\u16d8\0\u171c\0\u1760\0\u17a4"+
    "\0\u17e8\0\u03b8\0\u182c\0\u1870\0\u18b4\0\u18f8\0\u193c\0\u1980"+
    "\0\u19c4\0\u1a08\0\u1a4c\0\u1a90\0\u1ad4\0\u1b18\0\u1b5c\0\u04c8"+
    "\0\u1ba0\0\u1be4\0\u1c28\0\u1c6c\0\u1cb0\0\u1cf4\0\u1d38\0\u1d7c"+
    "\0\u1dc0\0\u1e04\0\u1e48\0\u1e8c\0\u1ed0\0\u1f14\0\u1f58\0\u1f9c"+
    "\0\u03b8\0\u1fe0\0\u2024\0\u03b8\0\u2068\0\u20ac\0\u03b8\0\u20f0"+
    "\0\u2134\0\u2178\0\u21bc\0\u03b8\0\u2200\0\u2244\0\u2288\0\u22cc"+
    "\0\u2310\0\u2354\0\u2398\0\u23dc\0\u2420\0\u2464\0\u24a8\0\u24ec"+
    "\0\u2530\0\u2574\0\u25b8\0\u10bc\0\u25fc\0\u2640\0\u2684\0\u03b8"+
    "\0\u26c8\0\u270c\0\u13a8\0\u2750\0\u2794\0\u27d8\0\u281c\0\u2860"+
    "\0\u28a4\0\u28e8\0\u03b8\0\u292c\0\u03b8\0\u2970\0\u29b4\0\u29f8"+
    "\0\u2a3c\0\u2a80\0\u2ac4\0\u2b08\0\u2b4c\0\u2b90\0\u2bd4\0\u2c18"+
    "\0\u2c5c\0\u2ca0\0\u2ce4\0\u2d28\0\u2d6c\0\u2db0\0\u2df4\0\u2e38"+
    "\0\u2e7c\0\u2ec0\0\u2f04\0\u2f48\0\u2f8c\0\u2fd0\0\u3014\0\u3058"+
    "\0\u309c\0\u30e0\0\u3124\0\u3168\0\u31ac\0\u31f0\0\u3234\0\u3278"+
    "\0\u32bc\0\u3300\0\u3344\0\u3388\0\u33cc\0\u3410\0\u3454\0\u3498"+
    "\0\u34dc\0\u3520\0\u3564\0\u35a8\0\u35ec\0\u3630\0\u3674\0\u36b8"+
    "\0\u36fc\0\u25fc\0\u3740\0\u3784\0\u37c8\0\u380c\0\u3850\0\u03b8"+
    "\0\u3894\0\u38d8\0\u0264\0\u391c\0\u3960\0\u39a4\0\u39e8\0\u3a2c"+
    "\0\u3a70\0\u3ab4\0\u391c\0\u3af8\0\u3b3c\0\u3b80\0\u3bc4\0\u3c08"+
    "\0\u3c4c\0\u3c90\0\u2024\0\u03b8\0\u3cd4\0\u3d18\0\u3d5c\0\u3da0"+
    "\0\u3de4\0\u3e28\0\u3e6c\0\u3eb0\0\u3ef4\0\u3f38\0\u3f7c\0\u3fc0"+
    "\0\u4004\0\u4048\0\u408c\0\u40d0\0\u4114\0\u4158\0\u419c\0\u41e0"+
    "\0\u4224\0\u3d5c\0\u4268\0\u3e28\0\u42ac\0\u3ef4\0\u42f0\0\u3fc0"+
    "\0\u4334\0\u4378\0\u0264\0\u43bc\0\u4400";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\11\1\12\1\13\1\14\1\15\1\14\1\12\1\14"+
    "\1\16\1\17\1\11\1\20\1\12\1\21\1\14\1\22"+
    "\1\11\1\12\1\11\1\23\1\24\1\25\1\26\2\12"+
    "\1\27\3\12\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\2\26\1\44"+
    "\1\26\1\45\1\46\1\45\1\11\1\40\1\12\1\47"+
    "\1\50\1\51\1\52\1\12\1\53\1\54\2\12\1\55"+
    "\1\56\1\57\1\12\4\14\12\60\1\61\1\62\102\60"+
    "\1\63\1\62\70\60\13\64\1\65\70\64\15\66\1\67"+
    "\5\66\1\70\2\66\1\71\33\66\1\72\2\66\1\73"+
    "\33\66\1\74\5\66\1\75\2\66\1\76\33\66\1\77"+
    "\2\66\1\100\16\66\15\101\1\102\44\101\1\103\2\101"+
    "\1\104\33\101\1\105\44\101\1\106\2\101\1\107\16\101"+
    "\10\11\1\0\2\11\1\0\3\11\1\0\3\11\4\0"+
    "\6\11\2\0\6\11\13\0\1\11\1\0\23\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\22\12"+
    "\2\111\1\112\3\14\1\111\1\14\1\0\2\111\1\0"+
    "\1\111\1\113\1\14\1\0\3\111\4\0\1\114\3\111"+
    "\1\113\1\115\1\0\1\116\2\111\1\115\1\111\1\114"+
    "\1\111\13\0\1\111\1\0\12\111\1\113\3\111\4\14"+
    "\2\111\1\117\1\120\2\121\1\111\1\121\1\0\2\111"+
    "\1\0\1\111\1\113\1\121\1\0\3\111\4\0\1\114"+
    "\2\122\1\123\1\113\1\115\1\0\1\116\2\111\1\115"+
    "\1\111\1\114\1\111\13\0\1\111\1\0\10\111\1\123"+
    "\1\111\1\113\3\111\1\120\3\121\10\124\1\125\1\124"+
    "\1\126\10\124\1\127\60\124\1\11\4\12\1\130\2\12"+
    "\1\0\1\12\1\110\1\0\1\131\2\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\5\12\1\132\13\0\1\11"+
    "\1\0\16\12\1\133\1\134\1\135\1\12\104\0\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\1\13\2\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\3\12\1\136\2\12"+
    "\13\0\1\11\1\0\2\12\1\137\3\12\1\140\10\12"+
    "\1\134\1\135\1\12\24\0\1\24\104\0\1\141\1\142"+
    "\22\0\1\45\103\0\1\45\32\0\1\11\7\12\1\0"+
    "\1\12\1\110\1\143\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\1\12\1\144\1\145\3\12\13\0\1\11"+
    "\1\0\6\12\1\146\13\12\35\0\1\45\13\0\1\45"+
    "\35\0\3\116\1\0\1\116\6\0\1\116\61\0\4\116"+
    "\1\11\7\12\1\0\1\147\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\1\12\1\150\4\12"+
    "\13\0\1\11\1\0\13\12\1\151\6\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\152\3\12\1\0\1\153\2\12"+
    "\4\0\6\12\2\0\2\12\1\154\3\12\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\1\155\2\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\4\12\1\156\1\12\13\0\1\11\1\0\10\12\1\157"+
    "\11\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\2\12\1\160\3\12\2\0"+
    "\4\12\1\161\1\13\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\2\12\1\162\3\12\13\0"+
    "\1\11\1\0\6\12\1\163\13\12\1\11\7\12\1\0"+
    "\1\164\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\1\165\1\12\1\166\3\12\13\0\1\11"+
    "\1\0\2\12\1\167\17\12\47\0\1\45\1\0\1\45"+
    "\102\0\1\170\1\45\103\0\1\45\1\0\1\171\101\0"+
    "\1\45\4\0\1\45\25\0\1\11\7\12\1\0\1\172"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\1\12\1\173\4\12\13\0\1\11\1\0\22\12"+
    "\1\11\4\12\1\130\2\12\1\0\1\12\1\110\1\0"+
    "\2\13\1\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\5\12\1\174\13\0\1\11\1\0\7\12\1\175\6\12"+
    "\1\133\1\134\1\135\1\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\1\176\21\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\1\12\1\177\4\12\13\0"+
    "\1\11\1\0\1\200\5\12\1\201\13\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\1\12\1\202\1\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\14\12\1\203\5\12\1\11\7\12\1\0\1\162"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\3\12\1\204\2\12\13\0\1\11\1\0\6\12"+
    "\1\205\13\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\6\12\1\13\4\12\1\206\6\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\2\12\1\207\17\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\2\12\1\210\17\12"+
    "\12\60\2\0\70\60\11\211\1\212\11\211\1\0\46\211"+
    "\1\213\22\211\1\214\11\211\1\0\46\211\1\213\11\211"+
    "\13\64\1\0\70\64\20\0\1\65\63\0\15\66\1\0"+
    "\5\66\1\0\2\66\1\0\33\66\1\0\2\66\1\0"+
    "\16\66\37\0\1\215\24\0\1\216\44\0\1\217\115\0"+
    "\1\220\131\0\1\221\55\0\1\222\24\0\1\223\44\0"+
    "\1\224\115\0\1\225\131\0\1\226\16\0\15\101\1\0"+
    "\44\101\1\0\2\101\1\0\16\101\37\0\1\227\24\0"+
    "\1\230\56\0\1\231\131\0\1\232\55\0\1\233\24\0"+
    "\1\234\56\0\1\235\131\0\1\236\16\0\10\11\1\0"+
    "\1\237\1\11\1\0\3\11\1\0\3\11\4\0\6\11"+
    "\2\0\6\11\13\0\1\11\1\0\22\11\10\111\1\0"+
    "\2\111\1\0\3\111\1\0\3\111\4\0\6\111\2\0"+
    "\6\111\13\0\1\111\1\0\24\111\1\112\3\240\1\111"+
    "\1\240\1\0\2\111\1\0\2\111\1\240\1\0\3\111"+
    "\4\0\6\111\2\0\6\111\13\0\1\111\1\0\16\111"+
    "\4\240\3\111\3\241\1\111\1\241\1\0\2\111\1\0"+
    "\2\111\1\241\1\0\3\111\4\0\6\111\1\242\1\0"+
    "\6\111\2\0\1\242\10\0\1\111\1\0\16\111\4\241"+
    "\3\111\3\116\1\111\1\116\1\0\2\111\1\0\1\111"+
    "\1\113\1\116\1\0\3\111\4\0\4\111\1\113\1\115"+
    "\2\0\2\111\1\115\3\111\13\0\1\111\1\0\12\111"+
    "\1\113\3\111\4\116\2\111\1\117\1\111\2\243\1\111"+
    "\1\243\1\0\2\111\1\0\2\111\1\243\1\0\3\111"+
    "\4\0\6\111\2\0\6\111\13\0\1\111\1\0\17\111"+
    "\3\243\3\111\3\120\1\111\1\120\1\0\2\111\1\0"+
    "\1\111\1\113\1\120\1\0\3\111\4\0\4\111\1\113"+
    "\1\115\1\0\1\116\2\111\1\115\3\111\13\0\1\111"+
    "\1\0\12\111\1\113\3\111\4\120\2\111\1\117\1\120"+
    "\2\121\1\111\1\121\1\0\2\111\1\0\1\111\1\113"+
    "\1\121\1\0\3\111\4\0\1\244\3\111\1\113\1\115"+
    "\1\0\1\116\2\111\1\115\1\111\1\244\1\111\13\0"+
    "\1\111\1\0\12\111\1\113\3\111\1\120\3\121\4\111"+
    "\2\245\2\111\1\0\2\111\1\0\3\111\1\0\3\111"+
    "\4\0\6\111\2\0\6\111\13\0\1\111\1\0\25\111"+
    "\5\246\1\0\2\111\1\0\1\111\2\246\1\0\3\111"+
    "\4\0\1\111\2\246\1\111\2\246\2\0\2\111\2\246"+
    "\2\111\13\0\1\111\1\0\4\111\1\246\5\111\1\246"+
    "\3\111\4\246\10\247\1\250\12\247\1\0\64\247\2\251"+
    "\1\247\1\252\1\253\1\254\4\124\1\251\4\247\1\0"+
    "\5\247\1\124\5\247\2\124\3\247\1\124\34\247\1\252"+
    "\1\251\1\252\10\0\1\250\73\0\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\2\12\1\255\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\17\12"+
    "\1\133\2\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\5\12"+
    "\1\256\13\0\1\11\1\0\2\12\1\257\17\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\2\12\1\13\3\12\13\0"+
    "\1\11\1\0\2\12\1\260\17\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\6\12\13\0\1\11\1\0\21\12\1\133"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\2\12\1\133"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\4\12\1\261\1\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\1\262\2\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\1\12"+
    "\1\13\4\12\13\0\1\11\1\0\22\12\25\0\1\263"+
    "\104\0\1\264\55\0\1\11\7\12\1\0\1\12\1\110"+
    "\1\265\3\12\1\0\1\266\2\12\4\0\6\12\2\0"+
    "\2\12\1\267\3\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\4\12\1\270\15\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\6\12\1\271\1\12\1\13"+
    "\11\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\1\12\1\133\20\12\1\11\7\12\1\0"+
    "\1\272\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\3\12\1\273\2\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\1\12\1\274\20\12\10\11\1\0\2\11"+
    "\1\152\3\11\1\0\1\153\2\11\4\0\6\11\2\0"+
    "\6\11\13\0\1\11\1\0\23\11\7\12\1\0\1\12"+
    "\1\110\1\0\1\12\1\13\1\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\1\275\5\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\276\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\5\12\1\277\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\1\300\5\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\5\12\1\301"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\2\12\1\302\17\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\1\13\5\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\6\12\1\303\13\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\1\12\1\304\20\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\1\12\1\305\1\12\1\306\2\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\4\12\1\307"+
    "\1\12\13\0\1\11\1\0\22\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\6\12\13\0\1\11\1\0\15\12\1\310"+
    "\4\12\51\0\1\45\1\0\1\26\30\0\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\2\12\1\13\3\12\2\0\1\12\1\277\4\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\2\12\1\311\3\12"+
    "\1\312\13\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\2\12\1\260\17\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\1\12"+
    "\1\313\20\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\2\12"+
    "\1\314\3\12\13\0\1\11\1\0\2\12\1\315\17\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\3\12\1\316\2\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\3\12\1\317\2\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\1\320\2\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\1\12\1\321\1\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\6\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\2\12\1\322\3\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\1\323\5\12\13\0\1\11\1\0\4\12\1\324\15\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\12\12\1\13\1\12\1\277\5\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\1\13\2\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\2\12\1\325"+
    "\3\12\13\0\1\11\1\0\22\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\1\12\1\326\4\12\13\0\1\11\1\0"+
    "\22\12\3\0\5\327\5\0\2\327\11\0\2\327\1\0"+
    "\2\327\4\0\2\327\23\0\1\327\5\0\1\327\3\0"+
    "\4\327\3\0\5\330\5\0\2\330\11\0\2\330\1\0"+
    "\2\330\4\0\2\330\23\0\1\330\5\0\1\330\3\0"+
    "\4\330\63\0\1\331\63\0\1\332\77\0\1\333\131\0"+
    "\1\334\101\0\1\335\63\0\1\336\77\0\1\337\131\0"+
    "\1\340\101\0\1\341\63\0\1\342\77\0\1\343\131\0"+
    "\1\344\101\0\1\345\63\0\1\346\77\0\1\347\131\0"+
    "\1\350\16\0\3\11\5\351\1\0\2\11\1\0\1\11"+
    "\2\351\1\0\3\11\4\0\1\11\2\351\1\11\2\351"+
    "\2\0\2\11\2\351\2\11\13\0\1\11\1\0\4\11"+
    "\1\351\5\11\1\351\3\11\4\351\2\111\1\112\3\240"+
    "\1\111\1\240\1\0\2\111\1\0\2\111\1\240\1\0"+
    "\3\111\4\0\1\114\5\111\2\0\4\111\1\114\1\111"+
    "\13\0\1\111\1\0\16\111\4\240\3\111\3\241\1\111"+
    "\1\241\1\0\2\111\1\0\1\111\1\113\1\241\1\0"+
    "\3\111\4\0\4\111\1\113\1\111\2\0\6\111\13\0"+
    "\1\111\1\0\12\111\1\113\3\111\4\241\3\0\3\241"+
    "\1\0\1\241\6\0\1\241\61\0\4\241\2\111\1\117"+
    "\1\111\2\243\1\111\1\243\1\0\2\111\1\0\2\111"+
    "\1\243\1\0\3\111\4\0\1\244\5\111\2\0\4\111"+
    "\1\244\1\111\13\0\1\111\1\0\17\111\3\243\2\111"+
    "\1\352\1\111\2\245\2\111\1\0\2\111\1\0\3\111"+
    "\1\0\3\111\4\0\6\111\2\0\6\111\13\0\1\111"+
    "\1\0\24\111\1\353\5\246\1\0\2\111\1\0\1\111"+
    "\2\246\1\0\3\111\4\0\1\244\2\246\1\111\2\246"+
    "\2\0\2\111\2\246\1\244\1\111\13\0\1\111\1\0"+
    "\4\111\1\246\5\111\1\246\3\111\4\246\10\247\1\125"+
    "\12\247\1\0\64\247\2\252\1\247\1\252\1\250\5\247"+
    "\1\252\4\247\1\0\55\247\3\252\4\247\2\124\1\247"+
    "\1\124\1\250\5\247\1\124\4\247\1\0\55\247\3\124"+
    "\3\247\5\354\1\125\4\247\2\354\4\247\1\0\4\247"+
    "\2\354\1\247\2\354\4\247\2\354\23\247\1\354\5\247"+
    "\1\354\3\247\4\354\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\16\12\1\133\3\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\3\12\1\355\2\12\13\0"+
    "\1\11\1\0\2\12\1\356\17\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\6\12\13\0\1\11\1\0\6\12\1\206"+
    "\13\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\6\12\13\0"+
    "\1\11\1\0\15\12\1\357\4\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\5\12\1\272\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\3\12\1\313\2\12"+
    "\13\0\1\11\1\0\22\12\25\0\1\360\56\0\10\11"+
    "\1\0\2\11\1\265\3\11\1\0\1\266\2\11\4\0"+
    "\6\11\2\0\6\11\13\0\1\11\1\0\23\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\3\12\1\361\2\12\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\6\12\1\362\13\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\4\12\1\133\1\12\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\2\12"+
    "\1\363\3\12\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\2\12"+
    "\1\162\17\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\2\12"+
    "\1\364\3\12\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\365\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\7\12\1\13\12\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\2\12\1\13\3\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\2\12\1\366\3\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\1\367\5\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\5\12\1\370\14\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\1\12\1\13\20\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\2\12\1\140\3\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\371\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\22\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\3\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\1\372\5\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\1\12\1\13"+
    "\1\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\2\12\1\373\3\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\14\12\1\13\5\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\4\12\1\13\15\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\4\12\1\13\1\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\1\12\1\277\4\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\4\12\1\277\1\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\1\277\5\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\1\12\1\133\4\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\1\374\4\12\1\162\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\5\12\1\375\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\1\12"+
    "\1\376\4\12\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\4\12"+
    "\1\377\15\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\1\12"+
    "\1\u0100\4\12\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\4\12\1\u0101\1\12\13\0\1\11"+
    "\1\0\22\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\1\u0102"+
    "\5\12\13\0\1\11\1\0\22\12\3\0\5\u0103\5\0"+
    "\2\u0103\11\0\2\u0103\1\0\2\u0103\4\0\2\u0103\23\0"+
    "\1\u0103\5\0\1\u0103\3\0\4\u0103\3\0\5\u0104\5\0"+
    "\2\u0104\11\0\2\u0104\1\0\2\u0104\4\0\2\u0104\23\0"+
    "\1\u0104\5\0\1\u0104\3\0\4\u0104\57\0\1\u0105\65\0"+
    "\1\331\125\0\1\u0106\56\0\1\u0107\124\0\1\u0108\65\0"+
    "\1\335\125\0\1\u0109\56\0\1\u010a\124\0\1\u010b\65\0"+
    "\1\341\125\0\1\u010c\56\0\1\u010d\124\0\1\u010e\65\0"+
    "\1\345\125\0\1\u010f\56\0\1\u0110\45\0\3\11\5\u0111"+
    "\1\0\2\11\1\0\1\11\2\u0111\1\0\3\11\4\0"+
    "\1\11\2\u0111\1\11\2\u0111\2\0\2\11\2\u0111\2\11"+
    "\13\0\1\11\1\0\4\11\1\u0111\5\11\1\u0111\3\11"+
    "\4\u0111\2\111\1\353\5\246\1\0\2\111\1\0\1\111"+
    "\2\246\1\0\3\111\4\0\1\111\2\246\1\111\2\246"+
    "\2\0\2\111\2\246\2\111\13\0\1\111\1\0\4\111"+
    "\1\246\5\111\1\246\3\111\4\246\3\247\5\u0112\1\125"+
    "\4\247\2\u0112\4\247\1\0\4\247\2\u0112\1\247\2\u0112"+
    "\4\247\2\u0112\23\247\1\u0112\5\247\1\u0112\3\247\4\u0112"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\1\12\1\277"+
    "\1\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\15\12\1\u0113\4\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\2\12\1\133\3\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\11\12\1\13\10\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\7\12\1\277\12\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\6\12\13\0\1\11\1\0\6\12\1\307\13\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\1\12\1\u0114\4\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\3\12\1\0\1\11\2\12\4\0\6\12"+
    "\2\0\1\12\1\206\4\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\1\12\1\u0115\4\12"+
    "\13\0\1\11\1\0\22\12\1\11\7\12\1\0\1\12"+
    "\1\110\1\0\1\373\2\12\1\0\1\11\2\12\4\0"+
    "\6\12\2\0\6\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\4\12\1\162\15\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\2\12\1\312\17\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\2\12\1\u0116\17\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\2\12\1\u0117\3\12\13\0\1\11\1\0\22\12\1\11"+
    "\7\12\1\0\1\12\1\110\1\0\3\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\1\12\1\u0118\4\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\1\13\21\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\6\12"+
    "\1\13\13\12\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\6\12"+
    "\13\0\1\11\1\0\12\12\1\13\7\12\1\11\7\12"+
    "\1\0\1\262\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\22\12"+
    "\25\0\1\u0119\122\0\1\331\12\0\1\u0105\25\0\1\u0107"+
    "\1\u011a\5\u0107\1\u011a\1\u0107\2\0\3\u0107\1\0\1\u011a"+
    "\4\0\1\u0107\1\u011a\6\u0107\2\u011a\6\u0107\1\0\2\u011a"+
    "\1\0\1\u011a\2\0\6\u011a\22\u0107\25\0\1\u011b\122\0"+
    "\1\335\12\0\1\u0108\25\0\1\u010a\1\u011c\5\u010a\1\u011c"+
    "\1\u010a\2\0\3\u010a\1\0\1\u011c\4\0\1\u010a\1\u011c"+
    "\6\u010a\2\u011c\6\u010a\1\0\2\u011c\1\0\1\u011c\2\0"+
    "\6\u011c\22\u010a\25\0\1\u011d\122\0\1\341\12\0\1\u010b"+
    "\25\0\1\u010d\1\u011e\5\u010d\1\u011e\1\u010d\2\0\3\u010d"+
    "\1\0\1\u011e\4\0\1\u010d\1\u011e\6\u010d\2\u011e\6\u010d"+
    "\1\0\2\u011e\1\0\1\u011e\2\0\6\u011e\22\u010d\25\0"+
    "\1\u011f\122\0\1\345\12\0\1\u010e\25\0\1\u0110\1\u0120"+
    "\5\u0110\1\u0120\1\u0110\2\0\3\u0110\1\0\1\u0120\4\0"+
    "\1\u0110\1\u0120\6\u0110\2\u0120\6\u0110\1\0\2\u0120\1\0"+
    "\1\u0120\2\0\6\u0120\22\u0110\3\11\5\u0121\1\0\2\11"+
    "\1\0\1\11\2\u0121\1\0\3\11\4\0\1\11\2\u0121"+
    "\1\11\2\u0121\2\0\2\11\2\u0121\2\11\13\0\1\11"+
    "\1\0\4\11\1\u0121\5\11\1\u0121\3\11\4\u0121\3\247"+
    "\5\u0122\1\125\4\247\2\u0122\4\247\1\0\4\247\2\u0122"+
    "\1\247\2\u0122\4\247\2\u0122\23\247\1\u0122\5\247\1\u0122"+
    "\3\247\4\u0122\1\11\7\12\1\0\1\12\1\110\1\0"+
    "\3\12\1\0\1\11\2\12\4\0\6\12\2\0\2\12"+
    "\1\u0101\3\12\13\0\1\11\1\0\22\12\1\11\7\12"+
    "\1\0\1\12\1\110\1\0\1\u0123\2\12\1\0\1\11"+
    "\2\12\4\0\6\12\2\0\6\12\13\0\1\11\1\0"+
    "\22\12\1\11\7\12\1\0\1\12\1\110\1\0\3\12"+
    "\1\0\1\11\2\12\4\0\6\12\2\0\3\12\1\371"+
    "\2\12\13\0\1\11\1\0\22\12\1\11\7\12\1\0"+
    "\1\12\1\110\1\0\1\u0124\2\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\1\373\5\12\13\0"+
    "\1\11\1\0\22\12\1\11\7\12\1\0\1\12\1\110"+
    "\1\0\3\12\1\0\1\11\2\12\4\0\6\12\2\0"+
    "\6\12\13\0\1\11\1\0\2\12\1\u0125\17\12\25\0"+
    "\1\u0107\103\0\1\u010a\103\0\1\u010d\103\0\1\u0110\56\0"+
    "\3\11\5\12\1\0\2\11\1\0\1\11\2\12\1\0"+
    "\3\11\4\0\1\11\2\12\1\11\2\12\2\0\2\11"+
    "\2\12\2\11\13\0\1\11\1\0\4\11\1\12\5\11"+
    "\1\12\3\11\4\12\3\247\5\124\1\125\4\247\2\124"+
    "\4\247\1\0\4\247\2\124\1\247\2\124\4\247\2\124"+
    "\23\247\1\124\5\247\1\124\3\247\4\124\1\11\7\12"+
    "\1\0\1\277\1\110\1\0\3\12\1\0\1\11\2\12"+
    "\4\0\6\12\2\0\6\12\13\0\1\11\1\0\22\12"+
    "\1\11\7\12\1\0\1\12\1\110\1\0\3\12\1\0"+
    "\1\11\2\12\4\0\6\12\2\0\6\12\13\0\1\11"+
    "\1\0\12\12\1\277\7\12";

  private static int [] zzUnpackTrans() {
    int [] result = new int[17476];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\10\0\7\1\1\11\1\1\2\11\14\1\2\11\3\1"+
    "\1\11\14\1\1\11\5\1\1\11\4\1\1\11\27\1"+
    "\1\11\1\1\1\0\13\1\1\11\6\1\1\11\15\1"+
    "\1\0\20\1\1\11\2\1\1\11\2\0\1\11\4\0"+
    "\1\11\12\0\3\1\1\0\5\1\1\11\12\1\1\11"+
    "\1\1\1\11\41\1\22\0\7\1\1\11\22\1\1\0"+
    "\1\11\2\0\1\1\2\0\1\1\2\0\1\1\2\0"+
    "\11\1\10\0\5\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
    /**
     * Token type specifying we're in an invalid multi-line string.
     */
    static final int INTERNAL_IN_STRING_INVALID	= -1;

    /**
     * Token type specifying we're in a valid multi-line string.
     */
    static final int INTERNAL_IN_STRING_VALID	= -2;


    /**
     * Token type specifying we're in an invalid multi-line byte string.
     */
    static final int INTERNAL_IN_BYTE_STRING_INVALID	= -3;

    /**
     * Token type specifying we're in a valid multi-line byte string.
     */
    static final int INTERNAL_IN_BYTE_STRING_VALID	= -4;


    /**
     * Token type specifying we're in an invalid multi-line raw string.
     */
    static final int INTERNAL_IN_RAW_STRING_INVALID	= -(1<<11);

    /**
     * Token type specifying we're in a valid multi-line raw string.
     */
    static final int INTERNAL_IN_RAW_STRING_VALID	= -(2<<11);


    /**
     * Token type specifying we're in an invalid multi-line raw byte string.
     */
    static final int INTERNAL_IN_RAW_BYTE_STRING_INVALID	= -(3<<11);

    /**
     * Token type specifying we're in a valid multi-line raw byte string.
     */
    static final int INTERNAL_IN_RAW_BYTE_STRING_VALID	= -(4<<11);


    /**
     * When in the STRING state, whether the current string is valid.
     */
    private boolean validString;


    /**
     * When in a raw or raw-byte state, the number of '#' signs in the delimiters.
     */
    private int poundCount;


    /**
    * The delimiter for raw or raw-byte states.
    */
    private String delimiter;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public RustTokenMaker() {
	}


    /**
     * Adds the token specified to the current linked list of tokens as an
     * "end token;" that is, at <code>zzMarkedPos</code>.
     *
     * @param tokenType The token's type.
     */
    private void addEndToken(int tokenType) {
        addToken(zzMarkedPos,zzMarkedPos, tokenType);
    }


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds an end token that encodes the information necessary to know
	 * the delimiter being used for a raw or binary-raw string that spans
	 * multiple lines.
	 *
	 * @param endTokenState The end-token state.
	 */
	private void addRawStringLiteralEndToken(int endTokenState) {
		addEndToken(endTokenState - poundCount);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, false);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 * @param hyperlink Whether this token is a hyperlink.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType,
						int startOffset, boolean hyperlink) {
		super.addToken(array, start,end, tokenType, startOffset, hyperlink);
		zzStartRead = zzMarkedPos;
	}


    String createDelimiter(int poundCount, char ch) {
        if (poundCount == 0) { // Common case
            return String.valueOf(ch);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ch);
        for (int i = 0; i < poundCount; i++) {
            sb.append('#');
        }
        return sb.toString();
    }


    /**
     * Returns the closest {@link TokenTypes} "standard" token type for a given
     * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
     */
    @Override
    public int getClosestStandardTokenTypeForInternalType(int type) {
        switch (type) {
            case INTERNAL_IN_BYTE_STRING_INVALID:
            case INTERNAL_IN_BYTE_STRING_VALID:
            case INTERNAL_IN_RAW_BYTE_STRING_INVALID:
            case INTERNAL_IN_RAW_BYTE_STRING_VALID:
            case INTERNAL_IN_RAW_STRING_INVALID:
            case INTERNAL_IN_RAW_STRING_VALID:
            case INTERNAL_IN_STRING_INVALID:
            case INTERNAL_IN_STRING_VALID:
                return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
        }
        return type;
    }


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
        validString = true;
        poundCount = 0;

		// Start off in the proper state.
		int state;
		switch (initialTokenType) {
            case INTERNAL_IN_BYTE_STRING_INVALID:
                state = BYTE_STRING_LITERAL;
                validString = false;
                break;
            case INTERNAL_IN_BYTE_STRING_VALID:
                state = BYTE_STRING_LITERAL;
                break;
            case INTERNAL_IN_STRING_INVALID:
                state = STRING;
                validString = false;
                break;
            case INTERNAL_IN_STRING_VALID:
                state = STRING;
                break;
			case TokenTypes.COMMENT_MULTILINE:
				state = MLC;
				break;
			case TokenTypes.COMMENT_DOCUMENTATION:
				state = DOCCOMMENT;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_* states that encode extra info
					int main = -(-initialTokenType & 0x0000ff00);
					switch (main) {
						default: // Should never happen
                        case INTERNAL_IN_RAW_STRING_INVALID:
                            state = RAW_STRING_LITERAL;
                            validString = false;
                            poundCount = -initialTokenType & 0xff;
                            delimiter = createDelimiter(poundCount, '"');
                            break;
                        case INTERNAL_IN_RAW_STRING_VALID:
                            state = RAW_STRING_LITERAL;
                            poundCount = -initialTokenType & 0xff;
                            delimiter = createDelimiter(poundCount, '"');
                            break;
                        case INTERNAL_IN_RAW_BYTE_STRING_INVALID:
                            state = RAW_BYTE_STRING_LITERAL;
                            validString = false;
                            poundCount = -initialTokenType & 0xff;
                            delimiter = createDelimiter(poundCount, '"');
                            break;
                        case INTERNAL_IN_RAW_BYTE_STRING_VALID:
                            state = RAW_BYTE_STRING_LITERAL;
                            poundCount = -initialTokenType & 0xff;
                            delimiter = createDelimiter(poundCount, '"');
                            break;
					}
                }
				else {
					state = YYINITIAL;
				}
				break;
		}

        start = text.offset;
        s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public RustTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public RustTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2318) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 41:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, TokenTypes.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, TokenTypes.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 43: break;
        case 18:
          { addToken(TokenTypes.LITERAL_NUMBER_FLOAT);
          }
        case 44: break;
        case 14:
          { // As long as the token read is at least as long as the delimiter,
                                // we have found our end token (too long implies just extra '#' signs for
                                // some reason)
                                int tokenLength = yylength();
                                if (tokenLength >= delimiter.length()) {
                                    int type = validString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE;
                                    int end = zzStartRead + delimiter.length();
                                    addToken(start, end - 1, type);
                                    zzStartRead = zzCurrentPos = zzMarkedPos = end;
                                    yybegin(YYINITIAL);
                                }
                                // Otherwise, there weren't enough '#' signs, so we just ignore this content.
                                // It is part of the literal
          }
        case 45: break;
        case 32:
          { addToken(TokenTypes.LITERAL_CHAR);
          }
        case 46: break;
        case 26:
          { /* Skip all escaped chars. */
          }
        case 47: break;
        case 12:
          { /* Skip all escape chars for now, even though this isn't right */
          }
        case 48: break;
        case 1:
          { addToken(TokenTypes.ERROR_IDENTIFIER);
          }
        case 49: break;
        case 5:
          { addToken(TokenTypes.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 50: break;
        case 27:
          { /* Invalid Unicode character \\uXXXX */ validString = false;
          }
        case 51: break;
        case 36:
          { addToken(TokenTypes.COMMENT_MULTILINE);
          }
        case 52: break;
        case 19:
          { addToken(TokenTypes.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 53: break;
        case 10:
          { addToken(TokenTypes.SEPARATOR);
          }
        case 54: break;
        case 2:
          { addToken(TokenTypes.IDENTIFIER);
          }
        case 55: break;
        case 33:
          { start = zzMarkedPos-3; yybegin(LINE_DOCCOMMENT);
          }
        case 56: break;
        case 15:
          { addToken(start,zzStartRead-1, TokenTypes.COMMENT_MULTILINE); return firstToken;
          }
        case 57: break;
        case 20:
          { addToken(TokenTypes.ERROR_CHAR);
          }
        case 58: break;
        case 4:
          { addToken(TokenTypes.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 59: break;
        case 39:
          { int temp = zzStartRead;
                                    if (start <= zzStartRead - 1) {
                                        addToken(start,zzStartRead-1, TokenTypes.COMMENT_DOCUMENTATION);
                                    }
                                    addHyperlinkToken(temp,zzMarkedPos-1, TokenTypes.COMMENT_DOCUMENTATION);
                                    start = zzMarkedPos;
          }
        case 60: break;
        case 40:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, TokenTypes.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, TokenTypes.COMMENT_EOL); start = zzMarkedPos;
          }
        case 61: break;
        case 17:
          { addToken(TokenTypes.ERROR_NUMBER_FORMAT);
          }
        case 62: break;
        case 42:
          { addToken(TokenTypes.RESERVED_WORD_2);
          }
        case 63: break;
        case 31:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, TokenTypes.COMMENT_DOCUMENTATION);
          }
        case 64: break;
        case 13:
          { int type = validString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 65: break;
        case 16:
          { addToken(start,zzStartRead-1, TokenTypes.COMMENT_DOCUMENTATION); return firstToken;
          }
        case 66: break;
        case 23:
          { start = zzMarkedPos-2; yybegin(MLC);
          }
        case 67: break;
        case 6:
          { start = zzMarkedPos-1; validString = true; yybegin(STRING);
          }
        case 68: break;
        case 37:
          { addToken(TokenTypes.LITERAL_BOOLEAN);
          }
        case 69: break;
        case 30:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, TokenTypes.COMMENT_MULTILINE);
          }
        case 70: break;
        case 8:
          { addToken(TokenTypes.WHITESPACE);
          }
        case 71: break;
        case 34:
          { start = zzMarkedPos-3; yybegin(DOCCOMMENT);
          }
        case 72: break;
        case 24:
          { start = zzMarkedPos-2; validString = true; yybegin(BYTE_STRING_LITERAL);
          }
        case 73: break;
        case 3:
          { addToken(TokenTypes.RESERVED_WORD);
          }
        case 74: break;
        case 35:
          { start = zzMarkedPos - yylength(); validString = true; poundCount = yylength() - 3; delimiter = createDelimiter(poundCount, '#'); yybegin(RAW_BYTE_STRING_LITERAL);
          }
        case 75: break;
        case 29:
          { /* All Unicode chars, valid or not, are not allowed in byte strings \\uXXXX */ validString = false;
          }
        case 76: break;
        case 25:
          { start = zzMarkedPos - yylength(); validString = true; poundCount = yylength() - 2; delimiter = createDelimiter(poundCount, '#'); yybegin(RAW_STRING_LITERAL);
          }
        case 77: break;
        case 7:
          { addNullToken(); return firstToken;
          }
        case 78: break;
        case 21:
          { addToken(TokenTypes.DATA_TYPE);
          }
        case 79: break;
        case 28:
          { /* Invalid latin-1 character \xXX */ validString = false;
          }
        case 80: break;
        case 9:
          { addToken(TokenTypes.OPERATOR);
          }
        case 81: break;
        case 38:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, TokenTypes.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, TokenTypes.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 82: break;
        case 22:
          { start = zzMarkedPos-2; yybegin(EOL_COMMENT);
          }
        case 83: break;
        case 11:
          {
          }
        case 84: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, TokenTypes.COMMENT_DOCUMENTATION); return firstToken;
            }
            case 294: break;
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, TokenTypes.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 295: break;
            case BYTE_STRING_LITERAL: {
              // Strings always continue to the next line
                                if (validString) {
                                    addToken(start, zzStartRead - 1, Token.LITERAL_STRING_DOUBLE_QUOTE);
                                    addEndToken(INTERNAL_IN_BYTE_STRING_VALID);
                                }
                                else {
                                    addToken(start, zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
                                    addEndToken(INTERNAL_IN_BYTE_STRING_INVALID);
                                }
                                return firstToken;
            }
            case 296: break;
            case MLC: {
              addToken(start,zzStartRead-1, TokenTypes.COMMENT_MULTILINE); return firstToken;
            }
            case 297: break;
            case STRING: {
              // Strings always continue to the next line
                                if (validString) {
                                    addToken(start, zzStartRead - 1, Token.LITERAL_STRING_DOUBLE_QUOTE);
                                    addEndToken(INTERNAL_IN_STRING_VALID);
                                }
                                else {
                                    addToken(start, zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
                                    addEndToken(INTERNAL_IN_STRING_INVALID);
                                }
                                return firstToken;
            }
            case 298: break;
            case LINE_DOCCOMMENT: {
              addToken(start,zzStartRead-1, TokenTypes.COMMENT_DOCUMENTATION); addNullToken(); return firstToken;
            }
            case 299: break;
            case RAW_STRING_LITERAL: {
              // Strings always continue to the next line
                                if (validString) {
                                    addToken(start, zzStartRead - 1, Token.LITERAL_STRING_DOUBLE_QUOTE);
                                    addRawStringLiteralEndToken(INTERNAL_IN_RAW_STRING_VALID);
                                }
                                else {
                                    addToken(start, zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
                                    addRawStringLiteralEndToken(INTERNAL_IN_RAW_STRING_INVALID);
                                }
                                return firstToken;
            }
            case 300: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 301: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
