/* The following code was generated by JFlex 1.4.1 on 1/20/09 10:04 AM */

/*
 * 02/25/2005
 *
 * SASTokenMaker.java - Scanner for SAS files.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class generates tokens representing a text stream as SAS.<p>
 *
 * This implementation was created using
 * <a href="https://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>), so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>SASTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class SASTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;
  public static final int MLC = 6;
  public static final int CHAR = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  1,  2,  2,  3,  3,  4, 4
  };

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\3\1\1\25\0\1\3\1\0\1\23\2\0\1\53\1\4"+
    "\1\24\2\22\1\6\1\5\1\0\1\5\1\0\1\7\2\2\1\52"+
    "\1\51\1\45\5\2\1\0\1\0\1\10\1\12\1\10\2\0\1\26"+
    "\1\42\1\27\1\32\1\13\1\33\1\16\1\30\1\21\1\2\1\44"+
    "\1\20\1\36\1\15\1\40\1\37\1\14\1\31\1\34\1\17\1\35"+
    "\1\46\1\47\1\43\1\41\1\50\3\0\1\10\1\25\1\0\1\26"+
    "\1\42\1\27\1\32\1\13\1\33\1\16\1\30\1\21\1\2\1\44"+
    "\1\20\1\36\1\15\1\40\1\37\1\14\1\31\1\34\1\17\1\35"+
    "\1\46\1\47\1\43\1\41\1\50\1\0\1\5\1\0\1\11\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\2\1\1\1\3\1\1\3\4\3\1"+
    "\1\5\4\1\1\6\1\7\1\10\15\1\1\5\4\1"+
    "\1\3\1\11\1\12\1\13\1\14\1\12\1\15\1\16"+
    "\1\12\1\17\1\12\1\20\1\21\1\4\7\1\1\5"+
    "\5\1\1\4\3\1\1\4\15\1\1\5\66\1\1\5"+
    "\14\1\21\0\1\22\1\5\5\1\1\5\66\1\1\23"+
    "\50\1\1\5\15\1\1\5\1\1\1\5\4\1\1\5"+
    "\20\1\1\5\3\1\7\0\1\24\2\0\1\24\24\0"+
    "\21\1\1\5\6\1\1\5\44\1\1\5\1\1\1\5"+
    "\11\1\1\5\7\1\1\5\4\1\1\23\22\1\1\5"+
    "\5\1\12\0\1\24\16\0\10\1\1\5\3\1\1\5"+
    "\13\1\1\5\2\1\1\5\3\1\1\5\23\1\1\5"+
    "\10\1\1\23\2\5\6\1\16\0\42\1\13\0\17\1"+
    "\2\0\12\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[639];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\54\0\130\0\204\0\260\0\334\0\334\0\u0108"+
    "\0\u0134\0\u0160\0\334\0\u018c\0\u01b8\0\u01b8\0\u01e4\0\u0210"+
    "\0\u023c\0\u0268\0\u0294\0\u02c0\0\u02ec\0\334\0\334\0\334"+
    "\0\u0318\0\u0344\0\u0370\0\u039c\0\u03c8\0\u03f4\0\u0420\0\u044c"+
    "\0\u0478\0\u04a4\0\u04d0\0\u04fc\0\u0528\0\u0108\0\u0554\0\u0580"+
    "\0\u05ac\0\u05d8\0\u0604\0\334\0\u0630\0\334\0\334\0\u065c"+
    "\0\334\0\334\0\u0688\0\334\0\u06b4\0\u0160\0\334\0\u0108"+
    "\0\u06e0\0\u070c\0\u0738\0\u0764\0\u0790\0\u07bc\0\u07e8\0\u0814"+
    "\0\u0840\0\u086c\0\u0898\0\u08c4\0\u08f0\0\u091c\0\u0948\0\u0974"+
    "\0\u09a0\0\u09cc\0\u09f8\0\u0a24\0\u0a50\0\u0a7c\0\u0aa8\0\u0ad4"+
    "\0\u0b00\0\u0b2c\0\u0b58\0\u0b84\0\u0bb0\0\u0bdc\0\u0c08\0\u0c34"+
    "\0\u0c60\0\u0c8c\0\u0cb8\0\u0ce4\0\u0d10\0\u0d3c\0\u0d68\0\u0d94"+
    "\0\u0dc0\0\u0dec\0\u0e18\0\u0e44\0\u0e70\0\u0e9c\0\u0ec8\0\u0ef4"+
    "\0\u0f20\0\u0f4c\0\u0f78\0\u0fa4\0\u0fd0\0\u0ffc\0\u1028\0\u1054"+
    "\0\u1080\0\u10ac\0\u10d8\0\u1104\0\u1130\0\u115c\0\u1188\0\u11b4"+
    "\0\u11e0\0\u120c\0\u1238\0\u1264\0\u1290\0\u12bc\0\u12e8\0\u1314"+
    "\0\u1340\0\u136c\0\u1398\0\u13c4\0\u13f0\0\u141c\0\u1448\0\u1474"+
    "\0\u14a0\0\u14cc\0\u14f8\0\u1524\0\u1550\0\u157c\0\u15a8\0\u15d4"+
    "\0\u1600\0\u162c\0\u1658\0\u1684\0\u16b0\0\u16dc\0\u1708\0\u1734"+
    "\0\u1760\0\u178c\0\u17b8\0\u17e4\0\u1810\0\u183c\0\u1868\0\u1894"+
    "\0\u18c0\0\u18ec\0\u1918\0\u1944\0\u1970\0\u199c\0\u19c8\0\u19f4"+
    "\0\u1a20\0\u1a4c\0\u1a78\0\u1aa4\0\334\0\u1ad0\0\u1afc\0\u1b28"+
    "\0\u1b54\0\u1b80\0\u1bac\0\u1bd8\0\u1c04\0\u1c30\0\u1c5c\0\u1c88"+
    "\0\u1cb4\0\u1ce0\0\u1d0c\0\u1d38\0\u1d64\0\u1d90\0\u1dbc\0\u1de8"+
    "\0\u1e14\0\u1e40\0\u1e6c\0\u1e98\0\u1ec4\0\u1ef0\0\u1f1c\0\u1f48"+
    "\0\u1f74\0\u1fa0\0\u1fcc\0\u1ff8\0\u2024\0\u2050\0\u207c\0\u20a8"+
    "\0\u20d4\0\u2100\0\u212c\0\u2158\0\u2184\0\u21b0\0\u21dc\0\u2208"+
    "\0\u2234\0\u2260\0\u228c\0\u22b8\0\u22e4\0\u2310\0\u233c\0\u2368"+
    "\0\u2394\0\u23c0\0\u23ec\0\u2418\0\u2444\0\u2470\0\u249c\0\u24c8"+
    "\0\u24f4\0\u2520\0\u0108\0\u254c\0\u2578\0\u25a4\0\u25d0\0\u25fc"+
    "\0\u2628\0\u2654\0\u2680\0\u26ac\0\u26d8\0\u2704\0\u2730\0\u275c"+
    "\0\u2788\0\u27b4\0\u27e0\0\u280c\0\u2838\0\u2864\0\u2890\0\u28bc"+
    "\0\u28e8\0\u2914\0\u2940\0\u296c\0\u2998\0\u29c4\0\u29f0\0\u2a1c"+
    "\0\u2a48\0\u2a74\0\u2aa0\0\u2acc\0\u2af8\0\u2b24\0\u2b50\0\u2b7c"+
    "\0\u2ba8\0\u2bd4\0\u2c00\0\u2c2c\0\u2c58\0\u2c84\0\u2cb0\0\u2cdc"+
    "\0\u2d08\0\u2d34\0\u2d60\0\u2d8c\0\u2db8\0\u2de4\0\u2e10\0\u2e3c"+
    "\0\u2e68\0\u2e94\0\u2ec0\0\u2eec\0\u2f18\0\u2f44\0\u2f70\0\u2f9c"+
    "\0\u2fc8\0\u2ff4\0\u3020\0\u304c\0\u3078\0\u30a4\0\u30d0\0\u30fc"+
    "\0\u3128\0\u3154\0\u3180\0\u31ac\0\u31d8\0\u3204\0\u3230\0\u325c"+
    "\0\u3288\0\u32b4\0\u32e0\0\u330c\0\u3338\0\u3364\0\u3390\0\u33bc"+
    "\0\u33e8\0\u3414\0\u3440\0\u346c\0\u3498\0\u34c4\0\u34f0\0\334"+
    "\0\u351c\0\u3548\0\u3574\0\u35a0\0\u35cc\0\u35f8\0\u3624\0\u3650"+
    "\0\u367c\0\u36a8\0\u36d4\0\u3700\0\u372c\0\u3758\0\u3784\0\u37b0"+
    "\0\u37dc\0\u3808\0\u3834\0\u3860\0\u388c\0\u38b8\0\u38e4\0\u3910"+
    "\0\u393c\0\u3968\0\u3994\0\u39c0\0\u39ec\0\u3a18\0\u3a44\0\u3a70"+
    "\0\u3a9c\0\u3ac8\0\u3af4\0\u3b20\0\u3b4c\0\u3b78\0\u3ba4\0\u3bd0"+
    "\0\u3bfc\0\u3c28\0\u3c54\0\u3c80\0\u26ac\0\u3cac\0\u3cd8\0\u3d04"+
    "\0\u3d30\0\u3d5c\0\u3d88\0\u3db4\0\u3de0\0\u3e0c\0\u3e38\0\u3e64"+
    "\0\u3e90\0\u3ebc\0\u3ee8\0\u3f14\0\u3f40\0\u3f6c\0\u3f98\0\u3fc4"+
    "\0\u3ff0\0\u401c\0\u4048\0\u4074\0\u40a0\0\u40cc\0\u40f8\0\u4124"+
    "\0\u4150\0\u417c\0\u41a8\0\u41d4\0\u4200\0\u422c\0\u4258\0\u4284"+
    "\0\u42b0\0\u42dc\0\u4308\0\u1ff8\0\u4334\0\u4360\0\u438c\0\u43b8"+
    "\0\u43e4\0\u4410\0\u443c\0\u4468\0\u4494\0\u4308\0\u44c0\0\u44ec"+
    "\0\u4518\0\u4544\0\u4570\0\u459c\0\u45c8\0\u45f4\0\u4620\0\u464c"+
    "\0\u4678\0\u46a4\0\u46d0\0\u46fc\0\u4728\0\u4754\0\u4780\0\u47ac"+
    "\0\u47d8\0\u4804\0\u4830\0\u485c\0\u4888\0\u48b4\0\u48e0\0\u490c"+
    "\0\u4938\0\u4964\0\u4990\0\u49bc\0\u49e8\0\u4a14\0\u4a40\0\u4a6c"+
    "\0\u4a98\0\u4ac4\0\u4af0\0\u4b1c\0\u4b48\0\u4b74\0\u4ba0\0\u4bcc"+
    "\0\u4bf8\0\u4c24\0\u4c50\0\u4c7c\0\u4ca8\0\u4cd4\0\u4d00\0\u4d2c"+
    "\0\u4d58\0\u4d84\0\u4db0\0\u4ddc\0\u4e08\0\u4e34\0\u4e60\0\u4e8c"+
    "\0\u4eb8\0\u4ee4\0\u4f10\0\u4f3c\0\u4f68\0\u4f94\0\u4fc0\0\u4fec"+
    "\0\u5018\0\u5044\0\u5070\0\u509c\0\u50c8\0\u50f4\0\u5120\0\u514c"+
    "\0\u15d4\0\u5178\0\u51a4\0\u51d0\0\u51fc\0\u5228\0\u5254\0\u5280"+
    "\0\u52ac\0\u52d8\0\u5304\0\u5330\0\u535c\0\u5388\0\u53b4\0\u53e0"+
    "\0\u540c\0\u5438\0\u5464\0\u5490\0\u54bc\0\u54e8\0\u5514\0\u5540"+
    "\0\u556c\0\u5598\0\u55c4\0\u55f0\0\u561c\0\u5648\0\u5674\0\u56a0"+
    "\0\u56cc\0\u56f8\0\u5724\0\u5750\0\u577c\0\u57a8\0\u57d4\0\u5800"+
    "\0\u582c\0\u5858\0\u5884\0\u58b0\0\u58dc\0\u5908\0\u5934\0\u5960"+
    "\0\u598c\0\u59b8\0\u59e4\0\u5a10\0\u5a3c\0\u5a68\0\u5a94\0\u5ac0"+
    "\0\u5aec\0\u5b18\0\u5b44\0\u5b70\0\u5b9c\0\u5bc8\0\u5bf4\0\u5c20"+
    "\0\u5c4c\0\u5c78\0\u5ca4\0\u5cd0\0\u5cfc\0\u5d28\0\u5d54\0\u5d80"+
    "\0\u5dac\0\u5dd8\0\u5e04\0\u5e30\0\u5e5c\0\u5e88\0\u5eb4\0\u5ee0"+
    "\0\u5f0c\0\u5f38\0\u5f64\0\u5f90\0\u5fbc\0\u5fe8\0\u6014\0\u6040"+
    "\0\u606c\0\u6098\0\u60c4\0\u60f0\0\u611c\0\u6148\0\u6174\0\u61a0"+
    "\0\u61cc\0\u61f8\0\u6224\0\u6250\0\u627c\0\u62a8\0\u62d4\0\u6300"+
    "\0\u632c\0\u6358\0\u6384\0\u63b0\0\u63dc\0\u6408\0\u6434\0\u6460"+
    "\0\u648c\0\u64b8\0\u64e4\0\u6510\0\u653c\0\u6568\0\u6594\0\u65c0"+
    "\0\u65ec\0\u6618\0\u6644\0\u6670\0\u669c\0\u45f4\0\u66c8\0\u66f4"+
    "\0\u6720\0\u674c\0\u535c\0\u6778\0\u67a4\0\u67d0\0\u67fc\0\u6828"+
    "\0\u6854\0\u6880\0\u68ac\0\u68d8\0\u6904\0\u6930\0\u695c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[639];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\1\10\1\11\1\12\2\13\1\14\1\15"+
    "\1\16\1\13\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\10\1\45\1\46\1\47\1\10\1\50\1\51\3\10"+
    "\1\52\1\6\1\7\1\10\1\53\1\12\1\13\1\54"+
    "\1\14\1\15\1\16\1\13\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\10\1\45\1\46\1\47\1\10\1\50"+
    "\1\51\3\10\1\52\1\55\1\56\21\55\1\57\30\55"+
    "\1\60\1\61\22\60\1\62\27\60\1\63\1\64\4\63"+
    "\1\65\45\63\56\0\1\10\10\0\7\10\3\0\26\10"+
    "\4\0\1\11\52\0\1\66\10\0\7\66\3\0\26\66"+
    "\7\0\1\67\57\0\1\13\43\0\1\10\10\0\1\10"+
    "\1\70\1\71\2\10\1\72\1\10\3\0\4\10\1\73"+
    "\11\10\1\74\7\10\3\0\1\10\10\0\7\10\3\0"+
    "\10\10\1\75\15\10\3\0\1\10\10\0\1\70\6\10"+
    "\3\0\13\10\1\76\12\10\3\0\1\10\10\0\1\70"+
    "\3\10\1\70\2\10\3\0\4\10\1\77\6\10\1\100"+
    "\12\10\3\0\1\10\10\0\1\101\5\10\1\102\3\0"+
    "\1\10\1\103\1\10\1\104\1\105\6\10\1\46\12\10"+
    "\3\0\1\10\10\0\1\106\3\10\1\70\1\10\1\107"+
    "\3\0\1\10\1\110\11\10\1\111\12\10\3\0\1\10"+
    "\10\0\2\10\1\112\4\10\3\0\5\10\2\46\2\10"+
    "\1\113\14\10\3\0\1\10\10\0\2\10\1\114\1\10"+
    "\1\115\1\116\1\117\3\0\1\10\1\120\1\121\2\10"+
    "\1\122\4\10\1\123\13\10\3\0\1\10\10\0\2\10"+
    "\1\124\1\10\1\125\1\126\1\10\3\0\4\10\1\127"+
    "\2\10\1\130\2\10\1\131\2\10\1\132\1\133\7\10"+
    "\3\0\1\10\10\0\5\10\1\134\1\135\3\0\1\10"+
    "\1\136\1\10\1\137\1\140\5\10\1\141\1\142\12\10"+
    "\3\0\1\10\10\0\1\143\3\10\1\144\1\10\1\145"+
    "\3\0\1\10\1\146\13\10\1\147\10\10\3\0\1\10"+
    "\10\0\1\150\6\10\3\0\1\10\1\151\5\10\1\152"+
    "\1\153\15\10\3\0\1\10\10\0\1\154\5\10\1\155"+
    "\3\0\1\10\1\156\2\10\1\157\3\10\1\160\1\46"+
    "\1\10\1\46\12\10\3\0\1\10\10\0\5\10\1\161"+
    "\1\162\3\0\1\10\1\163\2\10\1\164\2\10\1\165"+
    "\3\10\1\166\12\10\3\0\1\10\10\0\1\167\1\170"+
    "\2\10\1\171\1\10\1\172\3\0\3\10\1\173\4\10"+
    "\1\174\2\10\1\175\1\176\2\10\1\177\5\10\1\46"+
    "\3\0\1\10\10\0\2\10\1\200\4\10\3\0\12\10"+
    "\1\201\13\10\3\0\1\10\10\0\1\202\5\10\1\203"+
    "\3\0\1\10\1\204\11\10\1\205\12\10\3\0\1\10"+
    "\10\0\5\10\1\206\1\207\3\0\1\10\1\210\1\211"+
    "\1\10\1\212\2\10\1\46\1\213\1\214\10\10\1\215"+
    "\3\10\3\0\1\10\10\0\4\10\1\216\1\124\1\10"+
    "\3\0\4\10\1\217\1\220\2\10\1\221\1\10\1\222"+
    "\6\10\1\223\4\10\3\0\1\10\10\0\1\224\4\10"+
    "\1\225\1\10\3\0\13\10\1\226\1\46\11\10\3\0"+
    "\1\10\10\0\1\227\6\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\1\10\1\230\13\10\1\147\10\10"+
    "\3\0\1\10\10\0\1\231\5\10\1\232\3\0\3\10"+
    "\1\233\22\10\14\0\1\234\1\235\1\236\1\237\1\240"+
    "\1\241\1\242\4\0\1\243\1\244\2\0\1\245\1\0"+
    "\1\246\1\247\1\250\1\251\2\0\1\252\1\0\1\253"+
    "\2\0\1\254\7\0\1\53\2\0\1\54\45\0\1\55"+
    "\1\0\21\55\1\0\30\55\1\60\1\0\22\60\1\0"+
    "\27\60\1\63\1\0\4\63\1\0\45\63\7\0\1\255"+
    "\46\0\1\10\10\0\7\10\3\0\5\10\1\256\20\10"+
    "\3\0\1\10\10\0\7\10\3\0\7\10\1\257\16\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\260\21\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\261\7\10"+
    "\1\262\13\10\3\0\1\10\10\0\6\10\1\213\3\0"+
    "\26\10\3\0\1\10\10\0\1\263\3\10\1\264\1\265"+
    "\1\266\3\0\2\10\1\267\1\270\1\10\1\271\1\272"+
    "\1\273\2\10\1\274\13\10\3\0\1\10\10\0\6\10"+
    "\1\124\3\0\13\10\1\275\12\10\3\0\1\10\10\0"+
    "\4\10\1\276\2\10\3\0\12\10\1\277\13\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\300\2\10\1\213"+
    "\1\10\1\301\14\10\3\0\1\10\10\0\4\10\1\302"+
    "\2\10\3\0\11\10\1\303\14\10\3\0\1\10\10\0"+
    "\7\10\3\0\12\10\1\257\2\10\1\304\10\10\3\0"+
    "\1\10\10\0\1\153\6\10\3\0\26\10\3\0\1\10"+
    "\10\0\1\305\6\10\3\0\1\10\1\306\6\10\1\307"+
    "\15\10\3\0\1\10\10\0\2\10\1\310\1\311\3\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\312\4\10"+
    "\3\0\7\10\1\313\5\10\1\314\10\10\3\0\1\10"+
    "\10\0\7\10\3\0\15\10\1\315\10\10\3\0\1\10"+
    "\10\0\3\10\1\46\3\10\3\0\7\10\1\316\12\10"+
    "\1\46\3\10\3\0\1\10\10\0\2\10\1\317\1\10"+
    "\1\320\2\10\3\0\6\10\1\321\1\322\2\10\1\323"+
    "\13\10\3\0\1\10\10\0\7\10\3\0\12\10\1\324"+
    "\13\10\3\0\1\10\10\0\7\10\3\0\10\10\1\325"+
    "\15\10\3\0\1\10\10\0\1\326\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\327\24\10"+
    "\3\0\1\10\10\0\2\10\1\330\4\10\3\0\26\10"+
    "\3\0\1\10\10\0\5\10\1\331\1\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\3\10\1\332\22\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\333\24\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\334\24\10"+
    "\3\0\1\10\10\0\7\10\3\0\5\10\1\46\20\10"+
    "\3\0\1\10\10\0\4\10\1\335\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\4\10\1\317\1\46\1\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\4\10\1\336"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\2\10\1\337"+
    "\23\10\3\0\1\10\10\0\7\10\3\0\12\10\1\340"+
    "\13\10\3\0\1\10\10\0\1\341\6\10\3\0\13\10"+
    "\1\342\12\10\3\0\1\10\10\0\6\10\1\220\3\0"+
    "\26\10\3\0\1\10\10\0\1\147\6\10\3\0\1\10"+
    "\1\343\11\10\1\72\12\10\3\0\1\10\10\0\7\10"+
    "\3\0\11\10\1\113\14\10\3\0\1\10\10\0\2\10"+
    "\1\344\1\10\1\345\1\346\1\10\3\0\4\10\1\347"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\1\10\1\350"+
    "\11\10\1\351\12\10\3\0\1\10\10\0\1\352\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\11\10"+
    "\1\353\1\10\1\350\12\10\3\0\1\10\10\0\2\10"+
    "\1\354\4\10\3\0\4\10\1\355\4\10\1\356\1\357"+
    "\1\360\5\10\1\46\4\10\3\0\1\10\10\0\7\10"+
    "\3\0\1\10\1\361\24\10\3\0\1\10\10\0\7\10"+
    "\3\0\11\10\1\362\14\10\3\0\1\10\10\0\3\10"+
    "\1\363\3\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\16\10\1\133\2\10\1\364\4\10\3\0\1\10"+
    "\10\0\7\10\3\0\1\10\1\365\24\10\3\0\1\10"+
    "\10\0\2\10\1\366\1\367\1\370\2\10\3\0\7\10"+
    "\1\371\1\10\1\372\1\373\13\10\3\0\1\10\10\0"+
    "\2\10\1\374\4\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\10\10\1\375\15\10\3\0\1\10\10\0"+
    "\2\10\1\46\4\10\3\0\26\10\3\0\1\10\10\0"+
    "\5\10\1\376\1\10\3\0\7\10\1\377\16\10\3\0"+
    "\1\10\10\0\7\10\3\0\7\10\1\u0100\16\10\3\0"+
    "\1\10\10\0\4\10\1\u0101\2\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\13\10\1\u0102\12\10\3\0"+
    "\1\10\10\0\7\10\3\0\11\10\1\u0103\14\10\3\0"+
    "\1\10\10\0\7\10\3\0\13\10\1\u0104\12\10\3\0"+
    "\1\10\10\0\5\10\1\u0105\1\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\2\10\1\u0106\23\10\3\0"+
    "\1\10\10\0\1\u0107\6\10\3\0\1\10\1\u0108\11\10"+
    "\1\u0109\12\10\3\0\1\10\10\0\5\10\1\u010a\1\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\u010b\4\10"+
    "\3\0\4\10\1\u010c\6\10\1\u010d\12\10\3\0\1\10"+
    "\10\0\4\10\1\46\1\u010e\1\10\3\0\26\10\3\0"+
    "\1\10\10\0\5\10\1\353\1\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\1\10\1\u010f\2\10\1\u0110"+
    "\1\46\5\10\1\u0111\12\10\3\0\1\10\10\0\3\10"+
    "\1\u0112\3\10\3\0\11\10\1\46\14\10\3\0\1\10"+
    "\10\0\7\10\3\0\1\10\1\u0113\24\10\3\0\1\10"+
    "\10\0\7\10\3\0\11\10\1\u0114\1\u0115\13\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\u0116\3\10\1\u0117"+
    "\15\10\3\0\1\10\10\0\7\10\3\0\11\10\1\u0118"+
    "\14\10\3\0\1\10\10\0\6\10\1\u0102\3\0\26\10"+
    "\3\0\1\10\10\0\4\10\1\u0119\1\10\1\u011a\3\0"+
    "\15\10\1\u011b\10\10\3\0\1\10\10\0\7\10\3\0"+
    "\5\10\1\352\20\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u011c\2\10\1\u011d\21\10\3\0\1\10\10\0"+
    "\3\10\1\u011e\3\10\3\0\7\10\1\u011f\16\10\3\0"+
    "\1\10\10\0\4\10\1\u0120\2\10\3\0\4\10\1\u0121"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\5\10\1\u0122"+
    "\20\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u0123"+
    "\12\10\3\0\1\10\10\0\1\u0124\6\10\3\0\2\10"+
    "\1\u0125\23\10\3\0\1\10\10\0\3\10\1\u0126\1\u0127"+
    "\2\10\3\0\4\10\1\u0128\1\46\20\10\3\0\1\10"+
    "\10\0\4\10\1\u0129\2\10\3\0\26\10\3\0\1\10"+
    "\10\0\1\u012a\3\10\1\u012b\1\10\1\u012c\3\0\13\10"+
    "\1\u012d\12\10\3\0\1\10\10\0\4\10\1\46\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u012e\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\1\u012f\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\3\10\1\u0130\22\10"+
    "\3\0\1\10\10\0\7\10\3\0\5\10\1\u0131\20\10"+
    "\3\0\1\10\10\0\7\10\3\0\7\10\1\46\16\10"+
    "\3\0\1\10\10\0\4\10\1\u0132\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\4\10\1\u0133\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\1\u0134\6\10\3\0\26\10\3\0"+
    "\1\10\10\0\5\10\1\362\1\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\1\10\1\u0135\24\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\u0136\3\10\1\u0137"+
    "\15\10\3\0\1\10\10\0\1\u0102\6\10\3\0\14\10"+
    "\1\u0138\11\10\3\0\1\10\10\0\5\10\1\u0139\1\10"+
    "\3\0\4\10\1\u013a\11\10\1\133\7\10\3\0\1\10"+
    "\10\0\6\10\1\u013b\3\0\26\10\3\0\1\10\10\0"+
    "\2\10\1\u013c\1\10\1\363\2\10\3\0\26\10\3\0"+
    "\1\10\10\0\1\u013d\5\10\1\302\3\0\26\10\16\0"+
    "\1\u013e\2\0\1\u013f\25\0\1\u0140\41\0\1\u0141\1\u0142"+
    "\47\0\1\u0143\42\0\1\u0144\17\0\1\u0145\43\0\1\u0146"+
    "\3\0\1\u0147\3\0\1\u0148\26\0\1\u0149\24\0\1\u014a"+
    "\30\0\1\u014b\15\0\1\u0148\62\0\1\u014c\47\0\1\u014d"+
    "\1\0\1\u014e\34\0\1\u014f\16\0\1\u0148\32\0\1\u0150"+
    "\7\0\1\u0151\5\0\1\u0152\3\0\1\u0153\27\0\1\u0154"+
    "\21\0\1\u0155\27\0\1\u0156\12\0\1\u0157\62\0\1\u0158"+
    "\32\0\1\u0159\24\0\1\u0148\25\0\1\u015a\61\0\1\u015b"+
    "\6\0\1\u015c\25\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\u015d\2\10\1\u015e\16\10\3\0\1\10\10\0\1\46"+
    "\6\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\13\10\1\365\12\10\3\0\1\10\10\0\1\u015f\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\5\10\1\u0160\1\10"+
    "\3\0\1\10\1\u0161\11\10\1\350\12\10\3\0\1\10"+
    "\10\0\7\10\3\0\16\10\1\u0162\7\10\3\0\1\10"+
    "\10\0\1\46\5\10\1\u0163\3\0\7\10\1\u0164\16\10"+
    "\3\0\1\10\10\0\1\u0165\6\10\3\0\26\10\3\0"+
    "\1\10\10\0\2\10\1\u0166\4\10\3\0\26\10\3\0"+
    "\1\10\10\0\1\224\6\10\3\0\3\10\1\u0167\22\10"+
    "\3\0\1\10\10\0\1\143\6\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\10\10\1\u0168\15\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\366\21\10\3\0"+
    "\1\10\10\0\7\10\3\0\3\10\1\173\22\10\3\0"+
    "\1\10\10\0\7\10\3\0\1\10\1\124\2\10\1\u0169"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\10\10\1\u016a"+
    "\15\10\3\0\1\10\10\0\7\10\3\0\13\10\1\46"+
    "\12\10\3\0\1\10\10\0\4\10\1\u016b\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\11\10\1\u016c"+
    "\14\10\3\0\1\10\10\0\7\10\3\0\12\10\1\u016d"+
    "\13\10\3\0\1\10\10\0\5\10\1\257\1\10\3\0"+
    "\26\10\3\0\1\10\10\0\1\u016e\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\5\10\1\u016f\1\10\3\0\10\10"+
    "\1\u016d\15\10\3\0\1\10\10\0\7\10\3\0\1\10"+
    "\1\u0170\24\10\3\0\1\10\10\0\2\10\1\u0171\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\u0172\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\3\10\1\u0173\3\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\341\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\1\u0174\6\10\3\0\17\10"+
    "\1\46\6\10\3\0\1\10\10\0\4\10\1\u0175\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\366\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\362\4\10\1\257"+
    "\1\10\3\0\26\10\3\0\1\10\10\0\4\10\1\u0176"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\1\365\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u0177\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\6\10\1\302\3\0\13\10"+
    "\1\u0178\12\10\3\0\1\10\10\0\1\342\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\10\10\1\213"+
    "\15\10\3\0\1\10\10\0\7\10\3\0\13\10\1\350"+
    "\12\10\3\0\1\10\10\0\5\10\1\331\1\10\3\0"+
    "\11\10\1\u0179\14\10\3\0\1\10\10\0\7\10\3\0"+
    "\11\10\1\u017a\14\10\3\0\1\10\10\0\7\10\3\0"+
    "\7\10\1\u017b\16\10\3\0\1\10\10\0\7\10\3\0"+
    "\6\10\1\u017c\17\10\3\0\1\10\10\0\5\10\1\u017d"+
    "\1\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u017e\24\10\3\0\1\10\10\0\4\10\1\u017f"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\3\10\1\u0180"+
    "\3\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\4\10\1\u0181\21\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0182\24\10\3\0\1\10\10\0\1\u0183\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u0184\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\2\10\1\124\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\4\10\1\213"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\7\10\1\u0185"+
    "\16\10\3\0\1\10\10\0\7\10\3\0\2\10\1\u0186"+
    "\23\10\3\0\1\10\10\0\7\10\3\0\1\10\1\u0187"+
    "\24\10\3\0\1\10\10\0\1\u0188\4\10\1\46\1\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\5\10"+
    "\1\u0189\20\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\u0116\21\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\276\21\10\3\0\1\10\10\0\7\10\3\0\1\10"+
    "\1\u018a\24\10\3\0\1\10\10\0\4\10\1\u018b\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\353\21\10\3\0\1\10\10\0\7\10\3\0\12\10"+
    "\1\u018c\13\10\3\0\1\10\10\0\7\10\3\0\14\10"+
    "\1\353\11\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\u018d\21\10\3\0\1\10\10\0\7\10\3\0\5\10"+
    "\1\364\20\10\3\0\1\10\10\0\5\10\1\46\1\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\3\10"+
    "\1\46\22\10\3\0\1\10\10\0\6\10\1\u018e\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\4\10\1\46"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\1\10\1\u0108"+
    "\24\10\3\0\1\10\10\0\6\10\1\u018f\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\u0190\6\10"+
    "\1\u0191\15\10\3\0\1\10\10\0\1\213\6\10\3\0"+
    "\12\10\1\u0192\13\10\3\0\1\10\10\0\7\10\3\0"+
    "\13\10\1\u0193\12\10\3\0\1\10\10\0\5\10\1\u0194"+
    "\1\10\3\0\13\10\1\350\12\10\3\0\1\10\10\0"+
    "\3\10\1\257\3\10\3\0\5\10\1\u0195\11\10\1\353"+
    "\6\10\3\0\1\10\10\0\7\10\3\0\15\10\1\u0196"+
    "\10\10\3\0\1\10\10\0\1\u018a\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u0197\23\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u0198\7\10"+
    "\1\u0199\4\10\1\46\6\10\3\0\1\10\10\0\7\10"+
    "\3\0\1\10\1\u019a\24\10\3\0\1\10\10\0\7\10"+
    "\3\0\12\10\1\46\13\10\3\0\1\10\10\0\7\10"+
    "\3\0\11\10\1\u0182\14\10\3\0\1\10\10\0\7\10"+
    "\3\0\22\10\1\u019b\3\10\3\0\1\10\10\0\1\u019c"+
    "\6\10\3\0\26\10\3\0\1\10\10\0\4\10\1\u019d"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\1\10\1\46"+
    "\5\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\11\10\1\257\14\10\3\0\1\10\10\0\7\10\3\0"+
    "\11\10\1\46\14\10\3\0\1\10\10\0\6\10\1\u019e"+
    "\3\0\26\10\3\0\1\10\10\0\4\10\1\u019f\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\11\10"+
    "\1\u01a0\14\10\3\0\1\10\10\0\4\10\1\u01a1\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u01a2\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\2\10\1\u01a3\4\10\3\0"+
    "\4\10\1\u01a4\21\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u01a5\24\10\3\0\1\10\10\0\7\10\3\0"+
    "\12\10\1\u01a6\13\10\3\0\1\10\10\0\2\10\1\u01a7"+
    "\4\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\4\10\1\u01a8\21\10\3\0\1\10\10\0\7\10\3\0"+
    "\11\10\1\u01a9\3\10\1\u0182\10\10\3\0\1\10\10\0"+
    "\7\10\3\0\21\10\1\147\4\10\3\0\1\10\10\0"+
    "\4\10\1\353\2\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\4\10\1\u01aa\21\10\3\0\1\10\10\0"+
    "\7\10\3\0\15\10\1\u01ab\10\10\3\0\1\10\10\0"+
    "\6\10\1\362\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\13\10\1\153\5\10\1\u01ac\4\10\3\0\1\10"+
    "\10\0\7\10\3\0\10\10\1\u01ad\15\10\3\0\1\10"+
    "\10\0\2\10\1\u01ae\4\10\3\0\26\10\3\0\1\10"+
    "\10\0\3\10\1\257\3\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\4\10\1\u01af\21\10\3\0\1\10"+
    "\10\0\7\10\3\0\7\10\1\u01b0\16\10\3\0\1\10"+
    "\10\0\6\10\1\u01b1\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\17\10\1\46\6\10\3\0\1\10\10\0"+
    "\1\362\5\10\1\u01b2\3\0\26\10\3\0\1\10\10\0"+
    "\4\10\1\u01b3\2\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\24\10\1\124\1\10\3\0\1\10\10\0"+
    "\4\10\1\u01b4\2\10\3\0\26\10\3\0\1\10\10\0"+
    "\1\u01b5\6\10\3\0\26\10\3\0\1\10\10\0\4\10"+
    "\1\u01b6\2\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\11\10\1\u01b7\14\10\3\0\1\10\10\0\2\10"+
    "\1\46\4\10\3\0\7\10\1\u01b8\16\10\3\0\1\10"+
    "\10\0\7\10\3\0\5\10\1\u01b9\1\u01ba\17\10\3\0"+
    "\1\10\10\0\1\u01bb\6\10\3\0\5\10\1\u01bc\20\10"+
    "\3\0\1\10\10\0\2\10\1\u01bd\4\10\3\0\26\10"+
    "\3\0\1\10\10\0\4\10\1\u01be\2\10\3\0\2\10"+
    "\1\46\23\10\3\0\1\10\10\0\2\10\1\u01bf\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\u01c0\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u01c1\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\1\u01c2\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\1\365\6\10\3\0\12\10\1\323"+
    "\13\10\3\0\1\10\10\0\5\10\1\u01c3\1\u01c4\3\0"+
    "\7\10\1\u01c5\16\10\3\0\1\10\10\0\7\10\3\0"+
    "\4\10\1\u01c6\21\10\3\0\1\10\10\0\2\10\1\u0121"+
    "\4\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\5\10\1\317\20\10\3\0\1\10\10\0\2\10\1\u01c7"+
    "\4\10\3\0\26\10\3\0\1\10\10\0\5\10\1\u01c8"+
    "\1\10\3\0\26\10\3\0\1\10\10\0\6\10\1\201"+
    "\3\0\10\10\1\257\15\10\3\0\1\10\10\0\6\10"+
    "\1\u01c9\3\0\26\10\3\0\1\10\10\0\3\10\1\u01ca"+
    "\3\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\5\10\1\u01cb\20\10\3\0\1\10\10\0\2\10\1\46"+
    "\4\10\3\0\4\10\1\257\21\10\33\0\1\u0148\55\0"+
    "\1\u01cc\45\0\1\u01cd\54\0\1\u0151\5\0\1\u01ce\3\0"+
    "\1\u01cf\51\0\1\u0155\1\u01d0\27\0\1\u0159\17\0\1\u01d1"+
    "\5\0\1\u01d2\51\0\1\u01d3\32\0\1\u0147\47\0\1\u01d4"+
    "\100\0\1\u0148\30\0\1\u01d5\1\0\1\u0148\63\0\1\u0140"+
    "\53\0\1\u01d6\2\0\1\u01d7\4\0\1\251\54\0\1\u01d8"+
    "\47\0\1\u0148\56\0\1\u01d9\50\0\1\u01da\50\0\1\u0148"+
    "\50\0\1\u01d4\64\0\1\u01db\2\0\1\u01dc\45\0\1\u01dd"+
    "\33\0\1\u0159\2\0\1\u01de\63\0\1\u01df\41\0\1\u013e"+
    "\65\0\1\u01e0\43\0\1\u0148\71\0\1\u01e1\57\0\1\u01e2"+
    "\27\0\1\u01e3\57\0\1\u01e4\34\0\1\10\10\0\7\10"+
    "\3\0\7\10\1\152\16\10\3\0\1\10\10\0\7\10"+
    "\3\0\1\10\1\220\24\10\3\0\1\10\10\0\7\10"+
    "\3\0\12\10\1\213\13\10\3\0\1\10\10\0\7\10"+
    "\3\0\13\10\1\u01e5\12\10\3\0\1\10\10\0\2\10"+
    "\1\u01e6\4\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\12\10\1\u01e7\13\10\3\0\1\10\10\0\4\10"+
    "\1\u01e8\2\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\13\10\1\u01e9\12\10\3\0\1\10\10\0\3\10"+
    "\1\311\3\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\12\10\1\323\13\10\3\0\1\10\10\0\7\10"+
    "\3\0\1\10\1\u01ea\24\10\3\0\1\10\10\0\7\10"+
    "\3\0\12\10\1\u01eb\13\10\3\0\1\10\10\0\6\10"+
    "\1\u01ec\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\12\10\1\u01ed\13\10\3\0\1\10\10\0\6\10\1\u01ee"+
    "\3\0\26\10\3\0\1\10\10\0\6\10\1\u01ef\3\0"+
    "\26\10\3\0\1\10\10\0\5\10\1\u01af\1\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\12\10\1\u01f0"+
    "\13\10\3\0\1\10\10\0\1\u01f1\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\4\10\1\u01f2\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\7\10\1\u01f3\16\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u019b\23\10"+
    "\3\0\1\10\10\0\4\10\1\363\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\1\10\1\220\5\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u01f4\23\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\u01f5\21\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\u01f6\21\10"+
    "\3\0\1\10\10\0\1\u01f7\6\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\12\10\1\u01f8\13\10\3\0"+
    "\1\10\10\0\4\10\1\u017d\2\10\3\0\26\10\3\0"+
    "\1\10\10\0\6\10\1\u01f9\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\1\46\25\10\3\0\1\10\10\0"+
    "\7\10\3\0\4\10\1\u01fa\21\10\3\0\1\10\10\0"+
    "\7\10\3\0\1\10\1\u017d\24\10\3\0\1\10\10\0"+
    "\1\u017d\6\10\3\0\26\10\3\0\1\10\10\0\6\10"+
    "\1\u01fb\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\14\10\1\46\11\10\3\0\1\10\10\0\2\10\1\361"+
    "\4\10\3\0\26\10\3\0\1\10\10\0\2\10\1\u01fc"+
    "\4\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\7\10\1\u01fd\16\10\3\0\1\10\10\0\1\362\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\5\10\1\u01fe\1\10"+
    "\3\0\26\10\3\0\1\10\10\0\2\10\1\u01ff\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\7\10"+
    "\1\u0200\16\10\3\0\1\10\10\0\4\10\1\257\2\10"+
    "\3\0\26\10\3\0\1\10\10\0\1\u0201\6\10\3\0"+
    "\4\10\1\u0202\21\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0203\6\10\1\u018a\15\10\3\0\1\10\10\0"+
    "\7\10\3\0\5\10\1\u0204\20\10\3\0\1\10\10\0"+
    "\2\10\1\u0205\4\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\7\10\1\u0206\16\10\3\0\1\10\10\0"+
    "\6\10\1\153\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\4\10\1\153\21\10\3\0\1\10\10\0\7\10"+
    "\3\0\13\10\1\u0207\12\10\3\0\1\10\10\0\7\10"+
    "\3\0\21\10\1\257\4\10\3\0\1\10\10\0\7\10"+
    "\3\0\1\10\1\u0208\24\10\3\0\1\10\10\0\7\10"+
    "\3\0\13\10\1\u0109\12\10\3\0\1\10\10\0\7\10"+
    "\3\0\11\10\1\75\14\10\3\0\1\10\10\0\1\u0183"+
    "\6\10\3\0\4\10\1\u0209\21\10\3\0\1\10\10\0"+
    "\7\10\3\0\4\10\1\376\21\10\3\0\1\10\10\0"+
    "\5\10\1\336\1\10\3\0\26\10\3\0\1\10\10\0"+
    "\5\10\1\u020a\1\10\3\0\7\10\1\u020b\16\10\3\0"+
    "\1\10\10\0\7\10\3\0\13\10\1\u020c\12\10\3\0"+
    "\1\10\10\0\7\10\3\0\13\10\1\u020d\12\10\3\0"+
    "\1\10\10\0\7\10\3\0\7\10\1\u0116\16\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\u020e\21\10\3\0"+
    "\1\10\10\0\7\10\3\0\1\10\1\u0116\5\10\1\353"+
    "\16\10\3\0\1\10\10\0\2\10\1\u020f\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\2\10\1\213"+
    "\23\10\3\0\1\10\10\0\7\10\3\0\5\10\1\u0210"+
    "\20\10\3\0\1\10\10\0\4\10\1\u0211\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\4\10\1\u0212\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u0213"+
    "\12\10\3\0\1\10\10\0\1\u0214\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\u0215\24\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u0216\23\10"+
    "\3\0\1\10\10\0\7\10\3\0\13\10\1\362\12\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\u0217\24\10"+
    "\3\0\1\10\10\0\7\10\3\0\6\10\1\u0218\17\10"+
    "\3\0\1\10\10\0\7\10\3\0\7\10\1\353\16\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\u0219\24\10"+
    "\3\0\1\10\10\0\6\10\1\u018e\3\0\13\10\1\u020c"+
    "\12\10\3\0\1\10\10\0\2\10\1\u021a\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\6\10\1\u0182"+
    "\17\10\3\0\1\10\10\0\4\10\1\317\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\10\10\1\u021b"+
    "\15\10\3\0\1\10\10\0\7\10\3\0\7\10\1\u021c"+
    "\5\10\1\u0182\10\10\3\0\1\10\10\0\1\u0191\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\2\10"+
    "\1\u021d\4\10\1\46\16\10\3\0\1\10\10\0\7\10"+
    "\3\0\10\10\1\u0109\15\10\3\0\1\10\10\0\6\10"+
    "\1\u01a2\3\0\26\10\3\0\1\10\10\0\6\10\1\u021e"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\16\10"+
    "\1\u021f\7\10\3\0\1\10\10\0\1\u0220\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\4\10\1\u0221\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\13\10\1\353"+
    "\12\10\3\0\1\10\10\0\7\10\3\0\10\10\1\353"+
    "\15\10\3\0\1\10\10\0\7\10\3\0\2\10\1\u0160"+
    "\23\10\3\0\1\10\10\0\7\10\3\0\4\10\1\u0222"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\4\10\1\u0223"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u0224"+
    "\12\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u011c"+
    "\12\10\3\0\1\10\10\0\7\10\3\0\1\10\1\u0225"+
    "\24\10\3\0\1\10\10\0\5\10\1\336\1\10\3\0"+
    "\12\10\1\u0226\13\10\3\0\1\10\10\0\7\10\3\0"+
    "\5\10\1\220\20\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0227\24\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0228\24\10\3\0\1\10\10\0\7\10\3\0"+
    "\3\10\1\213\22\10\3\0\1\10\10\0\7\10\3\0"+
    "\13\10\1\u0229\12\10\14\0\1\u0148\60\0\1\u0148\75\0"+
    "\1\u01dc\45\0\1\u022a\36\0\1\u01cc\53\0\1\u0150\50\0"+
    "\1\u0159\101\0\1\u0140\26\0\1\u0148\54\0\1\u022b\55\0"+
    "\1\u022c\46\0\1\u022d\71\0\1\u0158\63\0\1\u0148\51\0"+
    "\1\u022e\27\0\1\u022f\74\0\1\u01d1\32\0\1\u0230\2\0"+
    "\1\u0231\10\0\1\u0232\1\0\1\u0233\1\0\1\u0234\3\0"+
    "\1\u0235\35\0\1\u01cd\60\0\1\u013f\56\0\1\u0147\62\0"+
    "\1\u01d0\45\0\1\u0236\53\0\1\u0237\41\0\1\u01cc\35\0"+
    "\1\10\10\0\7\10\3\0\5\10\1\u0238\20\10\3\0"+
    "\1\10\10\0\7\10\3\0\5\10\1\u0239\20\10\3\0"+
    "\1\10\10\0\7\10\3\0\1\10\1\u0161\24\10\3\0"+
    "\1\10\10\0\5\10\1\u016f\1\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\u023a\21\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\u023b\21\10\3\0"+
    "\1\10\10\0\7\10\3\0\17\10\1\u023c\6\10\3\0"+
    "\1\10\10\0\2\10\1\213\4\10\3\0\26\10\3\0"+
    "\1\10\10\0\7\10\3\0\6\10\1\u023d\6\10\1\u0182"+
    "\10\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u023e"+
    "\12\10\3\0\1\10\10\0\2\10\1\u023f\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\5\10\1\u0240\1\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\11\10\1\u0241"+
    "\14\10\3\0\1\10\10\0\7\10\3\0\6\10\1\u0242"+
    "\3\10\1\u0243\13\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0244\24\10\3\0\1\10\10\0\7\10\3\0"+
    "\7\10\1\u010e\16\10\3\0\1\10\10\0\7\10\3\0"+
    "\11\10\1\u0245\14\10\3\0\1\10\10\0\7\10\3\0"+
    "\4\10\1\u0246\21\10\3\0\1\10\10\0\7\10\3\0"+
    "\13\10\1\u0247\12\10\3\0\1\10\10\0\5\10\1\u0180"+
    "\1\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0248\24\10\3\0\1\10\10\0\7\10\3\0"+
    "\15\10\1\46\10\10\3\0\1\10\10\0\7\10\3\0"+
    "\5\10\1\353\20\10\3\0\1\10\10\0\1\220\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\13\10"+
    "\1\u0249\12\10\3\0\1\10\10\0\7\10\3\0\5\10"+
    "\1\u024a\20\10\3\0\1\10\10\0\7\10\3\0\20\10"+
    "\1\46\5\10\3\0\1\10\10\0\2\10\1\u024b\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\1\10"+
    "\1\u024c\24\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\u0238\21\10\3\0\1\10\10\0\6\10\1\u024d\3\0"+
    "\26\10\3\0\1\10\10\0\3\10\1\46\3\10\3\0"+
    "\26\10\3\0\1\10\10\0\4\10\1\u0215\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\2\10\1\72\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\2\10\1\257"+
    "\23\10\3\0\1\10\10\0\6\10\1\u024e\3\0\26\10"+
    "\3\0\1\10\10\0\6\10\1\u024f\3\0\26\10\3\0"+
    "\1\10\10\0\1\u024b\6\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\21\10\1\317\4\10\3\0\1\10"+
    "\10\0\7\10\3\0\4\10\1\220\21\10\3\0\1\10"+
    "\10\0\1\u0249\6\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\13\10\1\u018a\12\10\3\0\1\10\10\0"+
    "\7\10\3\0\1\10\1\u0250\24\10\3\0\1\10\10\0"+
    "\7\10\3\0\7\10\1\u015e\16\10\3\0\1\10\10\0"+
    "\7\10\3\0\1\10\1\46\24\10\3\0\1\10\10\0"+
    "\2\10\1\46\4\10\3\0\6\10\1\u0251\17\10\3\0"+
    "\1\10\10\0\7\10\3\0\15\10\1\u0252\10\10\3\0"+
    "\1\10\10\0\7\10\3\0\4\10\1\357\21\10\3\0"+
    "\1\10\10\0\1\u0253\6\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\4\10\1\u0254\21\10\3\0\1\10"+
    "\10\0\7\10\3\0\6\10\1\u0255\17\10\3\0\1\10"+
    "\10\0\4\10\1\u0238\2\10\3\0\26\10\3\0\1\10"+
    "\10\0\3\10\1\220\3\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\4\10\1\257\21\10\3\0\1\10"+
    "\10\0\6\10\1\u0256\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\1\10\1\u0257\24\10\3\0\1\10\10\0"+
    "\7\10\3\0\16\10\1\46\7\10\3\0\1\10\10\0"+
    "\7\10\3\0\12\10\1\353\13\10\3\0\1\10\10\0"+
    "\7\10\3\0\6\10\1\353\17\10\3\0\1\10\10\0"+
    "\1\365\3\10\1\u01be\2\10\3\0\26\10\3\0\1\10"+
    "\10\0\7\10\3\0\22\10\1\u0258\3\10\3\0\1\10"+
    "\10\0\7\10\3\0\15\10\1\u0182\10\10\3\0\1\10"+
    "\10\0\7\10\3\0\1\10\1\u01fc\24\10\3\0\1\10"+
    "\10\0\7\10\3\0\21\10\1\u0238\4\10\3\0\1\10"+
    "\10\0\7\10\3\0\4\10\1\u0169\21\10\3\0\1\10"+
    "\10\0\7\10\3\0\15\10\1\u0186\10\10\3\0\1\10"+
    "\10\0\7\10\3\0\15\10\1\u0259\10\10\3\0\1\10"+
    "\10\0\7\10\3\0\22\10\1\46\3\10\34\0\1\u0234"+
    "\37\0\1\u025a\71\0\1\u025b\61\0\1\u0148\30\0\1\u025c"+
    "\64\0\1\u025d\65\0\1\u025e\2\0\1\u025f\20\0\1\u0158"+
    "\66\0\1\u0260\64\0\1\251\51\0\1\u0261\47\0\1\u0262"+
    "\35\0\1\u0263\100\0\1\u0264\15\0\1\10\10\0\1\353"+
    "\6\10\3\0\26\10\3\0\1\10\10\0\4\10\1\u0265"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\4\10\1\u0266"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\1\10\1\u0267\24\10\3\0\1\10\10\0\1\u0182\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\13\10"+
    "\1\u0178\12\10\3\0\1\10\10\0\2\10\1\u01f1\4\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\1\10"+
    "\1\362\24\10\3\0\1\10\10\0\7\10\3\0\13\10"+
    "\1\u0116\12\10\3\0\1\10\10\0\1\u0268\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u0269"+
    "\12\10\3\0\1\10\10\0\7\10\3\0\13\10\1\u026a"+
    "\12\10\3\0\1\10\10\0\7\10\3\0\4\10\1\124"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\1\10\1\213"+
    "\24\10\3\0\1\10\10\0\6\10\1\u026b\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\u026c\21\10"+
    "\3\0\1\10\10\0\7\10\3\0\2\10\1\u026d\23\10"+
    "\3\0\1\10\10\0\3\10\1\353\3\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\1\10\1\355\24\10"+
    "\3\0\1\10\10\0\4\10\1\u026e\2\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\7\10\1\213\16\10"+
    "\3\0\1\10\10\0\2\10\1\u026f\4\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\15\10\1\257\10\10"+
    "\3\0\1\10\10\0\2\10\1\u0270\4\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\u01fc\21\10"+
    "\3\0\1\10\10\0\7\10\3\0\6\10\1\46\17\10"+
    "\3\0\1\10\10\0\7\10\3\0\10\10\1\u0271\15\10"+
    "\3\0\1\10\10\0\7\10\3\0\25\10\1\46\3\0"+
    "\1\10\10\0\6\10\1\u01af\3\0\26\10\3\0\1\10"+
    "\10\0\1\u0272\6\10\3\0\26\10\3\0\1\10\10\0"+
    "\7\10\3\0\23\10\1\257\2\10\3\0\1\10\10\0"+
    "\7\10\3\0\4\10\1\347\21\10\3\0\1\10\10\0"+
    "\6\10\1\72\3\0\26\10\3\0\1\10\10\0\5\10"+
    "\1\u0273\1\10\3\0\26\10\31\0\1\u0148\55\0\1\u01cc"+
    "\47\0\1\u01d9\41\0\1\u0148\52\0\1\u0274\66\0\1\u0275"+
    "\45\0\1\u01cd\50\0\1\u0274\76\0\1\u013e\46\0\1\u0148"+
    "\67\0\1\u0148\6\0\1\10\10\0\7\10\3\0\1\10"+
    "\1\u0276\24\10\3\0\1\10\10\0\1\124\6\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\2\10\1\u0277"+
    "\23\10\3\0\1\10\10\0\2\10\1\u0278\4\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\4\10\1\u0109"+
    "\21\10\3\0\1\10\10\0\7\10\3\0\7\10\1\u0238"+
    "\16\10\3\0\1\10\10\0\7\10\3\0\2\10\1\u017d"+
    "\23\10\3\0\1\10\10\0\7\10\3\0\1\10\1\u0279"+
    "\24\10\3\0\1\10\10\0\4\10\1\u027a\2\10\3\0"+
    "\26\10\3\0\1\10\10\0\7\10\3\0\1\10\1\u027b"+
    "\24\10\3\0\1\10\10\0\1\u0189\6\10\3\0\26\10"+
    "\3\0\1\10\10\0\7\10\3\0\6\10\1\u027c\17\10"+
    "\3\0\1\10\10\0\7\10\3\0\4\10\1\u0266\21\10"+
    "\30\0\1\u0148\44\0\1\u0263\35\0\1\10\10\0\7\10"+
    "\3\0\15\10\1\220\10\10\3\0\1\10\10\0\4\10"+
    "\1\u027d\2\10\3\0\26\10\3\0\1\10\10\0\4\10"+
    "\1\220\2\10\3\0\26\10\3\0\1\10\10\0\7\10"+
    "\3\0\4\10\1\u027e\21\10\3\0\1\10\10\0\1\u027f"+
    "\6\10\3\0\26\10\3\0\1\10\10\0\4\10\1\u0273"+
    "\2\10\3\0\26\10\3\0\1\10\10\0\7\10\3\0"+
    "\6\10\1\u027d\17\10\3\0\1\10\10\0\1\u020d\6\10"+
    "\3\0\26\10\3\0\1\10\10\0\7\10\3\0\14\10"+
    "\1\u017d\11\10\3\0\1\10\10\0\7\10\3\0\4\10"+
    "\1\u017d\21\10\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[27016];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\11\3\1\1\11\12\1\3\11\23\1\1\11"+
    "\1\1\2\11\1\1\2\11\1\1\1\11\2\1\1\11"+
    "\144\1\21\0\1\11\220\1\7\0\1\1\2\0\1\11"+
    "\24\0\157\1\12\0\1\1\16\0\105\1\16\0\42\1"+
    "\13\0\17\1\2\0\12\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[639];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public SASTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "*", null };
	}


	/**
	 * Returns whether tokens of the specified type should have "mark
	 * occurrences" enabled for the current programming language.
	 *
	 * @param type The token type.
	 * @return Whether tokens of this type should have "mark occurrences"
	 *         enabled.
	 */
	@Override
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==Token.IDENTIFIER || type==Token.VARIABLE;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR;
				start = text.offset;
				break;
			case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			default:
				state = YYINITIAL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SASTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public SASTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 180) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r':
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof)
              zzAtBOL = false;
            else
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 13:
          { yybegin(YYINITIAL); addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 21: break;
        case 2:
          { addNullToken(); return firstToken;
          }
        case 22: break;
        case 18:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 23: break;
        case 17:
          { start = zzMarkedPos-2; yybegin(MLC);
          }
        case 24: break;
        case 3:
          { addToken(Token.WHITESPACE);
          }
        case 25: break;
        case 8:
          { start = zzMarkedPos-1; yybegin(CHAR);
          }
        case 26: break;
        case 5:
          { addToken(Token.RESERVED_WORD);
          }
        case 27: break;
        case 6:
          { addToken(Token.SEPARATOR);
          }
        case 28: break;
        case 16:
          { addToken(Token.VARIABLE);
          }
        case 29: break;
        case 14:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 30: break;
        case 1:
          { addToken(Token.IDENTIFIER);
          }
        case 31: break;
        case 20:
          { addToken(Token.FUNCTION);
          }
        case 32: break;
        case 19:
          { addToken(Token.DATA_TYPE);
          }
        case 33: break;
        case 11:
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 34: break;
        case 9:
          { // We must do this because of how we
									// abuse JFlex; since we return an entire
									// list of tokens at once instead of a
									// single token at a time, the "^" regex
									// character doesn't really work, so we must
									// check that we're at the beginning of a
									// line ourselves.
									start = zzStartRead;
									// Might not be any whitespace.
									if (yylength()>1) {
										addToken(zzStartRead,zzMarkedPos-2, Token.WHITESPACE);
										zzStartRead = zzMarkedPos-1;
									}
									// Remember:  zzStartRead may now be updated,
									// so we must check against 'start'.
									if (start==s.offset) {
										addToken(zzStartRead,zzEndRead, Token.COMMENT_EOL);
										addNullToken();
										return firstToken;
									}
									else {
										addToken(zzStartRead,zzStartRead, Token.OPERATOR);
									}
          }
        case 35: break;
        case 7:
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 36: break;
        case 4:
          { addToken(Token.OPERATOR);
          }
        case 37: break;
        case 12:
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 38: break;
        case 10:
          {
          }
        case 39: break;
        case 15:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 40: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 640: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 641: break;
            case MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 642: break;
            case CHAR: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 643: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
