/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ctags;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.fife.ctags.TagEntry;
import org.fife.ctags.TagFileInfo;

public class CTagReader {
    public static final byte TAG_UNSORTED = 1;
    public static final byte TAG_SORTED = 2;
    public static final byte TAG_FOLDSORTED = 3;
    public static final int TAG_FULLMATCH = 0;
    public static final int TAG_PARTIALMATCH = 1;
    public static final int TAG_OBSERVECASE = 0;
    public static final int TAG_IGNORECASE = 2;
    public static final int TAGRESULT_FAILURE = 0;
    public static final int TAGRESULT_SUCCESS = 1;
    private static final int JUMP_BACK = 512;
    public static final String EmptyString = "";
    public static final String PseudoTagPrefix = "!_";
    private boolean initialized;
    private int format;
    private int sortMethod;
    private RandomAccessFile fp;
    private long pos;
    private long size;
    private String line;
    private String name;
    private String searchName;
    private boolean searchPartial;
    private boolean searchIgnoreCase;
    private String programAuthor;
    private String programName;
    private String programUrl;
    private String programVersion;

    private boolean find(TagEntry entry, String name, int options) throws IOException {
        boolean result = false;
        this.searchName = name;
        this.searchPartial = (options & 1) != 0;
        this.searchIgnoreCase = (options & 2) != 0;
        this.fp.seek(0L);
        result = this.sortMethod == 2 && !this.searchIgnoreCase || this.sortMethod == 3 && this.searchIgnoreCase ? this.findBinary() : this.findSequential();
        if (result && entry != null) {
            entry.parseTagLine(this.line);
        }
        return result;
    }

    private boolean findBinary() throws IOException {
        boolean result = false;
        long lower_limit = 0L;
        long upper_limit = this.size;
        long last_pos = 0L;
        long pos = upper_limit / 2L;
        while (!result) {
            if (!this.readTagLineSeek(pos)) {
                result = this.findFirstMatchBefore();
                break;
            }
            if (pos == last_pos) break;
            int comp = this.nameComparison();
            last_pos = pos;
            if (comp < 0) {
                upper_limit = pos;
                pos = lower_limit + (upper_limit - lower_limit) / 2L;
                continue;
            }
            if (comp > 0) {
                lower_limit = pos;
                pos = lower_limit + (upper_limit - lower_limit) / 2L;
                continue;
            }
            if (pos == 0L) {
                result = true;
                continue;
            }
            result = this.findFirstMatchBefore();
        }
        return result;
    }

    private boolean findFirstMatchBefore() throws IOException {
        boolean more_lines;
        boolean result = false;
        long start = this.pos;
        this.findFirstNonMatchBefore();
        do {
            more_lines = this.readTagLine();
            if (this.nameComparison() != 0) continue;
            result = true;
        } while (more_lines && !result && this.pos < start);
        return result;
    }

    private void findFirstNonMatchBefore() {
        int comp;
        boolean more_lines;
        long start;
        long pos = start = this.pos;
        do {
            pos = pos < 512L ? 0L : (pos -= 512L);
            more_lines = this.readTagLineSeek(pos);
            comp = this.nameComparison();
        } while (more_lines && comp == 0 && pos > 0L && pos < start);
    }

    private boolean findNext(TagEntry entry) throws IOException {
        boolean result = false;
        if (this.sortMethod == 2 && !this.searchIgnoreCase || this.sortMethod == 3 && this.searchIgnoreCase) {
            result = this.tagsNext(entry);
            if (result && this.nameComparison() != 0) {
                result = false;
            }
        } else {
            result = this.findSequential();
            if (result && entry != null) {
                entry.parseTagLine(this.line);
            }
        }
        return result;
    }

    private boolean findSequential() throws IOException {
        boolean result = false;
        if (this.initialized) {
            while (!result && this.readTagLine()) {
                if (this.nameComparison() != 0) continue;
                result = true;
            }
        }
        return result;
    }

    private int nameComparison() {
        int result = this.searchIgnoreCase ? (this.searchPartial ? this.searchName.compareToIgnoreCase(this.name.substring(0, this.searchName.length())) : this.searchName.compareToIgnoreCase(this.name)) : (this.searchPartial ? this.searchName.compareTo(this.name.substring(0, this.searchName.length())) : this.searchName.compareTo(this.name));
        return result;
    }

    private static final String readFieldValue(TagEntry entry, String key) {
        if (key.equals("kind")) {
            return entry.kind;
        }
        if (key.equals("file")) {
            return EmptyString;
        }
        String result = null;
        int size = entry.fieldList.size();
        for (int i = 0; i < size && result == null; ++i) {
            if (!key.equals(entry.fieldList.get((int)i).key)) continue;
            result = entry.fieldList.get((int)i).value;
        }
        return result;
    }

    private boolean readNext(TagEntry entry) throws IOException {
        boolean result = false;
        if (!this.initialized) {
            result = false;
        } else if (!this.readTagLine()) {
            result = false;
        } else {
            if (entry != null) {
                entry.parseTagLine(this.line);
            }
            result = true;
        }
        return result;
    }

    private void readPseudoTags(TagFileInfo info) throws IOException {
        long startOfLine;
        int prefixLength = PseudoTagPrefix.length();
        if (info == null) {
            return;
        }
        info.format = 1;
        info.sort = 1;
        info.author = null;
        info.name = null;
        info.url = null;
        info.version = null;
        while (true) {
            startOfLine = this.fp.getFilePointer();
            if (!this.readTagLine() || !this.line.startsWith(PseudoTagPrefix)) break;
            TagEntry entry = new TagEntry();
            entry.parseTagLine(this.line);
            String key = entry.name.substring(prefixLength);
            String value = entry.file;
            if (key.equals("TAG_FILE_SORTED")) {
                this.sortMethod = Integer.parseInt(value);
            } else if (key.equals("TAG_FILE_FORMAT")) {
                this.format = Integer.parseInt(value);
            } else if (key.equals("TAG_PROGRAM_AUTHOR")) {
                this.programAuthor = value;
            } else if (key.equals("TAG_PROGRAM_NAME")) {
                this.programName = value;
            } else if (key.equals("TAG_PROGRAM_URL")) {
                this.programUrl = value;
            } else if (key.equals("TAG_PROGRAM_VERSION")) {
                this.programVersion = value;
            }
            info.format = this.format;
            info.sort = this.sortMethod;
            info.author = this.programAuthor;
            info.name = this.programName;
            info.url = this.programUrl;
            info.version = this.programVersion;
        }
        this.fp.seek(startOfLine);
    }

    private boolean readTagLine() throws IOException {
        this.line = this.fp.readLine();
        if (this.line != null) {
            int index = this.line.indexOf(9);
            if (index == -1 && (index = this.line.indexOf(10)) == -1) {
                index = this.line.indexOf(13);
            }
            this.name = index != -1 ? this.line.substring(0, index) : this.line;
        }
        return this.line != null;
    }

    private boolean readTagLineSeek(long pos) {
        boolean result = false;
        try {
            this.fp.seek(this.fp.getFilePointer() + pos);
            result = this.readTagLine();
            if (pos > 0L && result) {
                result = this.readTagLine();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public void tagsOpen(String filePath, TagFileInfo info) throws FileNotFoundException, IOException {
        this.fp = new RandomAccessFile(filePath, "r");
        this.size = this.fp.length();
        this.readPseudoTags(info);
        this.initialized = true;
    }

    public boolean tagsFirst(TagEntry entry) throws IOException {
        boolean result = false;
        if (this.initialized) {
            long startOfLine;
            this.fp.seek(0L);
            do {
                startOfLine = this.fp.getFilePointer();
            } while (this.readTagLine() && this.line.startsWith(PseudoTagPrefix));
            this.fp.seek(startOfLine);
            result = this.readNext(entry);
        }
        return result;
    }

    public boolean tagsNext(TagEntry entry) throws IOException {
        boolean result = false;
        if (this.initialized) {
            result = this.readNext(entry);
        }
        return result;
    }

    public String tagsField(TagEntry entry, String key) {
        String result = null;
        if (entry != null) {
            result = CTagReader.readFieldValue(entry, key);
        }
        return result;
    }

    public boolean tagsFind(TagEntry entry, String name, int options) throws IOException {
        boolean result = false;
        if (this.initialized) {
            result = this.find(entry, name, options);
        }
        return result;
    }

    public boolean tagsFindNext(TagEntry entry) throws IOException {
        boolean result = false;
        if (this.initialized) {
            result = this.findNext(entry);
        }
        return result;
    }

    public boolean tagsClose() throws IOException {
        if (this.initialized) {
            this.initialized = false;
            this.fp.close();
            this.size = 0L;
            this.pos = 0L;
            this.line = null;
            this.name = null;
            this.programAuthor = null;
            this.programName = null;
            this.programUrl = null;
            this.programVersion = null;
            return true;
        }
        return false;
    }
}

