/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ctags;

import java.util.ArrayList;
import java.util.List;
import org.fife.ctags.TagExtensionField;

public class TagEntry {
    public String name;
    public String file;
    public String pattern;
    public long lineNumber;
    public String kind;
    public boolean fileScope;
    public List<TagExtensionField> fieldList = new ArrayList<TagExtensionField>(1);

    public TagEntry() {
    }

    public TagEntry(String line) {
        this.parseTagLine(line);
    }

    private static final String fixEscapes(String pattern) {
        StringBuilder sb = new StringBuilder();
        int old = 0;
        int pos = 0;
        int len = pattern.length();
        while (old < len && (pos = pattern.indexOf(92, old)) > -1) {
            sb.append(pattern, old, pos);
            if (pos < len - 1) {
                char ch = pattern.charAt(++pos);
                switch (ch) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
            } else {
                sb.append('\\');
            }
            old = ++pos;
        }
        if (old < len) {
            sb.append(pattern.substring(old));
        }
        return sb.toString();
    }

    public String getPlainTextPattern() {
        return this.pattern == null ? null : TagEntry.fixEscapes(this.pattern.substring(2, this.pattern.length() - 2));
    }

    private void parseExtensionFields(String string) {
        if (string == null) {
            return;
        }
        string = string.trim();
        String[] keyValuePairs = string.split("\t");
        int numKeyValuePairs = keyValuePairs.length;
        for (int i = 0; i < numKeyValuePairs; ++i) {
            int colonIndex = keyValuePairs[i].indexOf(58);
            if (colonIndex == -1) {
                this.kind = keyValuePairs[i];
                continue;
            }
            String key = keyValuePairs[i].substring(0, colonIndex);
            String value = keyValuePairs[i].substring(colonIndex + 1);
            if (key.equals("kind")) {
                this.kind = value;
                continue;
            }
            if (key.equals("file")) {
                this.fileScope = true;
                continue;
            }
            if (key.equals("line")) {
                this.lineNumber = Integer.parseInt(value);
                continue;
            }
            this.fieldList.add(new TagExtensionField(key, value));
        }
    }

    public void parseTagLine(String line) {
        this.kind = null;
        this.fileScope = false;
        int tabIndex = line.indexOf(9);
        if (tabIndex == -1) {
            this.name = line;
        } else {
            this.name = line.substring(0, tabIndex);
            int tabIndex2 = line.indexOf(9, tabIndex + 1);
            if (tabIndex2 == -1) {
                this.file = line.substring(tabIndex + 1);
            } else {
                this.file = line.substring(tabIndex + 1, tabIndex2);
                String temp = line.substring(tabIndex2 + 1);
                char tempChar = temp.charAt(0);
                if (tempChar == '/' || tempChar == '?') {
                    this.lineNumber = 0L;
                    int curPos = 0;
                    int foo = 0;
                    do {
                        if ((foo = temp.indexOf(tempChar, curPos + 1)) <= -1) continue;
                        curPos = foo;
                    } while (foo != -1 && temp.charAt(foo - 1) == '\\');
                    if (foo != -1) {
                        this.pattern = temp.substring(0, foo + 1);
                        temp = temp.substring(foo + 1);
                    }
                } else if (Character.isDigit(tempChar)) {
                    this.pattern = null;
                    int i = 0;
                    while (Character.isDigit(tempChar)) {
                        tempChar = temp.charAt(++i);
                    }
                    this.lineNumber = Integer.parseInt(temp.substring(0, i));
                    temp = temp.substring(i);
                }
                boolean fieldsPresent = temp.startsWith(";\"");
                if (fieldsPresent) {
                    this.parseExtensionFields(temp.substring(2));
                }
            }
        }
        this.fieldList.clear();
        this.fieldList.addAll(this.fieldList);
    }

    public String toString() {
        return this.name;
    }
}

