/*
 * Decompiled with CFR 0.152.
 */
package org.fife.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.fife.help.HelpTreeNode;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;

class TopicsFoundDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JList choicesList;
    private int selectedIndex = -1;
    private static final String MSG = "org.fife.help.TopicsFoundDialog";

    TopicsFoundDialog(JFrame owner, List<HelpTreeNode> choices) {
        super(owner);
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        JLabel instruction = new JLabel(msg.getString("Instructions"));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        labelPanel.add(instruction);
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.setBorder(UIUtil.getEmpty5Border());
        TopicsFoundListener listener = new TopicsFoundListener();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton button = new JButton(msg.getString("Display"));
        button.setActionCommand("Display");
        button.addActionListener(listener);
        buttonPanel.add(button);
        buttonPanel.add(Box.createHorizontalStrut(3));
        button = new JButton(msg.getString("Cancel"));
        button.setActionCommand("Cancel");
        button.addActionListener(listener);
        buttonPanel.add(button);
        buttonPanel.setBorder(UIUtil.getEmpty5Border());
        this.choicesList = new JList<Object>(choices.toArray());
        this.choicesList.addMouseListener(listener);
        this.choicesList.addKeyListener(listener);
        this.choicesList.setSelectionModel(new RListSelectionModel());
        this.choicesList.setSelectedIndex(0);
        RScrollPane sp = new RScrollPane(this.choicesList);
        sp.setVerticalScrollBarPolicy(22);
        JPanel choicesPanel = new JPanel(new BorderLayout());
        choicesPanel.add(sp);
        choicesPanel.setBorder(UIUtil.getEmpty5Border());
        ResizableFrameContentPane temp = new ResizableFrameContentPane(new BorderLayout());
        temp.add((Component)labelPanel, "North");
        temp.add((Component)choicesPanel, "Center");
        temp.add((Component)buttonPanel, "South");
        this.getContentPane().add(temp);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.setTitle(msg.getString("Title"));
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private class TopicsFoundListener
    extends MouseAdapter
    implements ActionListener,
    KeyListener {
        private TopicsFoundListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Display")) {
                TopicsFoundDialog.this.selectedIndex = TopicsFoundDialog.this.choicesList.getSelectedIndex();
                TopicsFoundDialog.this.setVisible(false);
            } else if (actionCommand.equals("Cancel")) {
                TopicsFoundDialog.this.selectedIndex = -1;
                TopicsFoundDialog.this.setVisible(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 10: {
                    TopicsFoundDialog.this.selectedIndex = TopicsFoundDialog.this.choicesList.getSelectedIndex();
                    TopicsFoundDialog.this.setVisible(false);
                    break;
                }
                case 27: {
                    TopicsFoundDialog.this.selectedIndex = -1;
                    TopicsFoundDialog.this.setVisible(false);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TopicsFoundDialog.this.selectedIndex = TopicsFoundDialog.this.choicesList.getSelectedIndex();
                TopicsFoundDialog.this.setVisible(false);
            }
        }
    }
}

