/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fife.io.ProcessRunnerOutputListener;

public class ProcessRunner
implements Runnable {
    private File dir;
    private String[] commandLine;
    private Map<String, String> envVars;
    private boolean appendEnv;
    private String stdout;
    private String stderr;
    private ProcessRunnerOutputListener outputListener;
    private int rc;
    private Throwable lastError;

    public ProcessRunner(String[] commandLine) {
        this.setCommandLine(commandLine);
        this.appendEnv = true;
    }

    private void clearLastOutput() {
        this.stderr = null;
        this.stdout = null;
        this.rc = Integer.MIN_VALUE;
        this.lastError = null;
    }

    private String[] createEnvVarArray() {
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.appendEnv) {
            env.putAll(System.getenv());
        }
        if (this.envVars != null) {
            env.putAll(this.envVars);
        }
        ArrayList<String> temp = new ArrayList<String>(env.size());
        for (Map.Entry entry : env.entrySet()) {
            temp.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        String[] envp = new String[temp.size()];
        envp = temp.toArray(envp);
        return envp;
    }

    public boolean getAppendEnvironmentVars() {
        return this.appendEnv;
    }

    public String getCommandLineString() {
        int count = this.commandLine.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? "\"" : " \"").append(this.commandLine[i]).append('\"');
        }
        return sb.toString();
    }

    public File getDirectory() {
        return this.dir;
    }

    public Map<String, String> getEnvironmentVars() {
        HashMap<String, String> temp = new HashMap<String, String>();
        if (this.envVars != null) {
            temp.putAll(this.envVars);
        }
        return temp;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public int getReturnCode() {
        return this.rc;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getStdout() {
        return this.stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.clearLastOutput();
        Process proc = null;
        String[] envp = this.createEnvVarArray();
        try {
            proc = Runtime.getRuntime().exec(this.commandLine, envp, this.dir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.lastError = ioe;
            if (this.outputListener != null) {
                this.outputListener.processCompleted(proc, this.rc, this.lastError);
            }
            return;
        }
        InputStream errStream = proc.getErrorStream();
        InputStream outStream = proc.getInputStream();
        StreamReaderThread stdoutThread = new StreamReaderThread(proc, outStream, this.outputListener, true);
        StreamReaderThread stderrThread = new StreamReaderThread(proc, errStream, this.outputListener, false);
        stdoutThread.start();
        stderrThread.start();
        try {
            this.rc = proc.waitFor();
            proc = null;
            stdoutThread.join();
            stderrThread.join();
            this.stdout = stdoutThread.getStreamOutput();
            this.stderr = stderrThread.getStreamOutput();
        }
        catch (InterruptedException ie) {
            stdoutThread.interrupt();
            stderrThread.interrupt();
            this.lastError = ie;
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        if (this.outputListener != null) {
            this.outputListener.processCompleted(proc, this.rc, this.lastError);
        }
    }

    public void setDirectory(File dir) {
        this.dir = dir;
    }

    public void setCommandLine(String[] commandLine) throws IllegalArgumentException {
        int size = commandLine.length;
        if (size == 0) {
            throw new IllegalArgumentException("Must have at least 1 command line argument");
        }
        this.commandLine = new String[size];
        System.arraycopy(commandLine, 0, this.commandLine, 0, size);
        this.clearLastOutput();
    }

    public void setEnvironmentVars(Map<String, String> vars, boolean append) {
        this.appendEnv = append;
        if (this.envVars != null) {
            this.envVars.clear();
        } else {
            this.envVars = new HashMap<String, String>();
        }
        this.envVars.putAll(vars);
    }

    public void setOutputListener(ProcessRunnerOutputListener listener) {
        this.outputListener = listener;
    }

    static class StreamReaderThread
    extends Thread {
        private Process p;
        private BufferedReader r;
        private StringBuilder buffer;
        private ProcessRunnerOutputListener listener;
        private boolean isStdout;

        StreamReaderThread(Process p, InputStream in, ProcessRunnerOutputListener listener, boolean isStdout) {
            this.p = p;
            this.r = new BufferedReader(new InputStreamReader(in));
            this.buffer = new StringBuilder();
            this.listener = listener;
            this.isStdout = isStdout;
        }

        public String getStreamOutput() {
            return this.buffer.toString();
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.r.readLine()) != null) {
                    this.buffer.append(line).append('\n');
                    if (this.listener == null) continue;
                    this.listener.outputWritten(this.p, line, this.isStdout);
                }
            }
            catch (IOException ioe) {
                this.buffer.append("IOException occurred: " + ioe.getMessage());
            }
        }
    }
}

