/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class EscapableDialog
extends JDialog {
    private static final String ESCAPE_KEY = "OnEsc";

    public EscapableDialog() {
        this.init();
    }

    public EscapableDialog(Window owner) {
        super(owner);
        this.init();
    }

    public EscapableDialog(Window owner, boolean modal) {
        super(owner, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.init();
    }

    public EscapableDialog(Window owner, String title) {
        super(owner, title);
        this.init();
    }

    public EscapableDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
        this.init();
    }

    protected void escapePressed() {
        this.setVisible(false);
    }

    private void init() {
        this.setEscapeClosesDialog(true);
    }

    public void setEscapeClosesDialog(boolean closes) {
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        if (closes) {
            im.put(ks, ESCAPE_KEY);
            actionMap.put(ESCAPE_KEY, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EscapableDialog.this.escapePressed();
                }
            });
        } else {
            im.remove(ks);
            actionMap.remove(ESCAPE_KEY);
        }
    }
}

