/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class FSATextField
extends JTextField
implements ComponentListener,
DocumentListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final boolean IGNORE_CASE = FSATextField.getIgnoreCase();
    private FilenameFilter directoriesOnlyFilenameFilter;
    private File directory;
    private String dirName;
    private boolean autoCompleteFileName;
    private JList fileList;
    private DefaultListModel fileListModel;
    private JScrollPane scrollPane;
    private JWindow popupWindow;
    private boolean directoriesOnly;
    private long lastCount = -1L;
    private boolean ignoreDocumentUpdates = false;
    private Runnable listValueChangedRunnable;
    private String[] containedFiles;
    private int num;
    private String currentDirectory;
    private boolean fileSystemAware;
    private Window parent;
    private JPanel contentPane;

    public FSATextField() {
        this(false, System.getProperty("user.dir"));
    }

    public FSATextField(int cols) {
        this();
        this.setColumns(cols);
    }

    public FSATextField(boolean directoriesOnly, File currentDirectory) {
        this(directoriesOnly, currentDirectory.getAbsolutePath());
    }

    public FSATextField(boolean directoriesOnly, String currentDirectory) {
        this.enableEvents(4L);
        this.setDirectoriesOnly(directoriesOnly);
        this.fileListModel = new DefaultListModel();
        this.fileList = new JList(this.fileListModel);
        this.fileList.addListSelectionListener(this);
        this.contentPane = new JPanel(new GridLayout(1, 1));
        this.scrollPane = new JScrollPane(this.fileList);
        this.contentPane.add(this.scrollPane);
        this.setCurrentDirectory(currentDirectory);
        this.fileSystemAware = true;
        this.setAutoCompleteFileName(true);
        this.listValueChangedRunnable = new ListValueChangedRunnable();
        this.installStandardKeyActions();
    }

    public void addItem(String item) {
        this.fileListModel.addElement(item);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FSATextField.this.discoverParentWindow();
            }
        });
    }

    private void autoCompleteFileName(String entered) {
        char ch;
        if (entered != null && (ch = entered.charAt(entered.length() - 1)) != '/' && ch != '\\') {
            String value = (String)this.fileListModel.get(0);
            int len = this.getDocument().getLength();
            if (this.getCaretPosition() == len && len < value.length()) {
                String remaining = value.substring(len);
                this.ignoreDocumentUpdates = true;
                this.replaceSelection(remaining);
                this.select(len, this.getDocument().getLength());
                this.ignoreDocumentUpdates = false;
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void cleanupOldParentWindow() {
        if (this.popupWindow != null) {
            this.popupWindow.setContentPane(new JPanel());
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.parent != null) {
            this.parent.removeComponentListener(this);
            this.parent = null;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.processParentComponentEvent(e);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.processParentComponentEvent(e);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.processParentComponentEvent(e);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.processParentComponentEvent(e);
    }

    private JWindow createPopupWindow() {
        JWindow popupWindow = new JWindow(this.parent);
        popupWindow.setFocusableWindowState(false);
        popupWindow.setContentPane(this.contentPane);
        popupWindow.applyComponentOrientation(this.getComponentOrientation());
        return popupWindow;
    }

    private boolean discoverParentWindow() {
        this.parent = SwingUtilities.getWindowAncestor(this);
        if (this.parent != null) {
            this.parent.addComponentListener(this);
            if (this.parent.isVisible()) {
                this.updatePopupWindowDimensions();
            } else {
                System.out.println("DEBUG: Parent is not visible");
            }
        } else {
            System.out.println("DEBUG: *** parent is null");
        }
        return this.parent != null;
    }

    public boolean getAutoCompleteFileName() {
        return this.autoCompleteFileName;
    }

    private static int getCharCount(String str, char ch) {
        int count = 0;
        int prev = 0;
        int offs = 0;
        while ((offs = str.indexOf(ch, prev)) > -1) {
            ++count;
            prev = offs + 1;
        }
        return count;
    }

    private String[] getContainedFiles(File dir) {
        if (this.directoriesOnly) {
            return dir.list(this.directoriesOnlyFilenameFilter);
        }
        return dir.list();
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public boolean getFileSystemAware() {
        return this.fileSystemAware;
    }

    public File getSelectedFile() {
        String text = this.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return new File(text);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    private static boolean getIgnoreCase() {
        String os = System.getProperty("os.name");
        boolean ignoreCase = false;
        if (os != null) {
            ignoreCase = (os = os.toLowerCase()).indexOf("windows") > -1 || os.indexOf("mac os x") > -1;
        }
        return ignoreCase;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.isShowing() && this.fileSystemAware && !this.ignoreDocumentUpdates) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String entered = FSATextField.this.updateComboBoxContents();
                    if (FSATextField.this.getAutoCompleteFileName()) {
                        FSATextField.this.autoCompleteFileName(entered);
                    }
                }
            });
        }
    }

    private void installExtraKeyActions() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "OnDown");
        actionMap.put("OnDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible()) {
                    int size;
                    int index = FSATextField.this.fileList.getSelectedIndex();
                    index = index < (size = FSATextField.this.fileList.getModel().getSize()) - 1 ? index + 1 : 0;
                    FSATextField.this.fileList.setSelectedIndex(index);
                    FSATextField.this.fileList.ensureIndexIsVisible(index);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "OnUp");
        actionMap.put("OnUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible()) {
                    int index = FSATextField.this.fileList.getSelectedIndex();
                    index = index > 0 ? index - 1 : FSATextField.this.fileList.getModel().getSize() - 1;
                    FSATextField.this.fileList.setSelectedIndex(index);
                    FSATextField.this.fileList.ensureIndexIsVisible(index);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "OnPageDown");
        actionMap.put("OnPageDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size;
                int index;
                if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible() && (index = FSATextField.this.fileList.getSelectedIndex()) < (size = FSATextField.this.fileList.getModel().getSize()) - 1) {
                    int visRows = FSATextField.this.fileList.getVisibleRowCount();
                    index = Math.min(index + visRows, size - 1);
                    FSATextField.this.fileList.setSelectedIndex(index);
                    FSATextField.this.fileList.ensureIndexIsVisible(index);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "OnPageUp");
        actionMap.put("OnPageUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible() && (index = FSATextField.this.fileList.getSelectedIndex()) > 0) {
                    int visRows = FSATextField.this.fileList.getVisibleRowCount();
                    index = Math.max(index - visRows, 0);
                    FSATextField.this.fileList.setSelectedIndex(index);
                    FSATextField.this.fileList.ensureIndexIsVisible(index);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "OnEsc");
        actionMap.put("OnEsc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible()) {
                    FSATextField.this.setPopupVisible(false);
                    return;
                }
                JRootPane root = SwingUtilities.getRootPane(FSATextField.this);
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(27, 0))) != null && (action = am.get(obj)) != null) {
                        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
    }

    private void installStandardKeyActions() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        this.setFocusTraversalKeysEnabled(false);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "OnTab");
        actionMap.put("OnTab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dot;
                Caret c = FSATextField.this.getCaret();
                if (c != null && (dot = c.getDot()) > c.getMark() && dot == FSATextField.this.getDocument().getLength()) {
                    c.setDot(dot);
                    if (FSATextField.this.popupWindow != null && FSATextField.this.popupWindow.isVisible()) {
                        FSATextField.this.popupWindow.setVisible(false);
                    }
                    return;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(9, 1), "OnShiftTab");
        actionMap.put("OnShiftTab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        });
    }

    public boolean isDirectoriesOnly() {
        return this.directoriesOnly;
    }

    private void processParentComponentEvent(ComponentEvent e) {
        switch (e.getID()) {
            case 100: 
            case 101: 
            case 103: {
                this.updatePopupWindowDimensions();
                if (this.popupWindow == null) break;
                this.setPopupVisible(false);
                break;
            }
        }
    }

    @Override
    public void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005) {
            this.setPopupVisible(false);
        }
        super.processFocusEvent(e);
    }

    public void removeAllItems() {
        this.fileListModel.removeAllElements();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanupOldParentWindow();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.isShowing() && this.fileSystemAware && !this.ignoreDocumentUpdates) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FSATextField.this.updateComboBoxContents();
                }
            });
        }
    }

    public void setAutoCompleteFileName(boolean auto) {
        this.autoCompleteFileName = auto;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory.getAbsolutePath();
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setDirectoriesOnly(boolean directoriesOnly) {
        if (directoriesOnly) {
            this.directoriesOnlyFilenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File parentDir, String fileName) {
                    return new File(parentDir.getAbsolutePath(), fileName).isDirectory();
                }
            };
        }
        this.directoriesOnly = directoriesOnly;
    }

    @Override
    public void setDocument(Document document) {
        if (document != null) {
            Document oldDocument = this.getDocument();
            if (oldDocument != null) {
                oldDocument.removeDocumentListener(this);
            }
            super.setDocument(document);
            document.addDocumentListener(this);
        }
    }

    public void setFileSystemAware(boolean aware) {
        this.fileSystemAware = aware;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.fileList.setCellRenderer(renderer);
    }

    private void setPopupVisible(boolean visible) {
        if (visible) {
            if (this.popupWindow == null) {
                this.popupWindow = this.createPopupWindow();
            }
            this.popupWindow.pack();
            if (this.popupWindow.getWidth() != this.getWidth()) {
                this.updatePopupWindowDimensions();
                this.popupWindow.pack();
            }
            Rectangle bounds = this.getBounds();
            Point loc = this.getLocation();
            loc.x = 0;
            SwingUtilities.convertPointToScreen(loc, this);
            this.popupWindow.setLocation(loc.x, loc.y + bounds.height - bounds.y);
            this.popupWindow.setVisible(true);
        } else if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    @Override
    public void setUI(TextUI ui) {
        Document document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        super.setUI(ui);
        this.getDocument().addDocumentListener(this);
        if (this.popupWindow != null) {
            SwingUtilities.updateComponentTreeUI(this.popupWindow);
        } else if (this.contentPane != null) {
            SwingUtilities.updateComponentTreeUI(this.contentPane);
        }
        this.installExtraKeyActions();
    }

    private String updateComboBoxContents() {
        String text = this.getText();
        if (text.length() == 0) {
            this.setPopupVisible(false);
            this.lastCount = 0L;
            return null;
        }
        int lastSeparator = Math.max(text.lastIndexOf(47), text.lastIndexOf(92)) + 1;
        File t2 = null;
        if (lastSeparator != 0) {
            String pathPart = text.substring(0, lastSeparator);
            t2 = new File(pathPart);
            if (!t2.isAbsolute()) {
                t2 = new File(this.currentDirectory, pathPart);
            }
        } else {
            t2 = new File(this.currentDirectory);
        }
        if (!t2.equals(this.directory)) {
            this.directory = t2;
            if (!this.directory.isDirectory()) {
                this.lastCount = -1L;
                this.setPopupVisible(false);
                this.num = 0;
                this.containedFiles = null;
                return null;
            }
            this.dirName = this.directory.getAbsolutePath();
            if (this.dirName.charAt(this.dirName.length() - 1) != File.separatorChar) {
                this.dirName = this.dirName + File.separatorChar;
            }
            if (File.separatorChar == '\\' && this.directory.getAbsolutePath().startsWith("\\\\")) {
                int slashCount = FSATextField.getCharCount(this.directory.getAbsolutePath(), '\\');
                if (slashCount < 5) {
                    this.containedFiles = null;
                } else {
                    Cursor old = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    GetContentsRunnable gcr = new GetContentsRunnable(this.directory);
                    Thread thread = new Thread(gcr);
                    thread.start();
                    try {
                        thread.join(8000L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    this.setCursor(old);
                    thread.interrupt();
                    this.containedFiles = gcr.containedFiles;
                }
            } else {
                this.containedFiles = this.getContainedFiles(this.directory);
            }
            if (this.containedFiles != null) {
                this.num = this.containedFiles.length;
                if (this.num > 0) {
                    Arrays.sort(this.containedFiles, IGNORE_CASE ? String.CASE_INSENSITIVE_ORDER : null);
                }
            } else {
                this.num = 0;
            }
        }
        if (this.num > 0) {
            this.removeAllItems();
            String dirPart = text.substring(0, lastSeparator);
            String fpFileName = text.substring(lastSeparator);
            int fpFileNameLength = fpFileName.length();
            long count = 0L;
            int i = Arrays.binarySearch(this.containedFiles, fpFileName, IGNORE_CASE ? String.CASE_INSENSITIVE_ORDER : null);
            if (i < 0) {
                i = -(i + 1);
            }
            while (i < this.num && this.containedFiles[i].regionMatches(IGNORE_CASE, 0, fpFileName, 0, fpFileNameLength)) {
                this.addItem(dirPart + this.containedFiles[i]);
                ++count;
                ++i;
            }
            if (count != this.lastCount && count > 0L) {
                this.setPopupVisible(true);
            } else if (count == 0L) {
                this.setPopupVisible(false);
            }
            this.lastCount = count;
            return count > 0L ? text : null;
        }
        this.lastCount = -1L;
        lastSeparator = 0;
        this.setPopupVisible(false);
        return null;
    }

    private void updatePopupWindowDimensions() {
        Dimension size = this.getSize();
        this.contentPane.setMinimumSize(new Dimension(size.width, this.contentPane.getMinimumSize().height));
        this.contentPane.setPreferredSize(new Dimension(size.width, this.contentPane.getPreferredSize().height));
        this.contentPane.setMaximumSize(new Dimension(size.width, this.contentPane.getMaximumSize().height));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SwingUtilities.invokeLater(this.listValueChangedRunnable);
    }

    private class ListValueChangedRunnable
    implements Runnable {
        private ListValueChangedRunnable() {
        }

        @Override
        public void run() {
            FSATextField.this.ignoreDocumentUpdates = true;
            String selectedValue = (String)FSATextField.this.fileList.getSelectedValue();
            if (selectedValue != null) {
                FSATextField.this.setText(selectedValue);
            }
            FSATextField.this.ignoreDocumentUpdates = false;
        }
    }

    private class GetContentsRunnable
    implements Runnable {
        private File dir;
        String[] containedFiles;

        GetContentsRunnable(File dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            this.containedFiles = FSATextField.this.getContainedFiles(this.dir);
        }
    }
}

