/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.UIUtil;

public class FontDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JList fontList;
    private JList fontSizeList;
    private JLabel sampleTextLabel;
    private Box fontFormatPanel;
    private JPanel samplePanel;
    private JCheckBox boldCheckBox;
    private JCheckBox italicCheckBox;
    private JCheckBox underlineCheckBox;
    private int properties = 0;
    private int size = 12;
    private Font selectedFont;
    private Color selectedColor;
    private JLabel fontChooserLabel;
    private String styleLabel;
    private JLabel sizeLabel;
    private String sampleLabel;

    public FontDialog(Dialog owner, String title, Font initialSelection, Color initialColor) {
        this(owner, title, initialSelection, initialColor, true, true);
    }

    public FontDialog(Dialog owner, String title, Font initialSelection, Color initialColor, boolean underlineSelectable, boolean colorSelectable) {
        super(owner);
        this.init(owner, title, initialSelection, initialColor, underlineSelectable, colorSelectable);
    }

    public FontDialog(Frame owner, String title, Font initialSelection, Color initialColor) {
        this(owner, title, initialSelection, initialColor, true, true);
    }

    public FontDialog(Frame owner, String title, Font initialSelection, Color initialColor, boolean underlineSelectable, boolean colorSelectable) {
        super(owner);
        this.init(owner, title, initialSelection, initialColor, underlineSelectable, colorSelectable);
    }

    private void init(Window owner, String title, Font initialSelection, Color initialColor, boolean underlineSelectable, boolean colorSelectable) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        float alignment = orientation.isLeftToRight() ? 0.0f : 1.0f;
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.UI");
        if (title == null) {
            title = msg.getString("FontDialog.Title");
        }
        this.setTitle(title);
        Box fontChooserPanel = Box.createVerticalBox();
        this.fontList = new JList(FontDialog.createFontListModel());
        this.fontList.setSelectionModel(new RListSelectionModel());
        this.fontList.getSelectionModel().addListSelectionListener(this);
        RScrollPane fontListScrollPane = new RScrollPane(this.fontList);
        this.fontChooserLabel = UIUtil.newLabel(msg, "FontLabel");
        fontChooserPanel.add(this.fontChooserLabel);
        fontChooserPanel.add(fontListScrollPane);
        this.fontChooserLabel.setAlignmentX(alignment);
        fontListScrollPane.setAlignmentX(alignment);
        Box fontSizePanel = Box.createVerticalBox();
        DefaultListModel<Integer> listModel = new DefaultListModel<Integer>();
        for (int i = 2; i <= 40; ++i) {
            listModel.addElement(i);
        }
        this.fontSizeList = new JList(listModel);
        this.fontSizeList.setSelectionModel(new RListSelectionModel());
        this.fontSizeList.getSelectionModel().addListSelectionListener(this);
        RScrollPane fontSizeListScrollPane = new RScrollPane(this.fontSizeList);
        this.sizeLabel = UIUtil.newLabel(msg, "SizeLabel");
        fontSizePanel.add(this.sizeLabel);
        fontSizePanel.add(fontSizeListScrollPane);
        this.sizeLabel.setAlignmentX(alignment);
        fontSizeListScrollPane.setAlignmentX(alignment);
        this.boldCheckBox = this.createCheckBox(msg, "Bold");
        this.italicCheckBox = this.createCheckBox(msg, "Italic");
        this.underlineCheckBox = this.createCheckBox(msg, "Underline");
        if (!underlineSelectable) {
            this.underlineCheckBox.setEnabled(false);
        }
        this.fontFormatPanel = Box.createVerticalBox();
        this.fontFormatPanel.add(this.boldCheckBox);
        this.fontFormatPanel.add(this.italicCheckBox);
        this.fontFormatPanel.add(this.underlineCheckBox);
        this.styleLabel = msg.getString("FontStyle");
        this.setFontStyleLabel(this.styleLabel);
        JButton okButton = this.createButton(msg, "OK");
        JButton cancelButton = this.createButton(msg, "Cancel");
        JButton colorButton = this.createButton(msg, "Color");
        if (!colorSelectable) {
            colorButton.setVisible(false);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1, 0, 5));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        buttonPanel.add(colorButton);
        JPanel topPanel = new JPanel();
        topPanel.add(fontChooserPanel);
        topPanel.add(this.fontFormatPanel);
        topPanel.add(fontSizePanel);
        topPanel.add(buttonPanel);
        topPanel.setBorder(UIUtil.getEmpty5Border());
        this.samplePanel = new JPanel();
        this.sampleLabel = msg.getString("Sample");
        this.setFontSampleLabel(this.sampleLabel);
        this.sampleTextLabel = new JLabel(msg.getString("SampleText"));
        this.sampleTextLabel.setHorizontalAlignment(0);
        this.sampleTextLabel.setPreferredSize(new Dimension(250, 80));
        this.samplePanel.add(this.sampleTextLabel);
        if (initialSelection == null) {
            Font font = initialSelection = owner != null ? owner.getFont() : new Font("Monospaced", 0, 13);
        }
        if (initialSelection.isBold()) {
            this.properties |= 1;
        }
        if (initialSelection.isItalic()) {
            this.properties |= 2;
        }
        this.setSelectedFont(initialSelection, initialColor);
        this.getRootPane().setDefaultButton(okButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(topPanel);
        this.getContentPane().add(this.samplePanel);
        this.setResizable(false);
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Bold")) {
            this.properties ^= 1;
            Font newFont = this.sampleTextLabel.getFont().deriveFont(this.properties, this.size);
            this.sampleTextLabel.setFont(newFont);
        } else if (command.equals("Italic")) {
            this.properties ^= 2;
            Font newFont = this.sampleTextLabel.getFont().deriveFont(this.properties, this.size);
            this.sampleTextLabel.setFont(newFont);
        } else if (command.equals("Underline")) {
            if (this.getUnderlineSelected()) {
                this.sampleTextLabel.setText("<html><u>" + this.sampleTextLabel.getText() + "</u>");
            } else {
                String old = this.sampleTextLabel.getText();
                this.sampleTextLabel.setText(old.substring(9, old.length() - 4));
            }
        } else if (command.equals("Color")) {
            Color tempColor = JColorChooser.showDialog(this, "Font Color", this.sampleTextLabel.getForeground());
            if (tempColor != null) {
                this.sampleTextLabel.setForeground(tempColor);
                this.repaint();
            }
        } else if (command.equals("OK")) {
            this.selectedFont = this.sampleTextLabel.getFont();
            this.selectedColor = this.sampleTextLabel.getForeground();
            this.setVisible(false);
        } else if (command.equals("Cancel")) {
            this.selectedFont = null;
            this.selectedColor = null;
            this.setVisible(false);
        }
    }

    private JButton createButton(ResourceBundle msg, String keyRoot) {
        JButton button = UIUtil.newButton(msg, keyRoot, keyRoot + "ButtonMnemonic");
        button.setActionCommand(keyRoot);
        button.addActionListener(this);
        return button;
    }

    private JCheckBox createCheckBox(ResourceBundle msg, String keyRoot) {
        JCheckBox cb = new JCheckBox(msg.getString(keyRoot));
        cb.setMnemonic((int)msg.getString(keyRoot + "Mnemonic").charAt(0));
        cb.setActionCommand(keyRoot);
        cb.addActionListener(this);
        return cb;
    }

    private static DefaultListModel createFontListModel() {
        String[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        HashSet<String> monospacedFontsSet = FontDialog.createMonospacedFontsSet();
        DefaultListModel<FontInfo> listModel = new DefaultListModel<FontInfo>();
        for (int i = 0; i < families.length; ++i) {
            boolean monospaced = monospacedFontsSet.contains(families[i]);
            FontInfo fi = new FontInfo(families[i], monospaced);
            listModel.addElement(fi);
        }
        return listModel;
    }

    private static HashSet<String> createMonospacedFontsSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("Andale Mono");
        set.add("Andale Mono IPA");
        set.add("Bitstream Vera Sans Mono");
        set.add("Consolas");
        set.add("Courier");
        set.add("Courier New");
        set.add("DejaVu Sans Mono");
        set.add("Fixed");
        set.add("FreeMono");
        set.add("Liberation Mono");
        set.add("Lucida Console");
        set.add("Lucida Sans Typewriter");
        set.add("Lucida Typewriter");
        set.add("Luxi Mono");
        set.add("Monaco");
        set.add("Monospaced");
        set.add("Monotype.com");
        set.add("Nimbus Mono L");
        set.add("OCR A Extended");
        set.add("OCRB");
        set.add("Terminal");
        set.add("Vera Sans Mono");
        return set;
    }

    public final String getFontLabel() {
        return this.fontChooserLabel.getText();
    }

    public final String getFontSampleLabel() {
        return this.sampleLabel;
    }

    public final String getFontSampleText() {
        return this.sampleTextLabel.getText();
    }

    public final String getFontSizeLabel() {
        return this.sizeLabel.getText();
    }

    public final String getFontStyleLabel() {
        return this.styleLabel;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public boolean getUnderlineSelected() {
        return this.underlineCheckBox.isSelected();
    }

    public void setFontLabel(String text) {
        this.fontChooserLabel.setText(text);
    }

    public void setFontSampleLabel(String text) {
        this.sampleLabel = text;
        this.samplePanel.setBorder(BorderFactory.createCompoundBorder(UIUtil.getEmpty5Border(), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.sampleLabel), BorderFactory.createCompoundBorder(UIUtil.getEmpty5Border(), BorderFactory.createBevelBorder(1)))));
    }

    public void setFontSampleText(String text) {
        this.sampleTextLabel.setText(text);
    }

    public void setFontSizeLabel(String text) {
        this.sizeLabel.setText(text);
    }

    public void setFontStyleLabel(String text) {
        this.styleLabel = text;
        this.fontFormatPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.styleLabel), UIUtil.getEmpty5Border()));
    }

    public void setSelectedFont(Font toSelect, Color color) {
        if (toSelect == null) {
            return;
        }
        this.sampleTextLabel.setForeground(color != null ? color : Color.BLACK);
        this.setSelectedFontInFontList(toSelect.getFamily());
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        this.boldCheckBox.setSelected(toSelect.isBold());
        this.italicCheckBox.setSelected(toSelect.isItalic());
        this.fontSizeList.setSelectedValue(toSelect.getSize(), true);
    }

    private void setSelectedFontInFontList(String fontFamily) {
        if (fontFamily == null) {
            this.fontList.setSelectedIndex(-1);
        } else {
            ListModel model = this.fontList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(fontFamily)) continue;
                this.fontList.setSelectedIndex(i);
                this.fontList.ensureIndexIsVisible(i);
                break;
            }
        }
        this.fontList.repaint();
    }

    public void setUnderlineSelected(boolean underline) {
        if (this.underlineCheckBox.isEnabled()) {
            this.underlineCheckBox.setSelected(underline);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm == this.fontList.getSelectionModel()) {
            FontInfo fi = (FontInfo)this.fontList.getSelectedValue();
            Font newFont = new Font(fi.fontFamily, this.properties, this.size);
            this.sampleTextLabel.setFont(newFont);
        } else if (lsm == this.fontSizeList.getSelectionModel()) {
            this.size = (Integer)this.fontSizeList.getSelectedValue();
            Font newFont = this.sampleTextLabel.getFont().deriveFont(this.properties, this.size);
            this.sampleTextLabel.setFont(newFont);
        }
    }

    private static class FontInfo
    implements Comparable<Object> {
        private String fontFamily;
        private boolean monospaced;

        FontInfo(String fontFamily, boolean monospaced) {
            this.fontFamily = fontFamily;
            this.monospaced = monospaced;
        }

        @Override
        public int compareTo(Object obj) {
            int value = -1;
            if (obj instanceof String) {
                value = this.fontFamily.compareTo((String)obj);
            } else if (obj instanceof FontInfo) {
                value = this.fontFamily.compareTo(((FontInfo)obj).fontFamily);
            }
            return value;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            return this.fontFamily.hashCode() + (this.monospaced ? 1 : 0);
        }

        public String toString() {
            String value = this.fontFamily;
            if (this.monospaced) {
                value = "<html><b>" + value + "</b>";
            }
            return value;
        }
    }
}

