/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.fife.ui.KeyStrokeField;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;

public class GetKeyStrokeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private KeyStroke stroke;
    private KeyStrokeField textField;
    private boolean canceled;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.GetKeyStrokeDialog");

    public GetKeyStrokeDialog(Dialog parent, KeyStroke initial) {
        super(parent, MSG.getString("Dialog.KeyStroke.Title"));
        this.createUI(initial);
    }

    public GetKeyStrokeDialog(Frame parent, KeyStroke initial) {
        super(parent, MSG.getString("Dialog.KeyStroke.Title"));
        this.createUI(initial);
    }

    private void createUI(KeyStroke initial) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        Listener listener = new Listener();
        Box contentPane = Box.createVerticalBox();
        contentPane.setBorder(UIUtil.getEmpty5Border());
        JPanel temp = new JPanel(new BorderLayout());
        JLabel prompt = UIUtil.newLabel(MSG, "Dialog.KeyStroke.Prompt");
        temp.add((Component)prompt, "Before");
        contentPane.add(temp);
        contentPane.add(Box.createVerticalStrut(8));
        this.textField = new KeyStrokeField();
        JLabel charLabel = UIUtil.newLabel(MSG, "Dialog.KeyStroke.Key", this.textField);
        temp = new JPanel(new BorderLayout());
        temp.add((Component)charLabel, "Before");
        temp.add(this.textField);
        contentPane.add(temp);
        JButton ok = UIUtil.newButton(MSG, "OK", listener);
        ok.setActionCommand("OK");
        JButton cancel = UIUtil.newButton(MSG, "Cancel", listener);
        cancel.setActionCommand("Cancel");
        JPanel buttonPanel = (JPanel)UIUtil.createButtonFooter(ok, cancel);
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0), buttonPanel.getBorder()));
        ResizableFrameContentPane realCP = new ResizableFrameContentPane(new BorderLayout());
        realCP.add((Component)contentPane, "North");
        realCP.add((Component)buttonPanel, "South");
        this.setContentPane(realCP);
        this.setKeyStroke(initial);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    public boolean getCancelled() {
        return this.canceled;
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public void setKeyStroke(KeyStroke stroke) {
        this.stroke = stroke;
        this.textField.setKeyStroke(stroke);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.canceled = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GetKeyStrokeDialog.this.textField.requestFocusInWindow();
                    GetKeyStrokeDialog.this.textField.selectAll();
                }
            });
        }
        super.setVisible(visible);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if ("OK".equals(command)) {
                GetKeyStrokeDialog.this.stroke = GetKeyStrokeDialog.this.textField.getKeyStroke();
                GetKeyStrokeDialog.this.canceled = false;
                GetKeyStrokeDialog.this.setVisible(false);
            } else if ("Cancel".equals(command)) {
                GetKeyStrokeDialog.this.stroke = null;
                GetKeyStrokeDialog.this.setVisible(false);
            }
        }
    }
}

