/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.fife.ui.UIUtil;

public class Hyperlink
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String text;
    private String address;

    public Hyperlink(String address) {
        this(address, address);
    }

    public Hyperlink(String text, String address) {
        this.enableEvents(16L);
        this.setAddress(address);
        this.setText(text);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setFocusable(true);
    }

    public String getAddress() {
        return this.address;
    }

    public String getDisplayedText() {
        return this.text;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getButton() == 1) {
            switch (e.getID()) {
                case 500: {
                    if (UIUtil.browse(this.getAddress())) break;
                    UIManager.getLookAndFeel().provideErrorFeedback(this);
                }
            }
        }
        super.processMouseEvent(e);
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        text = "<html><body><u>" + text + "</u>";
        super.setText(text);
        this.setToolTipText(this.address);
    }

    @Override
    public void setUI(LabelUI ui) {
        super.setUI(ui);
        this.setForeground(UIUtil.getHyperlinkForeground());
    }
}

