/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ImagePreviewPane
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JLabel imageLabel;
    private static final int WIDTH = 120;
    private static final int HEIGHT = 120;

    public ImagePreviewPane() {
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.imageLabel = new JLabel();
        this.imageLabel.setPreferredSize(new Dimension(120, 120));
        this.add(this.imageLabel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        File file;
        String propName = e.getPropertyName();
        if ("SelectedFileChangedProperty".equals(propName) && (file = (File)e.getNewValue()) != null) {
            ImageIcon icon = null;
            try {
                Image image = ImageIO.read(file);
                if (image != null) {
                    image = image.getScaledInstance(120, 120, 1);
                    icon = new ImageIcon(image);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.imageLabel.setIcon(icon);
            this.repaint();
        }
    }
}

