/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuListener;

public class MenuButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private JPopupMenu popupMenu = new JPopupMenu();
    private CompoundIcon compoundIcon;

    public MenuButton(Icon icon) {
        this.setAction(new ButtonPressedAction());
        this.setIcon(icon);
    }

    public void addMenuItem(Action action) {
        this.addMenuItem(new JMenuItem(action));
    }

    public void addMenuItem(JMenuItem menuItem) {
        this.popupMenu.add(menuItem);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.popupMenu.addPopupMenuListener(l);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        if (this.popupMenu != null) {
            this.popupMenu.applyComponentOrientation(o);
        }
    }

    public int getItemCount() {
        return this.popupMenu.getComponentCount();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size != null) {
            size.width += 3;
        }
        return size;
    }

    public void insertMenuItem(JMenuItem item, int index) {
        this.popupMenu.insert(item, index);
    }

    public Component removeItem(int index) {
        Component old = this.popupMenu.getComponent(index);
        this.popupMenu.remove(index);
        return old;
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.popupMenu.removePopupMenuListener(l);
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.compoundIcon == null) {
            this.compoundIcon = new CompoundIcon(icon);
        } else {
            this.compoundIcon.setOtherIcon(icon);
        }
        super.setIcon(this.compoundIcon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
    }

    private static class DownArrowIcon
    implements Icon {
        int[] xcoord = new int[3];
        int[] ycoord = new int[3];
        private static final int SIZE = 6;

        DownArrowIcon() {
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = UIManager.getColor("Label.foreground");
            if (color == null) {
                color = c.getForeground();
            }
            g.setColor(color);
            this.xcoord[0] = x;
            this.xcoord[1] = x + 6;
            this.xcoord[2] = this.xcoord[0] + this.xcoord[1] >>> 1;
            this.ycoord[0] = this.ycoord[1] = y;
            this.ycoord[2] = y + 6;
            g.fillPolygon(this.xcoord, this.ycoord, 3);
        }
    }

    private static class CompoundIcon
    implements Icon {
        private Icon arrowIcon;
        private Icon otherIcon;
        private static final int SPACING = 3;

        CompoundIcon(Icon icon) {
            this.setOtherIcon(icon);
            this.arrowIcon = new DownArrowIcon();
        }

        @Override
        public int getIconHeight() {
            if (this.otherIcon == null) {
                return this.arrowIcon.getIconHeight();
            }
            return Math.max(this.otherIcon.getIconHeight(), this.arrowIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            if (this.otherIcon == null) {
                return this.arrowIcon.getIconWidth();
            }
            return this.otherIcon.getIconWidth() + 3 + this.arrowIcon.getIconWidth();
        }

        private int paintArrowIcon(Component c, Graphics g, int x, int y) {
            y = (c.getHeight() - this.arrowIcon.getIconHeight()) / 2;
            Graphics2D g2d = (Graphics2D)g;
            Object old = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.arrowIcon.paintIcon(c, g2d, x, y);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
            return x + this.arrowIcon.getIconWidth() + 3;
        }

        private int paintOtherIcon(Component c, Graphics g, int x, int y) {
            if (this.otherIcon != null) {
                this.otherIcon.paintIcon(c, g, x, y);
                x += this.otherIcon.getIconWidth() + 3;
            }
            return x;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                x = this.paintOtherIcon(c, g, x, y);
                this.paintArrowIcon(c, g, x, y);
            } else {
                x = this.paintArrowIcon(c, g, x, y);
                this.paintOtherIcon(c, g, x, y);
            }
        }

        public void setOtherIcon(Icon otherIcon) {
            this.otherIcon = otherIcon;
        }
    }

    private class ButtonPressedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ButtonPressedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point location = MenuButton.this.getLocation();
            location.y = MenuButton.this.getHeight();
            MenuButton.this.popupMenu.applyComponentOrientation(MenuButton.this.getComponentOrientation());
            MenuButton.this.popupMenu.show(MenuButton.this, 0, location.y);
        }
    }
}

