/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.BevelDividerBorder;
import org.fife.ui.EscapableDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RScrollPane;
import org.fife.ui.RTreeSelectionModel;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SubstanceOptionsDialogTreeRenderer;
import org.fife.ui.TitledPanel;
import org.fife.ui.UIUtil;
import org.fife.util.SubstanceUtil;

public class OptionsDialog
extends EscapableDialog
implements ActionListener,
TreeSelectionListener,
PropertyChangeListener {
    private OptionsDialogPanel[] optionsPanels;
    private JTree optionTree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JScrollPane optionTreeScrollPane;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JPanel currentOptionPanel;
    private CardLayout currentOptionPanelLayout;
    private TitledPanel titledPanel;

    public OptionsDialog(Frame owner) {
        this(owner, new OptionsDialogPanel[0]);
    }

    public OptionsDialog(Frame owner, OptionsDialogPanel[] optionsPanels) {
        super((Window)owner);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.UI");
        this.root = new DefaultMutableTreeNode(msg.getString("Options"));
        this.treeModel = new DefaultTreeModel(this.root);
        this.optionTree = new JTree(this.treeModel){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setCellRenderer(OptionsDialog.createTreeCellRenderer());
            }
        };
        this.optionTree.setSelectionModel(new RTreeSelectionModel());
        this.optionTree.setCellRenderer(OptionsDialog.createTreeCellRenderer());
        this.optionTree.setShowsRootHandles(true);
        this.optionTree.setRootVisible(false);
        this.optionTree.addTreeSelectionListener(this);
        this.optionTreeScrollPane = new RScrollPane(this.optionTree);
        this.optionTreeScrollPane.setVerticalScrollBarPolicy(22);
        JPanel indexPanel = new JPanel(new GridLayout(1, 1));
        indexPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        indexPanel.add(this.optionTreeScrollPane);
        this.currentOptionPanelLayout = new CardLayout();
        this.currentOptionPanel = new JPanel(this.currentOptionPanelLayout);
        this.setOptionsPanels(optionsPanels);
        JPanel temp = new JPanel(new GridLayout(1, 3, 5, 0));
        this.okButton = new JButton(msg.getString("OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(msg.getString("Cancel"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.applyButton = new JButton(msg.getString("Apply"));
        this.applyButton.setActionCommand("Apply");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        UIUtil.ensureDefaultButtonWidth(this.okButton);
        UIUtil.ensureDefaultButtonWidth(this.cancelButton);
        UIUtil.ensureDefaultButtonWidth(this.applyButton);
        temp.add(this.okButton);
        temp.add(this.cancelButton);
        temp.add(this.applyButton);
        JComponent buttonPanel = (JComponent)UIUtil.createButtonFooter(temp, -1, 10);
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(new BevelDividerBorder(1, 15), buttonPanel.getBorder()));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        this.titledPanel = new TitledPanel("Temporary", this.currentOptionPanel, 1);
        this.titledPanel.setBorder(UIUtil.getEmpty5Border());
        rightPanel.add(this.titledPanel);
        rightPanel.add((Component)buttonPanel, "South");
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
        contentPane.setBorder(UIUtil.getEmpty5Border());
        contentPane.add((Component)indexPanel, "Before");
        contentPane.add(rightPanel);
        this.setContentPane(contentPane);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setTitle(msg.getString("Options"));
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Cancel")) {
            this.setVisible(false);
        } else if (actionCommand.equals("OK")) {
            boolean result = this.doApply((Frame)this.getParent());
            if (result) {
                this.setVisible(false);
            }
        } else if (actionCommand.equals("Apply")) {
            this.doApply((Frame)this.getParent());
        }
    }

    private void addOptionPanel(OptionsDialogPanel panel) {
        panel.addPropertyChangeListener(this);
        this.currentOptionPanel.add((Component)panel, OptionsDialog.createKeyForPanel(panel));
        for (OptionsDialogPanel childPanel : panel.getChildPanels()) {
            this.addOptionPanel(childPanel);
        }
    }

    public void broadcast(String event) {
        for (OptionsDialogPanel panel : this.optionsPanels) {
            panel.optionsEvent(event);
        }
    }

    private static String createKeyForPanel(OptionsDialogPanel panel) {
        String key = panel.getName();
        while ((panel = panel.getParentPanel()) != null) {
            key = panel.getName() + "-" + key;
        }
        return key;
    }

    private static TreeCellRenderer createTreeCellRenderer() {
        if (SubstanceUtil.isSubstanceInstalled()) {
            return new SubstanceOptionsDialogTreeRenderer();
        }
        return new OptionTreeCellRenderer();
    }

    @Override
    protected void escapePressed() {
        this.cancelButton.doClick();
    }

    public final boolean doApply(Frame owner) {
        int i;
        int numPanels = this.optionsPanels.length;
        for (i = 0; i < numPanels; ++i) {
            OptionsDialogPanel.OptionsPanelCheckResult result = this.optionsPanels[i].ensureValidInputs();
            if (result == null) continue;
            this.setVisibleOptionPanel(result.panel);
            if (result.component instanceof JTextComponent) {
                ((JTextComponent)result.component).selectAll();
            }
            result.component.requestFocusInWindow();
            JOptionPane.showMessageDialog(this, result.errorMessage, "Error", 0);
            return false;
        }
        this.doApplyImpl(owner);
        this.setApplyButtonEnabled(false);
        for (i = 0; i < numPanels; ++i) {
            this.optionsPanels[i].setUnsavedChanges(false);
        }
        return true;
    }

    private void doApplyImpl(Frame owner) {
        for (OptionsDialogPanel panel : this.optionsPanels) {
            panel.doApply(owner);
        }
        owner.repaint();
    }

    public final String getApplyButtonText() {
        return this.applyButton.getText();
    }

    public final String getCancelButtonText() {
        return this.cancelButton.getText();
    }

    public final String getOKButtonText() {
        return this.okButton.getText();
    }

    protected OptionsDialogPanel[] getOptionsDialogPanels() {
        return this.optionsPanels;
    }

    public OptionsDialogPanel getPanelById(String id) {
        ArrayList<OptionsDialogPanel> panels = new ArrayList<OptionsDialogPanel>();
        panels.addAll(Arrays.asList(this.optionsPanels));
        for (OptionsDialogPanel panel : this.optionsPanels) {
            if (id.equals(panel.getId())) {
                return panel;
            }
            List<OptionsDialogPanel> children = panel.getChildPanels();
            if (children.isEmpty()) continue;
            panels.addAll(children);
        }
        return null;
    }

    public void initialize() {
        Frame owner = (Frame)this.getParent();
        for (OptionsDialogPanel panel : this.optionsPanels) {
            panel.setValues(owner);
        }
        this.setApplyButtonEnabled(false);
    }

    private void insertOptionPanel(MutableTreeNode parentNode, OptionsDialogPanel panel) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(panel);
        this.treeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
        for (OptionsDialogPanel childPanel : panel.getChildPanels()) {
            this.insertOptionPanel(node, childPanel);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.applyButton.isEnabled()) {
            this.applyButton.setEnabled(true);
        }
    }

    public void setApplyButtonEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
    }

    public void setApplyButtonText(String text) {
        this.applyButton.setText(text);
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public void setOKButtonText(String text) {
        this.okButton.setText(text);
    }

    public void setOptionsPanels(List<OptionsDialogPanel> optionsPanels) {
        int count = optionsPanels.size();
        OptionsDialogPanel[] panels = new OptionsDialogPanel[count];
        this.setOptionsPanels(optionsPanels.toArray(panels));
    }

    public void setOptionsPanels(OptionsDialogPanel[] optionsPanels) {
        this.optionsPanels = optionsPanels;
        int numOptionPanels = optionsPanels.length;
        this.root.removeAllChildren();
        this.currentOptionPanel.removeAll();
        for (int i = 0; i < numOptionPanels; ++i) {
            this.insertOptionPanel(this.root, optionsPanels[i]);
            this.addOptionPanel(optionsPanels[i]);
        }
        UIUtil.expandAllNodes(this.optionTree);
        if (numOptionPanels > 0) {
            this.optionTree.setSelectionRow(0);
        }
        this.optionTree.expandPath(new TreePath(this.root));
        this.pack();
    }

    public boolean setSelectedOptionsPanel(String nameOrId) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.optionTree.getModel().getRoot();
        return this.setSelectedOptionsPanelImpl(nameOrId, root);
    }

    private void setSelectedOptionsPanel(OptionsDialogPanel panel, boolean selectInTree) {
        if (selectInTree) {
            UIUtil.expandAllNodes(this.optionTree);
            for (int i = 0; i < this.optionTree.getRowCount(); ++i) {
                Object obj;
                TreePath path = this.optionTree.getPathForRow(i);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == null || (obj = node.getUserObject()) != panel) continue;
                this.optionTree.setSelectionPath(path);
                break;
            }
        }
        this.currentOptionPanelLayout.show(this.currentOptionPanel, OptionsDialog.createKeyForPanel(panel));
        this.titledPanel.setTitle(panel.getName());
        this.titledPanel.setIcon(panel.getIcon());
        JComponent topComponent = panel.getTopJComponent();
        if (topComponent != null) {
            topComponent.requestFocusInWindow();
            if (topComponent instanceof JTextComponent) {
                ((JTextComponent)topComponent).selectAll();
            }
        }
    }

    private boolean setSelectedOptionsPanelImpl(String nameOrId, DefaultMutableTreeNode node) {
        OptionsDialogPanel panel;
        Object obj = node.getUserObject();
        if (obj instanceof OptionsDialogPanel && (nameOrId.equals((panel = (OptionsDialogPanel)obj).getName()) || nameOrId.equals(panel.getId()))) {
            this.setSelectedOptionsPanel(panel, true);
            return true;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!this.setSelectedOptionsPanelImpl(nameOrId, node)) continue;
            return true;
        }
        return false;
    }

    private void setVisibleOptionPanel(OptionsDialogPanel panel) {
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)e.nextElement();
            OptionsDialogPanel panel2 = (OptionsDialogPanel)dmtn.getUserObject();
            if (panel2 != panel) continue;
            TreePath path = new TreePath(dmtn.getPath());
            this.optionTree.setSelectionPath(path);
            break;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        int[] selectedRows;
        if (visible) {
            UIUtil.expandAllNodes(this.optionTree);
            Dimension size = this.optionTree.getPreferredScrollableViewportSize();
            size.width += 45;
            this.optionTreeScrollPane.setPreferredSize(size);
            this.pack();
        }
        if ((selectedRows = this.optionTree.getSelectionRows()) == null || selectedRows.length == 0) {
            this.optionTree.setSelectionRow(0);
        }
        super.setVisible(visible);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.optionTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        if (!((obj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof OptionsDialogPanel)) {
            return;
        }
        OptionsDialogPanel panel = (OptionsDialogPanel)obj;
        this.setSelectedOptionsPanel(panel, false);
    }

    private static class OptionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private OptionTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focused);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof OptionsDialogPanel) {
                OptionsDialogPanel panel = (OptionsDialogPanel)obj;
                this.setIcon(panel.getIcon());
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

