/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.fife.ui.OptionsDialog;
import org.fife.ui.UIUtil;

public abstract class OptionsDialogPanel
extends JPanel {
    private String name;
    private String id;
    private Icon icon;
    protected boolean hasUnsavedChanges;
    private List<OptionsDialogPanel> childPanels;
    private OptionsDialogPanel parent;

    public OptionsDialogPanel() {
        this("<Unnamed>");
    }

    public OptionsDialogPanel(String name) {
        this.name = name;
        this.hasUnsavedChanges = false;
        this.childPanels = new ArrayList<OptionsDialogPanel>(0);
    }

    public void addChildPanel(OptionsDialogPanel child) {
        this.childPanels.add(child);
        child.parent = this;
    }

    protected void addLeftAligned(Container parent, Component toAdd) {
        this.addLeftAligned(parent, toAdd, 0);
    }

    protected void addLeftAligned(Container parent, Component toAdd, int spacer) {
        this.addLeftAligned(parent, toAdd, spacer, 0);
    }

    protected void addLeftAligned(Container parent, Component toAdd, int spacer, int indent) {
        if ((indent = Math.max(indent, 0)) > 0) {
            Box box = this.createHorizontalBox();
            box.add(Box.createHorizontalStrut(indent));
            box.add(toAdd);
            box.add(Box.createHorizontalGlue());
            toAdd = box;
        }
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(toAdd, "Before");
        parent.add(temp);
        if (spacer > 0) {
            parent.add(Box.createVerticalStrut(spacer));
        }
    }

    protected Box createHorizontalBox() {
        return new Box(2);
    }

    public final void doApply(Frame owner) {
        this.doApplyImpl(owner);
        for (int i = 0; i < this.getChildPanelCount(); ++i) {
            this.getChildPanel(i).doApply(owner);
        }
    }

    protected abstract void doApplyImpl(Frame var1);

    public final OptionsPanelCheckResult ensureValidInputs() {
        OptionsPanelCheckResult res = this.ensureValidInputsImpl();
        if (res == null) {
            for (int i = 0; i < this.getChildPanelCount() && (res = this.getChildPanel(i).ensureValidInputs()) == null; ++i) {
            }
        }
        return res;
    }

    protected abstract OptionsPanelCheckResult ensureValidInputsImpl();

    public OptionsDialogPanel getChildPanel(int index) {
        return this.childPanels.get(index);
    }

    public int getChildPanelCount() {
        return this.childPanels.size();
    }

    public List<OptionsDialogPanel> getChildPanels() {
        return new ArrayList<OptionsDialogPanel>(this.childPanels);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OptionsDialog getOptionsDialog() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof OptionsDialog); parent = parent.getParent()) {
        }
        return (OptionsDialog)parent;
    }

    protected OptionsDialogPanel getParentPanel() {
        return this.parent;
    }

    public abstract JComponent getTopJComponent();

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    public void optionsEvent(String event) {
        for (OptionsDialogPanel panel : this.childPanels) {
            panel.optionsEvent(event);
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setUnsavedChanges(boolean hasUnsavedChanges) {
        this.hasUnsavedChanges = hasUnsavedChanges;
    }

    public final void setValues(Frame owner) {
        this.setValuesImpl(owner);
        for (int i = 0; i < this.getChildPanelCount(); ++i) {
            this.getChildPanel(i).setValues(owner);
        }
        this.setUnsavedChanges(false);
    }

    protected abstract void setValuesImpl(Frame var1);

    @Override
    public final String toString() {
        return this.name;
    }

    public static class OptionPanelBorder
    implements Border {
        private String title;
        private Insets insets;
        private Font font;
        private static final int HEIGHT = 25;

        public OptionPanelBorder(String title) {
            this.title = title;
            this.insets = new Insets(25, 8, 8, 8);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints old = UIUtil.setNativeRenderingHints(g2d);
            g.setColor(UIUtil.getHyperlinkForeground());
            this.font = UIManager.getFont("Label.font");
            if (this.font == null) {
                this.font = new JLabel().getFont();
            }
            FontMetrics fm = c.getFontMetrics(this.font);
            int titleWidth = fm.stringWidth(this.title);
            int middleY = y + 12;
            int titleY = middleY + fm.getHeight() / 2;
            ComponentOrientation orientation = c.getComponentOrientation();
            if (orientation.isLeftToRight()) {
                g.drawString(this.title, x, titleY);
                g.setColor(c.getBackground().darker());
                g.drawLine(x + titleWidth + 5, middleY, x + width, middleY);
            } else {
                int titleX = x + width - titleWidth - 1;
                g.drawString(this.title, titleX, titleY);
                g.setColor(c.getBackground().darker());
                g.drawLine(x, middleY, titleX - 5, middleY);
            }
            if (old != null) {
                g2d.addRenderingHints(old);
            }
        }
    }

    public static class OptionsPanelCheckResult {
        public OptionsDialogPanel panel;
        public JComponent component;
        public String errorMessage;

        public OptionsPanelCheckResult(OptionsDialogPanel panel) {
            this.panel = panel;
        }

        public OptionsPanelCheckResult(OptionsDialogPanel panel, JComponent component, String errorMessage) {
            this.panel = panel;
            this.component = component;
            this.errorMessage = errorMessage;
        }
    }
}

