/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BoundedRangeModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class RScrollPane
extends JScrollPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPopupMenu vertSBMenu;
    private JPopupMenu horizSBMenu;
    private int mouseX;
    private int mouseY;

    public RScrollPane() {
        this.initialize();
    }

    public RScrollPane(Component view) {
        super(view);
        this.initialize();
    }

    public RScrollPane(int width, int height, Component view) {
        super(view);
        this.setPreferredSize(new Dimension(width, height));
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("ScrollHereHorizontal".equals(command)) {
            int width = this.getHorizontalScrollBar().getWidth();
            float howFarIn = (float)this.mouseX / (float)width;
            BoundedRangeModel brm = this.getHorizontalScrollBar().getModel();
            int newPosition = Math.round(howFarIn * (float)(brm.getMaximum() - brm.getMinimum())) - brm.getExtent() / 2;
            brm.setValue(newPosition);
        } else if ("ScrollHereVertical".equals(command)) {
            int height = this.getVerticalScrollBar().getHeight();
            float howFarIn = (float)this.mouseY / (float)height;
            BoundedRangeModel brm = this.getVerticalScrollBar().getModel();
            int newPosition = Math.round(howFarIn * (float)(brm.getMaximum() - brm.getMinimum())) - brm.getExtent() / 2;
            brm.setValue(newPosition);
        } else if ("Top".equals(command)) {
            BoundedRangeModel brm = this.getVerticalScrollBar().getModel();
            brm.setValue(0);
        } else if ("Bottom".equals(command)) {
            BoundedRangeModel brm = this.getVerticalScrollBar().getModel();
            brm.setValue(brm.getMaximum());
        } else if ("PageUp".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int viewportHeight = viewport.getExtentSize().height;
            p.translate(0, -viewportHeight);
            if (p.getY() < 0.0) {
                p.setLocation(p.getX(), 0.0);
            }
            viewport.setViewPosition(p);
        } else if ("PageDown".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int viewportHeight = viewport.getExtentSize().height;
            Component view = viewport.getView();
            double tempY = p.getY() + (double)viewportHeight;
            if ((double)view.getHeight() >= tempY + (double)viewportHeight) {
                p.setLocation(p.getX(), tempY);
            } else {
                p.setLocation(p.getX(), (double)(view.getHeight() - viewportHeight));
            }
            viewport.setViewPosition(p);
        } else if ("ScrollUp".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int unitIncrement = this.getVerticalScrollBar().getUnitIncrement(-1);
            if (p.getY() > (double)unitIncrement) {
                p.translate(0, -unitIncrement);
                viewport.setViewPosition(p);
            } else {
                p.setLocation(p.getX(), 0.0);
                viewport.setViewPosition(p);
            }
        } else if ("ScrollDown".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int unitIncrement = this.getVerticalScrollBar().getUnitIncrement(1);
            Component view = viewport.getView();
            if (p.getY() < (double)(view.getHeight() - viewport.getHeight() - unitIncrement)) {
                p.translate(0, unitIncrement);
                viewport.setViewPosition(p);
            } else {
                p.setLocation(p.getX(), (double)(view.getHeight() - viewport.getHeight()));
                viewport.setViewPosition(p);
            }
        } else if ("LeftEdge".equals(command)) {
            BoundedRangeModel brm = this.getHorizontalScrollBar().getModel();
            brm.setValue(0);
        } else if ("RightEdge".equals(command)) {
            BoundedRangeModel brm = this.getHorizontalScrollBar().getModel();
            brm.setValue(brm.getMaximum());
        } else if ("PageLeft".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int viewportWidth = viewport.getExtentSize().width;
            p.translate(-viewportWidth, 0);
            if (p.getX() < 0.0) {
                p.setLocation(0.0, p.getY());
            }
            viewport.setViewPosition(p);
        } else if ("PageRight".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            Component view = viewport.getView();
            int viewportWidth = viewport.getExtentSize().width;
            p.translate(viewportWidth, 0);
            if (p.getX() > (double)(view.getWidth() - viewportWidth)) {
                p.setLocation((double)(view.getWidth() - viewportWidth), p.getY());
            }
            viewport.setViewPosition(p);
        } else if ("ScrollLeft".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int unitIncrement = this.getHorizontalScrollBar().getUnitIncrement(-1);
            if (p.getX() > (double)unitIncrement) {
                p.translate(-unitIncrement, 0);
                viewport.setViewPosition(p);
            } else {
                p.setLocation(0.0, p.getY());
                viewport.setViewPosition(p);
            }
        } else if ("ScrollRight".equals(command)) {
            JViewport viewport = this.getViewport();
            Point p = viewport.getViewPosition();
            int unitIncrement = this.getHorizontalScrollBar().getUnitIncrement(1);
            Component view = viewport.getView();
            if (p.getX() < (double)(view.getWidth() - viewport.getWidth() - unitIncrement)) {
                p.translate(unitIncrement, 0);
                viewport.setViewPosition(p);
            } else {
                p.setLocation((double)(view.getWidth() - viewport.getWidth()), p.getY());
                viewport.setViewPosition(p);
            }
        }
    }

    private void addMenuItem(String key, String actionCommand, JPopupMenu menu, ResourceBundle msg) {
        JMenuItem item = new JMenuItem(msg.getString(key));
        item.setActionCommand(actionCommand);
        item.addActionListener(this);
        menu.add(item);
    }

    private void createHorizontalScrollBarMenu() {
        this.horizSBMenu = new JPopupMenu();
        ResourceBundle msg = ResourceBundle.getBundle(RScrollPane.class.getName());
        this.addMenuItem("ScrollHere", "ScrollHereHorizontal", this.horizSBMenu, msg);
        this.horizSBMenu.addSeparator();
        this.addMenuItem("LeftEdge", "LeftEdge", this.horizSBMenu, msg);
        this.addMenuItem("RightEdge", "RightEdge", this.horizSBMenu, msg);
        this.horizSBMenu.addSeparator();
        this.addMenuItem("PageLeft", "PageLeft", this.horizSBMenu, msg);
        this.addMenuItem("PageRight", "PageRight", this.horizSBMenu, msg);
        this.horizSBMenu.addSeparator();
        this.addMenuItem("ScrollLeft", "ScrollLeft", this.horizSBMenu, msg);
        this.addMenuItem("ScrollRight", "ScrollRight", this.horizSBMenu, msg);
        this.horizSBMenu.applyComponentOrientation(this.getComponentOrientation());
    }

    private void createVerticalScrollBarMenu() {
        this.vertSBMenu = new JPopupMenu();
        ResourceBundle msg = ResourceBundle.getBundle(RScrollPane.class.getName());
        this.addMenuItem("ScrollHere", "ScrollHereVertical", this.vertSBMenu, msg);
        this.vertSBMenu.addSeparator();
        this.addMenuItem("Top", "Top", this.vertSBMenu, msg);
        this.addMenuItem("Bottom", "Bottom", this.vertSBMenu, msg);
        this.vertSBMenu.addSeparator();
        this.addMenuItem("PageUp", "PageUp", this.vertSBMenu, msg);
        this.addMenuItem("PageDown", "PageDown", this.vertSBMenu, msg);
        this.vertSBMenu.addSeparator();
        this.addMenuItem("ScrollUp", "ScrollUp", this.vertSBMenu, msg);
        this.addMenuItem("ScrollDown", "ScrollDown", this.vertSBMenu, msg);
        this.vertSBMenu.applyComponentOrientation(this.getComponentOrientation());
    }

    private void initialize() {
        PopupListener popupListener = new PopupListener();
        this.getVerticalScrollBar().addMouseListener(popupListener);
        this.getHorizontalScrollBar().addMouseListener(popupListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.vertSBMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.vertSBMenu);
        }
        if (this.horizSBMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.horizSBMenu);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RScrollPane.this.mouseX = e.getX();
                RScrollPane.this.mouseY = e.getY();
                if (e.getComponent().equals(RScrollPane.this.getVerticalScrollBar())) {
                    if (RScrollPane.this.vertSBMenu == null) {
                        RScrollPane.this.createVerticalScrollBarMenu();
                    }
                    RScrollPane.this.vertSBMenu.show(RScrollPane.this.getVerticalScrollBar(), RScrollPane.this.mouseX, RScrollPane.this.mouseY);
                } else {
                    if (RScrollPane.this.horizSBMenu == null) {
                        RScrollPane.this.createHorizontalScrollBarMenu();
                    }
                    RScrollPane.this.horizSBMenu.show(RScrollPane.this.getHorizontalScrollBar(), RScrollPane.this.mouseX, RScrollPane.this.mouseY);
                }
            }
        }
    }
}

