/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentFilesMenu
extends JMenu {
    private int maxFileHistorySize = 25;
    private List<String> fileHistory = new ArrayList<String>(this.maxFileHistorySize);
    private static final int DEFAULT_MAX_SIZE = 25;

    public RecentFilesMenu(String name) {
        this(name, (List<String>)null);
    }

    public RecentFilesMenu(String name, List<String> initialContents) {
        super(name);
        if (initialContents != null) {
            for (String fileFullPath : initialContents) {
                this.addFileToFileHistory(fileFullPath);
            }
        }
    }

    public RecentFilesMenu(String name, String[] initialContents) {
        this(name, initialContents != null ? Arrays.asList(initialContents) : (List)null);
    }

    public void addFileToFileHistory(String fileFullPath) {
        if (this.getShouldIgnoreFile(fileFullPath)) {
            return;
        }
        int index = this.fileHistory.indexOf(fileFullPath);
        if (index > -1) {
            JMenuItem menuItem = (JMenuItem)this.getMenuComponent(index);
            this.remove(index);
            this.insert(menuItem, 0);
            String temp = this.fileHistory.remove(index);
            this.fileHistory.add(0, temp);
            return;
        }
        JMenuItem menuItem = new JMenuItem(this.createOpenAction(fileFullPath));
        this.insert(menuItem, 0);
        this.fileHistory.add(0, fileFullPath);
        if (this.getItemCount() > this.maxFileHistorySize) {
            this.remove(this.getItemCount() - 1);
            this.fileHistory.remove(this.fileHistory.size() - 1);
        }
    }

    protected abstract Action createOpenAction(String var1);

    public String getFileFullPath(int index) {
        return this.fileHistory.get(index);
    }

    public List<String> getFileHistory() {
        return new ArrayList<String>(this.fileHistory);
    }

    public int getMaximumFileHistorySize() {
        return this.maxFileHistorySize;
    }

    protected boolean getShouldIgnoreFile(String fileFullPath) {
        return false;
    }

    public void setMaximumFileHistorySize(int newSize) {
        if (newSize < 0) {
            return;
        }
        this.maxFileHistorySize = newSize;
        while (this.getItemCount() > this.maxFileHistorySize) {
            this.remove(this.getItemCount() - 1);
            this.fileHistory.remove(this.fileHistory.size() - 1);
        }
    }
}

