/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.fife.ui.SizeGripIcon;
import org.fife.ui.StatusBarPanel;

class SizeGrip
extends StatusBarPanel {
    private static final long serialVersionUID = 1L;
    private Window window;
    private ComponentAdapter maximizeWindow;
    private SizeGripIcon sizeGripIcon;
    private boolean paintGrip;

    SizeGrip() {
        MouseHandler adapter = new MouseHandler();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.possiblyFixCursor(ComponentOrientation.getOrientation(this.getLocale()));
        this.sizeGripIcon = new SizeGripIcon();
        this.maximizeWindow = new ComponentAdapter(){
            long prevTime;
            boolean isLastResize;

            @Override
            public void componentResized(ComponentEvent e) {
                this.checkMaximize(true);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.checkMaximize(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.checkMaximize(!this.isLastResize);
            }

            public void checkMaximize(boolean resize) {
                long currTime = System.currentTimeMillis();
                if (this.isLastResize != resize && this.prevTime + 100L > currTime) {
                    SizeGrip.this.paintGrip = SizeGrip.this.getShouldPaintGrip();
                    SizeGrip.this.repaint();
                }
                this.isLastResize = resize;
                this.prevTime = currTime;
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.window = (Window)SwingUtilities.getRoot(this);
        this.window.addComponentListener(this.maximizeWindow);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        this.possiblyFixCursor(o);
        super.applyComponentOrientation(o);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private boolean getShouldPaintGrip() {
        Rectangle rect = this.window.getBounds();
        Dimension dim = this.getToolkit().getScreenSize();
        return rect.x != rect.y || rect.x > 0 || rect.x <= -20 || dim.width - 20 >= rect.width || dim.width + 20 <= rect.width;
    }

    public SizeGripIcon getSizeGripIcon() {
        return this.sizeGripIcon;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintGrip) {
            this.sizeGripIcon.paintIcon(this, g, 0, 0);
        }
    }

    protected void possiblyFixCursor(ComponentOrientation o) {
        int cursor = 7;
        if (o.isLeftToRight()) {
            cursor = 6;
        }
        if (cursor != this.getCursor().getType()) {
            this.setCursor(Cursor.getPredefinedCursor(cursor));
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.window.removeComponentListener(this.maximizeWindow);
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private Point origPos;

        private MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.origPos == null) {
                this.mousePressed(e);
            }
            Point newPos = e.getPoint();
            SwingUtilities.convertPointToScreen(newPos, SizeGrip.this);
            int xDelta = newPos.x - this.origPos.x;
            int yDelta = newPos.y - this.origPos.y;
            if (SizeGrip.this.getComponentOrientation().isLeftToRight()) {
                int w = SizeGrip.this.window.getWidth();
                if (newPos.x >= SizeGrip.this.window.getX()) {
                    w += xDelta;
                }
                int h = SizeGrip.this.window.getHeight();
                if (newPos.y >= SizeGrip.this.window.getY()) {
                    h += yDelta;
                }
                SizeGrip.this.window.setSize(w, h);
            } else {
                Rectangle newBounds = SizeGrip.this.window.getBounds();
                if (newPos.x <= SizeGrip.this.window.getX() + SizeGrip.this.window.getWidth()) {
                    newBounds.width -= xDelta;
                    newBounds.x += xDelta;
                }
                if (newPos.y >= SizeGrip.this.window.getY()) {
                    newBounds.height += yDelta;
                }
                SizeGrip.this.window.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
            }
            SizeGrip.this.window.invalidate();
            SizeGrip.this.window.validate();
            this.origPos.setLocation(newPos);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.origPos = e.getPoint();
            SwingUtilities.convertPointToScreen(this.origPos, SizeGrip.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.origPos = null;
        }
    }
}

