/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.fife.ui.UIUtil;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    private JLabel imageLabel;
    private ProgressBar progressBar;
    private static final int STATUS_BAR = 25;

    public SplashScreen(String splashScreenPath, String statusText) {
        this(splashScreenPath, statusText, new Color(190, 190, 190), new Color(44, 70, 154), new Color(75, 141, 199), Color.WHITE);
    }

    public SplashScreen(String splashScreenPath, String statusText, Color statusBackground, Color foreground1, Color foreground2, Color textColor) {
        JPanel contentPane = new JPanel(new BorderLayout());
        ClassLoader cl = this.getClass().getClassLoader();
        URL imageURL = cl.getResource(splashScreenPath);
        ImageIcon image = new ImageIcon(imageURL);
        this.imageLabel = new JLabel(image);
        contentPane.add(this.imageLabel);
        this.progressBar = new ProgressBar(image.getIconWidth(), statusText, statusBackground, foreground1, foreground2, textColor);
        contentPane.add((Component)this.progressBar, "South");
        this.setContentPane(contentPane);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setLocationRelativeTo(null);
    }

    public void updateStatus(String statusText, int percentComplete) {
        this.progressBar.update(statusText, percentComplete);
        this.progressBar.paintImmediately(0, 0, this.progressBar.getWidth(), this.progressBar.getHeight());
        this.imageLabel.paintImmediately(0, 0, this.imageLabel.getWidth(), this.imageLabel.getHeight());
    }

    private static class ProgressBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Dimension preferredSize;
        private Color textColor;
        private GradientPaint paint;
        private int percentComplete;
        private String text;
        private int textX;
        private int textY;

        ProgressBar(int width, String initialText, Color background, Color foreground1, Color foreground2, Color textColor) {
            this.setBackground(background);
            this.preferredSize = new Dimension(width, 25);
            this.paint = new GradientPaint(0.0f, 0.0f, foreground1, 0.0f, 25.0f, foreground2);
            this.textColor = textColor;
            this.update(this.text, this.percentComplete);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int width = this.getWidth();
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(this.paint);
            int filledWidth = width * this.percentComplete / 100;
            int x = this.getComponentOrientation().isLeftToRight() ? 0 : this.getWidth() - filledWidth;
            g2d.fillRect(x, 0, filledWidth, this.getHeight());
            g2d.setPaint(oldPaint);
            if (this.text != null) {
                RenderingHints old = UIUtil.setNativeRenderingHints(g2d);
                g2d.setColor(this.textColor);
                g2d.drawString(this.text, this.textX, this.textY);
                if (old != null) {
                    g2d.addRenderingHints(old);
                }
            }
        }

        void update(String text, int percentComplete) {
            FontMetrics fm;
            this.text = text;
            if (text != null && (fm = this.getFontMetrics(this.getFont())) != null) {
                int stringLength = fm.charsWidth(text.toCharArray(), 0, text.length());
                this.textX = (this.getWidth() - stringLength) / 2;
                this.textY = (25 + fm.getAscent()) / 2;
            }
            this.percentComplete = percentComplete;
            this.repaint();
        }
    }
}

