/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.fife.ui.OS;

public abstract class StandardAction
extends AbstractAction {
    public static final String DEFAULT_ACCELERATOR = "StandardAction.DefaultAccelerator";

    public StandardAction() {
    }

    public StandardAction(ResourceBundle msg, String key) {
        String shortDescKey;
        KeyStroke ks;
        String mnemonicKey;
        if (msg.containsKey(key)) {
            this.setName(msg.getString(key));
        }
        if (msg.containsKey(mnemonicKey = key + ".Mnemonic")) {
            this.setMnemonic(msg.getString(mnemonicKey).charAt(0));
        }
        if ((ks = StandardAction.getKeyStroke(msg, key + StandardAction.shortcutExtension(OS.get()))) == null) {
            ks = StandardAction.getKeyStroke(msg, key + StandardAction.shortcutExtension(null));
        }
        if (ks != null) {
            this.setAccelerator(ks);
            this.setDefaultAccelerator(ks);
        }
        if (msg.containsKey(shortDescKey = key + ".ShortDesc")) {
            this.setShortDescription(msg.getString(shortDescKey));
        }
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public KeyStroke getDefaultAccelerator() {
        return (KeyStroke)this.getValue(DEFAULT_ACCELERATOR);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    private static KeyStroke getKeyStroke(ResourceBundle msg, String key) {
        String temp;
        KeyStroke ks = null;
        if (msg.containsKey(key) && (temp = msg.getString(key)) != null) {
            temp = StandardAction.massageAcceleratorString(temp);
            ks = KeyStroke.getKeyStroke(temp);
        }
        return ks;
    }

    public int getMnemonic() {
        Integer i = (Integer)this.getValue("MnemonicKey");
        return i != null ? i : -1;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    private static String massageAcceleratorString(String accelerator) {
        String defaultStr = "default ";
        int index = accelerator.indexOf("default ");
        if (index > -1) {
            String replacement = OS.get() == OS.MAC_OS_X ? "meta " : "control ";
            accelerator = accelerator.substring(0, index) + replacement + accelerator.substring(index + "default ".length());
        }
        return accelerator;
    }

    public void restoreDefaultAccelerator() {
        this.setAccelerator(this.getDefaultAccelerator());
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public void setDefaultAccelerator(KeyStroke accelerator) {
        this.putValue(DEFAULT_ACCELERATOR, accelerator);
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setIcon(String res) {
        this.setIcon(this.getClass().getResource(res));
    }

    public void setIcon(URL res) {
        this.setIcon(new ImageIcon(res));
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic > 0 ? Integer.valueOf(mnemonic) : null);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setShortDescription(String desc) {
        this.putValue("ShortDescription", desc);
    }

    private static String shortcutExtension(OS os) {
        String extension = ".Accelerator";
        String suffix = null;
        if (os != null) {
            switch (os) {
                case MAC_OS_X: {
                    suffix = ".OSX";
                    break;
                }
                case LINUX: {
                    suffix = ".Linux";
                    break;
                }
                case WINDOWS: {
                    suffix = ".Windows";
                    break;
                }
                case SOLARIS: {
                    suffix = ".Solaris";
                    break;
                }
            }
        }
        if (suffix != null) {
            extension = extension + suffix;
        }
        return extension;
    }
}

