/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.fife.ui.UIUtil;

public class StatusBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean shadowEnabled;

    public StatusBarPanel() {
        this.shadowEnabled = true;
    }

    public StatusBarPanel(LayoutManager layout) {
        super(layout);
        this.shadowEnabled = true;
    }

    public StatusBarPanel(LayoutManager layout, JLabel label) {
        super(layout);
        this.add(label);
        this.shadowEnabled = true;
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isShadowEnabled()) {
            Color bg;
            int width = this.getWidth();
            int height = this.getHeight();
            Color color = bg = this.getBackground();
            color = UIUtil.deriveColor(color, 15);
            g.setColor(color);
            g.drawLine(0, 2, width, 2);
            color = UIUtil.deriveColor(color, 24);
            g.setColor(color);
            g.drawLine(0, 1, width, 1);
            color = UIUtil.deriveColor(color, 40);
            g.setColor(color);
            g.drawLine(0, 0, width, 0);
            color = UIUtil.deriveColor(bg, 8);
            g.setColor(color);
            g.drawLine(0, height - 1, width, height - 1);
            color = UIUtil.deriveColor(color, 4);
            g.setColor(color);
            g.drawLine(0, height - 2, width, height - 2);
            color = UIUtil.deriveColor(color, -3);
            g.setColor(color);
            g.drawLine(0, height - 3, width, height - 3);
            color = UIUtil.deriveColor(color, -5);
            g.setColor(color);
            g.drawLine(0, height - 4, width, height - 4);
        }
    }

    public void setShadowEnabled(boolean enabled) {
        if (this.shadowEnabled != enabled) {
            this.shadowEnabled = enabled;
            this.repaint();
        }
    }
}

