/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.fife.ui.UIUtil;

public class TitledPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int BEVEL_BORDER = 0;
    public static final int LINE_BORDER = 1;
    private JLabel label;
    private JLabel iconLabel;
    private static final int GRADIENT_WIDTH = 80;
    private static final Font DEFAULT_FONT = new Font("dialog", 1, 12);

    public TitledPanel(String title, Component content, int border) {
        this(title, DEFAULT_FONT, content, border);
    }

    public TitledPanel(String title, Font font, Component content, int border) {
        this.setTitle(title);
        this.setIcon(null);
        this.label.setFont(font);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        boolean ltr = orientation.isLeftToRight();
        GradientPanel topPanel = new GradientPanel(80);
        topPanel.setLayout(new BorderLayout());
        this.label.setBorder(UIUtil.getEmpty5Border());
        topPanel.add((Component)this.label, "Before");
        this.iconLabel.setBorder(ltr ? BorderFactory.createEmptyBorder(5, 5, 5, 10) : BorderFactory.createEmptyBorder(5, 10, 5, 5));
        topPanel.add((Component)this.iconLabel, "After");
        topPanel.setBorder(border == 0 ? new BottomBevelBorder() : BorderFactory.createLineBorder(Color.GRAY));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add(content);
        this.applyComponentOrientation(orientation);
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setIcon(Icon icon) {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel(icon);
        } else {
            this.iconLabel.setIcon(icon);
        }
    }

    public void setTitle(String title) {
        if (this.label == null) {
            this.label = new JLabel(title);
        } else {
            this.label.setText(title);
        }
    }

    public static class BottomBevelBorder
    implements Border {
        private static final Insets INSETS = new Insets(0, 0, 2, 0);
        private Color light;
        private Color dark;

        public BottomBevelBorder() {
            this(null, null);
        }

        public BottomBevelBorder(Color light, Color dark) {
            this.light = light;
            this.dark = dark;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle bounds = c.getBounds();
            g.setColor(this.dark == null ? c.getBackground().darker() : this.dark);
            g.drawLine(bounds.x, y += bounds.height - 2, bounds.x + bounds.width, y);
            g.setColor(this.light == null ? c.getBackground().brighter() : this.light);
            g.drawLine(bounds.x, y + 1, bounds.x + bounds.width, y + 1);
        }
    }

    private static class GradientPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int gradientWidth;
        private Color background;
        private Color gradientBG;

        GradientPanel(int gradientWidth) {
            this.gradientWidth = gradientWidth;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = this.getBounds();
            int w = 0;
            if (bounds.width > this.gradientWidth) {
                g.setColor(this.background);
                w = bounds.width - this.gradientWidth;
                g.fillRect(0, 0, w, bounds.height);
            }
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint paint = new GradientPaint(w, 0.0f, this.background, bounds.width, 0.0f, this.gradientBG);
            g2d.setPaint(paint);
            g2d.fill(new Rectangle(w, 0, this.gradientWidth, bounds.height));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.background = UIManager.getColor("TextField.background");
            if (this.background == null) {
                this.background = Color.white;
            }
            this.gradientBG = UIManager.getColor("TextField.selectionBackground");
            this.gradientBG = this.gradientBG != null ? this.gradientBG.brighter() : new Color(160, 160, 255);
        }
    }
}

