/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ToolTipTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private boolean toolTipsEnabled;

    public ToolTipTree() {
        this.initialize();
    }

    public ToolTipTree(Hashtable<?, ?> value) {
        super(value);
        this.initialize();
    }

    public ToolTipTree(Object[] value) {
        super(value);
        this.initialize();
    }

    public ToolTipTree(TreeModel newModel) {
        super(newModel);
        this.initialize();
    }

    public ToolTipTree(TreeNode root) {
        super(root);
        this.initialize();
    }

    public ToolTipTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.initialize();
    }

    public ToolTipTree(Vector<?> value) {
        super(value);
        this.initialize();
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        Object comp;
        Component c;
        TreePath path;
        Point p = null;
        int row = this.getRowForLocation(e.getX(), e.getY());
        if (row != -1 && (path = this.getPathForRow(row)) != null && (c = this.cellRenderer.getTreeCellRendererComponent(this, comp = path.getLastPathComponent(), this.isRowSelected(row), !this.isCollapsed(row), this.getModel().isLeaf(comp), row, false)) instanceof JLabel) {
            JLabel renderer = (JLabel)c;
            Icon icon = renderer.getIcon();
            int xOffset = icon == null ? 0 : icon.getIconWidth() + renderer.getIconTextGap();
            Rectangle bounds = this.getRowBounds(row);
            p = new Point(bounds.x + xOffset, bounds.y);
        }
        return p;
    }

    public boolean getToolTipsEnabled() {
        return this.toolTipsEnabled;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int y;
        String tip = null;
        int x = e.getX();
        TreePath path = this.getPathForLocation(x, y = e.getY());
        if (path != null) {
            tip = path.getLastPathComponent().toString();
        }
        return tip;
    }

    protected void initialize() {
        this.setToolTipsEnabled(true);
    }

    public void setToolTipsEnabled(boolean enabled) {
        this.toolTipsEnabled = enabled;
        if (this.toolTipsEnabled) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }
}

