/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public final class WebLookAndFeelUtils {
    private static final String LAF_CLASS_NAME = "com.alee.laf.WebLookAndFeel";
    private static final String BUTTON_UI_CLASS_NAME = "com.alee.laf.button.WebButtonUI";
    private static final String MENU_BAR_STYLE_CLASS = "com.alee.laf.menu.WebMenuBarStyle";
    private static final String STYLE_CONSTANTS_CLASS = "com.alee.laf.StyleConstants";
    private static boolean decorateFrames = true;

    private WebLookAndFeelUtils() {
    }

    public static void fixToolbar(JToolBar toolBar) {
        WebLookAndFeelUtils.fixToolbar(toolBar, false);
    }

    public static void fixToolbar(JToolBar toolBar, boolean flatten) {
        WebLookAndFeelUtils.fixToolbar(toolBar, flatten, true);
    }

    public static void fixToolbar(JToolBar toolBar, boolean flatten, boolean attached) {
        if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
            try {
                for (int i = 0; i < toolBar.getComponentCount(); ++i) {
                    Component comp = toolBar.getComponent(i);
                    if (!(comp instanceof JButton)) continue;
                    JButton button = (JButton)comp;
                    WebLookAndFeelUtils.fixToolbarButtonImpl(button);
                }
                Class<?> uiClazz = toolBar.getUI().getClass();
                ClassLoader cl = uiClazz.getClassLoader();
                if (flatten) {
                    Method m = uiClazz.getDeclaredMethod("setUndecorated", Boolean.TYPE);
                    m.invoke((Object)toolBar.getUI(), true);
                } else if (attached) {
                    Class<?> styleClazz = Class.forName("com.alee.laf.toolbar.ToolbarStyle", true, cl);
                    Method m = uiClazz.getDeclaredMethod("setToolbarStyle", styleClazz);
                    Field f = styleClazz.getDeclaredField("attached");
                    Object style = f.get(null);
                    m.invoke((Object)toolBar.getUI(), style);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fixToolbarButtonImpl(JButton button) throws Exception {
        ButtonUI ui = button.getUI();
        String clazzName = ui.getClass().getName();
        if (BUTTON_UI_CLASS_NAME.equals(clazzName)) {
            Class<?> uiClazz = ui.getClass();
            Method m = uiClazz.getDeclaredMethod("setRolloverDecoratedOnly", Boolean.TYPE);
            m.invoke((Object)ui, true);
            m = uiClazz.getMethod("setRound", Integer.TYPE);
            ClassLoader cl = uiClazz.getClassLoader();
            Class<?> clazz = Class.forName(STYLE_CONSTANTS_CLASS, true, cl);
            Field smallRound = clazz.getField("smallRound");
            int value = smallRound.getInt(null);
            m.invoke((Object)ui, value);
            m = uiClazz.getMethod("setLeftRightSpacing", Integer.TYPE);
            m.invoke((Object)ui, 0);
        }
    }

    public static boolean getDecorateFrames() {
        return decorateFrames;
    }

    public static void installWebLookAndFeelProperties(ClassLoader cl) {
        String honorBorders = "WebLookAndFeel.honorUserBorders";
        System.setProperty(honorBorders, "true");
        try {
            Class<?> clazz = Class.forName(LAF_CLASS_NAME, true, cl);
            Method m = null;
            if (decorateFrames) {
                m = clazz.getDeclaredMethod("setDecorateFrames", Boolean.TYPE);
                m.invoke(null, Boolean.TRUE);
            }
            m = clazz.getDeclaredMethod("setDecorateDialogs", Boolean.TYPE);
            m.invoke(null, Boolean.TRUE);
            if (decorateFrames) {
                clazz = Class.forName(MENU_BAR_STYLE_CLASS, true, cl);
                Field f = clazz.getDeclaredField("undecorated");
                f.set(null, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isWebLookAndFeel(String laf) {
        return laf.equals(LAF_CLASS_NAME);
    }

    public static boolean isWebLookAndFeelInstalled() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return WebLookAndFeelUtils.isWebLookAndFeel(laf.getClass().getName());
    }

    public static void setDecorateFrames(boolean decorateFrames) {
        WebLookAndFeelUtils.decorateFrames = decorateFrames;
    }
}

