/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.help.HelpDialog;
import org.fife.ui.AboutDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.OS;
import org.fife.ui.OptionsDialog;
import org.fife.ui.SplashScreen;
import org.fife.ui.StatusBar;
import org.fife.ui.app.ActionRegistry;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.ExceptionDialog;
import org.fife.ui.app.ExtendedLookAndFeelInfo;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationPrefs;
import org.fife.ui.app.ThirdPartyLookAndFeelManager;
import org.fife.ui.app.osxadapter.NativeMacApp;

public abstract class AbstractGUIApplication<T extends GUIApplicationPrefs<?>>
extends JFrame
implements GUIApplication,
NativeMacApp {
    public static final String STATUS_BAR_PROPERTY = "statusBar";
    public static final String STATUS_BAR_VISIBLE_PROPERTY = "statusBarVisible";
    public static final String TOOL_BAR_PROPERTY = "toolBar";
    public static final String TOOL_BAR_VISIBLE_PROPERTY = "toolBarVisible";
    public static final String ABOUT_ACTION_KEY = "aboutAction";
    public static final String EXIT_ACTION_KEY = "exitAction";
    public static final String HELP_ACTION_KEY = "helpAction";
    private JDialog aboutDialog;
    private CustomizableToolBar toolBar;
    private StatusBar statusBar;
    private ActionRegistry actions;
    private ResourceBundle resourceBundle;
    private String installLocation;
    private String language;
    private JPanel contentPane;
    private JPanel[] toolBarPanels;
    protected JPanel mainContentPanel;
    protected Container actualContentPane;
    private ThirdPartyLookAndFeelManager lafManager;
    private static final String STATUS_BAR_LOCATION = "South";
    private static final String TOOL_BAR_LOCATION = "North";

    public AbstractGUIApplication() {
        this((String)null);
    }

    public AbstractGUIApplication(String title) {
        this.initialize(title, this.loadPreferences());
    }

    public AbstractGUIApplication(String title, T prefs) {
        this.initialize(title, prefs);
    }

    private void initialize(String title, T prefs) {
        this.enableEvents(64L);
        this.setLanguage(prefs == null ? "en" : ((GUIApplicationPrefs)prefs).language);
        Locale locale = null;
        String language = this.getLanguage();
        int underscore = language.indexOf(95);
        locale = underscore > -1 ? new Locale(language.substring(0, underscore), language.substring(underscore + 1)) : new Locale(language);
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        this.setLocale(locale);
        SplashScreen splashScreen = this.createSplashScreen();
        if (splashScreen != null) {
            splashScreen.setVisible(true);
        }
        SwingUtilities.invokeLater(new StartupRunnable(this, title, splashScreen, prefs));
    }

    @Override
    public void about() {
        try {
            this.getAboutDialog().setVisible(true);
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    @Override
    public void addAction(String key, Action action) {
        this.actions.addAction(key, action);
    }

    public void addToolBar(JToolBar toolBar, String pos) {
        int count = this.toolBarPanels.length;
        JPanel[] newPanels = new JPanel[count + 1];
        System.arraycopy(this.toolBarPanels, 0, newPanels, 0, count);
        newPanels[count] = new JPanel(new BorderLayout());
        this.toolBarPanels = newPanels;
        this.toolBarPanels[count - 1].remove(this.mainContentPanel);
        this.toolBarPanels[count - 1].add(this.toolBarPanels[count]);
        this.toolBarPanels[count].add((Component)toolBar, pos);
        this.toolBarPanels[count].add(this.mainContentPanel);
    }

    protected JDialog createAboutDialog() {
        return new AboutDialog(this);
    }

    protected void createActions(T prefs) {
    }

    JPanel createMainContentPanel(Container actualContentPane) {
        JPanel mcp = new JPanel(new GridLayout(1, 1));
        mcp.add(actualContentPane);
        return mcp;
    }

    protected abstract JMenuBar createMenuBar(T var1);

    protected abstract SplashScreen createSplashScreen();

    protected abstract StatusBar createStatusBar(T var1);

    protected abstract CustomizableToolBar createToolBar(T var1);

    @Override
    public final void displayException(Throwable t) {
        this.displayException(this, t);
    }

    public final void displayException(Throwable t, String desc) {
        this.displayException(this, t, desc);
    }

    @Override
    public final void displayException(Dialog owner, Throwable t) {
        this.displayException(owner, t, null);
    }

    public void displayException(Dialog owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo(owner);
        ed.setVisible(true);
    }

    @Override
    public final void displayException(Frame owner, Throwable t) {
        this.displayException(owner, t, null);
    }

    public void displayException(Frame owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo(owner);
        ed.setVisible(true);
    }

    @Override
    public void doExit() {
        System.exit(0);
    }

    @Override
    public JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = this.createAboutDialog();
            this.aboutDialog.setLocationRelativeTo(this);
        }
        return this.aboutDialog;
    }

    @Override
    public Action getAction(String key) {
        return this.actions.getAction(key);
    }

    @Override
    public SortedSet<String> getActionKeys() {
        return this.actions.getActionKeys();
    }

    @Override
    public Action[] getActions() {
        return this.actions.getActions();
    }

    @Override
    public Container getContentPane() {
        return this.actualContentPane;
    }

    @Override
    public abstract HelpDialog getHelpDialog();

    @Override
    public String getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public ThirdPartyLookAndFeelManager getLookAndFeelManager() {
        return this.lafManager;
    }

    public static String getLocationOfJar() {
        String path = AbstractGUIApplication.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return new File(decodedPath).getParent();
    }

    public ExtendedLookAndFeelInfo[] get3rdPartyLookAndFeelInfo() {
        return this.lafManager != null ? this.lafManager.get3rdPartyLookAndFeelInfo() : null;
    }

    public OptionsDialog getOptionsDialog() {
        return null;
    }

    @Override
    public OS getOS() {
        return OS.get();
    }

    protected abstract String getPreferencesClassName();

    @Override
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(this.getResourceBundleClassName());
        }
        return this.resourceBundle;
    }

    public abstract String getResourceBundleClassName();

    @Override
    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public boolean getStatusBarVisible() {
        return this.statusBar != null ? this.statusBar.isVisible() : false;
    }

    public String getString(String key, Object ... params) {
        String text = this.getResourceBundle().getString(key);
        return MessageFormat.format(text, params);
    }

    @Override
    public CustomizableToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public boolean getToolBarVisible() {
        return this.toolBar != null ? this.toolBar.isVisible() : false;
    }

    @Override
    public abstract String getVersionString();

    @Override
    public boolean isMaximized() {
        return this.getExtendedState() == 6;
    }

    protected void loadActionShortcuts(File file) {
        try {
            this.actions.loadShortcuts(file);
        }
        catch (IOException ioe) {
            this.displayException(ioe);
        }
    }

    public T loadPreferences() {
        GUIApplicationPrefs prefs = null;
        String prefsClassName = this.getPreferencesClassName();
        if (prefsClassName != null) {
            try {
                Class<?> prefsClass = Class.forName(prefsClassName);
                prefs = (GUIApplicationPrefs)prefsClass.newInstance();
                prefs.load();
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
        return (T)prefs;
    }

    @Override
    public abstract void openFile(String var1);

    private void possibleMacOSXRegistration() {
        if (this.getOS() == OS.MAC_OS_X) {
            try {
                Class<?> osxAdapter = Class.forName("org.fife.ui.app.osxadapter.OSXAdapter");
                Class[] defArgs = new Class[]{NativeMacApp.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                this.displayException(e);
            }
            catch (ClassNotFoundException e) {
                this.displayException(e);
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }

    @Override
    public abstract void preferences();

    protected abstract void preDisplayInit(T var1, SplashScreen var2);

    protected abstract void preMenuBarInit(T var1, SplashScreen var2);

    protected abstract void preStatusBarInit(T var1, SplashScreen var2);

    protected abstract void preToolBarInit(T var1, SplashScreen var2);

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.doExit();
                break;
            }
            case 206: {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
        super.processWindowEvent(e);
    }

    @Override
    public void quit() {
        this.doExit();
    }

    private void registerMenuSelectionManagerListener() {
        if (this.statusBar == null) {
            return;
        }
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c;
                if (AbstractGUIApplication.this.statusBar == null) {
                    return;
                }
                String msg = AbstractGUIApplication.this.statusBar.getDefaultStatusMessage();
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 0 && (c = path[path.length - 1].getComponent()) instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)c;
                    Action a = item.getAction();
                    if (a != null) {
                        msg = (String)a.getValue("ShortDescription");
                    } else {
                        String text = item.getAccessibleContext().getAccessibleDescription();
                        if (text != null) {
                            msg = text;
                        }
                    }
                }
                AbstractGUIApplication.this.statusBar.setStatusMessage(msg);
            }
        });
    }

    protected void saveActionShortcuts(File file) {
        try {
            this.actions.saveShortcuts(file);
        }
        catch (IOException ioe) {
            this.displayException(ioe);
        }
    }

    @Override
    public void setContentPane(Container contentPane) {
        if (contentPane != null && !contentPane.equals(this.actualContentPane)) {
            if (this.actualContentPane != null) {
                this.mainContentPanel.remove(this.actualContentPane);
            }
            this.mainContentPanel.add(contentPane);
            this.actualContentPane = contentPane;
        }
    }

    private void setInstallLocation(String location) {
        File temp = new File(location);
        this.installLocation = temp.isDirectory() ? temp.getAbsolutePath() : System.getProperty("user.dir");
    }

    @Override
    public void setLanguage(String language) {
        this.language = language == null ? "en" : language;
    }

    public void setLookAndFeelManager(ThirdPartyLookAndFeelManager manager) {
        this.lafManager = manager;
    }

    @Override
    public void setStatusBar(StatusBar statusBar) {
        if (statusBar != null && !statusBar.equals(this.statusBar)) {
            StatusBar old = this.statusBar;
            if (old != null) {
                this.contentPane.remove(old);
            }
            this.statusBar = statusBar;
            this.contentPane.add((Component)statusBar, STATUS_BAR_LOCATION);
            this.firePropertyChange(STATUS_BAR_PROPERTY, old, statusBar);
        }
    }

    @Override
    public void setStatusBarVisible(boolean visible) {
        if (this.statusBar != null && this.statusBar.isVisible() != visible) {
            this.statusBar.setVisible(visible);
            this.firePropertyChange(STATUS_BAR_VISIBLE_PROPERTY, !visible, visible);
        }
    }

    @Override
    public void setToolBar(CustomizableToolBar toolBar) {
        if (toolBar != null && !toolBar.equals(this.toolBar)) {
            CustomizableToolBar old = this.toolBar;
            if (old != null) {
                this.toolBarPanels[0].remove(old);
            }
            this.toolBar = toolBar;
            this.toolBarPanels[0].add((Component)toolBar, TOOL_BAR_LOCATION);
            this.firePropertyChange(TOOL_BAR_PROPERTY, old, toolBar);
        }
    }

    @Override
    public void setToolBarVisible(boolean visible) {
        if (this.toolBar != null && this.toolBar.isVisible() != visible) {
            this.toolBar.setVisible(visible);
            this.firePropertyChange(TOOL_BAR_VISIBLE_PROPERTY, !visible, visible);
        }
    }

    public void updateLookAndFeel(LookAndFeel lnf) {
        if (this.aboutDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.aboutDialog);
        }
    }

    static /* synthetic */ JPanel[] access$402(AbstractGUIApplication x0, JPanel[] x1) {
        x0.toolBarPanels = x1;
        return x1;
    }

    private static class StartupRunnable
    implements Runnable {
        private String title;
        private SplashScreen splashScreen;
        private T prefs;
        final /* synthetic */ AbstractGUIApplication this$0;

        StartupRunnable(String title, SplashScreen splashScreen, T prefs) {
            this.this$0 = var1_1;
            this.splashScreen = splashScreen;
            this.prefs = prefs;
            this.title = title;
        }

        @Override
        public void run() {
            if (this.title != null) {
                this.this$0.setTitle(this.title);
            }
            this.this$0.setInstallLocation(AbstractGUIApplication.getLocationOfJar());
            this.this$0.contentPane = new JPanel(new BorderLayout());
            AbstractGUIApplication.super.setContentPane(this.this$0.contentPane);
            AbstractGUIApplication.access$402(this.this$0, new JPanel[1]);
            ((AbstractGUIApplication)this.this$0).toolBarPanels[0] = new JPanel(new BorderLayout());
            this.this$0.contentPane.add(this.this$0.toolBarPanels[0]);
            this.this$0.actualContentPane = new JPanel(new BorderLayout());
            this.this$0.mainContentPanel = this.this$0.createMainContentPanel(this.this$0.actualContentPane);
            this.this$0.toolBarPanels[0].add(this.this$0.mainContentPanel);
            if (this.this$0.lafManager != null) {
                ClassLoader cl = this.this$0.lafManager.getLAFClassLoader();
                UIManager.getLookAndFeelDefaults().put("ClassLoader", cl);
            }
            this.this$0.actions = new ActionRegistry();
            this.this$0.createActions(this.prefs);
            this.this$0.preStatusBarInit(this.prefs, this.splashScreen);
            StatusBar statusBar = this.this$0.createStatusBar(this.prefs);
            this.this$0.setStatusBar(statusBar);
            this.this$0.preToolBarInit(this.prefs, this.splashScreen);
            CustomizableToolBar toolBar = this.this$0.createToolBar(this.prefs);
            this.this$0.setToolBar(toolBar);
            this.this$0.preMenuBarInit(this.prefs, this.splashScreen);
            JMenuBar menuBar = this.this$0.createMenuBar(this.prefs);
            ComponentOrientation o = ComponentOrientation.getOrientation(this.this$0.getLocale());
            menuBar.applyComponentOrientation(o);
            this.this$0.setJMenuBar(menuBar);
            this.this$0.preDisplayInit(this.prefs, this.splashScreen);
            this.this$0.registerMenuSelectionManagerListener();
            this.this$0.possibleMacOSXRegistration();
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            this.this$0.pack();
            if (this.prefs != null) {
                if (((GUIApplicationPrefs)this.prefs).location != null) {
                    this.this$0.setLocation(((GUIApplicationPrefs)this.prefs).location);
                } else {
                    this.this$0.setLocationRelativeTo(null);
                }
                if (((GUIApplicationPrefs)this.prefs).size == null || ((GUIApplicationPrefs)this.prefs).size.equals(new Dimension(-1, -1))) {
                    this.this$0.setExtendedState(6);
                } else {
                    this.this$0.setSize(((GUIApplicationPrefs)this.prefs).size);
                }
                this.this$0.setToolBarVisible(((GUIApplicationPrefs)this.prefs).toolbarVisible);
                this.this$0.setStatusBarVisible(((GUIApplicationPrefs)this.prefs).statusBarVisible);
            } else {
                this.this$0.setToolBarVisible(true);
                this.this$0.setStatusBarVisible(true);
                this.this$0.setLocationRelativeTo(null);
            }
            ComponentOrientation orientation = ComponentOrientation.getOrientation(this.this$0.getLocale());
            this.this$0.applyComponentOrientation(orientation);
            if (this.splashScreen != null) {
                this.splashScreen.setVisible(false);
                this.splashScreen.dispose();
            }
            this.this$0.setVisible(true);
        }
    }

    public static class OptionsAction<T extends AbstractGUIApplication<?>>
    extends AppAction<T> {
        public OptionsAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public OptionsAction(T app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public OptionsAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractGUIApplication app = (AbstractGUIApplication)this.getApplication();
            app.setCursor(Cursor.getPredefinedCursor(3));
            OptionsDialog dialog = null;
            try {
                dialog = app.getOptionsDialog();
                dialog.initialize();
                dialog.pack();
                dialog.setLocationRelativeTo(app);
            }
            finally {
                app.setCursor(Cursor.getPredefinedCursor(0));
            }
            dialog.setVisible(true);
        }
    }
}

