/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class ActionRegistry {
    private Map<String, Action> actionMap = new HashMap<String, Action>();
    private static final String PROPS_FILE_HEADER = "Shortcuts for this application.  Do not modify by hand!";

    public void addAction(String key, Action action) {
        if (action == null) {
            throw new NullPointerException("action cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.actionMap.put(key, action);
    }

    public Action getAction(String key) {
        return this.actionMap.get(key);
    }

    public SortedSet<String> getActionKeys() {
        return new TreeSet<String>(this.actionMap.keySet());
    }

    public Action[] getActions() {
        return this.actionMap.values().toArray(new Action[this.actionMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadShortcuts(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Properties props = new Properties();
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
        try {
            props.load(bin);
        }
        finally {
            bin.close();
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            Action a = this.getAction(key);
            if (a == null) continue;
            String value = (String)entry.getValue();
            KeyStroke ks = KeyStroke.getKeyStroke(value);
            a.putValue("AcceleratorKey", ks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveShortcuts(File file) throws IOException {
        Properties props = new Properties();
        SortedSet<String> keys = this.getActionKeys();
        for (String key : keys) {
            Action action = this.getAction(key);
            KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
            String value = ks == null ? "" : ks.toString();
            props.setProperty(key, value);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            props.store(out, PROPS_FILE_HEADER);
        }
        finally {
            out.close();
        }
    }
}

