/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import org.fife.help.HelpDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.OS;
import org.fife.ui.StatusBar;
import org.fife.ui.app.AppAction;
import org.fife.ui.app.GUIApplicationConstants;
import org.fife.ui.app.GUIApplicationPrefs;

public interface GUIApplication
extends GUIApplicationConstants {
    public void addAction(String var1, Action var2);

    public void displayException(Throwable var1);

    public void displayException(Dialog var1, Throwable var2);

    public void displayException(Frame var1, Throwable var2);

    public void doExit();

    public JDialog getAboutDialog();

    public Action getAction(String var1);

    public SortedSet<String> getActionKeys();

    public Action[] getActions();

    public HelpDialog getHelpDialog();

    public Image getIconImage();

    public String getInstallLocation();

    public JMenuBar getJMenuBar();

    public String getLanguage();

    public Point getLocation();

    public OS getOS();

    public ResourceBundle getResourceBundle();

    public Dimension getSize();

    public StatusBar getStatusBar();

    public boolean getStatusBarVisible();

    public CustomizableToolBar getToolBar();

    public boolean getToolBarVisible();

    public String getVersionString();

    public boolean isMaximized();

    public GUIApplicationPrefs<?> loadPreferences();

    public void pack();

    public void setJMenuBar(JMenuBar var1);

    public void setLanguage(String var1);

    public void setStatusBar(StatusBar var1);

    public void setStatusBarVisible(boolean var1);

    public void setToolBar(CustomizableToolBar var1);

    public void setToolBarVisible(boolean var1);

    public static class ToggleToolBarAction<T extends GUIApplication>
    extends AppAction<T> {
        private static final long serialVersionUID = 1L;

        public ToggleToolBarAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public ToggleToolBarAction(T app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ToggleToolBarAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object app;
            app.setToolBarVisible(!(app = this.getApplication()).getToolBarVisible());
        }
    }

    public static class ToggleStatusBarAction<T extends GUIApplication>
    extends AppAction<T> {
        private static final long serialVersionUID = 1L;

        public ToggleStatusBarAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public ToggleStatusBarAction(T app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ToggleStatusBarAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object app;
            app.setStatusBarVisible(!(app = this.getApplication()).getStatusBarVisible());
        }
    }

    public static class HelpAction<T extends GUIApplication>
    extends AppAction<T> {
        private static final long serialVersionUID = 1L;

        public HelpAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public HelpAction(T app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public HelpAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object app = this.getApplication();
            if (app instanceof Component) {
                ((Component)app).setCursor(Cursor.getPredefinedCursor(3));
            }
            HelpDialog hd = null;
            try {
                hd = app.getHelpDialog();
            }
            finally {
                if (app instanceof Component) {
                    ((Component)app).setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (hd != null) {
                try {
                    hd.setVisible(true);
                }
                catch (Exception ex) {
                    app.displayException(ex);
                }
            }
        }
    }

    public static class ExitAction<T extends GUIApplication>
    extends AppAction<T> {
        private static final long serialVersionUID = 1L;

        public ExitAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public ExitAction(T app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ExitAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.getApplication().doExit();
        }
    }

    public static class AboutAction<T extends GUIApplication>
    extends AppAction<T> {
        private static final long serialVersionUID = 1L;

        public AboutAction(T app, String nameKey) {
            super(app, nameKey);
        }

        public AboutAction(T app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.getApplication().getAboutDialog().setVisible(true);
            }
            catch (Exception ex) {
                this.getApplication().displayException(ex);
            }
        }
    }
}

