/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Dimension;
import java.awt.Point;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationConstants;

public abstract class GUIApplicationPrefs<T extends GUIApplication>
implements GUIApplicationConstants {
    public Point location;
    public Dimension size;
    public boolean toolbarVisible;
    public boolean statusBarVisible;
    public String lookAndFeel;
    public String language;

    protected void populateCommonPreferences(GUIApplication app) {
        this.populateCommonPreferences(app, null);
    }

    protected void populateCommonPreferences(GUIApplication app, String lnf) {
        if (lnf == null) {
            lnf = UIManager.getLookAndFeel().getClass().getName();
        }
        this.location = app.getLocation();
        this.location.translate(15, 15);
        this.size = app.isMaximized() ? new Dimension(-1, -1) : app.getSize();
        this.lookAndFeel = lnf;
        this.toolbarVisible = app.getToolBarVisible();
        this.statusBarVisible = app.getStatusBarVisible();
        this.language = app.getLanguage();
    }

    public abstract GUIApplicationPrefs<T> load();

    protected void loadCommonPreferences(Preferences p) {
        this.location.x = p.getInt("location.x", this.location.x);
        this.location.y = p.getInt("location.y", this.location.y);
        this.size.width = p.getInt("size.width", this.size.width);
        this.size.height = p.getInt("size.height", this.size.height);
        this.toolbarVisible = p.getBoolean("toolbarVisible", this.toolbarVisible);
        this.statusBarVisible = p.getBoolean("statusBarVisible", this.statusBarVisible);
        this.lookAndFeel = p.get("lookAndFeel", this.lookAndFeel);
        this.language = p.get("language", this.language);
    }

    public abstract GUIApplicationPrefs<T> populate(T var1);

    protected void saveCommonPreferences(Preferences prefs) {
        prefs.putInt("location.x", this.location.x);
        prefs.putInt("location.y", this.location.y);
        prefs.putInt("size.width", this.size.width);
        prefs.putInt("size.height", this.size.height);
        prefs.putBoolean("toolbarVisible", this.toolbarVisible);
        prefs.putBoolean("statusBarVisible", this.statusBarVisible);
        prefs.put("lookAndFeel", this.lookAndFeel);
        prefs.put("language", this.language);
    }

    public abstract void save();

    protected abstract void setDefaults();
}

