/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private static final String MNEMONIC_SUFFIX = ".Mnemonic";
    private Map<String, JMenu> namedMenus;

    public void addExtraMenu(JMenu menu) {
        this.add((Component)menu, this.getExtraMenuInsertionIndex());
    }

    private static void configureMenuItem(JMenuItem item, String desc) {
        item.setToolTipText(null);
        item.getAccessibleContext().setAccessibleDescription(desc);
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(Action action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setToolTipText(null);
        return item;
    }

    protected JMenu createMenu(ResourceBundle msg, String textKey) {
        JMenu menu = new JMenu(msg.getString(textKey));
        String mnemonicKey = textKey + MNEMONIC_SUFFIX;
        if (msg.containsKey(mnemonicKey)) {
            menu.setMnemonic((int)msg.getString(mnemonicKey).charAt(0));
        }
        return menu;
    }

    protected JMenuItem createMenuItem(ResourceBundle msg, String textKey) {
        JMenuItem item = new JMenuItem(msg.getString(textKey));
        String mnemonicKey = textKey + MNEMONIC_SUFFIX;
        if (msg.containsKey(mnemonicKey)) {
            item.setMnemonic((int)msg.getString(mnemonicKey).charAt(0));
        }
        return item;
    }

    protected JMenuItem createMenuItem(Action a, ResourceBundle bundle, String textKey, String mnemonicKey) {
        return this.createMenuItem(a, bundle, textKey, mnemonicKey, null);
    }

    protected JMenuItem createMenuItem(Action a, ResourceBundle bundle, String textKey, String mnemonicKey, KeyStroke accelerator) {
        JMenuItem item = new JMenuItem(a);
        item.setText(bundle.getString(textKey));
        item.setMnemonic((int)bundle.getString(mnemonicKey).charAt(0));
        item.setAccelerator(accelerator);
        return item;
    }

    protected JMenuItem createMenuItem(Action a, String desc) {
        JMenuItem item = new JMenuItem(a);
        MenuBar.configureMenuItem(item, desc);
        return item;
    }

    protected JMenuItem createMenuItem(Action a) {
        JMenuItem item = new JMenuItem(a);
        String desc = (String)a.getValue("ShortDescription");
        MenuBar.configureMenuItem(item, desc);
        return item;
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(Action a, String description) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
        MenuBar.configureMenuItem(item, description);
        return item;
    }

    private int getExtraMenuInsertionIndex() {
        int count = this.getMenuCount();
        if (count == 0) {
            return 0;
        }
        JMenu menu = this.getMenu(count - 1);
        return menu != null ? count - 1 : count - 2;
    }

    public JMenu getMenuByName(String name) {
        return this.namedMenus != null ? this.namedMenus.get(name) : null;
    }

    public void registerMenuByName(String name, JMenu menu) {
        if (name == null) {
            throw new NullPointerException("menu name cannot be null");
        }
        if (this.namedMenus == null) {
            this.namedMenus = new HashMap<String, JMenu>();
        }
        this.namedMenus.put(name, menu);
    }
}

