/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fife.ui.app.ExtendedLookAndFeelInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ThirdPartyLookAndFeelManager {
    private String appRoot;
    private List<ExtendedLookAndFeelInfo> lnfInfo;
    private URLClassLoader lafLoader;
    private static final String CLASS = "class";
    private static final String JARS = "jars";
    private static final String DIR = "dir";
    private static final String LOOK_AND_FEEL = "LookAndFeel";
    private static final String MIN_JAVA_VERSION = "minJavaVersion";
    private static final String NAME = "name";

    public ThirdPartyLookAndFeelManager(String appRoot) {
        this.appRoot = appRoot;
        URL[] urls = null;
        this.lnfInfo = this.load3rdPartyLookAndFeelInfo("lnfs/lookandfeels.xml");
        try {
            int count;
            int n = count = this.lnfInfo == null ? 0 : this.lnfInfo.size();
            if (count > 0) {
                ArrayList<URL> lnfJarUrlList = new ArrayList<URL>();
                for (ExtendedLookAndFeelInfo info : this.lnfInfo) {
                    for (URL url : urls = info.getURLs(appRoot)) {
                        if (lnfJarUrlList.contains(url)) continue;
                        lnfJarUrlList.add(url);
                    }
                }
                urls = lnfJarUrlList.toArray(new URL[0]);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (urls == null) {
            urls = new URL[]{};
        }
        this.lafLoader = new URLClassLoader(urls);
    }

    public ExtendedLookAndFeelInfo[] get3rdPartyLookAndFeelInfo() {
        if (this.lnfInfo == null) {
            return new ExtendedLookAndFeelInfo[0];
        }
        ExtendedLookAndFeelInfo[] array = new ExtendedLookAndFeelInfo[this.lnfInfo.size()];
        return this.lnfInfo.toArray(array);
    }

    private String getJarsFromDirectory(String dirName) {
        File[] files;
        StringBuilder sb = new StringBuilder();
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            dir = new File(this.appRoot, dirName);
        }
        int count = (files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        })) == null ? 0 : files.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(files[i].getPath());
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public ClassLoader getLAFClassLoader() {
        return this.lafLoader;
    }

    private List<ExtendedLookAndFeelInfo> load3rdPartyLookAndFeelInfo(String xmlFile) {
        File file = new File(this.appRoot, xmlFile);
        if (!file.isFile()) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")));
            is.setEncoding("UTF-8");
            doc = db.parse(is);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<ExtendedLookAndFeelInfo> lafInfo = new ArrayList<ExtendedLookAndFeelInfo>(1);
        try {
            this.loadFromXML(doc.getDocumentElement(), lafInfo);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lafInfo;
    }

    private void loadFromXML(Element root, List<ExtendedLookAndFeelInfo> lafInfo) throws IOException {
        if (root == null) {
            throw new IOException("XML error:  node==null!");
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String elemName = child.getNodeName();
            if (LOOK_AND_FEEL.equals(elemName)) {
                NodeList childNodes = child.getChildNodes();
                if (childNodes != null && childNodes.getLength() > 0) {
                    throw new IOException("XML error:  LookAndFeel tags shouldn't have children!");
                }
                NamedNodeMap attributes = child.getAttributes();
                if (attributes == null || attributes.getLength() < 3) {
                    throw new IOException("XML error: LookAndFeel tags should have three attributes!");
                }
                String name = null;
                String className = null;
                String jars = null;
                double minVersion = 0.0;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node node2 = attributes.item(j);
                    String attr = node2.getNodeName();
                    if (NAME.equals(attr)) {
                        name = node2.getNodeValue();
                        continue;
                    }
                    if (CLASS.equals(attr)) {
                        className = node2.getNodeValue();
                        continue;
                    }
                    if (JARS.equals(attr)) {
                        jars = node2.getNodeValue();
                        continue;
                    }
                    if (DIR.equals(attr)) {
                        jars = this.getJarsFromDirectory(node2.getNodeValue());
                        continue;
                    }
                    if (MIN_JAVA_VERSION.equals(attr)) {
                        try {
                            minVersion = Double.parseDouble(node2.getNodeValue());
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                        continue;
                    }
                    throw new IOException("XML error: unknown attribute: '" + attr + "'");
                }
                if (name == null) {
                    throw new IOException("lookandfeels.xml: At least one LookAndFeel had no 'name' attribute.");
                }
                if (className == null) {
                    throw new IOException("lookandfeels.xml: LookandFeel " + name + " is missing required 'className' attribute.");
                }
                if (jars == null) {
                    throw new IOException("lookandfeels.xml: LookandFeel " + name + " is missing required 'jars' or 'dir' attribute.");
                }
                boolean add = true;
                if (minVersion > 0.0) {
                    String javaSpecVersion = System.getProperty("java.specification.version");
                    try {
                        double javaSpecVersionVal = Double.parseDouble(javaSpecVersion);
                        add = javaSpecVersionVal >= minVersion;
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                if (!add) continue;
                lafInfo.add(new ExtendedLookAndFeelInfo(name, className, jars));
                continue;
            }
            throw new IOException("XML error:  Unknown element node: " + elemName);
        }
    }
}

