/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app.osxadapter;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import org.fife.ui.app.osxadapter.NativeMacApp;

public class OSXAdapter
extends ApplicationAdapter {
    private static OSXAdapter theAdapter;
    private static Application theApplication;
    private NativeMacApp mainApp;

    private OSXAdapter(NativeMacApp inApp) {
        this.mainApp = inApp;
    }

    public void handleAbout(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleAbout: MyApp instance detached from listener");
        }
        ae.setHandled(true);
        this.mainApp.about();
    }

    public void handlePreferences(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handlePreferences: MyApp instance detached from listener");
        }
        this.mainApp.preferences();
        ae.setHandled(true);
    }

    public void handleQuit(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleQuit: MyApp instance detached from listener");
        }
        ae.setHandled(false);
        this.mainApp.quit();
    }

    public void handleOpenFile(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleOpenFile: MyApp instance detached from listener");
        }
        this.mainApp.openFile(ae.getFilename());
        ae.setHandled(true);
    }

    public void handleOpenApplication(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleOpenApplication: MyApp instance detached from listener");
        }
        ae.setHandled(true);
    }

    public void handleReOpenApplication(ApplicationEvent ae) {
        if (this.mainApp == null) {
            throw new IllegalStateException("handleOpenApplication: MyApp instance detached from listener");
        }
        ae.setHandled(true);
    }

    public static void registerMacOSXApplication(NativeMacApp inApp) {
        if (theApplication == null) {
            theApplication = Application.getApplication();
        }
        if (theAdapter == null) {
            theAdapter = new OSXAdapter(inApp);
        }
        theApplication.addApplicationListener((ApplicationListener)theAdapter);
    }

    public static void enablePrefs(boolean enabled) {
        if (theApplication == null) {
            theApplication = Application.getApplication();
        }
        theApplication.setEnabledPreferencesMenu(enabled);
    }
}

