/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.FSATextField;
import org.fife.ui.breadcrumbbar.BreadcrumbBarButton;
import org.fife.ui.breadcrumbbar.BreadcrumbBarToggleButton;
import org.fife.ui.breadcrumbbar.BreadcrumbButtonLayout;
import org.fife.ui.breadcrumbbar.ScrollableJPopupMenu;
import org.fife.ui.rtextfilechooser.FileDisplayNames;

public class BreadcrumbBar
extends JComponent {
    public static final String PROPERTY_LOCATION = "breadcrumbbar.location";
    public static final int BREADCRUMB_MODE = 0;
    public static final int TEXT_FIELD_MODE = 1;
    private File shownLocation;
    private JLabel iconLabel;
    private JPanel buttonPanel;
    private FSATextField dirField;
    private JToggleButton backButton;
    private Listener listener = new Listener();
    private HorizArrowIcon horizArrowIcon;
    private DownArrowIcon downArrowIcon;
    private Icon backIcon;
    private BufferedImage backImage;
    static final String ARROW_ACTIVATED = "arrowActivatedPropety";
    static final String ARROW_SELECTED = "arrowSelected";
    private static final String PKG = "org/fife/ui/breadcrumbbar/";
    private static final FileSystemView FSV = FileSystemView.getFileSystemView();

    public BreadcrumbBar() {
        this.setLayout(new BorderLayout());
        this.iconLabel = new JLabel();
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.iconLabel.setOpaque(false);
        this.add((Component)this.iconLabel, "Before");
        this.buttonPanel = new JPanel(new BreadcrumbButtonLayout());
        this.buttonPanel.setOpaque(false);
        this.add(this.buttonPanel);
        this.horizArrowIcon = new HorizArrowIcon();
        this.downArrowIcon = new DownArrowIcon();
        this.setShownLocation(new File("."));
        this.updateBorderAndBackground();
        this.addMouseListener(this.listener);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        ComponentOrientation old = this.getComponentOrientation();
        super.applyComponentOrientation(o);
        if (this.getMode() == 0 && this.dirField != null) {
            this.dirField.applyComponentOrientation(o);
        }
        if (!o.equals(old)) {
            Icon oldBackIcon = this.backIcon;
            this.backIcon = this.createBackIcon();
            for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                AbstractButton b;
                Component c = this.buttonPanel.getComponent(i);
                if (!(c instanceof AbstractButton) || (b = (AbstractButton)c).getIcon() != oldBackIcon) continue;
                b.setIcon(this.backIcon);
            }
        }
    }

    private JToggleButton createBackButton() {
        Icon backIcon = this.getBackIcon();
        BreadcrumbBarToggleButton b = new BreadcrumbBarToggleButton(backIcon);
        b.addActionListener(this.listener);
        return b;
    }

    private Icon createBackIcon() {
        String img = this.getComponentOrientation().isLeftToRight() ? "back.png" : "forward.png";
        this.backImage = BreadcrumbBar.loadImage(img);
        return new ImageIcon(this.backImage);
    }

    private AbstractButton createButton(File loc, boolean isArrow) {
        AbstractButton b = null;
        if (isArrow) {
            BreadcrumbBarToggleButton tb = new BreadcrumbBarToggleButton(this.horizArrowIcon);
            tb.setSelectedIcon(this.downArrowIcon);
            tb.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    Container parent = tb.getParent();
                    if (parent == null) {
                        return;
                    }
                    Boolean activate = tb.getModel().isRollover() || tb.getModel().isArmed();
                    Boolean selected = tb.isSelected() || tb.getModel().isPressed();
                    for (int i = 1; i < parent.getComponentCount(); ++i) {
                        if (parent.getComponent(i) != tb) continue;
                        AbstractButton b = (AbstractButton)parent.getComponent(i - 1);
                        b.putClientProperty(BreadcrumbBar.ARROW_ACTIVATED, activate);
                        b.putClientProperty(BreadcrumbBar.ARROW_SELECTED, selected);
                        b.repaint();
                        break;
                    }
                }
            });
            b = tb;
        } else {
            String name = loc.getName();
            if (name.length() == 0 && FSV.isDrive(loc)) {
                name = loc.getAbsolutePath();
            }
            if (name.length() == 0) {
                name = File.separatorChar == '\\' ? "\\\\" : "/";
            }
            b = new BreadcrumbBarButton(name);
        }
        b.putClientProperty(PROPERTY_LOCATION, loc);
        b.addActionListener(this.listener);
        return b;
    }

    private void configureDirField(FSATextField dirField) {
        dirField.setBorder(null);
        Dimension size = dirField.getPreferredSize();
        size.height = this.buttonPanel.getHeight();
        dirField.setPreferredSize(size);
        dirField.applyComponentOrientation(this.getComponentOrientation());
    }

    private FSATextField createDirField() {
        FSATextField dirField = new FSATextField(true, ".");
        this.configureDirField(dirField);
        dirField.addActionListener(this.listener);
        dirField.addKeyListener(this.listener);
        return dirField;
    }

    private static JMenuItem createMenuItem(File root, String name, Icon icon) {
        JMenuItem item = new JMenuItem(name, icon);
        item.putClientProperty(PROPERTY_LOCATION, root);
        return item;
    }

    private static void displayRelativeTo(JPopupMenu popup, Component c) {
        int x = 0;
        if (!popup.getComponentOrientation().isLeftToRight()) {
            x = c.getWidth() - popup.getPreferredSize().width;
        }
        popup.show(c, x, c.getHeight());
    }

    private File getAbsoluteLocation(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.getShownLocation(), path);
        }
        return file;
    }

    private Icon getBackIcon() {
        if (this.backIcon == null) {
            this.backIcon = this.createBackIcon();
        }
        return this.backIcon;
    }

    private static Icon getIcon(File dir) {
        Icon icon;
        try {
            icon = FSV.getSystemIcon(dir);
        }
        catch (NullPointerException npe) {
            icon = null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            icon = null;
        }
        return icon;
    }

    public int getMode() {
        return this.getComponent(1) == this.buttonPanel ? 0 : 1;
    }

    private static String getName(File dir) {
        return FileDisplayNames.get().getName(dir);
    }

    public File getShownLocation() {
        return this.shownLocation;
    }

    public boolean isAncestorOfShownLocation(File loc) {
        for (File f = this.shownLocation; f != null; f = f.getParentFile()) {
            if (!f.equals(loc)) continue;
            return true;
        }
        return false;
    }

    private static BufferedImage loadImage(String name) {
        BufferedImage image = null;
        name = PKG + name;
        ClassLoader cl = BreadcrumbBar.class.getClassLoader();
        try {
            InputStream in = cl.getResourceAsStream(name);
            BufferedInputStream bin = new BufferedInputStream(in);
            image = ImageIO.read(bin);
            bin.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void refresh() {
        Icon icon;
        this.buttonPanel.removeAll();
        for (File current = this.shownLocation; current != null; current = current.getParentFile()) {
            AbstractButton b = this.createButton(current, true);
            this.buttonPanel.add((Component)b, 0);
            b = this.createButton(current, false);
            this.buttonPanel.add((Component)b, 0);
        }
        AbstractButton rootButton = this.createButton(null, true);
        this.buttonPanel.add((Component)rootButton, 0);
        this.backButton = this.createBackButton();
        this.buttonPanel.add((Component)this.backButton, 1);
        try {
            icon = FSV.getSystemIcon(this.shownLocation);
        }
        catch (NullPointerException npe) {
            icon = UIManager.getIcon("FileView.directoryIcon");
        }
        this.iconLabel.setIcon(icon);
        if (this.getMode() == 1) {
            this.setMode(0);
        } else {
            this.buttonPanel.revalidate();
            this.buttonPanel.repaint();
        }
    }

    public void setMode(int mode) {
        this.remove(1);
        if (mode == 0) {
            this.add(this.buttonPanel);
        } else {
            if (this.dirField == null) {
                this.dirField = this.createDirField();
            }
            this.add(this.dirField);
            this.dirField.setFileSystemAware(false);
            this.dirField.setText(this.getShownLocation().getAbsolutePath());
            this.dirField.setCurrentDirectory(this.getShownLocation());
            this.dirField.selectAll();
            this.dirField.setFileSystemAware(true);
            this.dirField.requestFocusInWindow();
        }
        this.revalidate();
        this.repaint();
    }

    public void setShownLocation(File loc) {
        if (loc != null) {
            if (!(loc = this.getAbsoluteLocation(loc.getPath())).exists()) {
                loc = new File(System.getProperty("user.dir"));
            }
            if (!loc.equals(this.shownLocation)) {
                File old = this.shownLocation;
                try {
                    this.shownLocation = loc.getCanonicalFile();
                }
                catch (IOException ioe) {
                    this.shownLocation = loc.getAbsoluteFile();
                }
                this.refresh();
                this.firePropertyChange(PROPERTY_LOCATION, old, this.shownLocation);
            }
        }
    }

    private void updateBorderAndBackground() {
        JTextField tempField = null;
        Color bg = UIManager.getColor("TextField.background");
        if (bg == null) {
            tempField = new JTextField();
            bg = tempField.getBackground();
        }
        this.setBackground(bg);
        this.iconLabel.setBackground(bg);
        Border border = UIManager.getBorder("TextField.border");
        if (border == null) {
            border = BorderFactory.createLineBorder(Color.BLACK);
        }
        this.setBorder(border);
        Icon oldBackIcon = this.backIcon;
        this.backIcon = this.createBackIcon();
        for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
            AbstractButton b;
            Component c = this.buttonPanel.getComponent(i);
            if (!(c instanceof AbstractButton) || (b = (AbstractButton)c).getIcon() != oldBackIcon) continue;
            b.setIcon(this.backIcon);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateBorderAndBackground();
        this.listener.updateUI();
        if (this.buttonPanel != null) {
            this.buttonPanel.updateUI();
        }
        if (this.dirField != null) {
            this.dirField.updateUI();
            this.configureDirField(this.dirField);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    KeyListener {
        private List<JMenuItem> rootMenuItems;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == BreadcrumbBar.this.dirField) {
                File loc = BreadcrumbBar.this.getAbsoluteLocation(BreadcrumbBar.this.dirField.getText());
                if (loc.isDirectory()) {
                    BreadcrumbBar.this.setShownLocation(loc);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(BreadcrumbBar.this.dirField);
                }
            } else if (source == BreadcrumbBar.this.backButton) {
                for (int i = 2; i < BreadcrumbBar.this.buttonPanel.getComponentCount(); ++i) {
                    Component c = BreadcrumbBar.this.buttonPanel.getComponent(i);
                    if (!c.isVisible()) continue;
                    JButton b = (JButton)c;
                    ScrollableJPopupMenu popup = new ScrollableJPopupMenu();
                    this.addItemsFor(null, popup);
                    popup.addSeparator();
                    File loc = (File)b.getClientProperty(BreadcrumbBar.PROPERTY_LOCATION);
                    this.addItemsFor(loc.getParentFile(), popup);
                    popup.applyComponentOrientation(b.getComponentOrientation());
                    popup.addPopupMenuListener(new BreadcrumbPopupMenuListener(BreadcrumbBar.this.backButton));
                    BreadcrumbBar.displayRelativeTo(popup, BreadcrumbBar.this.backButton);
                    break;
                }
            } else if (source instanceof JToggleButton) {
                JToggleButton tb = (JToggleButton)source;
                ScrollableJPopupMenu popup = new ScrollableJPopupMenu();
                this.addItemsFor((File)tb.getClientProperty(BreadcrumbBar.PROPERTY_LOCATION), popup);
                popup.applyComponentOrientation(BreadcrumbBar.this.getComponentOrientation());
                popup.addPopupMenuListener(new BreadcrumbPopupMenuListener(tb));
                BreadcrumbBar.displayRelativeTo(popup, tb);
            } else if (source instanceof JButton) {
                JButton b = (JButton)source;
                File loc = (File)b.getClientProperty(BreadcrumbBar.PROPERTY_LOCATION);
                BreadcrumbBar.this.setShownLocation(loc);
            } else if (source instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)source;
                File newLoc = (File)item.getClientProperty(BreadcrumbBar.PROPERTY_LOCATION);
                BreadcrumbBar.this.setShownLocation(newLoc);
            }
        }

        private void addItemsFor(File dir, ScrollableJPopupMenu popup) {
            if (dir != null) {
                File[] children = dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                });
                int count = children != null ? children.length : 0;
                for (int i = 0; i < count; ++i) {
                    dir = children[i];
                    Icon icon = BreadcrumbBar.getIcon(dir);
                    JMenuItem item = new JMenuItem(dir.getName(), icon);
                    if (BreadcrumbBar.this.isAncestorOfShownLocation(dir)) {
                        Font font = item.getFont();
                        font = font.deriveFont(1);
                        item.setFont(font);
                    }
                    item.putClientProperty(BreadcrumbBar.PROPERTY_LOCATION, dir);
                    item.addActionListener(this);
                    popup.addComponent(item);
                }
            } else {
                List<JMenuItem> roots = this.getRoots();
                for (int i = 0; i < roots.size(); ++i) {
                    popup.addComponent(roots.get(i));
                }
            }
        }

        private List<JMenuItem> getRoots() {
            if (this.rootMenuItems == null) {
                this.rootMenuItems = new ArrayList<JMenuItem>(5);
                File[] rootFiles = File.listRoots();
                for (int i = 0; i < rootFiles.length; ++i) {
                    String name = BreadcrumbBar.getName(rootFiles[i]);
                    Icon icon = BreadcrumbBar.getIcon(rootFiles[i]);
                    JMenuItem item = BreadcrumbBar.createMenuItem(rootFiles[i], name, icon);
                    item.addActionListener(this);
                    this.rootMenuItems.add(item);
                }
            }
            return this.rootMenuItems;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object source = e.getSource();
            if (BreadcrumbBar.this.dirField == source && 27 == e.getKeyCode()) {
                BreadcrumbBar.this.setMode(0);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BreadcrumbBar.this.setMode(1);
        }

        public void updateUI() {
            int count = this.rootMenuItems == null ? 0 : this.rootMenuItems.size();
            for (int i = 0; i < count; ++i) {
                JMenuItem item = this.rootMenuItems.get(i);
                SwingUtilities.updateComponentTreeUI(item);
            }
        }
    }

    private class HorizArrowIcon
    implements Icon {
        private HorizArrowIcon() {
        }

        private int brighten(int component) {
            return component < 230 ? component + 20 : component;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color fg = c.getForeground();
            g.setColor(fg);
            Color highlight = new Color(this.brighten(fg.getRed()), this.brighten(fg.getGreen()), this.brighten(fg.getBlue()));
            g.translate(x, y);
            ComponentOrientation o = BreadcrumbBar.this.getComponentOrientation();
            if (o.isLeftToRight()) {
                g.drawLine(2, 1, 2, 6);
                g.drawLine(3, 2, 3, 5);
                g.drawLine(4, 3, 4, 4);
                g.setColor(highlight);
                g.drawLine(2, 0, 2, 0);
                g.drawLine(3, 1, 3, 1);
                g.drawLine(4, 2, 4, 2);
                g.drawLine(5, 3, 5, 3);
            } else {
                g.drawLine(5, 1, 5, 6);
                g.drawLine(4, 2, 4, 5);
                g.drawLine(3, 3, 3, 4);
                g.setColor(highlight);
                g.drawLine(5, 0, 5, 0);
                g.drawLine(4, 1, 4, 1);
                g.drawLine(3, 2, 3, 2);
                g.drawLine(2, 3, 2, 3);
            }
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }

    private class DownArrowIcon
    implements Icon {
        private DownArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color fg = c.getForeground();
            g.setColor(fg);
            g.translate(x, y);
            g.drawLine(0, 3, 6, 3);
            g.drawLine(1, 4, 5, 4);
            g.drawLine(2, 5, 4, 5);
            g.drawLine(3, 6, 3, 6);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private static class BreadcrumbPopupMenuListener
    implements PopupMenuListener {
        private JToggleButton source;

        BreadcrumbPopupMenuListener(JToggleButton source) {
            this.source = source;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.source.setSelected(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.source.setSelected(false);
        }
    }
}

