/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import org.fife.ui.UIUtil;
import org.fife.ui.breadcrumbbar.BreadcrumbBarButtonColorSet;
import org.fife.ui.breadcrumbbar.ButtonBorder;
import org.fife.util.SubstanceUtil;

class BreadcrumbBarButtonUI
extends BasicButtonUI {
    private BreadcrumbBarButtonColorSet colors = new BreadcrumbBarButtonColorSet();

    BreadcrumbBarButtonUI() {
    }

    public BreadcrumbBarButtonColorSet getColorSet() {
        return this.colors;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setMargin(new Insets(5, 4, 5, 4));
        b.setBorder(new ButtonBorder());
        b.setRolloverEnabled(true);
        b.setFocusable(false);
        b.setOpaque(false);
        this.colors.initialize(b);
        b.putClientProperty("breadcrumbBorderColor", this.colors.borderColor);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (Boolean.TRUE == b.getClientProperty("arrowSelected")) {
            g.setColor(this.colors.pressedC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.pressedC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.pressedFG);
        } else if (Boolean.TRUE == b.getClientProperty("arrowActivatedPropety")) {
            g.setColor(this.colors.nonArrowArrowArmedC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.nonArrowArrowArmedC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.pressedFG);
        } else if (model.isPressed()) {
            g.setColor(this.colors.pressedC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.pressedC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.pressedFG);
        } else if (model.isRollover() || model.isArmed()) {
            g.setColor(this.colors.rolloverC1);
            g.fillRect(0, 0, b.getWidth(), b.getHeight() / 2);
            g.setColor(this.colors.rolloverC2);
            g.fillRect(0, b.getHeight() / 2, b.getWidth(), b.getHeight() / 2);
            c.setForeground(this.colors.rolloverFG);
        } else {
            c.setForeground(this.colors.defaultFG);
        }
        boolean substance = SubstanceUtil.isSubstanceInstalled();
        RenderingHints oldHints = null;
        if (substance) {
            oldHints = UIUtil.setNativeRenderingHints((Graphics2D)g);
        }
        super.paint(g, c);
        if (oldHints != null) {
            ((Graphics2D)g).setRenderingHints(oldHints);
        }
    }
}

