/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.ui.breadcrumbbar.BreadcrumbBar;

public class BreadcrumbBarTest
extends JFrame
implements PropertyChangeListener {
    private JTextField tf;
    private static final String SUBSTANCE_PKG = "org.pushingpixels.substance.api.skin.Substance";

    public BreadcrumbBarTest() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        mb.add(menu);
        menu.add(new LookAndFeelAction(UIManager.getSystemLookAndFeelClassName()));
        menu.add(new LookAndFeelAction("javax.swing.plaf.metal.MetalLookAndFeel"));
        menu.add(new LookAndFeelAction("com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        menu.add(new LookAndFeelAction("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"));
        menu.addSeparator();
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceGraphiteAquaLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceGraphiteGlassLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceCeruleanLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceCremeCoffeeLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel"));
        menu.add(new LookAndFeelAction("org.pushingpixels.substance.api.skin.SubstanceDustCoffeeLookAndFeel"));
        this.setJMenuBar(mb);
        BreadcrumbBar bb = new BreadcrumbBar();
        bb.addPropertyChangeListener("breadcrumbbar.location", this);
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        cp.add((Component)bb, "North");
        this.tf = new JTextField(bb.getShownLocation().getAbsolutePath());
        cp.add((Component)this.tf, "South");
        this.setContentPane(cp);
        this.setTitle("BreadcrumbBar Test");
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String substanceClass = "org.pushingpixels.substance.api.skin.SubstanceGraphiteGlassLookAndFeel";
                UIManager.installLookAndFeel("Substance", substanceClass);
                String laf = substanceClass;
                try {
                    UIManager.setLookAndFeel(laf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new BreadcrumbBarTest().setVisible(true);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if ("breadcrumbbar.location".equals(propName)) {
            File loc = (File)e.getNewValue();
            this.tf.setText(loc.getAbsolutePath());
        }
    }

    private class LookAndFeelAction
    extends AbstractAction {
        private String laf;

        LookAndFeelAction(String laf) {
            this.laf = laf;
            int dot = laf.lastIndexOf(46);
            this.putValue("Name", laf.substring(dot + 1));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.laf);
                SwingUtilities.updateComponentTreeUI(BreadcrumbBarTest.this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

